/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.structure;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.VirtualFolder;
import se.datadosen.jalbum.io.VirtualDirectory;
import se.datadosen.jalbum.structure.MonthOptions;
import se.datadosen.jalbum.structure.Support;
import se.datadosen.jalbum.structure.Transformer;
import se.datadosen.jalbum.structure.YearOptions;

public class CalendarTransformer
implements Transformer<CalendarTransformer> {
    private List<String> patternGroups = new ArrayList<String>();
    private Locale locale = Locale.getDefault();

    public CalendarTransformer() {
        this.patternGroups.add(YearOptions.FOUR_DIGIT_YEAR.getPattern());
        this.patternGroups.add(MonthOptions.SHORT_MONTH.getPattern());
    }

    public List<String> getPatternGroups() {
        return new ArrayList<String>(this.patternGroups);
    }

    public void setPatternGroups(List<String> patternGroups) {
        this.patternGroups = new ArrayList<String>(patternGroups);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public AlbumObject transform(AlbumObject tree, VirtualFolder newRoot) {
        Support.toStream(tree).sorted((o1, o2) -> {
            long d2;
            long d1 = CalendarTransformer.getCameraDate(o1);
            if (d1 == (d2 = CalendarTransformer.getCameraDate(o2))) {
                return 0;
            }
            return d1 > d2 ? 1 : -1;
        }).forEach(ao -> this.add((AlbumObject)ao, newRoot));
        return newRoot;
    }

    private static long getCameraDate(AlbumObject ao) {
        long cameraDate = ao.getCameraDate();
        return cameraDate != 0L ? cameraDate : ao.getFile().lastModified();
    }

    private void add(AlbumObject ao, VirtualFolder parent) {
        Date date = new Date(CalendarTransformer.getCameraDate(ao));
        if (ao.getCategory() != Category.webPage) {
            for (String pattern : this.patternGroups) {
                if (pattern.length() <= 0) continue;
                SimpleDateFormat formatter = new SimpleDateFormat(pattern);
                String datePart = formatter.format(date);
                VirtualFolder folder = (VirtualFolder)parent.getChild(datePart);
                if (folder == null) {
                    folder = new VirtualFolder(new VirtualDirectory(parent.getFile(), datePart), parent, parent.getFactory());
                    parent.add(folder);
                }
                parent = folder;
            }
            parent.addFileOf(ao);
        }
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (this.patternGroups != null ? this.patternGroups.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CalendarTransformer other = (CalendarTransformer)obj;
        return this.patternGroups == other.patternGroups || this.patternGroups != null && this.patternGroups.equals(other.patternGroups);
    }

    @Override
    public CalendarTransformer copy() {
        CalendarTransformer copy = new CalendarTransformer();
        copy.patternGroups = new ArrayList<String>(this.patternGroups);
        copy.locale = this.locale;
        return copy;
    }
}

