/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.structure;

import java.awt.Graphics;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultTreeModel;
import se.datadosen.component.StateMonitor;
import se.datadosen.jalbum.structure.HasPattern;
import se.datadosen.jalbum.structure.TreeNodeImpl;

public abstract class AbstractGroupsPanel
extends JPanel {
    public static final String CUSTOM_OPTION = "CUSTOM";
    public static final String NONE_OPTION = "NONE";
    public static final String PATTERN_GROUPS_PROPERTY = "patternGroups";
    protected JTree tree;
    protected List<String> patternGroups = new ArrayList<String>();
    protected JComboBox[] groups;
    protected JTextField[] patterns;

    public AbstractGroupsPanel(JTree tree, JComboBox ... groups) {
        int i;
        this.tree = tree;
        this.groups = groups;
        this.patterns = new JTextField[groups.length];
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractGroupsPanel.this.patternsUpdated();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractGroupsPanel.this.patternsUpdated();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractGroupsPanel.this.patternsUpdated();
            }
        };
        for (i = 0; i < this.patterns.length; ++i) {
            this.patterns[i] = new JRespectingTextField(8);
            this.patterns[i].getDocument().addDocumentListener(documentListener);
        }
        for (i = 0; i < this.patterns.length; ++i) {
            this.bind(groups[i], this.patterns[i]);
        }
    }

    public void updateSample() {
        this.patternsUpdated();
    }

    public List<String> getPatternGroups() {
        return this.patternGroups;
    }

    public void setPatternGroups(List<String> patternGroups) {
        this.patternGroups = patternGroups;
        this.updateGroupsControls();
        this.patternsUpdated();
    }

    private void bind(final JComboBox cb, final JTextField tf) {
        new StateMonitor(this){
            final /* synthetic */ AbstractGroupsPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onChange() {
                HasPattern value = (HasPattern)cb.getSelectedItem();
                tf.setEnabled(value.getPattern() == null);
                if (value.getPattern() != null) {
                    tf.setText(value.getPattern());
                    this.this$0.patternsUpdated();
                } else {
                    tf.requestFocusInWindow();
                }
            }
        }.add(cb).done();
    }

    protected void patternsUpdated() {
        List<String> oldPatternGroups = this.patternGroups;
        this.patternGroups = new ArrayList<String>();
        for (JTextField tf : this.patterns) {
            this.patternGroups.add(tf.getText());
        }
        TreeNodeImpl root = this.createSampleModel(this.patternGroups);
        this.tree.setModel(new DefaultTreeModel(root));
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.firePropertyChange(PATTERN_GROUPS_PROPERTY, oldPatternGroups, this.patternGroups);
    }

    protected void updateGroupsControls() {
        ArrayList<String> patternGroups = new ArrayList<String>(this.patternGroups);
        for (JComboBox cb : this.groups) {
            AbstractGroupsPanel.setOption(cb, NONE_OPTION);
        }
        for (int i = 0; i < patternGroups.size(); ++i) {
            JComboBox cb = this.groups[i];
            JTextField pf = this.patterns[i];
            String pattern = patternGroups.get(i);
            if (pattern.length() <= 0) continue;
            HasPattern found = AbstractGroupsPanel.getMatching(pattern, cb);
            if (found != null) {
                cb.setSelectedItem(found);
                continue;
            }
            AbstractGroupsPanel.setOption(cb, CUSTOM_OPTION);
            pf.setText(pattern);
        }
    }

    protected static HasPattern getMatching(String patternGroup, JComboBox cb) {
        for (int i = 0; i < cb.getItemCount(); ++i) {
            HasPattern hp = (HasPattern)cb.getItemAt(i);
            if (!patternGroup.equals(hp.getPattern())) continue;
            return hp;
        }
        return null;
    }

    protected static void setOption(JComboBox cb, String optionName) {
        for (int i = 0; i < cb.getItemCount(); ++i) {
            Enum item = (Enum)cb.getItemAt(i);
            if (!optionName.equals(item.name())) continue;
            cb.setSelectedIndex(i);
            break;
        }
    }

    protected void setOptions(Enum ... options) {
        for (int i = 0; i < options.length; ++i) {
            this.groups[i].setSelectedItem(options[i]);
        }
    }

    protected abstract TreeNodeImpl createSampleModel(List<String> var1);

    protected abstract void setPresetsEnabledState();

    public static class JRespectingTextField
    extends JTextField {
        public JRespectingTextField(int columns) {
            super(columns);
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && (this.getParent() == null || this.getParent().isEnabled());
        }
    }

    public class JRespectingPanel
    extends JPanel {
        public JRespectingPanel(LayoutManager layout) {
            super(layout);
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && (this.getParent() == null || this.getParent().isEnabled());
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            AbstractGroupsPanel.this.setPresetsEnabledState();
        }
    }

    public static class JRespectingComboBox<E>
    extends JComboBox {
        public JRespectingComboBox(E[] items) {
            super(items);
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && (this.getParent() == null || this.getParent().isEnabled());
        }
    }

    public static class JRespectingLabel
    extends JLabel {
        @Override
        public boolean isEnabled() {
            return super.isEnabled() && (this.getParent() == null || this.getParent().isEnabled());
        }
    }
}

