/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.scaling;

import com.twelvemonkeys.image.ResampleOp;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import net.jalbum.util.Profiler;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.scaling.ImageScaler;
import se.datadosen.util.Stopwatch;

public class CustomScaler
extends ImageScaler {
    private Type type = Type.BLACKMAN_SINC;

    public CustomScaler() {
    }

    public CustomScaler(Type interpolation) {
        this.type = interpolation;
    }

    public Type getInterpolation() {
        return this.type;
    }

    public void setInterpolation(Type interpolation) {
        this.type = interpolation;
    }

    @Override
    public BufferedImage scale(Image input, int width, int height) {
        try (Profiler.Sample _s = Profiler.profile();){
            ResampleOp resampler = new ResampleOp(width, height, this.type.filterType);
            Stopwatch sw = new Stopwatch("Scaling to " + width + "x" + height + " using " + String.valueOf((Object)this.type));
            sw.start();
            BufferedImage output = resampler.filter((BufferedImage)input, null);
            if (JAlbum.logger.isLoggable(Level.FINER)) {
                sw.print();
            }
            BufferedImage bufferedImage = output;
            return bufferedImage;
        }
    }

    public static enum Type {
        STANDARD("Standard"),
        BLACKMAN_BESSEL(ResampleOp.VALUE_INTERPOLATION_BLACKMAN_BESSEL),
        BLACKMAN_SINC(ResampleOp.VALUE_INTERPOLATION_BLACKMAN_SINC),
        LANCZOS(ResampleOp.VALUE_INTERPOLATION_LANCZOS),
        MITCHELL(ResampleOp.VALUE_INTERPOLATION_MITCHELL);

        private String name;
        private int filterType;

        private Type(Object interpolation) {
            try {
                this.name = interpolation.toString();
                if (this.ordinal() > 0) {
                    Class<?> ipClass = interpolation.getClass();
                    Method m = ipClass.getMethod("getFilterType", new Class[0]);
                    m.setAccessible(true);
                    this.filterType = (Integer)m.invoke(interpolation, new Object[0]);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }

        public String toString() {
            return this.name;
        }

        public int getFilterType() {
            return this.filterType;
        }
    }
}

