/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.ast;

import bsh.BshScriptEngine;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import net.jalbum.util.Profiler;
import se.datadosen.jalbum.ASTEvaluator;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.ast.ASTNode;
import se.datadosen.tags.Element;
import se.datadosen.util.ScriptException;

public class ScriptletNode
extends ASTNode {
    private CompiledScript compiled;
    private final boolean evalScriptlet;
    private final boolean definitionScriptlet;
    private boolean defined;

    public ScriptletNode(Element elem) {
        super(elem.getContent());
        this.evalScriptlet = elem.isEvalScriptlet();
        this.definitionScriptlet = elem.isDefinitionScriptlet();
    }

    @Override
    protected void doEval(ASTEvaluator ev, StringBuilder out) throws javax.script.ScriptException {
        if (this.definitionScriptlet && this.defined) {
            return;
        }
        Object oldOut = ev.getVar("out");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ScriptEngine se = ev.getScriptEngine();
        se.put("out", pw);
        try {
            double d;
            Object o;
            Profiler.Sample _s;
            if (ev.getAlbumEngine().compile && this.compiled == null && se instanceof Compilable && !(se instanceof BshScriptEngine)) {
                _s = Profiler.profile("Compiling scriptlets");
                try {
                    this.compiled = ((Compilable)((Object)se)).compile(this.section.toString());
                }
                finally {
                    if (_s != null) {
                        _s.close();
                    }
                }
                this.defined = true;
            }
            if (this.compiled != null) {
                if (JAlbum.logger.isLoggable(Level.FINEST)) {
                    System.out.println("-------------------------");
                    System.out.println("Evaluating compiled snippet: ");
                    System.out.println(this.section.toString());
                    System.out.println("-------------------------");
                }
                _s = Profiler.profile("Executing compiled scriptlet");
                try {
                    o = this.compiled.eval();
                }
                finally {
                    if (_s != null) {
                        _s.close();
                    }
                }
            }
            _s = Profiler.profile("Executing interpreted scriptlet");
            try {
                o = se.eval(this.section.toString());
            }
            finally {
                if (_s != null) {
                    _s.close();
                }
            }
            if (JAlbum.logger.isLoggable(Level.FINEST)) {
                System.out.println("-------------------------");
                System.out.println("Evaluating snippet: ");
                System.out.println(this.section.toString());
                System.out.println("-------------------------");
            }
            this.defined = true;
            pw.flush();
            out.append(sw.toString());
            if (o instanceof Double && (d = ((Double)o).doubleValue()) == (double)((long)d)) {
                o = (long)d;
            }
            if (o != null && this.evalScriptlet) {
                out.append(o.toString());
            }
        }
        catch (javax.script.ScriptException ex) {
            if (ex.getCause() instanceof OperationAbortedException) {
                throw (OperationAbortedException)ex.getCause();
            }
            if (this.section.getSourceFile() != null) {
                throw ScriptException.of(ex, this.section.getSourceFile(), this.section.getSourceLineNumber(0));
            }
            throw ex;
        }
        catch (Throwable t) {
            System.out.println("Caught " + String.valueOf(t) + " for: [" + String.valueOf(this.section) + "]");
            throw t;
        }
        finally {
            if (oldOut != null) {
                se.put("out", oldOut);
            } else {
                se.getBindings(100).remove("out");
            }
        }
    }
}

