/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.ast;

import javax.script.ScriptException;
import se.datadosen.jalbum.AST;
import se.datadosen.jalbum.ASTEvaluator;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.ast.ASTNode;
import se.datadosen.jalbum.ast.ElementNode;
import se.datadosen.jalbum.ast.GroupNode;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Elements;

public class IfElseNode
extends ElementNode {
    private Element elseElement;

    public IfElseNode(Element ifElem, AST ast) throws ElementException {
        super(ifElem);
        GroupNode ifBranch = ast.buildTree(ifElem.getContent());
        this.add(ifBranch);
        Element nextElem = Elements.getElementByName("ja:", ifElem.getPostElement(), true);
        if (nextElem != null && nextElem.getName().equals("ja:else")) {
            this.elseElement = nextElem;
            if (IfElseNode.stripJSPComments(this.elseElement.getPreElement().toString()).trim().length() > 0) {
                throw new ElementException(Msg.get("scripting.elseNotFollowingIfError"), this.elseElement.getContent());
            }
            this.add(ast.buildTree(this.elseElement.getContent()));
        }
    }

    private ASTNode ifBranch() {
        return this.getMemberCount() > 0 ? this.getMembers().get(0) : null;
    }

    private ASTNode elseBranch() {
        return this.getMemberCount() == 2 ? this.getMembers().get(1) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doEval(ASTEvaluator evaluator, StringBuilder out) throws ScriptException, ElementException {
        ElementNode.Attributes a = this.getAttributes(evaluator);
        String existTest = a.get("exists");
        String testExpression = a.get("test");
        String valueExpression = a.get("value");
        String categoryTest = a.get("category");
        Category category = evaluator.getVar("fileCategory", Category.other);
        boolean not = a.containsKey("not");
        if (existTest == null && testExpression == null && categoryTest == null) {
            throw new ElementException(Msg.get("scripting.missingAttibutesForJaIfElement"), this.element.getContent());
        }
        try {
            block8: {
                block7: {
                    if (existTest != null && (!not ? evaluator.exists(existTest) : !evaluator.exists(existTest)) || testExpression != null && (!not ? IfElseNode.equals(testExpression, valueExpression) : !IfElseNode.equals(testExpression, valueExpression))) break block7;
                    if (categoryTest == null || IfElseNode.setOf(categoryTest).contains((Object)category) == not) break block8;
                }
                this.ifBranch().eval(evaluator, out);
                return;
            }
            ASTNode elseBranch = this.elseBranch();
            if (elseBranch == null) return;
            elseBranch.eval(evaluator, out);
            return;
        }
        catch (ScriptException | OperationAbortedException | ElementException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            throw new ElementException(Msg.get("scripting.expressionNotEvaluatingToBooleanError") + testExpression + Msg.get("scripting.expressionNotEvaluatingToBooleanError2"), this.element.getContent());
        }
    }

    private static boolean equals(String result, String value) {
        if (value != null) {
            return value.equals(result);
        }
        switch (result) {
            case "false": 
            case "": 
            case "0": 
            case "null": {
                return false;
            }
        }
        return true;
    }

    public Element getElseElement() {
        return this.elseElement;
    }
}

