/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.ast;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.StringTokenizer;
import javax.script.ScriptException;
import se.datadosen.jalbum.ASTEvaluator;
import se.datadosen.jalbum.ast.ASTNode;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Section;
import se.datadosen.util.SmartResourceBundle;

public class ExpressionLanguageNode
extends ASTNode {
    private Section section;

    public ExpressionLanguageNode(Section section) {
        super(section);
        this.section = section;
    }

    @Override
    protected void doEval(ASTEvaluator evaluator, StringBuilder out) throws ScriptException, ElementException {
        for (String expr : this.section.toString().split("\\|")) {
            String res = this.handleExpressionLanguage(expr, evaluator);
            if (res == null || res.length() <= 0) continue;
            out.append(res);
            break;
        }
    }

    private String handleExpressionLanguage(String expr, ASTEvaluator evaluator) throws ElementException, ScriptException {
        try {
            Object o = null;
            if (expr.indexOf(46) != -1) {
                StringTokenizer tokens = new StringTokenizer(expr, ".");
                String token = tokens.nextToken();
                String next = tokens.nextToken();
                o = evaluator.getVar(token);
                if (o instanceof SmartResourceBundle) {
                    String key = expr.substring(expr.indexOf(46) + 1);
                    return ((SmartResourceBundle)o).getString(key);
                }
                while (true) {
                    if (o instanceof Map) {
                        o = ((Map)o).get(next);
                    } else if (o != null) {
                        o = this.invokeGetter(o, next);
                    }
                    if (tokens.hasMoreTokens()) {
                        next = tokens.nextToken();
                        continue;
                    }
                    break;
                }
            } else if (evaluator.getUsing() != null) {
                try {
                    Field f = evaluator.getUsing().getClass().getField(expr);
                    o = f.get(evaluator.getUsing());
                }
                catch (NoSuchFieldException ex) {
                    o = evaluator.getVar(expr);
                }
            } else {
                if (expr.charAt(0) == '\"' || expr.charAt(expr.length() - 1) == '\"') {
                    return expr.substring(1, expr.length() - 1);
                }
                o = evaluator.getVar(expr);
            }
            if (o != null) {
                double d;
                if (o instanceof Double && (d = ((Double)o).doubleValue()) == (double)((long)d)) {
                    o = (long)d;
                }
                return o.toString();
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new ElementException(ex.toString());
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        return null;
    }

    private String upperInitial(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    private Object invokeGetter(Object bean, String name) throws SecurityException, NoSuchMethodException, InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        Class<?> beanClass = bean.getClass();
        Method m = null;
        try {
            m = beanClass.getMethod("get" + this.upperInitial(name), null);
        }
        catch (NoSuchMethodException ex) {
            try {
                m = beanClass.getMethod("is" + this.upperInitial(name), null);
            }
            catch (NoSuchMethodException ex2) {
                throw ex;
            }
        }
        return m.invoke(bean, (Object[])null);
    }
}

