/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.ast;

import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptException;
import se.datadosen.jalbum.ASTEvaluator;
import se.datadosen.jalbum.ast.ASTNode;
import se.datadosen.jalbum.ast.ExpressionLanguageNode;
import se.datadosen.jalbum.ast.GroupNode;
import se.datadosen.jalbum.ast.ScriptletNode;
import se.datadosen.jalbum.ast.TextNode;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Elements;

public abstract class ElementNode
extends GroupNode {
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    protected Element element;

    public ElementNode(Element elem) throws ElementException {
        super(elem.getContent());
        this.element = elem;
        for (Map.Entry<String, String> attr : elem.getAttributes().entrySet()) {
            String value = attr.getValue();
            if (value != null) {
                ASTNode newNode;
                Element e = Elements.getScriptlet(this.section.derive(value));
                if (e == null) {
                    e = Elements.getExpressionLanguage(this.section.derive(value));
                    if (e == null) {
                        this.attributes.put(attr.getKey(), value);
                        continue;
                    }
                    newNode = new ExpressionLanguageNode(e.getContent());
                } else {
                    newNode = new ScriptletNode(e);
                }
                GroupNode group = new GroupNode();
                group.add(new TextNode(e.getPreElement()));
                group.add(newNode);
                group.add(new TextNode(e.getPostElement()));
                this.attributes.put(attr.getKey(), group.getMemberCount() == 1 ? newNode : group);
                continue;
            }
            this.attributes.put(attr.getKey(), value);
        }
    }

    public Attributes getAttributes(ASTEvaluator ev) {
        return new Attributes(ev);
    }

    @Override
    public String toString() {
        Object s = super.toString();
        if (!this.attributes.isEmpty()) {
            s = (String)s + " " + String.valueOf(this.attributes);
        }
        return s;
    }

    public class Attributes {
        private ASTEvaluator ev;

        public Attributes(ASTEvaluator ev) {
            this.ev = ev;
        }

        public boolean containsKey(String key) {
            return ElementNode.this.attributes.containsKey(key);
        }

        public String get(String key) throws ScriptException, ElementException {
            Object val = ElementNode.this.attributes.get(key);
            if (val instanceof ASTNode) {
                return ((ASTNode)val).evalToString(this.ev);
            }
            return (String)val;
        }

        public String getOrDefault(String key, String def) throws ScriptException, ElementException {
            String val = this.get(key);
            return val != null ? val : def;
        }

        public boolean getOrDefault(String key, boolean def) throws ScriptException, ElementException {
            String val = this.get(key);
            return val != null ? Boolean.valueOf(val) : def;
        }

        public <T extends Number> T getOrDefault(String key, T def) throws ScriptException, ElementException {
            String val = this.get(key);
            if (val == null) {
                return def;
            }
            if (def instanceof Integer) {
                return (T)Integer.valueOf(val);
            }
            if (def instanceof Double) {
                return (T)Double.valueOf(val);
            }
            if (def instanceof Float) {
                return (T)Float.valueOf(val);
            }
            if (def instanceof Short) {
                return (T)Short.valueOf(val);
            }
            throw new IllegalArgumentException("Can't handle type " + String.valueOf(def.getClass()));
        }
    }
}

