/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.ast;

import javax.script.ScriptException;
import se.datadosen.jalbum.AST;
import se.datadosen.jalbum.ASTEvaluator;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.ast.ElementNode;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.util.Scope;

public class ColIteratorNode
extends ElementNode {
    public ColIteratorNode(Element elem, AST ast) throws ElementException {
        super(elem);
        this.setMembers(ast.buildTree(elem.getContent()).getMembers());
    }

    @Override
    protected void doEval(ASTEvaluator ev, StringBuilder out) throws ScriptException, ElementException {
        Scope scope = ev.getScope();
        AlbumBean engine = ev.getAlbumEngine();
        int imagesPerIndex = ColIteratorNode.getImagesPerIndex(engine);
        int indexNum = scope.getOrDefault("indexNum", 1) - 1;
        int imageNum = indexNum * imagesPerIndex + ev.getRow() * engine.getCols();
        AlbumObject[] currentObjects = (AlbumObject[])scope.get("currentObjects");
        for (int i = imageNum; i < currentObjects.length && i < imageNum + engine.getCols(); ++i) {
            ev.enterScope(currentObjects[i].getVars());
            super.doEval(ev, out);
            ev.exitScope(currentObjects[i].getVars());
        }
    }

    static int getImagesPerIndex(AlbumBean engine) {
        return (engine.getRows() > 0 ? engine.getRows() : 999) * engine.getCols();
    }
}

