/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.ast;

import java.util.HashSet;
import java.util.Set;
import javax.script.ScriptException;
import se.datadosen.jalbum.ASTEvaluator;
import se.datadosen.jalbum.Category;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Section;

public abstract class ASTNode {
    private final int offset;
    protected Section section;
    public static final char magic = '\f';
    public static final String magicString = "\f";

    public ASTNode(Section section) {
        this.offset = section.getBeginIndex();
        this.section = section;
    }

    public ASTNode(int offset) {
        this.offset = offset;
    }

    public final void eval(ASTEvaluator ev, StringBuilder out) throws ScriptException, ElementException {
        out.append('\f');
        this.doEval(ev, out);
        out.append('\f');
    }

    protected abstract void doEval(ASTEvaluator var1, StringBuilder var2) throws ScriptException, ElementException;

    public String evalToString(ASTEvaluator ev) throws ScriptException, ElementException {
        StringBuilder out = new StringBuilder();
        this.eval(ev, out);
        return ASTNode.stripMagicChars(out.toString());
    }

    public int getOffset() {
        return this.offset;
    }

    public Section getSection() {
        return this.section;
    }

    protected static String stripJSPComments(String doc) {
        int cEnd;
        int cStart = ((String)doc).indexOf("<%--");
        if (cStart == -1) {
            return doc;
        }
        StringBuilder buf = new StringBuilder();
        do {
            buf.append(((String)doc).substring(0, cStart));
            doc = ((String)doc).substring(cStart);
            cEnd = ((String)doc).indexOf("--%>");
            if (cEnd != -1) continue;
            return buf.toString();
        } while ((cStart = ((String)(doc = magicString + ((String)doc).substring(cEnd + 4) + magicString)).indexOf("<%--")) != -1);
        buf.append((String)doc);
        return buf.toString();
    }

    protected static Set<Category> setOf(String categories) {
        HashSet<Category> set = new HashSet<Category>();
        if (categories != null) {
            for (String name : categories.split(" *,\\ *")) {
                try {
                    set.add(Category.valueOf(name));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return set;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static String stripMagicChars(String s) {
        char[] oldChars = s.toCharArray();
        char[] newChars = new char[s.length()];
        int newLen = 0;
        for (int j = 0; j < s.length(); ++j) {
            char ch = oldChars[j];
            if (ch == '\f') continue;
            newChars[newLen] = ch;
            ++newLen;
        }
        return new String(newChars, 0, newLen);
    }
}

