/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPMeta;
import com.adobe.internal.xmp.XMPMetaFactory;
import com.adobe.internal.xmp.XMPSchemaRegistry;
import com.adobe.internal.xmp.options.PropertyOptions;
import com.adobe.internal.xmp.options.SerializeOptions;
import com.adobe.internal.xmp.properties.XMPProperty;
import com.drew.lang.GeoLocation;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Descriptor;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.iptc.IptcDirectory;
import com.drew.metadata.mp4.Mp4Directory;
import com.drew.metadata.xmp.XmpDirectory;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Formatter;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jalbum.imaging.Imaging2;
import net.jalbum.metadata.exif.ExtendedGpsDescriptor;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.formats.jpeg.xmp.JpegXmpRewriter;
import org.netbeans.editor.WeakPropertyChangeSupport;
import pixy.meta.Metadata;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.Flag;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;

public class XmpManager {
    public static final String dc_NS = "http://purl.org/dc/elements/1.1/";
    public static final String rdf_NS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String xap_NS = "http://ns.adobe.com/xap/1.0/";
    public static final String xapRights_NS = "http://ns.adobe.com/xap/1.0/rights/";
    public static final String jalbum_NS = "http://ns.jalbum.net/1.0/";
    public static final String adobe_NS = "http://ns.adobe.com/photoshop/1.0/";
    public static final String gpano_NS = "http://ns.google.com/photos/1.0/panorama/";
    private AlbumObject ao;
    private File file;
    private XMPMeta meta;
    private JpegXmpRewriter rewriter = new JpegXmpRewriter();
    private long lastModified;
    private WeakPropertyChangeSupport changeSupport;

    public XmpManager(AlbumObject ao) throws XMPException, IOException {
        this.ao = ao;
        this.init();
    }

    public XmpManager(File f) throws XMPException, IOException {
        this.file = f;
        this.init();
    }

    private File getFile() {
        return this.ao != null ? this.ao.getFile() : this.file;
    }

    private void init() throws XMPException, IOException {
        try {
            com.drew.metadata.Metadata m = null;
            if (this.ao != null && (this.ao.getCategory() == Category.image || this.ao.getCategory() == Category.video)) {
                try {
                    m = this.ao.getMetadata().getMetadata();
                    if (m != null && m.containsDirectoryOfType(XmpDirectory.class)) {
                        XmpDirectory xmpDir = (XmpDirectory)m.getFirstDirectoryOfType(XmpDirectory.class);
                        this.meta = xmpDir.getXMPMeta();
                    }
                }
                catch (Exception xmpDir) {
                    // empty catch block
                }
            }
            this.lastModified = this.getFile().lastModified();
            boolean xmpIsEmpty = false;
            if (this.meta == null) {
                try {
                    String xml = Imaging.getXmpXml((File)this.getFile());
                    if (xml != null) {
                        this.meta = XMPMetaFactory.parseFromString((String)xml);
                    }
                }
                catch (IOException | RuntimeException ex) {
                    JAlbum.logger.finer("Error reading xmp metadata from " + String.valueOf(this.getFile()) + ": " + String.valueOf(ex));
                }
                if (this.meta == null) {
                    this.meta = XMPMetaFactory.create();
                    xmpIsEmpty = true;
                }
            }
            if (m != null && m.containsDirectoryOfType(IptcDirectory.class)) {
                this.importIPTCDefaults((IptcDirectory)m.getFirstDirectoryOfType(IptcDirectory.class), xmpIsEmpty);
            }
            if (m != null && m.containsDirectoryOfType(ExifIFD0Directory.class)) {
                this.importWindowsDefaults((ExifIFD0Directory)m.getFirstDirectoryOfType(ExifIFD0Directory.class), xmpIsEmpty);
            }
            if (m != null && m.containsDirectoryOfType(GpsDirectory.class)) {
                this.importGpsDefaults((GpsDirectory)m.getFirstDirectoryOfType(GpsDirectory.class), xmpIsEmpty);
            }
            if (m != null && m.containsDirectoryOfType(Mp4Directory.class)) {
                this.importGpsDefaults((Mp4Directory)m.getFirstDirectoryOfType(Mp4Directory.class), xmpIsEmpty);
            }
        }
        catch (MetadataException | RuntimeException ex) {
            throw new IOException(ex);
        }
    }

    public XMPMeta getXMPMeta() {
        return this.meta;
    }

    private void handleExternallyModified() {
        long newLastModified = this.getFile().lastModified();
        if (newLastModified != this.lastModified) {
            try {
                XMPMeta m;
                String xml = Imaging2.getXmpXml(this.getFile());
                if (xml != null && (m = XMPMetaFactory.parseFromString((String)xml)) != null) {
                    this.meta = m;
                    this.lastModified = newLastModified;
                }
            }
            catch (XMPException | IOException throwable) {
                // empty catch block
            }
        }
    }

    private static boolean isJPEGImage(File f) {
        String name = f.getName().toLowerCase();
        return name.endsWith(".jpg") || name.endsWith(".jpeg");
    }

    public void save(boolean restoreLastModifiedDate) throws IOException {
        this.save(IO.readBytes(this.getFile()), this.meta, this.getFile(), restoreLastModifiedDate);
    }

    public void save() throws IOException {
        this.save(IO.readBytes(this.getFile()), this.meta, this.getFile(), true);
    }

    public void save(byte[] jpegBytes, File dest) throws IOException {
        this.save(jpegBytes, this.meta, dest, false);
    }

    public void saveThumb(byte[] jpegBytes, String imageSettingsHash, File dest) throws IOException {
        try {
            XMPMeta minimalMeta = XMPMetaFactory.create();
            minimalMeta.setProperty(jalbum_NS, "jalbum:imageSettingsHash", (Object)imageSettingsHash, null);
            this.save(jpegBytes, minimalMeta, dest, false);
        }
        catch (XMPException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(byte[] jpegBytes, XMPMeta meta, File dest, boolean restoreLastModifiedDate) throws IOException {
        String newXml;
        String name = dest.getName().toLowerCase();
        if (!(name.endsWith(".jpg") || name.endsWith(".jpeg") || name.endsWith(".gif") || name.endsWith(".png") || name.endsWith(".tif") || name.endsWith(".tiff"))) {
            return;
        }
        try {
            newXml = this.serialize(meta);
        }
        catch (XMPException ex) {
            throw new IOException(ex);
        }
        long lastModified = 0L;
        if (restoreLastModifiedDate) {
            lastModified = dest.lastModified();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(jpegBytes.length + 10000);
        BufferedOutputStream os = new BufferedOutputStream(baos);
        try {
            if (XmpManager.isJPEGImage(dest)) {
                this.rewriter.updateXmpXml(jpegBytes, (OutputStream)os, newXml);
            } else {
                ByteArrayInputStream is = new ByteArrayInputStream(jpegBytes);
                Metadata.insertXMP((InputStream)is, (OutputStream)os, (String)newXml);
            }
            IO.close(os);
            IO.writeBytes(baos.toByteArray(), dest);
        }
        catch (Exception ex) {
            IO.close(os);
            try {
                IO.writeBytes(jpegBytes, dest);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (ex instanceof IndexOutOfBoundsException) {
                System.err.println("Error appending xmp metadata to " + dest.getName() + ". Metadata too large for one 64KB segment (" + newXml.length() + " bytes)");
            } else {
                System.err.println("Error appending xmp metadata to " + dest.getName() + ". Metadata skipped. Error was:\n" + ex.toString());
                ex.printStackTrace(System.err);
            }
        }
        finally {
            if (lastModified != 0L) {
                dest.setLastModified(lastModified);
            }
        }
        this.firePropertyChange("xmp", null, null);
    }

    private String serialize(XMPMeta meta) throws XMPException {
        String doc = XMPMetaFactory.serializeToString((XMPMeta)meta, (SerializeOptions)new SerializeOptions().setIndent("").setNewline(" "));
        return doc;
    }

    public byte[] serialize() throws XMPException {
        return this.serialize(this.meta).getBytes(Charset.forName("UTF8"));
    }

    public void save(byte[] bytes, OutputStream os) throws IOException {
        String newXml;
        try {
            newXml = this.serialize(this.meta);
        }
        catch (XMPException ex) {
            throw new IOException(ex);
        }
        BufferedOutputStream bos = new BufferedOutputStream(os);
        this.rewriter.updateXmpXml(bytes, (OutputStream)bos, newXml);
    }

    private void removeXmp() throws IOException {
        byte[] fileBytes = IO.readBytes(this.getFile());
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.getFile()));
        this.rewriter.removeXmpXml(fileBytes, (OutputStream)os);
        IO.close(os);
    }

    public String getDescription() {
        try {
            String s;
            XMPProperty desc = this.meta.getLocalizedText(dc_NS, "dc:description", "", "x-default");
            String string = s = desc != null && desc.getValue() != null ? desc.getValue() : null;
            if (s != null) {
                return "OLYMPUS DIGITAL CAMERA".equals(s.trim()) ? "" : s;
            }
            return s;
        }
        catch (XMPException ex) {
            return null;
        }
    }

    public void setDescription(String description) throws XMPException {
        this.handleExternallyModified();
        if (description != null) {
            this.meta.setLocalizedText(dc_NS, "dc:description", "", "x-default", description);
        } else {
            this.meta.deleteProperty(dc_NS, "dc:description");
        }
    }

    public Integer getRating() {
        try {
            return this.meta.getPropertyInteger(xap_NS, "Rating");
        }
        catch (XMPException ex) {
            return null;
        }
    }

    public void setRating(Integer rating) throws XMPException {
        this.handleExternallyModified();
        this.meta.setPropertyInteger(xap_NS, "Rating", rating.intValue());
    }

    public String getTitle() {
        try {
            XMPProperty title = this.meta.getLocalizedText(dc_NS, "dc:title", "", "x-default");
            return title != null && title.getValue() != null ? title.getValue() : null;
        }
        catch (XMPException ex) {
            return null;
        }
    }

    public void setTitle(String title) throws XMPException {
        this.handleExternallyModified();
        if (title != null) {
            this.meta.setLocalizedText(dc_NS, "dc:title", "", "x-default", title);
        } else {
            this.meta.deleteProperty(dc_NS, "dc:title");
        }
    }

    public String getCreator() throws XMPException {
        XMPProperty p = this.meta.getArrayItem(dc_NS, "dc:creator", 1);
        return p != null && p.getValue() != null ? p.getValue() : null;
    }

    public void setCreator(String creator) throws XMPException {
        this.handleExternallyModified();
        try {
            this.meta.setArrayItem(dc_NS, "dc:creator", 1, creator);
        }
        catch (XMPException ex) {
            this.meta.appendArrayItem(dc_NS, "dc:creator", new PropertyOptions(1024), creator, null);
        }
    }

    public String getRights() throws XMPException {
        XMPProperty p = this.meta.getLocalizedText(dc_NS, "dc:rights", "", "x-default");
        return p != null && p.getValue() != null ? p.getValue() : null;
    }

    public void setRights(String rights) throws XMPException {
        this.handleExternallyModified();
        this.meta.setLocalizedText(dc_NS, "dc:rights", "", "x-default", rights);
    }

    public String getRightsURL() throws XMPException {
        return this.meta.getPropertyString(xapRights_NS, "WebStatement");
    }

    public void setRightsURL(String rightsURL) throws XMPException {
        this.handleExternallyModified();
        this.meta.setProperty(xapRights_NS, "WebStatement", (Object)rightsURL);
    }

    public Set<String> getKeywordSet() throws XMPException {
        XMPProperty p;
        LinkedHashSet<String> keywords = new LinkedHashSet<String>();
        int i = 1;
        while ((p = this.meta.getArrayItem(dc_NS, "dc:subject", i)) != null) {
            String keyword = p.getValue().trim();
            if (keyword.length() > 0) {
                keywords.add(keyword);
            }
            ++i;
        }
        return keywords;
    }

    public String getKeywords() throws XMPException {
        XMPProperty p;
        if (!this.meta.doesPropertyExist(dc_NS, "dc:subject")) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        int i = 1;
        while ((p = this.meta.getArrayItem(dc_NS, "dc:subject", i)) != null) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(p.getValue().trim());
            ++i;
        }
        return buf.toString();
    }

    public void setKeywords(String keywords) throws XMPException {
        this.setKeywords(keywords.split(",|;|\t"));
    }

    public void setKeywords(String[] keyArray) throws XMPException {
        int count;
        this.handleExternallyModified();
        for (int i = count = this.meta.countArrayItems(dc_NS, "dc:subject"); i >= 1; --i) {
            this.meta.deleteArrayItem(dc_NS, "dc:subject", i);
        }
        PropertyOptions arrayOptions = new PropertyOptions(512);
        for (String keyword : keyArray) {
            if ((keyword = keyword.trim()).length() <= 0) continue;
            this.meta.appendArrayItem(dc_NS, "dc:subject", arrayOptions, keyword, null);
        }
    }

    public Flag getFlag() throws XMPException {
        String s = this.meta.getPropertyString(xap_NS, "Label");
        if (s == null || s.isEmpty()) {
            return Flag.NoFlag;
        }
        try {
            return Flag.valueOf(s);
        }
        catch (IllegalArgumentException ex) {
            Debug.logErr("Unknown Flag (Label) for " + String.valueOf(this.getFile()) + ": " + s);
            return Flag.NoFlag;
        }
    }

    public void setFlag(Flag flag) throws XMPException {
        this.handleExternallyModified();
        if (flag == Flag.NoFlag) {
            this.meta.deleteProperty(xap_NS, "Label");
        } else {
            this.meta.setProperty(xap_NS, "Label", (Object)flag.name());
        }
    }

    private static String formatCoordinate(double coordinate, char posRef, char negRef) {
        char ref = coordinate >= 0.0 ? posRef : negRef;
        coordinate = Math.abs(coordinate);
        return (int)coordinate + "," + (coordinate - (double)((int)coordinate)) * 60.0 + ref;
    }

    public void setGpsLatitude(double latitude) throws XMPException {
        this.meta.setProperty("http://ns.adobe.com/exif/1.0/", "exif:GPSLatitude", (Object)XmpManager.formatCoordinate(latitude, 'N', 'S'));
    }

    public void setGpsLongitude(double longitude) throws XMPException {
        this.meta.setProperty("http://ns.adobe.com/exif/1.0/", "exif:GPSLongitude", (Object)XmpManager.formatCoordinate(longitude, 'E', 'W'));
    }

    public Double getGpsLatitude() throws XMPException {
        String coord = this.meta.getPropertyString("http://ns.adobe.com/exif/1.0/", "GPSLatitude");
        return coord != null ? Double.valueOf(ExtendedGpsDescriptor.formatDouble(coord)) : null;
    }

    public Double getGpsLongitude() throws XMPException {
        String coord = this.meta.getPropertyString("http://ns.adobe.com/exif/1.0/", "GPSLongitude");
        return coord != null ? Double.valueOf(ExtendedGpsDescriptor.formatDouble(coord)) : null;
    }

    public String getGpsLocation() throws XMPException {
        Double dLong;
        Double dLat = this.getGpsLatitude();
        if (dLat != null && (dLong = this.getGpsLongitude()) != null) {
            return XmpManager.toGpsLocation(dLat, dLong);
        }
        return null;
    }

    public void setGpsLocation(String loc) throws XMPException {
        String[] tokens = loc.split(", *");
        if (tokens.length == 2) {
            this.setGpsLatitude(Double.parseDouble(tokens[0]));
            this.setGpsLongitude(Double.parseDouble(tokens[1]));
        } else {
            this.meta.deleteProperty("http://ns.adobe.com/exif/1.0/", "GPSLatitude");
            this.meta.deleteProperty("http://ns.adobe.com/exif/1.0/", "GPSLongitude");
            com.drew.metadata.Metadata m = this.ao.getMetadata().getMetadata();
            if (m != null && m.containsDirectoryOfType(GpsDirectory.class)) {
                try {
                    this.importGpsDefaults((GpsDirectory)m.getFirstDirectoryOfType(GpsDirectory.class), false);
                }
                catch (MetadataException ex) {
                    Logger.getLogger(XmpManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else if (m != null && m.containsDirectoryOfType(Mp4Directory.class)) {
                try {
                    this.importGpsDefaults((Mp4Directory)m.getFirstDirectoryOfType(Mp4Directory.class), false);
                }
                catch (MetadataException ex) {
                    Logger.getLogger(XmpManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static String toGpsLocation(double latitude, double longitude) {
        Formatter formatter = new Formatter(Locale.US);
        return formatter.format("%.6f,%.6f", latitude, longitude).toString();
    }

    public String getJAlbumProperty(String key) throws XMPException {
        return this.meta.getPropertyString(jalbum_NS, "jalbum:" + key);
    }

    public String getJAlbumProperty(String key, String def) throws XMPException {
        String ret = this.getJAlbumProperty(key);
        return ret != null ? ret : def;
    }

    public void setJAlbumProperty(String key, String value) throws XMPException {
        this.meta.setProperty(jalbum_NS, "jalbum:" + key, (Object)value, null);
    }

    public void deleteJAlbumProperty(String key) throws XMPException {
        this.meta.deleteProperty(jalbum_NS, "jalbum:" + key);
    }

    private void importIPTCDefaults(IptcDirectory dir, boolean xmpIsEmpty) throws XMPException {
        String[] sa;
        String charset = this.ao.getEngine().getTextEncoding();
        String s = dir.getString(592, charset);
        if (s == null) {
            s = dir.getString(634, charset);
        }
        if (s != null && (xmpIsEmpty || this.getCreator() == null)) {
            this.setCreator(s);
        }
        s = null;
        switch (this.ao.getEngine().getTitleSource()) {
            case IPTCObjectName: {
                if (!dir.containsTag(517)) break;
                s = dir.getString(517, charset);
                break;
            }
            case IPTCHeadline: {
                if (!dir.containsTag(617)) break;
                s = dir.getString(617, charset);
            }
        }
        if (s != null && (xmpIsEmpty || this.getTitle() == null)) {
            this.setTitle(s);
        }
        if ((sa = dir.getStringArray(537)) != null && (xmpIsEmpty || this.getKeywords() == null || this.getKeywords().equals(dir.getString(537)))) {
            this.setKeywords(sa);
        }
        if ((s = dir.getString(628, charset)) != null && (xmpIsEmpty || this.getRights() == null)) {
            this.setRights(s);
        }
    }

    private static String ns(String s) {
        return s != null ? s : "";
    }

    private void importWindowsDefaults(ExifIFD0Directory dir, boolean xmpIsEmpty) throws XMPException, MetadataException {
        ExifIFD0Descriptor desc = new ExifIFD0Descriptor(dir);
        String s = desc.getWindowsCommentDescription();
        if (s != null && (xmpIsEmpty || XmpManager.ns(this.getDescription()).equals(desc.getWindowsTitleDescription()) && !XmpManager.ns(desc.getWindowsCommentDescription()).equals(desc.getWindowsTitleDescription()))) {
            JAlbum.logger.fine("Repairing incorrectly written xmp comment by Microsoft");
            this.setDescription(s);
        }
        s = null;
        s = desc.getWindowsTitleDescription();
        if (s != null && (xmpIsEmpty || this.getTitle() == null)) {
            this.setTitle(s);
        }
        s = null;
        s = desc.getWindowsKeywordsDescription();
        if (s != null && (xmpIsEmpty || this.getKeywords() == null)) {
            this.setKeywords(s);
        }
        s = null;
        s = desc.getWindowsAuthorDescription();
        if (s != null && (xmpIsEmpty || this.getCreator() == null)) {
            this.setCreator(s);
        }
        s = null;
    }

    private void importGpsDefaults(GpsDirectory dir, boolean xmpIsEmpty) throws XMPException, MetadataException {
        GeoLocation loc = dir.getGeoLocation();
        if (loc != null && (xmpIsEmpty || this.getGpsLatitude() == null)) {
            this.setGpsLatitude(loc.getLatitude());
            this.setGpsLongitude(loc.getLongitude());
        }
    }

    private void importGpsDefaults(Mp4Directory dir, boolean xmpIsEmpty) throws XMPException, MetadataException {
        Double longitude = dir.getDoubleObject(8194);
        Double latitude = dir.getDoubleObject(8193);
        if (longitude != null && latitude != null && (xmpIsEmpty || this.getGpsLatitude() == null)) {
            this.setGpsLongitude(longitude);
            this.setGpsLatitude(latitude);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new WeakPropertyChangeSupport();
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new WeakPropertyChangeSupport();
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(this, propertyName, oldValue, newValue);
    }

    static {
        XMPSchemaRegistry registry = XMPMetaFactory.getSchemaRegistry();
        try {
            registry.registerNamespace(jalbum_NS, "jalbum");
            registry.registerNamespace(gpano_NS, "GPano");
        }
        catch (XMPException ex) {
            Logger.getLogger(XmpManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

