/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import se.datadosen.io.RenamedFile;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.NameMap;
import se.datadosen.jalbum.TreeCollection;
import se.datadosen.jalbum.VirtualFolderOrderer;
import se.datadosen.util.IO;

public class VirtualFolder
extends AlbumObjectImpl {
    protected transient List<AlbumObject> children;
    protected transient NameMap nameMap;

    public VirtualFolder(File file, AlbumObject parent, AlbumObjectFactory factory) {
        super(VirtualFolder.makeSafe(file), parent, factory);
        this.orderer = new VirtualFolderOrderer(this);
    }

    @Override
    public void add(AlbumObject child) {
        this.getChildren().add(child);
        this.getNameMap().put(child.getName(), child);
    }

    public void remove(AlbumObject child) {
        this.getChildren().remove(child);
        this.getNameMap().remove(child.getName());
    }

    public void setParent(AlbumObject newParent) {
        this.parent = newParent;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    protected NameMap getNameMap() {
        if (this.nameMap == null) {
            this.nameMap = new NameMap();
        }
        return this.nameMap;
    }

    public void reorder() {
        this.reorder(this.getChildren(), this.orderer.getOrdering(), this.orderer.isReverseOrdering());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void reorder(List<AlbumObject> chldrn, AlbumObject.Ordering ordering, boolean reverse) {
        List<AlbumObject> list = chldrn;
        synchronized (list) {
            if (ordering == AlbumObject.Ordering.jalbum) {
                return;
            }
            Comparator<AlbumObject> comparator = ordering.getComparator(reverse);
            chldrn.sort(comparator);
        }
    }

    @Override
    public List<AlbumObject> getChildren() throws UncheckedIOException {
        return this.getChildren(!this.factory.isIgnoreOrdering());
    }

    @Override
    public List<AlbumObject> getChildren(boolean ordered) {
        if (this.children == null) {
            this.children = new ArrayList<AlbumObject>();
        }
        return this.children;
    }

    @Override
    public void setChildren(List<AlbumObject> children) throws IOException {
        this.children = children;
        this.nameMap.clear();
        for (AlbumObject ao : children) {
            this.nameMap.put(ao.getName(), ao);
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.children = null;
        this.nameMap = null;
        this.firePropertyChange("invalidated", null, null);
    }

    void reorderAll() {
        TreeCollection.of(this).stream().filter(ao -> ao instanceof VirtualFolder).map(ao -> (VirtualFolder)ao).forEach(vf -> vf.reorder());
    }

    private static File makeSafe(File f) {
        String webSafeName = IO.webSafe(f.getName());
        if (!webSafeName.equals(f.getName())) {
            f = new RenamedFile(webSafeName, f);
        }
        return f;
    }
}

