/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.jalbum.util.UnorderedArrayList;
import net.jalbum.views.View;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.explorer.JViewExplorer;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.NameMap;
import se.datadosen.jalbum.TreeCollection;
import se.datadosen.jalbum.VirtualFolder;

public class ViewAlbumObject
extends VirtualFolder {
    private transient AlbumObject viewSource;
    private transient Exception lastException;
    private transient List<AlbumObject> tmpChildren;
    private transient JViewExplorer viewExplorer;

    public ViewAlbumObject(File file, AlbumObject parent, AlbumObjectFactory factory) {
        super(file, parent, factory);
    }

    @Override
    public void remove(AlbumObject child) {
        this.safeGetChildren().remove(child);
        this.getNameMap().remove(child.getKey());
    }

    @Override
    public void add(AlbumObject child) {
        this.safeGetChildren().add(child);
        String key = child.getKey();
        this.getNameMap().put(key, child);
    }

    public List<AlbumObject> safeGetChildren() {
        return this.children != null ? this.children : this.tmpChildren;
    }

    @Override
    public Category getCategory() {
        if (this.category == null) {
            this.category = Category.view;
        }
        return super.getCategory();
    }

    public View getView() {
        return (View)this.getProperties().get("view");
    }

    @Override
    protected synchronized NameMap getNameMap() {
        if (this.nameMap == null) {
            this.getChildren();
        }
        return this.nameMap;
    }

    private void sortTree(List<AlbumObject> children) {
        TreeCollection.of(children).stream().filter(ao -> ao instanceof VirtualFolder).forEach(vf -> ((VirtualFolder)vf).reorder());
    }

    public boolean isBuilding() {
        return this.tmpChildren != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlbumObject> getChildren(boolean ordered) {
        if (this.children == null) {
            ViewAlbumObject viewAlbumObject = this;
            synchronized (viewAlbumObject) {
                if (this.children == null) {
                    this.tmpChildren = ordered ? new ArrayList<AlbumObject>() : new UnorderedArrayList();
                    this.nameMap = new NameMap();
                    View view = this.getView();
                    try {
                        this.lastException = null;
                        AlbumObject transformedRoot = view.getTransformer().transform(this.getViewSource(), this);
                        if (ordered) {
                            this.sortTree(this.tmpChildren);
                            this.reorder(this.tmpChildren, this.orderer.getOrdering(), this.orderer.isReverseOrdering());
                        }
                    }
                    catch (RuntimeException ex) {
                        this.lastException = ex;
                        System.err.println("Error processing view " + String.valueOf(this) + ": " + ex.getMessage());
                        throw ex;
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.err);
                    }
                    finally {
                        this.children = this.tmpChildren;
                        this.tmpChildren = null;
                    }
                }
            }
        }
        return this.children;
    }

    public AlbumObject getViewSource() {
        if (this.viewSource == null) {
            AlbumObject root = this.getRoot();
            this.viewSource = root.getChild(this.getProperties().get("viewSource", ""));
            if (this.viewSource == null) {
                this.lastException = new IllegalArgumentException("View source '" + this.getProperties().get("viewSource", "") + "' not found");
                this.children = new ArrayList();
                throw (IllegalArgumentException)this.lastException;
            }
        }
        return this.viewSource;
    }

    public void setViewSource(AlbumObject viewSource) {
        this.viewSource = viewSource;
        this.invalidate();
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public void exploreView(JAlbumExplorer explorer) {
        if (this.viewExplorer == null) {
            this.viewExplorer = new JViewExplorer(explorer, this);
            this.viewExplorer.setVisible(true);
        } else {
            this.viewExplorer.setVisible(true);
            this.viewExplorer.toFront();
        }
    }
}

