/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.FailedLoginException;
import net.jalbum.component.Dialogs;
import net.jalbum.remotefs.RemoteFSBean;
import net.jalbum.remotefs.RemoteFSDelegate;
import net.jalbum.remotefs.RemoteFSException;
import net.jalbum.remotefs.RemoteFSProgressMonitor;
import net.jalbum.remotefs.RemoteFile;
import se.datadosen.io.CachedFile;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.AlbumManifest;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.AuthenticationException;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.CategoryCounters;
import se.datadosen.jalbum.CircularFolderReferenceException;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.DownloadWorkers;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Notifier;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.ParameterException;
import se.datadosen.jalbum.RemoteFSNode;
import se.datadosen.jalbum.RemoteFSWorkers;
import se.datadosen.jalbum.RemoteFileImpl;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.jalbum.Tracer;
import se.datadosen.jalbum.TransferProtocol;
import se.datadosen.jalbum.event.ByteProgressEvent;
import se.datadosen.jalbum.event.FileProgressEvent;
import se.datadosen.jalbum.event.ProgressEvent;
import se.datadosen.jalbum.event.TransferListener;
import se.datadosen.jalbum.io.FileTreeCollection;
import se.datadosen.jalbum.io.FileTreeProcessor;
import se.datadosen.tags.ElementException;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.IO;
import se.datadosen.util.ReportingThread;
import se.datadosen.util.Stopwatch;
import se.datadosen.util.URLChecker;
import se.datadosen.util.annotations.Unbound;

public class UploadBean
implements RemoteFSProgressMonitor,
AutoCloseable {
    public static final String WEB_ROOT_PROPERTY = "webRoot";
    private static final String TIME_DIFF_TEST_NAME = "timedifftester.txt";
    private static final String AUTOUNZIP_EXTENSION = "zipstream";
    private static final String ZIPPED_ALBUM_NAME = "album.zipstream";
    private static final String ZIPPED_TEST_NAME = "test.zipstream";
    private static final String FILETREE_NAME = ":filetree";
    static final String LIFEBOAT_NAME = "lifeboat.zip";
    private transient List<TransferListener> transferListeners;
    private transient List<AlbumBeanListener> albumBeanListeners;
    private RemoteFSDelegate remoteFSBean = RemoteFSBean.createInstance();
    AtomicLong processedBytes = new AtomicLong(0L);
    private long totalBytes;
    private ProgressEvent eventObject;
    private AlbumBean engine;
    String remoteAlbumPath;
    private String baseDirectory = "";
    private String ftpServer = "";
    private String initialPath = "";
    private String ftpUser = "";
    private String ftpPassword = "";
    private boolean myjalbum;
    private boolean ftpForceUTF8 = false;
    private TransferProtocol protocol = TransferProtocol.ftp;
    private boolean passiveMode = true;
    private int ftpPort = 21;
    private boolean fireProgressEvents = true;
    private long timeDifference = 0L;
    private AccountProfile account;
    RemoteFSWorkers workers;
    private FileTreeProcessor processor;
    private boolean cancelled;
    private String remoteDirectory;
    private PropertyChangeSupport changeSupport;
    private final Stopwatch stopwatch = new Stopwatch();

    public UploadBean() {
    }

    public UploadBean(AlbumBean engine) {
        this.engine = engine;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Unbound
    public Stopwatch getStopwatch() {
        return this.stopwatch;
    }

    public static void showErrorDialog(Component owner, RemoteFSException ex, String messagePrefix, String title) {
        String copyToClipboard;
        Object[] options;
        Object message = messagePrefix != null ? messagePrefix + ": " : "";
        Object res = Dialogs.showOptionDialog(owner, message = (String)message + (ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage()), title, 0, options = new String[]{copyToClipboard = Msg.get("ui.copyToClipboard"), Msg.get("ok")}, options[1]);
        if (res == copyToClipboard) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection((String)message), null);
        }
    }

    public boolean cancelUpload() {
        this.cancelled = true;
        if (this.processor != null) {
            this.processor.shutdownNow();
            return this.processor.isShutdown();
        }
        return false;
    }

    @Unbound
    public RemoteFSDelegate getRemoteFS() {
        return this.remoteFSBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUploadFiles(File[] files, String remotePath, Set<File> skipFiles, AlbumManifest manifest, RemoteFSWorkers workers) throws RemoteFSException, IOException {
        try {
            this.uploadFilesImpl(files, remotePath, skipFiles, manifest, workers);
            workers.awaitCompletion();
        }
        finally {
            if (manifest != null) {
                this.eventObject.msg = Msg.get("upload.writingManifest");
                this.fireProgress(this.eventObject);
                workers.executeNow("manifest", remoteFS -> manifest.write(remoteFS, this.remoteAlbumPath));
            }
        }
    }

    private void uploadFilesImpl(File[] files, String remotePath, Set<File> skipFiles, AlbumManifest manifest, RemoteFSWorkers workers) throws RemoteFSException, IOException {
        for (File f : files) {
            if (f.isDirectory() || skipFiles.contains(f)) continue;
            String newPath = IO.combinePaths(remotePath, f.getName());
            workers.submit(f, remoteFS -> {
                ((ByteProgressEvent)this.eventObject).update(f.getParentFile().getName() + " (" + workers.getCurrentConnectionCount() + ")", f.getName(), this.processedBytes.get() + workers.getBytesInTransfer());
                this.fireFileProcessingStarted(this.eventObject);
                if (this.eventObject.isAborted()) {
                    throw new OperationAbortedException();
                }
                remoteFS.putFile(f, newPath);
                this.processedBytes.addAndGet(f.length());
                if (manifest != null) {
                    UploadBean uploadBean = this;
                    synchronized (uploadBean) {
                        manifest.putFile(new RemoteFileImpl(IO.relativePath(newPath, this.remoteAlbumPath), f.length(), f.lastModified()));
                    }
                }
                this.fireFileProcessingFinished(this.eventObject);
            });
        }
        for (File f : files) {
            File[] subFiles;
            if (!f.isDirectory() || skipFiles.contains(f) || !((subFiles = f.listFiles(new UploadFileFilter())) != null & subFiles.length > 0)) continue;
            String newPath = IO.combinePaths(remotePath, f.getName());
            if (manifest == null || !manifest.containsPrefix(IO.relativePath(newPath, this.remoteAlbumPath) + "/")) {
                workers.executeNow(newPath, remoteFS -> {
                    try {
                        remoteFS.createDirectory(newPath);
                    }
                    catch (RemoteFSException remoteFSException) {
                        // empty catch block
                    }
                });
            }
            this.uploadFilesImpl(subFiles, newPath, skipFiles, manifest, workers);
        }
    }

    private void doDeleteDirectory(String remotePath) throws RemoteFSException, IOException {
        try (RemoteFSWorkers wrk = new RemoteFSWorkers(this, Config.getConfig().getMaxSimultaneousTransfers());){
            this.doDeleteDirectory(remotePath, wrk);
        }
    }

    private void doDeleteDirectory(String remotePath, RemoteFSWorkers workers) throws RemoteFSException, IOException {
        RemoteFile[] files;
        this.remoteFSBean.setDirectory(remotePath);
        String relativeRemotePath = this.toRelative(remotePath);
        for (RemoteFile rf : files = this.remoteFSBean.getFiles(RemoteFSBean.noDotDotDotFileFilter)) {
            if (rf.isDirectory()) continue;
            workers.submit(rf, remoteFS -> {
                AlbumBeanEvent eventObject = new AlbumBeanEvent(this.engine, relativeRemotePath, rf.getName());
                this.fireImageProcessingStarted(eventObject);
                if (eventObject.isAborted()) {
                    throw new OperationAbortedException();
                }
                String fullPath = IO.combinePaths(remotePath, rf.getName());
                JAlbum.logger.finer("Deleting " + fullPath);
                remoteFS.removeFile(fullPath);
                this.fireImageProcessingFinished(eventObject);
            });
        }
        workers.awaitCompletion();
        for (RemoteFile rf : files) {
            if (!rf.isDirectory()) continue;
            String fullPath = IO.combinePaths(remotePath, rf.getName());
            this.doDeleteDirectory(fullPath, workers);
        }
        this.remoteFSBean.toParentDirectory();
        this.remoteFSBean.removeDirectory(remotePath);
    }

    public void deleteAlbum(AlbumObject root, String remoteDir) throws ParameterException, RemoteFSException, IOException {
        this.deleteDirectory(remoteDir);
        AlbumObjectProperties props = root.getProperties();
        if (this.toAbsolute(remoteDir).equals(this.toAbsolute(props.get("remotePath", "")))) {
            JAlbum.logger.info("Deleting album " + props.get("remotePath", ""));
            props.remove("accountProfileName");
            props.remove("remotePath");
            props.remove("albumURL");
            props.remove("albumId");
            props.remove("lastPublishedDate");
            props.save();
        }
    }

    public void deleteDirectory(String remoteDir) throws ParameterException, RemoteFSException, IOException {
        if (remoteDir.length() == 0) {
            throw new ParameterException("Cannot delete ftp root (security)");
        }
        String remotePath = this.toAbsolute(remoteDir);
        try {
            this.remoteFSBean.removeDirectory(remotePath);
            return;
        }
        catch (RemoteFSException remoteFSException) {
            this.doDeleteDirectory(remotePath);
            return;
        }
    }

    public void setFtpServer(String newFtpServer) {
        int pathIndex;
        this.ftpServer = newFtpServer.trim();
        int colonIndex = this.ftpServer.indexOf("://");
        if (colonIndex != -1) {
            this.ftpServer = this.ftpServer.substring(colonIndex + 3);
        }
        if ((pathIndex = this.ftpServer.indexOf(47)) != -1) {
            this.initialPath = this.ftpServer.substring(pathIndex + 1);
            this.ftpServer = this.ftpServer.substring(0, pathIndex);
        } else {
            this.initialPath = "";
        }
    }

    public String getFtpServer() {
        return this.ftpServer;
    }

    private String getInitialPath() {
        return this.initialPath;
    }

    public void setFtpPort(int newFtpPort) throws RemoteFSException {
        this.ftpPort = newFtpPort;
    }

    public int getFtpPort() throws RemoteFSException {
        return this.ftpPort;
    }

    public void setFtpUser(String newFtpUser) {
        this.ftpUser = newFtpUser.trim();
    }

    public String getFtpUser() {
        return this.ftpUser;
    }

    public void setFtpPassword(String newFtpPassword) {
        this.ftpPassword = newFtpPassword.trim();
    }

    public String getFtpPassword() {
        return this.ftpPassword;
    }

    public boolean isMyjalbum() {
        return this.myjalbum;
    }

    public void setMyjalbum(boolean myjalbum) {
        this.myjalbum = myjalbum;
    }

    public boolean isFtpForceUTF8() throws RemoteFSException {
        return this.ftpForceUTF8;
    }

    public void setFtpForceUTF8(boolean force) throws RemoteFSException {
        this.ftpForceUTF8 = force;
    }

    public TransferProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(TransferProtocol protocol) {
        this.protocol = protocol;
    }

    public void setPassiveMode(boolean newPassiveMode) throws RemoteFSException {
        this.passiveMode = newPassiveMode;
    }

    public boolean isPassiveMode() throws RemoteFSException {
        return this.passiveMode;
    }

    public void setAccountProperties(AccountProfile account) {
        Properties props;
        try {
            props = BeanBinder.getProperties(account);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        BeanBinder.setProperties(this, props);
        this.account = account;
    }

    AccountProfile getAccountProperties() {
        return this.account;
    }

    public void connect() throws RemoteFSException, IOException, AccountExpiredException, FailedLoginException {
        try {
            this.remoteFSBean.setProtocol(this.getProtocol());
            this.remoteFSBean.setProgressMonitor(this);
            this.remoteFSBean.setForceUTF8(this.isFtpForceUTF8());
            this.remoteFSBean.setPassiveMode(this.isPassiveMode());
            this.remoteFSBean.setPort(this.getFtpPort());
            this.remoteFSBean.setTrackDiskSpaceUsage(this.isMyjalbum());
            this.remoteFSBean.connect(this.getFtpServer(), this.getFtpUser(), this.getFtpPassword());
            if (this.initialPath.length() > 0) {
                this.remoteFSBean.setDirectory(this.initialPath);
            }
            this.baseDirectory = this.remoteFSBean.getDirectory();
        }
        catch (RemoteFSException ex) {
            if (this.account.isMyjalbum()) {
                try {
                    AccountManager.AccountStatus status = AccountManager.getJalbumAccountStatus(this.account);
                    Date accountExpires = status.getAccountExpires();
                    if (accountExpires != null && new Date().after(accountExpires)) {
                        throw new AccountExpiredException(Msg.get("publish.accountExpiredMessage", status.get("accountType"), status.getFormattedAccountExpires()));
                    }
                }
                catch (AuthenticationException ex1) {
                    throw new FailedLoginException(Msg.get("ui." + ex1.getMessage()));
                }
            }
            throw ex;
        }
    }

    public String getRemoteDirectory() {
        if (this.remoteDirectory == null) {
            this.remoteDirectory = this.engine.getRemoteDirectory();
        }
        return this.remoteDirectory;
    }

    public void setRemoteDirectory(String remoteDirectory) {
        this.remoteDirectory = remoteDirectory;
    }

    public void disconnect() {
        try {
            this.remoteFSBean.disconnect();
            this.account = null;
        }
        catch (IOException | RemoteFSException exception) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        try {
            return this.remoteFSBean.isConnected();
        }
        catch (RemoteFSException ex) {
            return false;
        }
    }

    public void testConnection(AlbumBean engine) throws IOException, RemoteFSException {
        this.remoteFSBean.testConnection(this.getFtpServer(), this.getFtpUser(), this.getFtpPassword());
    }

    @Unbound
    String getFtpWebRootDirectory() {
        if (this.account.getFtpWebRootDirectory().equals("VALUE_UNSET")) {
            return "VALUE_UNSET";
        }
        return this.account.isShowServerRootDirectory() ? this.toAbsolute(this.account.getFtpWebRootDirectory()) : this.toRelative(this.account.getFtpWebRootDirectory());
    }

    void setEngine(AlbumBean engine) {
        this.engine = engine;
    }

    @Unbound
    public String getPrintableAlbumURL() {
        String albumURL = this.getAlbumURL();
        return albumURL != null ? albumURL : "[" + Msg.get("ui.unreachableAddressAt", this.account.getFtpServer() + "]");
    }

    @Unbound
    public String getAlbumURL() {
        Object uri;
        String webRoot = this.getFtpWebRootDirectory();
        if (webRoot == null) {
            webRoot = "";
        }
        if (((String)(uri = IO.relativePath(IO.combinePaths("/", this.getRemoteDirectory()), IO.combinePaths("/", webRoot)))).startsWith("..")) {
            return null;
        }
        if (((String)uri).equals(".")) {
            uri = "";
        }
        uri = !"index".equals(this.engine.getIndexPageName()) ? IO.combinePaths((String)uri, this.engine.getIndexPageName() + this.engine.getPageExtension()) : (String)uri + "/";
        String url = IO.combinePaths(this.account.getWebRootURL(), (String)uri);
        return url;
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFiles(Set<RemoteFile> toDelete, AlbumManifest manifest, RemoteFSWorkers workers) throws IOException, RemoteFSException {
        if (toDelete.isEmpty()) {
            return;
        }
        AtomicInteger fileNum = new AtomicInteger(1);
        try {
            for (RemoteFile rf : toDelete) {
                workers.submit(rf, remoteFS -> {
                    String dir = rf.getParentPath() + " (" + workers.getCurrentConnectionCount() + ")";
                    FileProgressEvent eventObject = new FileProgressEvent((Object)this, dir, Msg.get("upload.deletingUnusedFiles"), fileNum.get(), toDelete.size());
                    this.fireFileProcessingStarted(eventObject);
                    if (eventObject.isAborted()) {
                        throw new OperationAbortedException();
                    }
                    try {
                        String newPath = IO.combinePaths(this.remoteAlbumPath, rf.getFullPath());
                        remoteFS.removeFile(newPath);
                    }
                    catch (RemoteFSException remoteFSException) {
                        // empty catch block
                    }
                    manifest.removeFile(rf);
                    this.fireFileProcessingFinished(eventObject);
                    fileNum.incrementAndGet();
                });
            }
            workers.awaitCompletion();
        }
        finally {
            workers.executeNow("manifest", remoteFS -> manifest.write(remoteFS, this.remoteAlbumPath));
        }
    }

    private void deleteEmptyDirectories(Set<RemoteFile> toDelete, AlbumManifest manifest) throws RemoteFSException, IOException {
        TreeSet<String> dirsToDelete = new TreeSet<String>();
        for (RemoteFile rf : toDelete) {
            dirsToDelete.add(IO.parentPath(rf.getFullPath()));
        }
        Iterator it = dirsToDelete.descendingIterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            String p = path;
            if (manifest.containsPrefix(p)) continue;
            String fullP = IO.combinePaths(this.remoteAlbumPath, p);
            try {
                this.remoteFSBean.removeDirectory(fullP);
            }
            catch (RemoteFSException ex) {
                System.err.println("Can't delete directory " + p + ": " + ex.getMessage());
                break;
            }
        }
    }

    public static long getTotalSize(Set<RemoteFile> files, int clusterSize) {
        long total = 0L;
        for (RemoteFile rf : files) {
            total += (rf.size() + (long)clusterSize - 1L) / (long)clusterSize * (long)clusterSize;
        }
        return total;
    }

    private String toAbsolute(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        return IO.combinePaths(this.baseDirectory, path);
    }

    String toRelative(String path) {
        if (!path.startsWith("/")) {
            return path;
        }
        String rel = IO.relativePath(path, this.baseDirectory);
        if (rel.startsWith("..")) {
            return path;
        }
        return rel;
    }

    public NavigableSet<RemoteFile> getExistingAlbumFiles(AlbumBean engine, String remoteDirectory) throws IOException, RemoteFSException {
        return this.getExistingAlbumFiles(engine, remoteDirectory, null);
    }

    @Override
    public void close() {
        this.disconnect();
    }

    public NavigableSet<RemoteFile> getExistingAlbumFiles(AlbumBean engine, String remoteDirectory, Consumer<RemoteFile> consumer) throws IOException, RemoteFSException {
        this.remoteFSBean.setProgressMonitor(this);
        this.eventObject = new ProgressEvent(this, Msg.get("upload.checkingExistingFiles"));
        this.fireProgress(this.eventObject);
        String remoteDir = this.toAbsolute(remoteDirectory);
        NavigableSet<RemoteFile> existingFiles = new TreeSet<RemoteFile>();
        try {
            this.remoteFSBean.setDirectory(remoteDir);
            RemoteFile[] rFiles = this.remoteFSBean.getFiles(RemoteFSBean.noDotDotDotFileFilter);
            existingFiles.addAll(Arrays.asList(rFiles));
            if (existingFiles.isEmpty()) {
                return existingFiles;
            }
        }
        catch (RemoteFSException ex) {
            return existingFiles;
        }
        try {
            if (existingFiles.contains(new RemoteFileImpl("manifest.jmf"))) {
                AlbumManifest manifest = new AlbumManifest(this.remoteFSBean, remoteDir);
                return manifest.getContent();
            }
        }
        catch (IOException | RemoteFSException manifest) {
            // empty catch block
        }
        try {
            this.timeDifference = this.calcTimeDifference(remoteDir);
            existingFiles = this.getFileTree(remoteDir);
            return existingFiles;
        }
        catch (ParseException ex) {
            ex.printStackTrace(System.err);
            return this.collectExistingFiles(remoteDir, remoteDir, engine.getOutputDir(), new MonitoredTreeSet<RemoteFile>(consumer));
        }
        catch (RemoteFSException ex) {
            return this.collectExistingFiles(remoteDir, remoteDir, engine.getOutputDir(), new MonitoredTreeSet<RemoteFile>(consumer));
        }
    }

    private NavigableSet<RemoteFile> getFileTree(String remoteDir) throws IOException, RemoteFSException, ParseException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.remoteFSBean.getUnmonitored(IO.combinePaths(remoteDir, FILETREE_NAME), bos);
        bos.flush();
        bos.close();
        byte[] rawbytes = bos.toByteArray();
        String content = new String(rawbytes, "UTF-8");
        TreeSet<RemoteFile> files = new TreeSet<RemoteFile>();
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMddHHmmss");
        Scanner sc = new Scanner(content);
        int pathStart = remoteDir.length() + 1;
        while (sc.hasNextLine()) {
            String rights = sc.next();
            if (rights.charAt(0) == 'd') {
                sc.nextLine();
                continue;
            }
            sc.next();
            sc.next();
            sc.next();
            long size = sc.nextLong();
            Date date = dateFormatter.parse(sc.next());
            sc.next();
            sc.next();
            String pathFromRoot = sc.nextLine().substring(1);
            files.add(new RemoteFileImpl(pathFromRoot.substring(pathStart), size, date.getTime() - this.timeDifference));
        }
        return files;
    }

    private void updateProperties() {
        AlbumObjectProperties props = this.engine.getProjectProperties();
        long now = new Date().getTime();
        props.put("lastPublishedDate", now);
        if (!props.containsKey("firstPublishedDate")) {
            props.put("firstPublishedDate", now);
        }
        props.put("accountProfileName", this.engine.getAccountProfileName());
        props.put("remotePath", this.getRemoteDirectory());
        String albumURL = this.getAlbumURL();
        if (albumURL != null) {
            props.put("albumURL", albumURL);
        } else {
            props.remove("albumURL");
        }
        props.save(true);
    }

    public AlbumManifest uploadAlbum(AlbumBean engine, boolean fullUpdate) throws RemoteFSException, IOException {
        this.engine = engine;
        this.fireProgressEvents = false;
        return this.uploadAlbum(engine, fullUpdate, null, this.getExistingAlbumFiles(engine, this.getRemoteDirectory()));
    }

    public AlbumManifest uploadAlbum(AlbumBean engine, boolean fullUpdate, Set<File> localAlbumFiles, NavigableSet<RemoteFile> existingFiles) throws RemoteFSException, IOException, OperationAbortedException {
        this.engine = engine;
        this.fireProgressEvents = false;
        File dir = engine.getOutputDir();
        if (!dir.isDirectory()) {
            throw new IOException(Msg.get("publish.invalidOutputDirectoryError"));
        }
        this.processedBytes.set(0L);
        this.eventObject = new ProgressEvent(this, Msg.get("upload.comparingFilesInfo"));
        this.remoteAlbumPath = this.toAbsolute(this.getRemoteDirectory());
        try {
            this.remoteFSBean.setDirectory(this.remoteAlbumPath);
        }
        catch (RemoteFSException ex) {
            this.remoteFSBean.createDirectory(this.remoteAlbumPath);
            this.remoteFSBean.setDirectory(this.remoteAlbumPath);
        }
        if (engine.getCurrentProject() != null && this.account != null) {
            System.out.println("\n" + Msg.get("ui.uploadingAlbumStarted", engine.getCurrentProject().getName(), this.getPrintableAlbumURL()));
        }
        if (this.cancelled) {
            throw new OperationAbortedException(Msg.get("ui.uploadCancelled"));
        }
        if (localAlbumFiles == null) {
            this.eventObject = new ProgressEvent(this, Msg.get("upload.comparingFilesInfo"));
            this.fireProgress(this.eventObject);
            localAlbumFiles = this.getAllLocalFiles(new File[]{dir}, dir);
        }
        AlbumManifest manifest = new AlbumManifest(existingFiles);
        HashMap<RemoteFileImpl, File> localMapper = new HashMap<RemoteFileImpl, File>();
        for (File f2 : localAlbumFiles) {
            localMapper.put(new RemoteFileImpl(f2, dir), f2);
        }
        TreeSet<RemoteFile> toDelete = new TreeSet<RemoteFile>();
        toDelete.addAll(existingFiles);
        toDelete.removeAll(localMapper.keySet());
        TreeSet<File> skipFiles = new TreeSet<File>();
        if (!fullUpdate) {
            Iterator<RemoteFile> it = existingFiles.iterator();
            while (it.hasNext()) {
                RemoteFile rf = it.next();
                File local = (File)localMapper.get(rf);
                if (local != null) {
                    if (local.lastModified() / 1000L * 1000L > rf.getModificationDate().getTime() / 1000L * 1000L || local.length() != rf.size()) continue;
                    skipFiles.add(local);
                    continue;
                }
                if (rf.getFullPath().contains("hi-res/")) continue;
                it.remove();
            }
        }
        if (this.cancelled) {
            throw new OperationAbortedException(Msg.get("ui.uploadCancelled"));
        }
        try (RemoteFSWorkers workers = this.createWorkers();){
            if (existingFiles instanceof AlbumManifest.ManifestBasedSet) {
                this.deleteFiles(toDelete, manifest, workers);
                if (!this.account.isMyjalbum()) {
                    this.deleteEmptyDirectories(toDelete, manifest);
                }
            }
            try {
                this.remoteFSBean.removeFile(IO.combinePaths(this.remoteAlbumPath, "manifest.jmf"));
            }
            catch (RemoteFSException rf) {
                // empty catch block
            }
            this.totalBytes = localAlbumFiles.stream().filter(f -> !skipFiles.contains(f)).mapToLong(File::length).sum();
            this.remoteFSBean.setProgressMonitor(this);
            this.stopwatch.reset();
            this.stopwatch.start();
            this.eventObject = new ByteProgressEvent((Object)this, this.totalBytes);
            if (Config.getConfig().isZipstreaming() && this.hasZipstreamingSupport()) {
                this.fireProgressEvents = true;
                System.out.println("Zip stream support detected");
                this.uploadFilesZipped(this.toFileSet(CachedFile.listFiles(dir, new UploadFileFilter())), dir, skipFiles, this.remoteAlbumPath, manifest);
            } else {
                this.fireProgressEvents = true;
                this.doUploadFiles(CachedFile.listFiles(dir, new UploadFileFilter()), this.remoteAlbumPath, skipFiles, manifest, workers);
            }
            this.stopwatch.stop();
            if (engine.getCurrentProject() != null && this.account != null) {
                System.out.println(Msg.get("ui.uploadingAlbumDone", engine.getCurrentProject().getName(), this.getPrintableAlbumURL(), this.stopwatch));
            }
            this.updateProperties();
            String albumURL = this.getAlbumURL();
            if (engine.getCurrentProject() != null && this.account != null && albumURL != null) {
                this.doAfterUploadAlbum(engine.getCurrentProject(), albumURL);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
            if (this.remoteFSBean.isConnected()) {
                this.remoteFSBean.disconnect();
            }
            this.remoteFSBean.reconnect();
            manifest.write(this.remoteFSBean, this.remoteAlbumPath);
            throw ex;
        }
        catch (RemoteFSException ex) {
            ex.printStackTrace(System.err);
            manifest.write(this.remoteFSBean, this.remoteAlbumPath);
            if (existingFiles instanceof AlbumManifest.ManifestBasedSet) {
                System.out.println("Dirty manifest.jmf. Comparing files manually.");
                return this.uploadAlbum(engine, fullUpdate, localAlbumFiles, this.collectExistingFiles(this.remoteAlbumPath, dir));
            }
            throw ex;
        }
        catch (ElementException ex) {
            Logger.getLogger(UploadBean.class.getName()).log(Level.SEVERE, null, ex);
        }
        return manifest;
    }

    private void doAfterUploadAlbum(AlbumProject project, final String albumURL) throws IOException, ElementException {
        this.engine.setRemoteDirectory(this.getRemoteDirectory());
        final AlbumObject root = project.getRootFolder();
        String cid = AccountManager.resolveCid(this.account);
        final AlbumObjectProperties props = root.getProperties();
        new Thread(this, "CategoryCounter"){
            final /* synthetic */ UploadBean this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void run() {
                try {
                    boolean usesFFMpegVideo;
                    CategoryCounters counters = JAlbumUtilities.countCategories(root);
                    boolean bl = usesFFMpegVideo = counters.getCount(Category.video) > 0 && props.get("ffmpegVideo", false) != false;
                    if (!usesFFMpegVideo) {
                        AlbumObjectProperties props2 = root.getProperties();
                        props2.remove("ffmpegVideo");
                        props2.save(true);
                    }
                    Tracer.getInstance().trace("publish album", albumURL, "skin:" + this.this$0.engine.getSkin() + "; style:" + this.this$0.engine.getStyle(), "ffmpegVideo:" + usesFFMpegVideo, "lang:" + Config.getConfig().getInterpretedLanguage() + "; images:" + counters.getCount(Category.image) + "; videos=" + counters.getCount(Category.video));
                }
                catch (CircularFolderReferenceException ex) {
                    System.err.println(ex);
                }
            }
        }.start();
        Notifier notifier = new Notifier(JAlbumContext.getInstance());
        if (cid != null && notifier.allowedToNotify(this.account)) {
            this.eventObject.msg = Msg.get("publish.updatingProfilePage") + "...";
            this.eventObject.subMessage = "";
            this.fireProgress(this.eventObject);
            notifier.albumAdded(this.account, albumURL, project, false);
        }
    }

    private RemoteFSWorkers createWorkers() {
        RemoteFSWorkers workers;
        this.workers = workers = new RemoteFSWorkers(this, Config.getConfig().getMaxSimultaneousTransfers());
        this.eventObject = new ByteProgressEvent((Object)this, this.totalBytes);
        workers.setProgressMonitor(currentBytes -> {
            this.eventObject.processed = this.processedBytes.get() + currentBytes;
            this.fireFileProcessingProgress(this.eventObject);
        });
        return workers;
    }

    public void uploadFiles(File[] filesDirs, String remotePath) throws RemoteFSException, IOException, OperationAbortedException {
        try (RemoteFSWorkers workers = this.createWorkers();){
            this.processedBytes.set(0L);
            this.totalBytes = this.getTotalFileSize(filesDirs, null);
            this.remoteFSBean.setProgressMonitor(this);
            this.doUploadFiles(filesDirs, this.toAbsolute(remotePath), new HashSet<File>(), null, workers);
        }
    }

    private Set<File> toFileSet(File[] files) {
        TreeSet<File> set = new TreeSet<File>();
        set.addAll(Arrays.asList(files));
        return set;
    }

    private List<FileNode> toFileNodeList(FileNode parent, File[] files, Set<File> skipFiles) {
        ArrayList<FileNode> fileNodes = null;
        if (files != null) {
            fileNodes = new ArrayList<FileNode>();
            for (File f : files) {
                if (skipFiles == null || !skipFiles.contains(f)) {
                    FileNode node = new FileNode(f);
                    if (f.isDirectory()) {
                        node.setChildren(this.toFileNodeList(node, f.listFiles(new UploadFileFilter()), skipFiles));
                    }
                    fileNodes.add(node);
                    continue;
                }
                if (parent == null) continue;
                parent.setProcessed(true);
            }
        }
        return fileNodes;
    }

    public void downloadFile(RemoteFSNode node, File destination) throws RemoteFSException, IOException, OperationAbortedException {
        this.processedBytes.set(0L);
        this.totalBytes = node.getSize();
        this.eventObject = new ByteProgressEvent(this, node.oldRemotePath(), node.getRemoteName(), 0L, this.totalBytes);
        this.remoteFSBean.setDirectory(((RemoteFSNode)node.getParent()).remotePath());
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(destination));){
            this.remoteFSBean.get(node.getRemoteName(), os);
        }
        this.processedBytes.addAndGet(node.getSize());
        this.fireFileProcessingFinished(this.eventObject);
    }

    public void downloadFiles(String remotePath, File destination) throws RemoteFSException, IOException, OperationAbortedException {
        Stopwatch stopwatch = new Stopwatch("Folder download");
        stopwatch.start();
        this.processedBytes.set(0L);
        NavigableSet<RemoteFile> existingFiles = this.collectExistingFiles(this.toAbsolute(remotePath), null);
        this.totalBytes = UploadBean.getTotalSize(existingFiles, 1);
        this.eventObject = new ByteProgressEvent((Object)this, this.totalBytes);
        DownloadWorkers workers = new DownloadWorkers(this, (ByteProgressEvent)this.eventObject, existingFiles, this.toAbsolute(remotePath), Config.getConfig().getMaxSimultaneousTransfers(), destination);
        try {
            workers.downloadFiles();
            stopwatch.print();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(UploadBean.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private long calcTimeDifference(String remoteDir) {
        long diff = 0L;
        try {
            String s = "The purpose of this file is to synchronize the clock of the server with jAlbum. It can be safely removed";
            byte[] bytes = s.getBytes("ISO-8859-1");
            try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
                this.remoteFSBean.put(in, TIME_DIFF_TEST_NAME);
            }
            Date localTime = new Date();
            RemoteFile[] files = this.remoteFSBean.getFiles();
            this.remoteFSBean.removeFile(TIME_DIFF_TEST_NAME);
            for (RemoteFile file : files) {
                if (!file.getName().equals(TIME_DIFF_TEST_NAME)) continue;
                diff = file.getModificationDate().getTime() - localTime.getTime();
                break;
            }
        }
        catch (IOException | RemoteFSException ex) {
            ex.printStackTrace(System.err);
        }
        return diff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadZipEntry(String path, InputStream in, ZipOutputStream out, boolean fireEvents) throws IOException {
        ZipEntry ze = new ZipEntry(path);
        out.putNextEntry(ze);
        try {
            byte[] b = new byte[32768];
            int bytesRead = 0;
            this.eventObject.processed = this.processedBytes.get();
            while (bytesRead >= 0) {
                bytesRead = in.read(b);
                if (bytesRead <= 0) continue;
                out.write(b, 0, bytesRead);
                if (!fireEvents) continue;
                this.eventObject.processed += (long)bytesRead;
                this.fireFileProcessingProgress(this.eventObject);
            }
            out.closeEntry();
        }
        finally {
            in.close();
        }
    }

    private void uploadFilesZipped(Set<File> filesDirs, File root, Set<File> skipFiles, ZipOutputStream out, AlbumManifest manifest) throws RemoteFSException, IOException {
        if (skipFiles != null) {
            filesDirs.removeAll(skipFiles);
        }
        for (File f : filesDirs) {
            if (f.isDirectory()) {
                Set<File> children = this.toFileSet(f.listFiles(new UploadFileFilter()));
                if (skipFiles != null) {
                    children.removeAll(skipFiles);
                }
                out.putNextEntry(new ZipEntry(IO.relativePath(f, root) + "/"));
                if (children.size() <= 0) continue;
                this.uploadFilesZipped(children, root, skipFiles, out, manifest);
                continue;
            }
            this.eventObject = new ByteProgressEvent(this, f.getParentFile().getName(), f.getName(), this.processedBytes.get(), this.totalBytes);
            this.fireFileProcessingStarted(this.eventObject);
            if (this.eventObject.isAborted()) {
                throw new OperationAbortedException();
            }
            String path = IO.relativePath(f, root);
            this.uploadZipEntry(path, new FileInputStream(f), out, true);
            if (manifest != null) {
                manifest.putFile(new RemoteFileImpl(IO.relativePath(f, root), f.length(), f.lastModified()));
            }
            this.fireFileProcessingFinished(this.eventObject);
            if (this.eventObject.isAborted()) {
                throw new OperationAbortedException();
            }
            this.processedBytes.addAndGet(f.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFilesZipped(Set<File> filesDirs, File root, Set<File> skipFiles, String remotePath, AlbumManifest manifest) throws RemoteFSException, IOException, OperationAbortedException {
        this.remoteFSBean.setDirectory(remotePath);
        PipedOutputStream out = new PipedOutputStream();
        final PipedInputStream in = new PipedInputStream(out);
        Thread putterThread = new Thread(this, "putter thread"){
            final /* synthetic */ UploadBean this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void run() {
                try {
                    this.this$0.fireProgressEvents = false;
                    this.this$0.remoteFSBean.put(in, UploadBean.ZIPPED_ALBUM_NAME);
                }
                catch (IOException | RemoteFSException ex) {
                    ex.printStackTrace(System.err);
                }
                finally {
                    this.this$0.fireProgressEvents = true;
                }
            }
        };
        putterThread.start();
        ZipOutputStream zout = new ZipOutputStream(out);
        zout.setLevel(1);
        int manifestHash = manifest.hashCode();
        try {
            this.uploadFilesZipped(filesDirs, root, skipFiles, zout, manifest);
        }
        finally {
            this.eventObject.msg = Msg.get("upload.writingManifest");
            this.fireProgress(this.eventObject);
            this.uploadZipEntry("manifest.jmf", new ByteArrayInputStream(manifest.getBytes()), zout, false);
            zout.finish();
            zout.close();
            try {
                putterThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasZipstreamingSupport() throws IOException, RemoteFSException {
        String testFileName = new Date().getTime() + ".tmp";
        PipedOutputStream out = new PipedOutputStream();
        final PipedInputStream in = new PipedInputStream(out);
        ReportingThread putterThread = new ReportingThread(this, "putter thread"){
            final /* synthetic */ UploadBean this$0;
            {
                this.this$0 = this$0;
                super(name);
            }

            @Override
            protected void runWithTry() throws Throwable {
                this.this$0.remoteFSBean.put(in, UploadBean.ZIPPED_TEST_NAME);
            }
        };
        putterThread.start();
        ZipOutputStream zout = new ZipOutputStream(out);
        zout.setLevel(1);
        try {
            zout.putNextEntry(new ZipEntry(testFileName));
            zout.closeEntry();
            zout.finish();
        }
        finally {
            zout.close();
            try {
                putterThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            this.remoteFSBean.removeFile(testFileName);
            return true;
        }
        catch (RemoteFSException ex) {
            if (putterThread.finishedNormally()) {
                try {
                    this.remoteFSBean.removeFile(ZIPPED_TEST_NAME);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private NavigableSet<RemoteFile> collectExistingFiles(String remotePath, File localDir) throws RemoteFSException, IOException {
        return this.collectExistingFiles(remotePath, remotePath, localDir, new TreeSet<RemoteFile>());
    }

    private NavigableSet<RemoteFile> collectExistingFiles(String root, String remotePath, File localDir, NavigableSet<RemoteFile> existing) throws RemoteFSException, IOException {
        try {
            RemoteFile[] rFiles;
            for (RemoteFile remoteFile : rFiles = this.remoteFSBean.getFiles(remotePath, RemoteFSBean.noDotDotDotFileFilter)) {
                File f;
                String fullPath = IO.combinePaths(remotePath, remoteFile.getName());
                File file = f = localDir != null ? new File(localDir, remoteFile.getName()) : null;
                if (remoteFile.isDirectory() && (f == null || f.exists() && f.isDirectory())) {
                    this.collectExistingFiles(root, fullPath, f, existing);
                    continue;
                }
                existing.add(new RemoteFileImpl(IO.relativePath(fullPath, root), remoteFile.size(), remoteFile.getModificationDate().getTime() - this.timeDifference));
            }
        }
        catch (RemoteFSException remoteFSException) {
            // empty catch block
        }
        return existing;
    }

    private long getTotalFileSize(File[] filesDirs, Set<File> skipFiles) throws IOException {
        try (FileTreeProcessor p = new FileTreeProcessor(new FileTreeCollection(filesDirs, (FileFilter)new UploadFileFilter()));){
            this.processor = p;
            long l = p.process(str -> str.peek(f -> {
                if (Thread.interrupted()) {
                    throw new OperationAbortedException();
                }
            }).filter(f -> !f.isDirectory() && (skipFiles == null || !skipFiles.contains(f))).mapToLong(File::length).sum());
            return l;
        }
    }

    private Set<File> getAllLocalFiles(File[] filesDirs, File root) throws IOException {
        return this.getAllFiles(filesDirs, new TreeSet<RemoteFile>(), root);
    }

    private Set<File> getAllFiles(File[] filesDirs, Set<RemoteFile> allFiles, File root) throws IOException {
        try (FileTreeProcessor p = new FileTreeProcessor(new FileTreeCollection(filesDirs, (FileFilter)new UploadFileFilter()));){
            this.processor = p;
            Set set = p.process(str -> str.peek(f -> {
                if (Thread.interrupted()) {
                    throw new OperationAbortedException(Msg.get("ui.uploadCancelled"));
                }
            }).filter(f -> !f.isDirectory()).collect(Collectors.toSet()));
            return set;
        }
    }

    public synchronized void addTransferListener(TransferListener l) {
        ArrayList<TransferListener> listeners;
        ArrayList<TransferListener> arrayList = listeners = this.transferListeners == null ? new ArrayList<TransferListener>(2) : new ArrayList<TransferListener>(this.transferListeners);
        if (!listeners.contains(l)) {
            listeners.add(l);
            this.transferListeners = listeners;
        }
    }

    public synchronized void removeTransferListener(TransferListener l) {
        if (this.transferListeners != null && this.transferListeners.contains(l)) {
            ArrayList<TransferListener> listeners = new ArrayList<TransferListener>(this.transferListeners);
            listeners.remove(l);
            this.transferListeners = listeners;
        }
    }

    protected void fireProgress(ProgressEvent e) {
        if (this.transferListeners != null) {
            for (TransferListener l : this.transferListeners) {
                l.progress(e);
            }
        }
    }

    protected void fireFileProcessingStarted(ProgressEvent e) {
        if (this.transferListeners != null) {
            for (TransferListener l : this.transferListeners) {
                l.fileProcessingStarted(e);
            }
        }
    }

    protected void fireFileProcessingProgress(ProgressEvent e) {
        if (this.transferListeners != null) {
            for (TransferListener l : this.transferListeners) {
                l.fileProcessingProgress(e);
            }
        }
    }

    protected void fireFileProcessingFinished(ProgressEvent e) {
        if (this.transferListeners != null) {
            for (TransferListener l : this.transferListeners) {
                l.fileProcessingFinished(e);
            }
        }
    }

    protected void fireErrorOccured(Exception param1, File param2) {
        if (this.transferListeners != null) {
            for (TransferListener l : this.transferListeners) {
                l.errorOccured(param1, param2);
            }
        }
    }

    public synchronized void addAlbumBeanListener(AlbumBeanListener l) {
        ArrayList<AlbumBeanListener> listeners;
        ArrayList<AlbumBeanListener> arrayList = listeners = this.albumBeanListeners == null ? new ArrayList<AlbumBeanListener>(2) : new ArrayList<AlbumBeanListener>(this.albumBeanListeners);
        if (!listeners.contains(l)) {
            listeners.add(l);
            this.albumBeanListeners = listeners;
        }
    }

    public synchronized void removeAlbumBeanListener(AlbumBeanListener l) {
        if (this.albumBeanListeners != null && this.albumBeanListeners.contains(l)) {
            ArrayList<AlbumBeanListener> listeners = new ArrayList<AlbumBeanListener>(this.albumBeanListeners);
            listeners.remove(l);
            this.albumBeanListeners = listeners;
        }
    }

    protected void fireImageProcessingStarted(AlbumBeanEvent e) {
        if (this.albumBeanListeners != null) {
            for (AlbumBeanListener l : this.albumBeanListeners) {
                l.imageProcessingStarted(e);
            }
        }
    }

    protected void fireImageProcessingFinished(AlbumBeanEvent e) {
        if (this.albumBeanListeners != null) {
            for (AlbumBeanListener l : this.albumBeanListeners) {
                l.imageProcessingFinished(e);
            }
        }
    }

    @Override
    public void bytesTransferred(long bytes) {
        if (this.fireProgressEvents && this.eventObject != null) {
            this.eventObject.processed = this.processedBytes.get() + bytes;
            this.fireFileProcessingProgress(this.eventObject);
        }
    }

    public PathFinder getPathFinder(AccountProfile account, AlbumBean engine) throws IOException, RemoteFSException {
        return new PathFinder(account, engine);
    }

    public PathFinder getPathFinder(AlbumObject root, AlbumBean engine) throws IOException, RemoteFSException {
        if (root.getProperties().containsKey("albumURL")) {
            return new PathFinder(root);
        }
        return new PathFinder(this.account, engine);
    }

    static {
        RemoteFSBean.addDiskSpaceListener(e -> {
            try {
                if (SignInManager.getInstance().isSignedIn()) {
                    String userName = SignInManager.getInstance().getUserName();
                    AccountProfile account1 = AccountManager.getInstance().findJAlbumAccountByUserName(userName);
                    if (account1 != null && account1.getFtpServer().equals(e.getServerName())) {
                        JAlbumContext.getInstance().getFrame().accountStatusPanel.updateAction.actionPerformed(null);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        });
    }

    static class UploadFileFilter
    implements FileFilter {
        private Pattern pattern;

        public UploadFileFilter(String ignorePattern) {
            this.pattern = Pattern.compile(ignorePattern);
        }

        public UploadFileFilter() {
            this.pattern = this.pattern = Pattern.compile("");
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            Matcher m = this.pattern.matcher(name);
            return !m.matches() && !name.endsWith(".jap") && !name.equals(".DS_Store") && !name.equals(".jalbum") && !name.equals("manifest.jmf");
        }
    }

    private static class MonitoredTreeSet<T>
    extends TreeSet<T> {
        Consumer<T> consumer;

        public MonitoredTreeSet(Consumer<T> consumer) {
            this.consumer = consumer;
        }

        @Override
        public boolean add(T e) {
            if (this.consumer != null) {
                this.consumer.accept(e);
            }
            return super.add(e);
        }
    }

    static class FileNode {
        private File file;
        private AtomicBoolean doProcess;
        private List<FileNode> children;
        private boolean processed;
        private boolean failed;

        public FileNode(File file) {
            this.file = file;
            this.doProcess = new AtomicBoolean(true);
        }

        public File getFile() {
            return this.file;
        }

        public List<FileNode> getChildren() {
            return this.children;
        }

        public void setChildren(List<FileNode> children) {
            this.children = children;
        }

        public boolean doProcess() {
            return this.doProcess.getAndSet(false);
        }

        public boolean isProcessed() {
            return this.processed;
        }

        public boolean isInProcessing() {
            return !this.processed && !this.doProcess.get();
        }

        public void setProcessed(boolean processed) {
            this.processed = processed;
            this.failed = false;
        }

        void retry() {
            this.doProcess = new AtomicBoolean(true);
            this.processed = false;
            this.failed = true;
        }

        public boolean isFailed() {
            return this.failed;
        }
    }

    public class PathFinder {
        String resolvedWebRootDirectory;
        String resolvedRemoteDirectory;
        String resolvedAlbumURL;
        AccountProfile account;
        AlbumBean engine;

        private PathFinder(AccountProfile account, AlbumBean engine) throws IOException, RemoteFSException {
            this.account = account;
            this.engine = engine;
            if (!UploadBean.this.isConnected()) {
                throw new RuntimeException("Not connected");
            }
            this.resolveDirectories();
            this.resolveAlbumURL();
        }

        private PathFinder(AlbumObject root) {
            AlbumObjectProperties props = root.getProperties();
            this.resolvedAlbumURL = (String)props.get("albumURL");
            this.resolvedRemoteDirectory = (String)props.get("remotePath");
        }

        private void resolveDirectories() throws IOException, RemoteFSException {
            String remoteDirectory;
            String webRootDirectory = this.account.getFtpWebRootDirectory();
            if (webRootDirectory.equals("VALUE_UNSET")) {
                this.resolvedWebRootDirectory = "";
                RemoteFile[] files = UploadBean.this.remoteFSBean.getFiles(UploadBean.this.toAbsolute(UploadBean.this.getBaseDirectory()));
                HashSet<String> webRootNames = new HashSet<String>();
                webRootNames.add("public_html");
                webRootNames.add("htdocs");
                webRootNames.add("wwwroot");
                webRootNames.add("httpdocs");
                webRootNames.add("www");
                webRootNames.add("html");
                for (RemoteFile f : files) {
                    if (!f.isDirectory() || !webRootNames.contains(f.getName().toLowerCase())) continue;
                    this.resolvedWebRootDirectory = f.getName();
                    break;
                }
            } else {
                this.resolvedWebRootDirectory = webRootDirectory;
            }
            if ((remoteDirectory = this.engine.getRemoteDirectory()).length() > 0 && UploadBean.this.remoteFSBean.existsDirectory(UploadBean.this.toAbsolute(remoteDirectory))) {
                this.resolvedRemoteDirectory = remoteDirectory;
                return;
            }
            String projectName = new File(this.engine.getDirectory()).getName();
            this.resolvedRemoteDirectory = IO.combinePaths(this.resolvedWebRootDirectory, projectName);
        }

        private void resolveAlbumURL() {
            String uri = IO.relativePath(this.resolvedRemoteDirectory, this.resolvedWebRootDirectory);
            if (uri.startsWith("..")) {
                return;
            }
            if (uri.equals(".")) {
                uri = "";
            }
            uri = !"index".equals(this.engine.getIndexPageName()) ? IO.combinePaths(uri, this.engine.getIndexPageName() + this.engine.getPageExtension()) : IO.combinePaths(uri, "/");
            this.resolvedAlbumURL = IO.combinePaths(this.account.getWebRootURL(), uri);
        }

        public String getResolvedRemoteDirectory() {
            return this.resolvedRemoteDirectory;
        }

        public String getResolvedAlbumURL() {
            return this.resolvedAlbumURL;
        }

        public boolean albumExists() throws IOException, RemoteFSException {
            try {
                return UploadBean.this.remoteFSBean.existsDirectory(UploadBean.this.toAbsolute(this.resolvedRemoteDirectory));
            }
            catch (RemoteFSException ex) {
                try {
                    RemoteFile[] files = UploadBean.this.remoteFSBean.getFiles(UploadBean.this.toAbsolute(this.resolvedRemoteDirectory));
                    return true;
                }
                catch (RemoteFSException remoteFSException) {
                    return false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int verifyWebAccess() throws UnsupportedEncodingException, IOException, RemoteFSException {
            String fileName = "webAccessTest.txt";
            String path = IO.combinePaths(UploadBean.this.toAbsolute(this.account.getFtpWebRootDirectory()), fileName);
            String msg = "Test. Remove me";
            try (ByteArrayInputStream is = new ByteArrayInputStream(msg.getBytes("UTF-8"));){
                UploadBean.this.remoteFSBean.put(is, path);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                int n = URLChecker.getResponseCode(IO.combinePaths(this.account.getWebRootURL(), fileName));
                return n;
            }
            finally {
                UploadBean.this.remoteFSBean.removeFile(path);
            }
        }
    }
}

