/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JSmartDialog;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.InvalidLicenseException;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.LicenseManagerImpl;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.util.Debug;

public class TrialExpiredException
extends InvalidLicenseException {
    public TrialExpiredException(String message) {
        super(message);
    }

    @Override
    public void showDialog(JFrame parent) {
        JTrialExpiredDialog d = new JTrialExpiredDialog(parent);
        d.setLocationRelativeTo(parent);
        ((Dialog)d).setVisible(true);
    }

    private static class JTrialExpiredDialog
    extends JSmartDialog {
        JLabel logo = new JLabel(Icons.get("share-jalbum", 64));
        private final JFrame parent;
        Action cancelAction = new AbstractAction(Msg.get("cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.setVisible(false);
            }
        };
        Action buyAction = new AbstractAction(Msg.get("ui.pricing")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String cid = null;
                    SignInManager sim = SignInManager.getInstance();
                    if (sim.isSignedIn()) {
                        cid = AccountManager.getCid(sim.getUserName(), sim.getPassword());
                    } else {
                        AccountProfile profile = AccountManager.getInstance().getFirstMyjalbumAccount();
                        if (profile != null) {
                            cid = AccountManager.getCid(profile);
                        }
                    }
                    BrowserLauncher.openURL("http://jalbum.net/purchase?referrer=licenseExpiredDialog&utm_source=client&utm_medium=buyAction&utm_campaign=licenseExpiredDialog" + (String)(cid != null ? "&cid=" + cid : ""));
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(parent, ex);
                }
            }
        };
        Action activateLicenseAction = new AbstractAction(Msg.get("ui.activateLicense")){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.setVisible(false);
                SwingUtilities.invokeLater(((LicenseManagerImpl)JAlbumContext.getInstance().getLicenseManager())::activateLicense);
            }
        };

        public JTrialExpiredDialog(JFrame parent) throws HeadlessException {
            super(parent, Msg.get("ui.trialExpiredTitle"), true);
            this.parent = parent;
            this.init();
        }

        private void init() {
            this.setResizable(false);
            JPanel logoPanel = new JPanel();
            logoPanel.setBorder(BorderFactory.createEmptyBorder(18, 18, 0, 8));
            logoPanel.add(this.logo);
            this.add((Component)logoPanel, "West");
            ControlPanel main = new ControlPanel();
            main.add("p", new JLabel("<html>" + Msg.get("ui.trialExpiredInfo") + "</html>"));
            this.add((Component)main, "East");
            this.addAction(this.activateLicenseAction);
            this.registerActions(this.buyAction, this.cancelAction);
            this.pack();
        }
    }
}

