/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.IncludeOption;

public class TreeCollection
extends AbstractCollection<AlbumObject> {
    private AlbumObject folder;
    private Collection<AlbumObject> objects;
    private EnumSet<IncludeOption> opts = EnumSet.noneOf(IncludeOption.class);
    private boolean ordered = true;
    private Predicate<AlbumObject> filter;

    public TreeCollection(AlbumObject folder) {
        this.folder = folder;
    }

    public TreeCollection(AlbumObject folder, EnumSet<IncludeOption> opts) {
        this.folder = folder;
        this.opts = opts;
    }

    public TreeCollection(Collection<AlbumObject> objects) {
        this.objects = objects;
    }

    public TreeCollection(Collection<AlbumObject> objects, EnumSet<IncludeOption> opts) {
        this.objects = objects;
        this.opts = opts;
    }

    public Predicate<AlbumObject> getFilter() {
        return this.filter;
    }

    public TreeCollection filter(Predicate<AlbumObject> filter) {
        this.filter = filter;
        return this;
    }

    public static TreeCollection of(AlbumObject root) {
        return TreeCollection.of(new AlbumObject[]{root});
    }

    public static TreeCollection of(Collection<AlbumObject> objects) {
        return new TreeCollection(objects);
    }

    public static TreeCollection of(AlbumObject[] objects) {
        return new TreeCollection(Arrays.asList(objects));
    }

    private Collection<AlbumObject> source() {
        return this.folder != null ? this.folder.getChildren(this.ordered) : this.objects;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public TreeCollection ordered(boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    @Override
    public Spliterator<AlbumObject> spliterator() {
        try {
            return new TreeSpliterator(this.doFilter(this.source()).spliterator());
        }
        catch (NullPointerException ex) {
            throw new IllegalArgumentException("Null getChildren() for " + this.folder.getFile().getAbsolutePath());
        }
    }

    @Override
    public Iterator<AlbumObject> iterator() {
        return new TreeIterator(this.doFilter(this.source()).iterator());
    }

    @Override
    public int size() {
        int count = 0;
        Iterator<AlbumObject> it = this.iterator();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    private Collection<AlbumObject> doFilter(Collection<AlbumObject> all) {
        if (this.opts.contains((Object)IncludeOption.EXCLUDED) && this.opts.contains((Object)IncludeOption.HIDDEN) && this.filter == null) {
            return all;
        }
        return all.stream().filter((? super T ao) -> (this.opts.contains((Object)IncludeOption.EXCLUDED) || this.opts.contains((Object)IncludeOption.EXCLUDED_FILES) && !ao.isFolder() || ao.isIncluded()) && (this.opts.contains((Object)IncludeOption.HIDDEN) || !ao.isFolder() || !ao.isHidden())).filter((? super T ao) -> this.filter != null ? this.filter.test((AlbumObject)ao) : true).collect(Collectors.toList());
    }

    private class TreeSpliterator
    implements Spliterator<AlbumObject>,
    Consumer<AlbumObject> {
        private Spliterator<AlbumObject> it;
        private final Deque<Spliterator<AlbumObject>> stack = new ArrayDeque<Spliterator<AlbumObject>>();
        private final Queue<AlbumObject> queue = new LinkedList<AlbumObject>();
        private final ConcurrentHashMap<File, Boolean> visited;
        private AlbumObject currentAO;

        public TreeSpliterator(Spliterator<AlbumObject> it, ConcurrentHashMap<File, Boolean> visited) {
            this.it = it;
            this.visited = visited;
        }

        public TreeSpliterator(Spliterator<AlbumObject> it) {
            this(it, new ConcurrentHashMap<File, Boolean>());
        }

        @Override
        public boolean tryAdvance(Consumer<? super AlbumObject> action) {
            AlbumObject queued = this.queue.poll();
            if (queued != null) {
                action.accept(queued);
                return true;
            }
            return this.doTryAdvance(action);
        }

        private boolean doTryAdvance(Consumer<? super AlbumObject> action) {
            boolean ret = this.it.tryAdvance(this);
            if (ret) {
                List<AlbumObject> children;
                action.accept(this.currentAO);
                File targetDir = LinkFile.targetOf(this.currentAO.getFile());
                if (this.currentAO.isFolder() && this.visited.putIfAbsent(targetDir, Boolean.TRUE) == null && (children = this.currentAO.getChildren(TreeCollection.this.ordered)) != null) {
                    this.stack.push(this.it);
                    this.it = TreeCollection.this.doFilter(children).spliterator();
                    if (!children.stream().filter(ao -> ao.isFolder()).findAny().isPresent()) {
                        this.it = new LeafOnlySpliterator<AlbumObject>(this.it);
                    }
                }
            } else if (!this.stack.isEmpty()) {
                this.it = this.stack.pop();
                return this.tryAdvance(action);
            }
            return ret;
        }

        private final Spliterator<AlbumObject> wrap(Spliterator<AlbumObject> sub) {
            if (sub instanceof LeafOnlySpliterator) {
                return sub;
            }
            return new TreeSpliterator(sub, this.visited);
        }

        @Override
        public Spliterator<AlbumObject> trySplit() {
            Spliterator<AlbumObject> sub = this.it.trySplit();
            if (sub != null) {
                return this.wrap(sub);
            }
            if (!(this.it instanceof LeafOnlySpliterator)) {
                while (this.doTryAdvance(ao -> this.queue.add((AlbumObject)ao))) {
                    sub = this.trySplit();
                    if (sub == null) continue;
                    return this.wrap(sub);
                }
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 273;
        }

        @Override
        public void accept(AlbumObject ao) {
            this.currentAO = ao;
        }
    }

    private class TreeIterator
    implements Iterator<AlbumObject> {
        private Iterator<AlbumObject> it;
        private final Deque<Iterator<AlbumObject>> stack = new ArrayDeque<Iterator<AlbumObject>>();
        private final Set<File> visited = new HashSet<File>();

        public TreeIterator(Iterator<AlbumObject> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            if (this.it.hasNext()) {
                return true;
            }
            for (Iterator<AlbumObject> it2 : this.stack) {
                if (!it2.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public AlbumObject next() {
            if (this.it.hasNext()) {
                AlbumObject next = this.it.next();
                File targetDir = LinkFile.targetOf(next.getFile());
                if (next.isFolder() && !this.visited.contains(targetDir)) {
                    this.visited.add(targetDir);
                    List<AlbumObject> children = next.getChildren(TreeCollection.this.ordered);
                    if (next != null) {
                        this.stack.push(this.it);
                        this.it = TreeCollection.this.doFilter(children).iterator();
                    }
                }
                return next;
            }
            if (!this.stack.isEmpty()) {
                this.it = this.stack.pop();
                return this.next();
            }
            throw new NoSuchElementException();
        }
    }

    private static final class LeafOnlySpliterator<AlbumObject>
    implements Spliterator<AlbumObject> {
        Spliterator<AlbumObject> split;

        public LeafOnlySpliterator(Spliterator<AlbumObject> split) {
            this.split = split;
        }

        @Override
        public boolean tryAdvance(Consumer<? super AlbumObject> action) {
            return this.split.tryAdvance(action);
        }

        @Override
        public Spliterator<AlbumObject> trySplit() {
            Spliterator<AlbumObject> sub = this.split.trySplit();
            return sub != null ? new LeafOnlySpliterator<AlbumObject>(sub) : null;
        }

        @Override
        public long estimateSize() {
            return this.split.estimateSize();
        }

        @Override
        public int characteristics() {
            return this.split.characteristics();
        }
    }
}

