/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import se.datadosen.component.Hour;
import se.datadosen.component.JNotification;
import se.datadosen.component.JSpeechBubble;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumUtilities;

public class TipOfTheDay {
    private static Thread pendingNotifier;

    private TipOfTheDay() {
    }

    public static boolean isPendingNotification() {
        return pendingNotifier != null && pendingNotifier.isAlive();
    }

    public static boolean isShowingNotification() {
        JComponent n = JAlbumContext.getInstance().getFrame().albumExplorer.getNotification();
        return n != null && n.isVisible();
    }

    public static void interruptPendingNotification() {
        if (pendingNotifier != null && pendingNotifier.isAlive()) {
            pendingNotifier.interrupt();
        }
    }

    public static void showInBackground(final JNotification n) {
        if (!Config.getConfig().isShowTipOfTheDay()) {
            return;
        }
        TipOfTheDay.interruptPendingNotification();
        pendingNotifier = new Thread("TipOfTheDay thread"){

            @Override
            public void run() {
                try {
                    1.sleep(1500L);
                    JAlbumContext.getInstance().getFrame().showNotification(n);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        pendingNotifier.start();
    }

    public static void showSpeechBubble(JComponent relComp, Hour pos, String message, int expirationSecs) {
        String htmlMessage = "<html><center>" + message + "</center></html>";
        JNotification note = new JNotification(htmlMessage);
        if (!note.isShownBefore()) {
            JAlbumUtilities.schedule(() -> {
                JSpeechBubble bubble = new JSpeechBubble(htmlMessage);
                bubble.setExpiration(expirationSecs);
                bubble.show(relComp, pos);
                note.setLastShown(System.currentTimeMillis());
            }, 1L, TimeUnit.SECONDS);
        }
    }

    public static void showInBackground(String message) {
        if (!Config.getConfig().isShowTipOfTheDay()) {
            return;
        }
        TipOfTheDay.showInBackground(message, 6);
    }

    public static void showInBackground(String message, int secs) {
        if (!Config.getConfig().isShowTipOfTheDay()) {
            return;
        }
        JNotification n = new JNotification(message, JNotification.Type.TIP);
        n.setPriority(JNotification.Priority.HIGH);
        if (!n.isShownBefore()) {
            n.setRememberShown(true);
            n.setExpiration(secs);
            TipOfTheDay.showInBackground(n);
        }
    }
}

