/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import net.jalbum.imaging.ImageMetadataReader2;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.util.Platform;
import se.datadosen.util.RotationSupport;

public class ThumbnailFileView
extends FileView {
    private File lastFile;
    private AlbumObject lastAlbumObject;
    private final AlbumObjectFactory factory;
    private FileSystemView fsv = FileSystemView.getFileSystemView();
    private Dimension thumbDim = Platform.isMac() ? new Dimension(24, 24) : new Dimension(42, 42);

    public ThumbnailFileView() {
        this.factory = new AlbumObjectFactory(JAlbumContext.getInstance().getEngine());
        this.factory.setCacheThumbnails(false);
    }

    @Override
    public Icon getIcon(File f) {
        if (f.isDirectory() || this.fsv.isDrive(f) || this.fsv.isComputerNode(f)) {
            return super.getIcon(f);
        }
        Icon icon = this.getThumbnail(f);
        if (icon != null) {
            return icon;
        }
        return super.getIcon(f);
    }

    private Icon getThumbnail(File f) {
        try {
            Metadata imageInfo = ImageMetadataReader2.readMetadata(f);
            if (imageInfo.containsDirectoryOfType(ExifSubIFDDirectory.class)) {
                Directory dir = imageInfo.getFirstDirectoryOfType(ExifSubIFDDirectory.class);
                byte[] rawImage = (byte[])dir.getObject(61441);
                ImageIcon ii = new ImageIcon(rawImage);
                return RotationSupport.adjustOrientation(AlbumObjectImpl.scaleToFit(ii, this.thumbDim, false), f);
            }
        }
        catch (ImageProcessingException imageProcessingException) {
        }
        catch (IOException | RuntimeException exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Boolean isTraversable(File f) {
        return f.isDirectory();
    }
}

