/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Taskbar;
import java.awt.Window;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.util.Platform;

public class TaskbarProgress {
    private static int currentProgressPercentage;
    private static Image iconImage;

    public int getProgress() {
        return currentProgressPercentage;
    }

    public static void setProgress(Window window, int progressPercentage) {
        if (progressPercentage == currentProgressPercentage) {
            return;
        }
        currentProgressPercentage = progressPercentage;
        JAlbumUtilities.runOnAWT(() -> {
            try {
                if (Platform.isMac()) {
                    Taskbar tb = Taskbar.getTaskbar();
                    if (progressPercentage > 0) {
                        int w = iconImage.getWidth(null);
                        int h = iconImage.getHeight(null);
                        int barHeight = h / 10;
                        int barY = h - 2 * barHeight;
                        int margin = 2;
                        BufferedImage bi = window.getGraphicsConfiguration().createCompatibleImage(w, h, 3);
                        Graphics2D g = bi.createGraphics();
                        g.drawImage(iconImage, 0, 0, null);
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g.setComposite(AlphaComposite.getInstance(1));
                        g.fillRect(0, barY - barHeight / 4, w, 3 * barHeight / 2);
                        g.setComposite(AlphaComposite.getInstance(2));
                        g.setStroke(new BasicStroke((float)w / 85.0f));
                        RoundRectangle2D.Float clip = new RoundRectangle2D.Float(margin, barY, w - 2 * margin, barHeight, barHeight, barHeight);
                        g.setClip(clip);
                        g.setColor(new Color(210, 210, 210));
                        g.fillRect(0, 0, w, h);
                        g.setColor(JAlbumColor.textHighlight);
                        g.fillRect(margin, 0, progressPercentage * (w - 2 * margin) / 100, h);
                        g.setColor(new Color(110, 110, 110));
                        g.setClip(null);
                        g.drawRoundRect(margin, barY, w - 2 * margin, barHeight, barHeight, barHeight);
                        tb.setIconImage(bi);
                    } else {
                        tb.setIconImage(iconImage);
                    }
                } else {
                    try {
                        Taskbar tb = Taskbar.getTaskbar();
                        tb.setWindowProgressValue(window, progressPercentage);
                    }
                    catch (NoClassDefFoundError | UnsupportedOperationException tb) {}
                }
            }
            catch (Throwable t) {
                System.err.println(t);
            }
        });
    }

    static {
        try {
            Taskbar tb = Taskbar.getTaskbar();
            iconImage = tb.getIconImage();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

