/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.util.NamedThreadFactory;

class TaskManager<T extends BackgroundTask> {
    private final LinkedList<T> tasks = new LinkedList();
    private final ExecutorService executor;

    public TaskManager(String name) {
        this.executor = Executors.newSingleThreadExecutor(new NamedThreadFactory(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean submit(T task) {
        ((BackgroundTask)task).tm = this;
        ((BackgroundTask)task).future = this.executor.submit(task);
        LinkedList<T> linkedList = this.tasks;
        synchronized (linkedList) {
            this.tasks.add(task);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<T> getTasks(AlbumProject ap) {
        LinkedList<T> linkedList = this.tasks;
        synchronized (linkedList) {
            return this.tasks.stream().filter(t -> t.ap.equals(ap));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<T> getQueuedTasks(AlbumProject ap) {
        LinkedList<T> linkedList = this.tasks;
        synchronized (linkedList) {
            return this.getTasks(ap).filter(t -> !t.isRunning());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<T> getTasks(AlbumProject ap, Class<T> type) {
        LinkedList<T> linkedList = this.tasks;
        synchronized (linkedList) {
            return this.tasks.stream().filter(t -> t.ap.equals(ap) && type.isInstance(t));
        }
    }

    public static abstract class BackgroundTask
    implements Callable {
        protected Runnable onDone;
        protected Consumer<Throwable> onError;
        protected Future future;
        protected TaskManager tm;
        protected final AlbumProject ap;
        private String name = "Unnamed";
        private boolean running;
        private boolean cancelled;

        public BackgroundTask(AlbumProject ap) {
            this.ap = ap;
        }

        public void onDone(Runnable c) {
            this.onDone = c;
        }

        public void onError(Consumer<Throwable> c) {
            this.onError = c;
        }

        public void abort() {
            if (this.future != null) {
                this.future.cancel(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel() {
            boolean ok = true;
            if (this.future != null) {
                ok = this.future.cancel(false);
            }
            if (ok) {
                this.cancelled = true;
                if (this.tm != null) {
                    LinkedList linkedList = this.tm.tasks;
                    synchronized (linkedList) {
                        this.tm.tasks.remove(this);
                    }
                }
            }
            return this.cancelled;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public Throwable getLastError() {
            try {
                this.future.get();
            }
            catch (ExecutionException ex) {
                return ex.getCause();
            }
            catch (InterruptedException ex) {
                return ex;
            }
            return null;
        }

        public boolean isRunning() {
            return this.running;
        }

        public boolean isAborted() {
            return this.future.isCancelled() || this.getLastError() instanceof OperationAbortedException;
        }

        public boolean completedNormally() {
            try {
                this.future.get();
            }
            catch (InterruptedException | CancellationException | ExecutionException ex) {
                return false;
            }
            return this.future.isDone() && !this.future.isCancelled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call() throws Exception {
            try {
                this.running = true;
                this.ap.workStarted();
                JAlbumContext.getInstance().getFrame().progressSpinner.workStarted();
                Object object = this.doInBackground();
                return object;
            }
            catch (OperationAbortedException ex) {
                System.out.println(Msg.get("ui.taskAborted", this.getName()));
                JAlbumContext.getInstance().getFrame().statusBar.setText(Msg.get("ui.taskAborted", this.getName()));
                if (ex.getMessage() != null) {
                    JOptionPane.showMessageDialog(JAlbumContext.getInstance().getFrame(), ex.getMessage(), Msg.get("ui.operationAborted"), 0);
                }
                throw ex;
            }
            catch (Throwable ex) {
                System.out.println("\n***** Error processing " + this.getName() + ": *****");
                if (ex instanceof RuntimeException) {
                    ex.printStackTrace(System.err);
                } else {
                    System.out.println(ex);
                }
                if (this.onError != null) {
                    SwingUtilities.invokeLater(() -> this.onError.accept(ex));
                }
                throw ex;
            }
            finally {
                JAlbumContext.getInstance().getFrame().progressSpinner.workDone();
                this.ap.workDone();
                LinkedList linkedList = this.tm.tasks;
                synchronized (linkedList) {
                    this.tm.tasks.remove(this);
                }
                this.running = false;
                this.done();
                if (this.onDone != null) {
                    SwingUtilities.invokeLater(this.onDone);
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        protected abstract Object doInBackground() throws Exception;

        protected void done() {
        }
    }
}

