/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.component.JSmartDialog;
import se.datadosen.jalbum.Msg;

public abstract class SlowOperation
extends Thread {
    private JLabel label;
    private Icon icon;
    private Icon altIcon;
    private String title;
    private boolean alive = true;
    private boolean done = false;
    private boolean aborted = false;
    private Object result;
    private Throwable throwable;
    protected JSmartDialog dialog;
    protected JProgressSpinner spinner;
    protected Action abortAction = new AbstractAction(Msg.get("abort")){

        @Override
        public void actionPerformed(ActionEvent e) {
            SlowOperation.this.aborted = true;
            SlowOperation.this.abort();
        }
    };

    public SlowOperation() {
        this.setDaemon(true);
    }

    public boolean launch(Window parent, String message, String title) throws Throwable {
        return this.launch(parent, new JLabel(message), null, title);
    }

    public boolean launch(Window parent, JLabel messageLabel, Icon altIcon, String title) throws Throwable {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        final SecondaryLoop loop = eventQueue.createSecondaryLoop();
        this.label = messageLabel;
        this.altIcon = altIcon;
        this.title = title;
        this.dialog = new JSlowOperationDialog(parent);
        this.start();
        this.dialog.pack();
        this.dialog.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ SlowOperation this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void windowClosed(WindowEvent e) {
                loop.exit();
            }
        });
        this.dialog.setVisible(true);
        loop.enter();
        if (this.throwable != null && !this.aborted) {
            throw this.throwable;
        }
        return !this.aborted;
    }

    public JLabel getMessageLabel() {
        return this.label;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Object getResult() {
        return this.result;
    }

    public boolean isDone() {
        return this.done;
    }

    @Override
    public void run() {
        try {
            this.operation();
            this.done = true;
        }
        catch (Throwable t) {
            this.throwable = t;
        }
        this.alive = false;
        SwingUtilities.invokeLater(() -> {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        });
    }

    public abstract void operation() throws Throwable;

    public abstract void abort();

    private void startBlinker() {
        Thread blinkerThread = new Thread("Blinker thread"){

            @Override
            public void run() {
                try {
                    while (SlowOperation.this.alive) {
                        3.sleep(500L);
                        SlowOperation.this.label.setIcon(SlowOperation.this.altIcon);
                        3.sleep(500L);
                        SlowOperation.this.label.setIcon(SlowOperation.this.icon);
                    }
                    if (SlowOperation.this.spinner != null) {
                        SlowOperation.this.spinner.setSpinning(false);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        blinkerThread.setDaemon(true);
        blinkerThread.start();
    }

    class JSlowOperationDialog
    extends JSmartDialog {
        public JSlowOperationDialog(Window d) {
            super(d, true);
            this.setTitle(SlowOperation.this.title);
            JComponent c = (JComponent)this.getContentPane();
            c.setLayout(new BorderLayout());
            c.setBorder(new EmptyBorder(20, 20, 14, 20));
            c.add((Component)SlowOperation.this.label, "Center");
            this.registerActions(SlowOperation.this.abortAction);
            SlowOperation.this.icon = SlowOperation.this.label.getIcon();
            if (SlowOperation.this.icon != null) {
                if (SlowOperation.this.altIcon == null) {
                    BufferedImage bi = new BufferedImage(SlowOperation.this.icon.getIconWidth(), SlowOperation.this.icon.getIconHeight(), 6);
                    SlowOperation.this.altIcon = new ImageIcon(bi);
                }
                SlowOperation.this.startBlinker();
            } else {
                SlowOperation.this.spinner = new JProgressSpinner(28, true);
                SlowOperation.this.spinner.setBorder(BorderFactory.createEmptyBorder(12, 0, 0, 0));
                c.add((Component)SlowOperation.this.spinner, "South");
            }
        }
    }
}

