/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.HeadlessException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JNotification;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.NoValidSkinException;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;

public class SkinManager {
    public static final String JALBUM_SKIN_TYPE = ".jaskin";
    private int initiallyIgnoredCount;
    private Set<String> ignoreDirs = new HashSet<String>(){
        {
            this.add("__MACOSX");
            this.add(".svn");
            SkinManager.this.initiallyIgnoredCount = this.size();
        }
    };
    private ProgressMonitor progressMonitor;
    private JAlbumFrame window = JAlbumContext.getInstance().getFrame();
    private boolean exitOnClose = false;

    public boolean isExitOnClose() {
        return this.exitOnClose;
    }

    public void setExitOnClose(boolean exitOnClose) {
        this.exitOnClose = exitOnClose;
    }

    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public void addIgnoreDir(String dir) {
        this.ignoreDirs.add(dir);
    }

    private boolean isIgnored(String path) {
        for (String ignoreDir : this.ignoreDirs) {
            if (!path.contains(ignoreDir)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doInstallSkin(String fileName, ZipInputStream zin, int entryCount, File skinsDir) throws ZipException, IOException {
        boolean isPatch = fileName.endsWith(".patch.jaskin");
        try {
            ZipEntry e;
            if (this.progressMonitor != null) {
                this.progressMonitor.setMinimum(1);
                this.progressMonitor.setMaximum(entryCount);
            }
            File destDir = skinsDir;
            String currentPath = null;
            String skinName = null;
            int counter = 1;
            HashSet<File> visitedRoots = new HashSet<File>();
            while ((e = zin.getNextEntry()) != null) {
                String p = this.pathOf(e);
                if (!this.isIgnored(p)) {
                    if (!p.equals(currentPath)) {
                        currentPath = p;
                        String n = this.rootOf(e);
                        if (skinName == null) {
                            skinName = n;
                        }
                        destDir = new File(skinsDir, currentPath);
                        File skinDir = new File(skinsDir, n);
                        if (!isPatch && !visitedRoots.contains(skinDir)) {
                            AlbumBean engine = JAlbumContext.getInstance().getEngine();
                            if (engine != null && engine.getSkin().equals(n)) {
                                engine.unloadCurrentSkin();
                            }
                            if (skinDir.exists()) {
                                IO.recycle(skinDir);
                            }
                            visitedRoots.add(skinDir);
                        }
                        destDir.mkdirs();
                    }
                    File destFile = new File(destDir, this.nameOf(e));
                    if (e.isDirectory()) {
                        if (!this.isIgnored(this.nameOf(e))) {
                            destFile.mkdir();
                        }
                    } else {
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destFile));
                        try {
                            byte[] buffer;
                            int bytesRead;
                            while ((bytesRead = zin.read(buffer = new byte[65536])) != -1) {
                                out.write(buffer, 0, bytesRead);
                            }
                        }
                        finally {
                            zin.closeEntry();
                            out.close();
                        }
                    }
                    if (e.getTime() != -1L) {
                        destFile.setLastModified(e.getTime());
                    }
                }
                if (this.progressMonitor != null) {
                    this.progressMonitor.setProgress(counter);
                    if (this.progressMonitor.isCanceled()) break;
                }
                ++counter;
            }
            String string = skinName;
            return string;
        }
        finally {
            zin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getEntryCount(ZipInputStream zin) throws IOException {
        int counter = 0;
        try {
            while (zin.getNextEntry() != null) {
                ++counter;
            }
            int n = counter;
            return n;
        }
        finally {
            zin.close();
        }
    }

    public void installSkin(final String name, final URL skinUrl, final Runnable afterInstallAction) {
        new SwingWorker<byte[], Object>(this){
            final /* synthetic */ SkinManager this$0;
            {
                this.this$0 = this$0;
            }

            void grabFile(URL url, OutputStream out) throws IOException {
                try (BufferedInputStream in = new BufferedInputStream(url.openStream());){
                    BufferedOutputStream bout = new BufferedOutputStream(out, 65535);
                    byte[] data = new byte[65535];
                    int x = 0;
                    while ((x = in.read(data, 0, 65535)) >= 0) {
                        bout.write(data, 0, x);
                    }
                    bout.close();
                }
            }

            @Override
            protected byte[] doInBackground() throws Exception {
                this.this$0.window.progressSpinner.workStarted();
                this.this$0.window.statusBar.pushText(Msg.get("ui.downloadingSkin"));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.grabFile(skinUrl, baos);
                return baos.toByteArray();
            }

            @Override
            protected void done() {
                this.this$0.window.progressSpinner.workDone();
                this.this$0.window.statusBar.popText(Msg.get("ui.downloadingSkin"));
                try {
                    this.this$0.installSkin(name, (byte[])this.get(), Config.getConfig().chainedSkinsDir.getDirectory(), afterInstallAction);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException ex) {
                    if (ex.getCause() instanceof FileNotFoundException) {
                        JOptionPane.showMessageDialog(this.this$0.window, Msg.get("ui.skinNotFoundError", name), Msg.get("sm.skinManagerTitle"), 0);
                    }
                    Debug.showErrorDialog(this.this$0.window, ex.getCause());
                }
            }
        }.execute();
    }

    public void installSkin(File skinFile) {
        Config config = Config.getConfig();
        this.installSkin(skinFile, config.chainedSkinsDir.getDirectory());
    }

    public void installSkin(File skinFile, File skinsDir) {
        try {
            this.installSkin(skinFile.getName(), IO.readBytes(skinFile), skinsDir, null);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), Msg.get("sm.skinManagerTitle"), 0);
        }
    }

    public void installSkin(String fileName, byte[] zipBytes, File skinsDir, Runnable afterInstallAction) {
        block7: {
            try {
                skinsDir.mkdirs();
                Set skins = this.listSkins(new ZipInputStream(new ByteArrayInputStream(zipBytes)));
                Object[] a = skins.toArray();
                JCheckBox[] selections = new JCheckBox[a.length];
                ControlPanel skinPanel = new ControlPanel();
                ((RiverLayout)skinPanel.getLayout()).setHgap(0);
                skinPanel.add(new JLabel(Msg.get("sm.skinInstallerInfo")));
                for (int i = 0; i < a.length; ++i) {
                    String skinName = a[i].toString();
                    File skinDir = new File(skinsDir, skinName);
                    selections[i] = new JCheckBox(skinName, true);
                    skinPanel.add("br", selections[i]);
                }
                int answer = JOptionPane.showConfirmDialog(null, skinPanel, Msg.get("sm.skinManagerTitle"), 2, 1);
                if (answer != 0) {
                    return;
                }
                for (JCheckBox selection : selections) {
                    if (selection.isSelected()) continue;
                    this.addIgnoreDir(selection.getText());
                }
                this.performInstall(fileName, zipBytes, skinsDir, afterInstallAction, skins);
            }
            catch (NoValidSkinException ex) {
                JOptionPane.showMessageDialog(null, Msg.get("sm.notAValidSkinFileError"), Msg.get("sm.skinManagerTitle"), 0);
                if (this.exitOnClose) {
                    System.exit(0);
                }
            }
            catch (HeadlessException | IOException ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage(), Msg.get("sm.skinManagerTitle"), 0);
                if (!this.exitOnClose) break block7;
                System.exit(0);
            }
        }
    }

    private void performInstall(final String fileName, final byte[] zipBytes, final File skinsDir, final Runnable afterInstallAction, final Set skins) {
        UIManager.put("ProgressMonitor.progressText", Msg.get("sm.skinManagerTitle"));
        final ProgressMonitor pm = new ProgressMonitor(null, Msg.get("sm.installingSkinInfo") + "...", null, 1, 1);
        this.setProgressMonitor(pm);
        new SwingWorker<String, Void>(this){
            final /* synthetic */ SkinManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected String doInBackground() throws Exception {
                String skinName = this.this$0.doInstallSkin(fileName, new ZipInputStream(new ByteArrayInputStream(zipBytes)), this.this$0.getEntryCount(new ZipInputStream(new ByteArrayInputStream(zipBytes))), skinsDir);
                return skinName;
            }

            @Override
            protected void done() {
                try {
                    String skinName = (String)this.get();
                    if (this.this$0.window != null) {
                        this.this$0.window.mainSettingsPanel.scanSkins();
                    }
                    if (!pm.isCanceled() && this.this$0.ignoreDirs.size() - this.this$0.initiallyIgnoredCount < skins.size()) {
                        JNotification n = new JNotification(Msg.get("sm.skinInstalledInfo"), JNotification.Type.SKIN);
                        n.setExpiration(4);
                        this.this$0.window.showNotification(n);
                        if (this.this$0.window != null && skinName != null && skinName.equals(this.this$0.window.mainSettingsPanel.getSelectedSkin())) {
                            this.this$0.window.reloadSkin();
                        }
                        if (afterInstallAction != null) {
                            SwingUtilities.invokeLater(afterInstallAction);
                        }
                    }
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                catch (ExecutionException ex) {
                    JOptionPane.showMessageDialog(null, ex.getCause().getMessage(), Msg.get("sm.skinManagerTitle"), 0);
                }
                catch (HeadlessException ex) {
                    ex.printStackTrace(System.err);
                    Debug.showStackTraceDialog(null, ex);
                }
                finally {
                    if (this.this$0.exitOnClose) {
                        System.exit(0);
                    }
                }
            }
        }.execute();
    }

    private String pathOf(ZipEntry e) {
        int i;
        String s = e.getName();
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        if ((i = s.lastIndexOf(47)) == -1) {
            return "";
        }
        return s.substring(0, i);
    }

    private String nameOf(ZipEntry e) {
        int i;
        String s = e.getName();
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        if ((i = s.lastIndexOf(47)) == -1) {
            return s;
        }
        return s.substring(i + 1);
    }

    public Set listSkins(File skinFile) throws NoValidSkinException, IOException {
        try (ZipInputStream zin = new ZipInputStream(new ByteArrayInputStream(IO.readBytes(skinFile)));){
            Set set = this.listSkins(zin);
            return set;
        }
    }

    public Set listSkins(ZipInputStream zin) throws NoValidSkinException, ZipException, IOException {
        ZipEntry e;
        TreeSet<String> names = new TreeSet<String>();
        while ((e = zin.getNextEntry()) != null) {
            String rootName = this.rootOf(e);
            if (this.ignoreDirs.contains(rootName)) continue;
            names.add(rootName);
        }
        zin.close();
        if (names.isEmpty()) {
            throw new NoValidSkinException();
        }
        return names;
    }

    private String rootOf(ZipEntry e) throws NoValidSkinException {
        int i;
        String s = e.getName();
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        if ((i = s.indexOf(47)) == -1) {
            if (e.isDirectory()) {
                return s;
            }
            throw new NoValidSkinException();
        }
        return s.substring(0, i);
    }
}

