/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.MiniConfig;
import se.datadosen.jalbum.SkinProperties;
import se.datadosen.jalbum.StyleFileFilter;
import se.datadosen.util.IO;
import se.datadosen.util.Stopwatch;
import se.datadosen.util.VersionNumber;

public class SkinInfo
implements Comparable<SkinInfo> {
    private final File skinFile;
    private SkinProperties props;

    public SkinInfo(File skinFile) {
        this.skinFile = skinFile;
    }

    public String getName() {
        return IO.baseName(this.skinFile);
    }

    public boolean isZipped() {
        return this.skinFile.isFile();
    }

    public boolean isBundled() {
        return !IO.isSubdirectoryOf(this.skinFile, Config.getConfig().chainedSkinsDir);
    }

    public VersionNumber getVersion() {
        return this.getProperties().getVersion();
    }

    public File getSkinFile() {
        return this.skinFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDefaultStyle() {
        try {
            if (this.skinFile.isDirectory()) {
                File[] styles;
                File stylesDir = new File(this.skinFile, "styles");
                Properties skinProps = IO.readPropertyFile(new File(this.skinFile, "hints.jap"));
                String style2 = skinProps.getProperty("style");
                if (style2 != null) {
                    if (new File(stylesDir, style2).exists()) return style2;
                }
                if ((styles = stylesDir.listFiles(new StyleFileFilter())) == null) return "";
                if (styles.length <= 0) return "";
                return styles[0].getName();
            }
            TreeSet<Path> styles = IO.listZipEntries(this.skinFile, this.getName() + "/styles/.+");
            try (InputStream is = IO.openFromZip(this.skinFile, this.getName() + "/hints.jap");){
                Properties skinProps = new Properties();
                skinProps.load(is);
                String style = skinProps.getProperty("style");
                if (style == null || !styles.contains(Path.of(this.getName(), "styles", style))) {
                    String string2 = styles.first().getFileName().toString();
                    return string2;
                }
                String string = style;
                return string;
            }
        }
        catch (IOException ex) {
            return "";
        }
    }

    public ImageIcon getPreview(String style) {
        if (this.skinFile.isDirectory()) {
            File f = new File(this.skinFile, "styles/" + IO.baseName(style) + ".jpg");
            if (!f.exists()) {
                f = new File(this.skinFile, "preview.jpg");
            }
            if (f.exists()) {
                return new ImageIcon(f.getAbsolutePath());
            }
        } else {
            ImageIcon imageIcon;
            block20: {
                String stylePath = this.getName() + "/styles/" + IO.baseName(style) + ".jpg";
                InputStream is = IO.openFromZip(this.skinFile, stylePath);
                try {
                    imageIcon = new ImageIcon(is.readAllBytes());
                    if (is == null) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        ImageIcon imageIcon2;
                        block21: {
                            InputStream is2 = IO.openFromZip(this.skinFile, this.getName() + "/preview.jpg");
                            try {
                                imageIcon2 = new ImageIcon(is2.readAllBytes());
                                if (is2 == null) break block21;
                            }
                            catch (Throwable throwable3) {
                                try {
                                    if (is2 != null) {
                                        try {
                                            is2.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable3.addSuppressed(throwable4);
                                        }
                                    }
                                    throw throwable3;
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            is2.close();
                        }
                        return imageIcon2;
                    }
                }
                is.close();
            }
            return imageIcon;
        }
        return null;
    }

    private SkinProperties getProperties() {
        if (this.props == null) {
            if (this.skinFile.isDirectory()) {
                this.props = new SkinProperties(this.skinFile);
            } else {
                try (InputStream is = IO.openFromZip(this.skinFile, this.getName() + "/skin.properties");){
                    this.props = new SkinProperties(is);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        return this.props;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.getName());
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SkinInfo other = (SkinInfo)obj;
        return Objects.equals(this.getName(), other.getName());
    }

    @Override
    public int compareTo(SkinInfo o) {
        return this.getName().compareTo(o.getName());
    }

    public File install() {
        if (!this.skinFile.isFile()) {
            throw new IllegalArgumentException("Not a zipped skin");
        }
        File bundledSkinsDir = new File(MiniConfig.getMiniConfig().configDir, "bundled-skins");
        File unzippedDir = new File(bundledSkinsDir, this.getName());
        if (unzippedDir.exists()) {
            IO.recycle(unzippedDir);
        }
        try {
            Stopwatch sw = new Stopwatch().start();
            System.out.print("Unzipping skin " + this.getName() + ": ");
            IO.unzip(this.skinFile, unzippedDir.getParentFile());
            System.out.println(sw);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        return unzippedDir;
    }

    public String toString() {
        return "SkinInfo { skinFile=" + String.valueOf(this.skinFile) + " version=" + String.valueOf(this.getVersion()) + " }";
    }
}

