/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.jalbum.resty.web.AbstractContent;
import net.jalbum.resty.web.RobustResty;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AuthenticationException;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.JPreferencesWindow;
import se.datadosen.jalbum.JSignUpDialog;
import se.datadosen.jalbum.LicenseManagerImpl;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Tracer;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Elements;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.Debug;
import se.datadosen.util.Platform;

public class SignInManager {
    public static final String SIGNIN_PROPERTY = "signIn";
    private static final String JALBUM_SUPPORTER = "jAlbumSupporter";
    private static SignInManager theInstance;
    protected JAlbumContext context;
    protected JSignInDialog theDialog;
    protected JTextField userName = new JTextField(10);
    protected JPasswordField password = new JPasswordField(10);
    protected boolean signedIn;
    protected boolean confirmedSignedIn;
    private ReadOnlyBooleanWrapper signedInProperty = new ReadOnlyBooleanWrapper(false);
    private PropertyChangeSupport changeSupport;
    private Runnable onConfirmedSignIn;
    protected AccountManager.AccountStatus status;
    protected Preferences preferences = Preferences.userNodeForPackage(SignInManager.class);
    protected Action signInAction = new AbstractAction(Msg.get("ui.signIn"), Icons.small("sign-in")){

        @Override
        public void actionPerformed(ActionEvent e) {
            SignInManager.this.getDialog().setVisible(false);
            JPreferencesWindow prefs = SignInManager.this.getWindow().preferencesWindow;
            SignInManager.this.theDialog.doNotShowAgain.setSelected(false);
            prefs.doNotShowSigninAgain.setSelected(false);
            boolean rememberMe = SignInManager.this.theDialog.rememberMe.isSelected();
            prefs.rememberSignIn.setSelected(rememberMe);
            prefs.backgroundSignInOnStart.setSelected(rememberMe);
            if (rememberMe) {
                prefs.userName.setText(SignInManager.this.getUserName());
                prefs.password.setText(SignInManager.this.getPassword());
            } else {
                prefs.password.setText("");
            }
            prefs.savePreferences();
            SignInManager.this.doSignIn();
        }
    };
    protected Action signUpAction = new AbstractAction(Msg.get("ui.noUserName")){

        @Override
        public void actionPerformed(ActionEvent e) {
            JSignUpDialog dialog = new JSignUpDialog((Window)SignInManager.this.theDialog);
            dialog.userName.setText(SignInManager.this.userName.getText());
            dialog.password.setText(new String(SignInManager.this.password.getPassword()));
            dialog.setVisible(true);
            if (dialog.isSignupOk()) {
                SignInManager.this.userName.setText(dialog.userName.getText());
                SignInManager.this.password.setText(new String(dialog.password.getPassword()));
            }
        }
    };
    protected Action closeAction = new AbstractAction(Msg.get("ui.noThanks")){

        @Override
        public void actionPerformed(ActionEvent e) {
            Tracer.getInstance().trace("close signin clicked");
            SignInManager.this.signedIn = false;
            SignInManager.this.signedInProperty.set(false);
            SignInManager.this.theDialog.setVisible(false);
            SignInManager.this.onConfirmedSignIn = null;
            Tracer.getInstance().trace("close signin confirmed");
            JPreferencesWindow prefs = SignInManager.this.getWindow().preferencesWindow;
            prefs.doNotShowSigninAgain.setSelected(SignInManager.this.theDialog.doNotShowAgain.isSelected());
            boolean rememberMe = SignInManager.this.theDialog.rememberMe.isSelected();
            prefs.rememberSignIn.setSelected(rememberMe);
            prefs.backgroundSignInOnStart.setSelected(false);
            if (!rememberMe) {
                prefs.userName.setText("");
                prefs.password.setText("");
            }
            prefs.savePreferences();
        }
    };

    protected SignInManager() {
        this.context = JAlbumContext.getInstance();
        if (this.getWindow() != null) {
            JPreferencesWindow prefs = this.getWindow().preferencesWindow;
            this.userName.setText(prefs.userName.getText());
            this.password.setText(prefs.password.getText());
        }
    }

    public static SignInManager getInstance() {
        if (theInstance == null) {
            theInstance = new SignInManager();
        }
        return theInstance;
    }

    @Deprecated
    public static SignInManager getInstance(JAlbumFrame window) {
        return SignInManager.getInstance();
    }

    protected JAlbumFrame getWindow() {
        return this.context.getFrame();
    }

    @Deprecated
    public String getLicenseCode() {
        return this.context.getLicenseManager().getLicenseCode();
    }

    @Deprecated
    public boolean isLicenseValid() {
        return this.context.getLicenseManager().isLicenseValid();
    }

    @Deprecated
    public boolean isOldDonor() {
        return this.context.getLicenseManager().isOldDonor();
    }

    public AccountManager.AccountStatus getAccountStatus() {
        return this.status;
    }

    public void doSignOut() {
        Tracer.getInstance().trace("signout");
        JPreferencesWindow prefs = this.getWindow().preferencesWindow;
        prefs.backgroundSignInOnStart.setSelected(false);
        prefs.password.setText("");
        this.password.setText("");
        prefs.savePreferences();
        this.signedIn = false;
        this.signedInProperty.set(false);
        this.confirmedSignedIn = false;
        this.getWindow().accountStatusPanel.setVisible(false);
        this.firePropertyChange(SIGNIN_PROPERTY, true, false);
    }

    private void doSignIn() {
        Tracer.getInstance().trace("signin");
        this.signedIn = true;
        this.signedInProperty.set(true);
        Thread backgroundThread = new Thread("Background authenticator"){

            @Override
            public void run() {
                try {
                    block18: {
                        try {
                            SignInManager.this.status = AccountManager.getJalbumAccountStatus(SignInManager.this.getUserName(), SignInManager.this.getPassword());
                            ((LicenseManagerImpl)SignInManager.this.context.getLicenseManager()).checkLicenseStatus(SignInManager.this.status);
                            String userName = (String)SignInManager.this.status.get("username");
                            SignInManager.this.setUserName(userName);
                            SignInManager.this.getWindow().actions.signOutAction.putValue("Name", Msg.get("ui.signOutUser", SignInManager.this.getUserName()));
                            Date accountExpires = SignInManager.this.status.getAccountExpires();
                            if (accountExpires == null) {
                                accountExpires = new Date(99999999999999L);
                            }
                            if (SignInManager.this.status.isPaid() && new Date().before(accountExpires)) {
                                SignInManager.this.preferences.putLong("accountExpires", accountExpires.getTime());
                            } else {
                                SignInManager.this.preferences.remove("accountExpires");
                            }
                            SignInManager.this.getWindow().accountStatusPanel.setStatus(SignInManager.this.status);
                            SignInManager.this.getWindow().accountStatusPanel.setVisible(true);
                            SignInManager.this.firePropertyChange(SignInManager.SIGNIN_PROPERTY, false, true);
                        }
                        catch (IOException ex) {
                            if (!Config.getConfig().isDebugMode()) break block18;
                            ex.printStackTrace(System.err);
                        }
                    }
                    SignInManager.this.confirmedSignedIn = true;
                    SignInManager.this.getWindow().actions.signOutAction.putValue("Name", Msg.get("ui.signOutUser", SignInManager.this.getUserName()));
                    SignInManager.this.getWindow().toolBars.signInOutButton.setAction(SignInManager.this.getWindow().actions.signOutAction);
                    if (SignInManager.this.status != null && SignInManager.this.status.containsKey("accountType")) {
                        AccountManager mgr = AccountManager.getInstance();
                        AccountProfile existing = mgr.findJAlbumAccountByUserName(SignInManager.this.getUserName());
                        if (!mgr.hasAccounts()) {
                            existing = SignInManager.this.activateJalbumAccount(mgr);
                        }
                        if (existing != null && !existing.getFtpPassword().equals(SignInManager.this.getPassword())) {
                            existing.setFtpPassword(SignInManager.this.getPassword());
                            try {
                                mgr.saveAccounts();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace(System.err);
                            }
                        }
                        AccountProfile previouslySelected = mgr.findAccountByName(JAlbumContext.getInstance().getEngine().getAccountProfileName());
                        if (existing != null && !existing.equals(previouslySelected) && (previouslySelected == null || previouslySelected.isMyjalbum())) {
                            SignInManager.this.getWindow().getEngine().setAccountProfileName(existing.getName());
                            SignInManager.this.getWindow().markAsClean();
                        }
                    }
                    if (SignInManager.this.onConfirmedSignIn != null) {
                        if (SignInManager.this.status != null && !SignInManager.this.status.containsKey("accountType")) {
                            try {
                                SwingUtilities.invokeLater(() -> {
                                    int answer = JOptionPane.showConfirmDialog(SignInManager.this.getWindow(), Msg.get("ui.noActiveStorage"), Msg.get("ui.upload"), 0, 0);
                                    if (answer == 0) {
                                        String upgradeURL = JAlbumSite.getInstance().getMyJAlbumUpgradeUrl() + "/?utm_source=client&utm_medium=yesButton&utm_campaign=signInDialog&referrer=jalbumSignInDialog&cid=" + AccountManager.getCid(SignInManager.this.getUserName(), SignInManager.this.getPassword());
                                        try {
                                            BrowserLauncher.openURL(upgradeURL);
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                });
                            }
                            catch (Exception ex1) {
                                ex1.printStackTrace(System.err);
                            }
                        } else {
                            SwingUtilities.invokeLater(SignInManager.this.onConfirmedSignIn);
                        }
                        SignInManager.this.onConfirmedSignIn = null;
                    }
                }
                catch (AuthenticationException ex) {
                    SignInManager.this.signedIn = false;
                    SignInManager.this.signedInProperty.set(false);
                    SwingUtilities.invokeLater(() -> {
                        JOptionPane.showMessageDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow(), Msg.get("ui." + ex.getMessage()), Msg.get("ui.signIn"), 1);
                        SignInManager.this.showDialog();
                    });
                }
            }
        };
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private AccountProfile activateJalbumAccount(AccountManager manager) {
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("userName", this.getUserName());
            data.put("password", this.getPassword());
            data.put("language", Config.getConfig().getInterpretedLanguage());
            data.put("confirmed", "true");
            RobustResty r = new RobustResty();
            String doc = r.text(JAlbumSite.getTrueInstance().getMyJAlbumActivationUrl(), (AbstractContent)RobustResty.form(data)).toString();
            Debug.log("Response from authetication: " + doc);
            String result = Elements.contentOfElement("result", doc);
            Element account = Elements.getElementByName("account", doc, false);
            if (result == null) {
                throw new RuntimeException("Script error. Please contact hosting@jalbum.net:\n" + doc);
            }
            if (account != null) {
                Map<String, String> attributes = account.getAttributes();
                AccountProfile newProfile = new AccountProfile(attributes.get("webRootURL"));
                BeanBinder.setProperties(newProfile, attributes);
                newProfile.setName();
                manager.addAccount(newProfile);
                return newProfile;
            }
        }
        catch (ElementException ex) {
            ex.printStackTrace(System.err);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void onStart() {
        JPreferencesWindow prefs = this.getWindow().preferencesWindow;
        if (prefs.backgroundSignInOnStart.isSelected()) {
            Tracer.getInstance().trace("bg signin");
            this.doSignIn();
        } else {
            ((LicenseManagerImpl)this.context.getLicenseManager()).backgroundCheckLicenseStatus();
            this.getWindow().toolBars.signInOutButton.setVisible(true);
        }
    }

    public ReadOnlyBooleanProperty signedInProperty() {
        return this.signedInProperty.getReadOnlyProperty();
    }

    public boolean isSignedIn() {
        return this.signedIn;
    }

    public boolean isConfirmedSignedIn() {
        return this.confirmedSignedIn;
    }

    public String getUserName() {
        return this.userName.getText().trim();
    }

    public void setUserName(String userName) {
        this.userName.setText(userName);
    }

    public String getPassword() {
        return new String(this.password.getPassword());
    }

    public void setPassword(String password) {
        this.password.setText(password);
    }

    private synchronized JSignInDialog getDialog() {
        if (this.theDialog == null) {
            this.getWindow().actions.signInAction.setEnabled(false);
            this.theDialog = new JSignInDialog(this.getWindow());
            this.getWindow().actions.signInAction.setEnabled(true);
        }
        return this.theDialog;
    }

    public void showDialog() {
        Tracer.getInstance().trace("signin presented");
        this.getDialog();
        if (this.getWindow().isShowing()) {
            JAlbumFrame.centerRelativeTo(this.theDialog, this.getWindow());
        } else {
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension screenSize = tk.getScreenSize();
            Dimension frameSize = this.theDialog.getSize();
            this.theDialog.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        }
        this.theDialog.setVisible(true);
    }

    public void setOnConfirmedSignIn(Runnable r) {
        this.onConfirmedSignIn = r;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    private static void setLargerFont(JComponent comp) {
        Font f = comp.getFont();
        comp.setFont(f.deriveFont(15.0f));
    }

    private static void setSmallerFont(JComponent comp) {
        Font f = comp.getFont();
        comp.setFont(f.deriveFont(f.getSize2D() - 2.0f));
    }

    public class JSignInDialog
    extends JDialog {
        JSmartBackgroundPanel backgroundPanel;
        JLabel userNameLabel;
        JLinkLabel signupLink;
        JLabel passwordLabel;
        JLinkLabel forgotPasswordLink;
        JCheckBox rememberMe;
        JButton signInButton;
        JCheckBox doNotShowAgain;
        JButton noThanksButton;
        JLinkLabel whySignInLink;

        public JSignInDialog(JFrame frame) {
            super((Frame)frame, true);
            this.backgroundPanel = new JSmartBackgroundPanel();
            this.userNameLabel = new JLabel(Msg.get("ui.userName"));
            this.signupLink = new JLinkLabel(SignInManager.this.signUpAction);
            this.passwordLabel = new JLabel(Msg.get("ui.password"));
            this.forgotPasswordLink = new JLinkLabel(JAlbumSite.getInstance().getForgotPasswordUrl(), Msg.get("ui.forgotPassword"), Msg.get("ui.forgotPasswordToolTip"));
            this.rememberMe = new JCheckBox(Msg.get("ui.rememberMe"), true);
            this.signInButton = new JButton(SignInManager.this.signInAction);
            this.doNotShowAgain = new JCheckBox(Msg.get("ui.doNotShowAgain"));
            this.noThanksButton = new JButton(SignInManager.this.closeAction);
            this.whySignInLink = new JLinkLabel(JAlbumSite.getInstance().getWhySignInUrl(), Msg.get("ui.whySignIn"));
            this.init();
        }

        private void init() {
            this.getRootPane().putClientProperty("apple.awt.draggableWindowBackground", "false");
            this.setUndecorated(true);
            this.rememberMe.setOpaque(false);
            this.doNotShowAgain.setOpaque(false);
            ImageIcon icon = new ImageIcon(this.getClass().getResource("images/signinwindow.png"));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Rectangle hitArea = new Rectangle(JSignInDialog.this.getWidth() - 22, 6, 22, 20);
                    if (hitArea.contains(e.getPoint())) {
                        SignInManager.this.closeAction.actionPerformed(null);
                    }
                }
            });
            JPreferencesWindow prefs = SignInManager.this.getWindow().preferencesWindow;
            this.rememberMe.setSelected(prefs.rememberSignIn.isSelected());
            this.doNotShowAgain.setSelected(prefs.doNotShowSigninAgain.isSelected());
            this.backgroundPanel.setBackground(JAlbumColor.control);
            this.backgroundPanel.setBackgroundImage(this.convertColorFormat(icon));
            this.backgroundPanel.setOpaque(true);
            if (!Platform.isMac()) {
                this.backgroundPanel.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.darkGray));
            }
            this.setContentPane(this.backgroundPanel);
            SignInManager.setLargerFont(this.userNameLabel);
            SignInManager.setLargerFont(SignInManager.this.userName);
            SignInManager.setLargerFont(this.passwordLabel);
            SignInManager.setLargerFont(SignInManager.this.password);
            if (Platform.isMac()) {
                SignInManager.setSmallerFont(this.signupLink);
                SignInManager.setSmallerFont(this.forgotPasswordLink);
            }
            JGlassPanel c = new JGlassPanel();
            c.setLayout(new BorderLayout());
            c.setBorder(BorderFactory.createEmptyBorder(30, 0, 30, 30));
            this.backgroundPanel.add(c);
            JGlassPanel topContainer = new JGlassPanel();
            topContainer.setLayout(new BorderLayout());
            topContainer.setPreferredSize(new Dimension(200, 56));
            JGlassPanel centeredLabelPanel = new JGlassPanel();
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 10;
            gridbag.setConstraints(centeredLabelPanel, constraints);
            centeredLabelPanel.setLayout(gridbag);
            c.add((Component)topContainer, "North");
            JGlassPanel fieldsContainer = new JGlassPanel();
            fieldsContainer.setPreferredSize(new Dimension(300, 140));
            if (Platform.isMac()) {
                fieldsContainer.setLayout(new RiverLayout(5, 3));
            } else {
                fieldsContainer.setLayout(new RiverLayout(5, 4));
            }
            fieldsContainer.add("p right", this.userNameLabel);
            fieldsContainer.add(SignInManager.this.userName);
            fieldsContainer.add("br", this.signupLink);
            fieldsContainer.add("p", this.passwordLabel);
            fieldsContainer.add(SignInManager.this.password);
            fieldsContainer.add("br", this.forgotPasswordLink);
            c.add((Component)fieldsContainer, "Center");
            JGlassPanel emptyPanel = new JGlassPanel();
            emptyPanel.setPreferredSize(new Dimension(0, 140));
            c.add((Component)emptyPanel, "West");
            JGlassPanel southContainer = new JGlassPanel();
            southContainer.setPreferredSize(new Dimension(260, 55));
            southContainer.setLayout(new RiverLayout(1, 2));
            southContainer.add("p right", this.rememberMe);
            southContainer.add(new JLabel("    "));
            southContainer.add(this.signInButton);
            c.add((Component)southContainer, "South");
            this.getRootPane().setDefaultButton(this.signInButton);
            SignInManager.setLargerFont(this.signInButton);
            this.pack();
        }

        private Image convertColorFormat(ImageIcon ii) {
            BufferedImage bi = new BufferedImage(ii.getIconWidth(), ii.getIconHeight(), 2);
            Graphics2D g = bi.createGraphics();
            g.drawImage(ii.getImage(), 0, 0, bi.getWidth(), bi.getHeight(), this);
            return bi;
        }
    }

    static class JSmartBackgroundPanel
    extends JPanel {
        Image bg;
        Image image;

        JSmartBackgroundPanel() {
        }

        public void setBackgroundImage(Image im) {
            this.image = im;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            Composite backup = g2d.getComposite();
            g2d.setComposite(AlphaComposite.Src);
            if (this.bg != null) {
                g.drawImage(this.bg, 0, 0, null);
            }
            if (this.image != null) {
                g.drawImage(this.image, 0, 0, null);
            }
            g2d.setComposite(backup);
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.image == null) {
                return super.getPreferredSize();
            }
            Dimension sp = super.getPreferredSize();
            int width = this.image.getWidth(null);
            int height = this.image.getHeight(null);
            return new Dimension(Math.max(width, sp.width), Math.max(height, sp.height));
        }
    }

    class JGlassPanel
    extends JPanel {
        public JGlassPanel() {
            this.setOpaque(false);
            this.setBackground(new Color(255, 255, 255, 0));
        }
    }
}

