/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;

public class ScriptLanguage {
    private static final ScriptLanguage[] values;
    private static final Set<String> supportedExtensions;
    public static final ScriptLanguage BEANSHELL;
    public static final ScriptLanguage GROOVY;
    private final String visibleName;
    private final ScriptEngineFactory factory;
    private static Map<String, String> syntaxHighlighting;

    public ScriptLanguage(String visibleName, ScriptEngineFactory factory) {
        this.visibleName = visibleName;
        this.factory = factory;
    }

    public static ScriptLanguage[] values() {
        return values;
    }

    public String getLookupName() {
        return this.factory.getNames().get(0);
    }

    public String toString() {
        return this.visibleName;
    }

    public String getLanguageName() {
        return this.factory.getLanguageName();
    }

    public String getExtension() {
        return this.factory.getExtensions().get(0);
    }

    public String getMimeType() {
        return syntaxHighlighting.getOrDefault(this.getExtension(), "text/text");
    }

    public static Set<String> getSupportedExtensions() {
        return supportedExtensions;
    }

    public static ScriptLanguage valueOf(String name) {
        for (ScriptLanguage lang : values) {
            for (String n : lang.factory.getNames()) {
                if (!n.equalsIgnoreCase(name)) continue;
                return lang;
            }
        }
        throw new IllegalArgumentException("No ScriptLanguage enum constant for name " + name);
    }

    public static ScriptLanguage extensionOf(String ext) {
        if (values == null) {
            throw new RuntimeException("oh not null");
        }
        for (ScriptLanguage lang : values) {
            if (!lang.getExtension().equals(ext)) continue;
            return lang;
        }
        throw new IllegalArgumentException("No ScriptLanguage enum constant for extension " + ext);
    }

    static {
        supportedExtensions = new HashSet<String>();
        ArrayList<ScriptLanguage> languages = new ArrayList<ScriptLanguage>();
        ScriptEngineManager mgr = new ScriptEngineManager();
        for (ScriptEngineFactory factory : mgr.getEngineFactories()) {
            if (factory.getEngineName().equals("Graal.js") || factory.getEngineName().equals("placeholder")) continue;
            ScriptLanguage sl = new ScriptLanguage(factory.getLanguageName() + " (" + factory.getEngineName() + ")", factory);
            languages.add(sl);
            supportedExtensions.add(sl.getExtension());
        }
        values = languages.toArray(new ScriptLanguage[languages.size()]);
        BEANSHELL = ScriptLanguage.extensionOf("bsh");
        GROOVY = ScriptLanguage.extensionOf("groovy");
        syntaxHighlighting = new HashMap(){
            {
                this.put("bsh", "text/java");
                this.put("groovy", "text/groovy");
                this.put("js", "text/javascript");
                this.put("lua", "text/lua");
            }
        };
    }
}

