/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import bsh.BshScriptEngine;
import bsh.BshScriptEngineFactory;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.UtilEvalError;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.jalbum.script.GroovierScriptEngine;
import net.jalbum.script.SmartBshScriptEngine;
import net.jalbum.util.Profiler;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.jsr223.GroovyScriptEngineFactory;
import org.openjdk.nashorn.api.scripting.NashornScriptEngineFactory;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.ScriptLanguage;

public class ScriptEnginePool {
    public static final Profiler profiler = new Profiler();
    private Map<ScriptLanguage, ScriptEngine> engines = new HashMap<ScriptLanguage, ScriptEngine>();
    private ScriptContext sharedContext;
    private ClassLoader classLoader;
    private final ScriptEngineManager mgr;

    public ScriptEnginePool() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ScriptEnginePool(ClassLoader classLoader) {
        this.classLoader = classLoader;
        Thread.currentThread().setContextClassLoader(classLoader);
        this.mgr = new ScriptEngineManager(classLoader);
        ScriptEnginePool.registerFactory(this.mgr, new GroovyJAlbumScriptEngineFactory());
        JAlbum.logger.finer("Initializing");
    }

    private static void registerFactory(ScriptEngineManager mgr, ScriptEngineFactory factory) {
        for (String ext : factory.getExtensions()) {
            mgr.registerEngineExtension(ext, factory);
        }
        for (String mt : factory.getMimeTypes()) {
            mgr.registerEngineMimeType(mt, factory);
        }
        for (String name : factory.getNames()) {
            mgr.registerEngineName(name, factory);
        }
    }

    public ScriptEngineManager getScriptEngineManager() {
        return this.mgr;
    }

    public ScriptEngine get(ScriptLanguage language) {
        if (this.sharedContext == null) {
            ScriptEngine engine = this.doGet(ScriptLanguage.BEANSHELL);
            if (language == ScriptLanguage.BEANSHELL) {
                return engine;
            }
        }
        return this.doGet(language);
    }

    private ScriptEngine doGet(ScriptLanguage language) {
        ScriptEngine engine = this.engines.get(language);
        if (engine == null) {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            engine = this.mgr.getEngineByName(language.getLookupName());
            if (engine == null) {
                throw new RuntimeException("No script engine found for " + String.valueOf(language));
            }
            JAlbum.logger.finer("Initializing " + String.valueOf(engine));
            if (this.sharedContext == null) {
                this.sharedContext = engine.getContext();
                this.sharedContext.getBindings(100).put("polyglot.js.allowAllAccess", (Object)true);
            }
            this.engines.put(language, engine);
        }
        return engine;
    }

    public ScriptContext getSharedContext() {
        if (this.sharedContext == null) {
            this.get(ScriptLanguage.BEANSHELL);
        }
        return this.sharedContext;
    }

    public static Object getVar(String name, ScriptEngine se) {
        try {
            NameSpace ns;
            if (se instanceof BshScriptEngine && (ns = (NameSpace)se.get("org_beanshell_engine_namespace")) != null) {
                return Primitive.unwrap((Object)ns.getVariable(name));
            }
            return se.get(name);
        }
        catch (UtilEvalError e) {
            throw new RuntimeException(e);
        }
    }

    void clearEngineVariables() {
        for (ScriptEngine se : this.engines.values()) {
            se.getBindings(100).clear();
        }
    }

    void resetBshEngine() {
        this.engines.remove(ScriptLanguage.BEANSHELL);
    }

    private class GroovyJAlbumScriptEngineFactory
    implements ScriptEngineFactory {
        private final GroovyScriptEngineFactory factory = new GroovyScriptEngineFactory();

        private GroovyJAlbumScriptEngineFactory() {
        }

        @Override
        public String getEngineName() {
            return "Groovy JAlbum Script Engine";
        }

        @Override
        public String getEngineVersion() {
            return this.factory.getEngineVersion();
        }

        @Override
        public List<String> getExtensions() {
            return this.factory.getExtensions();
        }

        @Override
        public List<String> getMimeTypes() {
            return this.factory.getMimeTypes();
        }

        @Override
        public List<String> getNames() {
            return this.factory.getNames();
        }

        @Override
        public String getLanguageName() {
            return this.factory.getLanguageName();
        }

        @Override
        public String getLanguageVersion() {
            return this.factory.getLanguageVersion();
        }

        @Override
        public Object getParameter(String key) {
            return this.factory.getParameter(key);
        }

        @Override
        public String getMethodCallSyntax(String obj, String m, String ... args) {
            return this.factory.getMethodCallSyntax(obj, m, args);
        }

        @Override
        public String getOutputStatement(String toDisplay) {
            return this.factory.getOutputStatement(toDisplay);
        }

        @Override
        public String getProgram(String ... statements) {
            return this.factory.getProgram(statements);
        }

        @Override
        public ScriptEngine getScriptEngine() {
            GroovierScriptEngine engine = new GroovierScriptEngine(this, ScriptEnginePool.this.classLoader, new CompilerConfiguration(CompilerConfiguration.DEFAULT));
            engine.addImports("java.awt.*", "java.awt.event.*", "javax.swing.*", "javax.swing.event.*", "se.datadosen.jalbum.*", "static se.datadosen.jalbum.JAlbumUtilities.*", "se.datadosen.util.*", "static se.datadosen.util.Colors.hex8", "se.datadosen.explorer.*", "se.datadosen.component.*", "se.datadosen.tags.*", "net.jalbum.*", "net.jalbum.util.*", "net.miginfocom.swing.*");
            return engine;
        }
    }

    public static class MyCompiledScript
    extends CompiledScript {
        private final CompiledScript script;
        private String source;
        private final ScriptEngine engine;

        public MyCompiledScript(CompiledScript script, ScriptEngine engine) {
            this.script = script;
            this.engine = engine;
        }

        public MyCompiledScript(CompiledScript script, ScriptEngine engine, String source) {
            this.script = script;
            this.engine = engine;
            this.source = source;
        }

        @Override
        public Object eval(ScriptContext sc) throws ScriptException {
            try (Profiler.Sample _s1 = profiler.measure("CompiledScript.eval");){
                Profiler.Sample _s = profiler.measure("CompiledScript.eval: " + this.source);
                try {
                    Object object = this.script.eval(sc);
                    if (_s != null) {
                        _s.close();
                    }
                    return object;
                }
                catch (Throwable throwable) {
                    if (_s != null) {
                        try {
                            _s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
        }

        @Override
        public ScriptEngine getEngine() {
            return this.engine;
        }
    }

    public class SmartBshScriptEngineFactory
    extends BshScriptEngineFactory {
        public ScriptEngine getScriptEngine() {
            return new SmartBshScriptEngine();
        }
    }

    private static class ModifiedNashornScriptEngineFactory
    implements ScriptEngineFactory {
        private final NashornScriptEngineFactory nashornFactory = new NashornScriptEngineFactory();

        private ModifiedNashornScriptEngineFactory() {
        }

        @Override
        public String getEngineName() {
            return this.nashornFactory.getEngineName();
        }

        @Override
        public String getEngineVersion() {
            return this.nashornFactory.getEngineVersion();
        }

        @Override
        public List<String> getExtensions() {
            return this.nashornFactory.getExtensions();
        }

        @Override
        public List<String> getMimeTypes() {
            return this.nashornFactory.getMimeTypes();
        }

        @Override
        public List<String> getNames() {
            return this.nashornFactory.getNames();
        }

        @Override
        public String getLanguageName() {
            return this.nashornFactory.getLanguageName();
        }

        @Override
        public String getLanguageVersion() {
            return this.nashornFactory.getLanguageVersion();
        }

        @Override
        public Object getParameter(String key) {
            return this.nashornFactory.getParameter(key);
        }

        @Override
        public String getMethodCallSyntax(String obj, String m, String ... args) {
            return this.nashornFactory.getMethodCallSyntax(obj, m, args);
        }

        @Override
        public String getOutputStatement(String toDisplay) {
            return this.nashornFactory.getOutputStatement(toDisplay);
        }

        @Override
        public String getProgram(String ... statements) {
            return this.nashornFactory.getProgram(statements);
        }

        @Override
        public ScriptEngine getScriptEngine() {
            ScriptEngine engine = this.nashornFactory.getScriptEngine(new String[]{"--optimistic-types=false", "--no-deprecation-warning"});
            Class<?>[] interfaces = Arrays.copyOf(engine.getClass().getInterfaces(), engine.getClass().getInterfaces().length + 1);
            interfaces[interfaces.length - 1] = ScriptEngine.class;
            return (ScriptEngine)Proxy.newProxyInstance(engine.getClass().getClassLoader(), interfaces, (proxy, method, args) -> {
                try (Profiler.Sample _s = profiler.measure(method.getName());){
                    Object ret = method.invoke((Object)engine, args);
                    if (method.getName().equals("compile")) {
                        MyCompiledScript myCompiledScript = new MyCompiledScript((CompiledScript)ret, engine, (String)args[0]);
                        return myCompiledScript;
                    }
                    Object object = ret;
                    return object;
                }
            });
        }
    }
}

