/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import se.datadosen.component.JCleanToolBar;
import se.datadosen.component.JToolBarButton;
import se.datadosen.explorer.ExplorerSelectionModel;
import se.datadosen.jalbum.ActionTracker;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.EditPanel;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.util.Platform;

public class PluginContext {
    private JAlbumContext context;
    private int addedToolsMenuItems = 0;
    private int addedContextMenuItems = 0;
    private List<Action> importActions = new ArrayList<Action>();

    PluginContext(JAlbumContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Passing null JAlbumContext to PluginContext");
        }
        this.context = context;
    }

    public void addToolsMenuItem(JMenuItem item) {
        int macAdjust;
        if (item.getAction() != null) {
            item.setAction(new ActionTracker(item.getAction()));
        }
        JMenu toolsMenu = this.context.getFrame().frameMenus.toolsMenu;
        int n = macAdjust = Platform.isMac() ? 0 : 2;
        if (this.addedToolsMenuItems++ == 0) {
            toolsMenu.add((Component)new JSeparator(), toolsMenu.getItemCount() - macAdjust);
        }
        toolsMenu.add((Component)item, toolsMenu.getItemCount() - macAdjust);
    }

    public void addContextMenuItem(JMenuItem item) {
        if (item.getAction() != null) {
            item.setAction(new ActionTracker(item.getAction()));
        }
        boolean insertIndex = false;
        JMenu menu = this.context.getExplorer().extensionsMenu;
        menu.add(item);
    }

    public void addImportMenuItem(JMenuItem item) {
        if (item.getAction() != null) {
            item.setAction(new ActionTracker(item.getAction()));
        }
        JMenu importMenu = this.context.getFrame().frameMenus.importMenu;
        importMenu.add((Component)item, importMenu.getItemCount());
    }

    public void addImportAction(Action a) {
        this.importActions.add(new ActionTracker(a));
        JMenu importMenu = this.context.getFrame().frameMenus.importMenu;
        JMenuItem item = new JMenuItem(a);
        importMenu.add((Component)item, importMenu.getItemCount());
    }

    public void addToolBarAction(Action action) {
        this.addToolBarAction(new ActionTracker(action), true);
    }

    public void addToolBarAction(Action action, boolean showLabel) {
        JCleanToolBar bar = this.context.getExplorer().toolBar;
        bar.add(new JToolBarButton(new ActionTracker(action), showLabel));
        bar.validate();
    }

    public EditPanel getEditPanel() {
        return this.getJAlbumContext().getExplorer().editor;
    }

    public AlbumObject[] getSelectedAlbumObjects() {
        return this.context.getExplorer().explorer.getSelectedAlbumObjects();
    }

    public ExplorerSelectionModel getSelectionModel() {
        return this.context.getExplorer().explorer.selectionModel;
    }

    public AlbumObject getRootFolder() {
        return this.context.getExplorer().getRootFolder();
    }

    public AlbumObject getCurrentFolder() {
        return this.context.getExplorer().getCurrentFolder();
    }

    public JAlbumContext getJAlbumContext() {
        return this.context;
    }

    public List<Action> getImportActions() {
        return this.importActions;
    }
}

