/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.adobe.internal.xmp.XMPException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jalbum.resty.web.RobustResty;
import net.jalbum.resty.web.XMLResource;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.MiniConfig;
import se.datadosen.jalbum.XmpManager;
import se.datadosen.util.DigestUtil;

public class PlaceService {
    private static PlaceService theInstance;
    private static final String DB_NAME = "places-cache.txt";
    private final DecimalFormat threeDec = new DecimalFormat("0.###", new DecimalFormatSymbols(Locale.US));
    private static final String ENDPOINT_URL = "http://jalbum.net/integration/findNearbyPlace";
    private static final String SALT = "InvalidUserInputException";
    private Map<String, Place> db = new HashMap<String, Place>();
    private final RobustResty resty = new RobustResty();
    private ScheduledFuture delayedSave;

    public PlaceService() {
        try {
            this.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void load() throws IOException {
        this.db = new HashMap<String, Place>();
        File f = new File(MiniConfig.getMiniConfig().configDir, DB_NAME);
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));){
            String line;
            while ((line = in.readLine()) != null) {
                String[] tokens = line.split("\t");
                if (tokens.length >= 4) {
                    this.db.put(tokens[0], new Place(tokens[1], tokens[2], tokens[3]));
                    continue;
                }
                this.db.put(tokens[0], null);
            }
        }
    }

    private void scheduleSave() {
        if (this.delayedSave != null) {
            this.delayedSave.cancel(false);
        }
        this.delayedSave = JAlbumUtilities.schedule(() -> {
            try {
                this.save();
            }
            catch (IOException ex) {
                Logger.getLogger(PlaceService.class.getName()).log(Level.SEVERE, null, ex);
            }
        }, 1000L, TimeUnit.MILLISECONDS);
    }

    private synchronized void save() throws IOException {
        File f = new File(MiniConfig.getMiniConfig().configDir, DB_NAME);
        try (PrintWriter out = new PrintWriter(f, "UTF-8");){
            for (Map.Entry<String, Place> e : this.db.entrySet()) {
                if (e.getValue() != null) {
                    out.println(e.getKey() + "\t" + e.getValue().name + "\t" + e.getValue().region + "\t" + e.getValue().iso2Country);
                    continue;
                }
                out.println(e.getKey());
            }
        }
    }

    private String toKey(String gpsLocation) {
        String[] tokens = gpsLocation.split(",");
        double lat = Double.parseDouble(tokens[0]);
        double lng = Double.parseDouble(tokens[1]);
        return this.threeDec.format(lat) + "," + this.threeDec.format(lng);
    }

    public Place getPlace(AlbumObject ao) {
        XmpManager mgr = ao.getXmpManager();
        if (mgr != null) {
            try {
                String loc = mgr.getGpsLocation();
                if (loc != null) {
                    return this.getPlace(loc);
                }
                return null;
            }
            catch (XMPException loc) {
            }
            catch (IOException ex) {
                Logger.getLogger(PlaceService.class.getName()).log(Level.FINE, null, ex);
            }
        }
        return null;
    }

    public Place getPlace(String gpsLocation) throws IOException {
        String key = this.toKey(gpsLocation);
        Place loc = this.db.get(key);
        if (loc == null && !this.db.containsKey(key)) {
            if (JAlbum.logger.isLoggable(Level.FINE)) {
                System.out.println("Place service: Cache miss looking up " + key + ". Cache size: " + this.db.size());
            }
            try {
                loc = this.lookupLocation(key);
                this.db.put(key, loc);
            }
            catch (PlaceException ex) {
                this.db.put(key, null);
            }
            this.scheduleSave();
        }
        return loc;
    }

    public static synchronized PlaceService getInstance() {
        if (theInstance == null) {
            theInstance = new PlaceService();
        }
        return theInstance;
    }

    public Place lookupLocation(String gpsLocation) throws IOException, PlaceException {
        String[] tokens = gpsLocation.split(",");
        double lat = Double.parseDouble(tokens[0]);
        double lng = Double.parseDouble(tokens[1]);
        return this.lookupLocation(lat, lng);
    }

    public Place lookupLocation(double lat, double lng) throws IOException, PlaceException {
        XMLResource xmlRes = this.resty.xml("http://jalbum.net/integration/findNearbyPlace?lat=" + lat + "&lng=" + lng + "&username=jAlbum&style=full&hash=" + DigestUtil.md5(SALT + lat + lng + SALT));
        try {
            String message = (String)xmlRes.get("//status/@message", String.class);
            if (message.length() > 0) {
                throw new PlaceException(message);
            }
            String name = (String)xmlRes.get("//name", String.class);
            String cc = (String)xmlRes.get("//countryCode", String.class);
            String region = (String)xmlRes.get("//region", String.class);
            return new Place(name, region, cc);
        }
        catch (PlaceException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public static class Place
    implements Serializable,
    Comparable<Place> {
        public String name;
        public String region;
        public String iso2Country;

        public Place(String name, String region, String country) {
            if (this.isEmpty(name) || this.isEmpty(country)) {
                throw new IllegalArgumentException("Illegal arguments to Location: '" + name + "' and '" + country + "'");
            }
            this.name = name;
            this.region = region;
            this.iso2Country = country;
        }

        public String getName() {
            return this.iso2Country + " - " + (String)(this.region != null ? this.region + " - " : "") + " - " + this.name;
        }

        public String toString() {
            return this.name + ", " + (String)(this.region != null ? this.region + ", " : "") + this.iso2Country;
        }

        private boolean isEmpty(String s) {
            return s == null || s.length() == 0;
        }

        @Override
        public int compareTo(Place o) {
            return this.getName().compareTo(o.getName());
        }
    }

    public static class PlaceException
    extends Exception {
        public PlaceException(String message) {
            super(message);
        }
    }
}

