/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import se.datadosen.component.JNotification;
import se.datadosen.jalbum.Sounds;

public class NotificationManager
implements PropertyChangeListener {
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private LinkedList<JNotification> queue = new LinkedList();
    private LinkedList<JNotification> oldNotifications = new LinkedList();
    private JNotification active = null;
    private int showCount = 0;
    private final Thread managerThread = new ManagerThread();
    private static final int MAX_SHOW_COUNT = 2;
    public static final String OLD_NOTIFICATIONS_SIZE = "oldNotificationsSize";
    public static final String OLD_NOTIFICATIONS_LIST = "oldNotificationsList";
    public static final String NEW_ACTIVE_NOTIFICATION = "newActiveNotification";
    public static final String PAINTED_OLD_NOTIFICATION = "paintedOldNotification";

    public NotificationManager() {
        this.managerThread.start();
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(name, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(name, listener);
    }

    public synchronized void showNotification(JNotification n) {
        JNotification.Priority prio = n.getPriority();
        if (prio == JNotification.Priority.HIGH) {
            this.queue.addFirst(n);
            this.nextNotification();
            return;
        }
        this.queue.addLast(n);
        if (!this.isCurrentlyShowing()) {
            this.nextNotification();
        }
    }

    private boolean isCurrentlyShowing() {
        return this.active != null && this.active.isVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextNotification() {
        Thread thread = this.managerThread;
        synchronized (thread) {
            this.managerThread.notify();
        }
    }

    public int getShowCount() {
        return this.showCount;
    }

    public JNotification getActiveNotification() {
        return this.active != null && this.active.isVisible() ? this.active : null;
    }

    public synchronized List<JNotification> getOldNotifications() {
        LinkedList<JNotification> copy = new LinkedList<JNotification>(this.oldNotifications);
        return copy;
    }

    public synchronized void removeOldNotification(JNotification removeNotification) {
        int oldCount = 0;
        for (JNotification noti : this.oldNotifications) {
            if (noti.isDismissed()) continue;
            ++oldCount;
        }
        this.oldNotifications.remove(removeNotification);
        if (!removeNotification.isDismissed()) {
            int newCount = 0;
            for (JNotification noti : this.oldNotifications) {
                if (noti.isDismissed()) continue;
                ++newCount;
            }
            this.changeSupport.firePropertyChange(OLD_NOTIFICATIONS_SIZE, oldCount, newCount);
        }
        this.changeSupport.firePropertyChange(OLD_NOTIFICATIONS_LIST, null, this.oldNotifications);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.nextNotification();
    }

    public synchronized void addOldNotification(JNotification n) {
        LinkedList oldList = new LinkedList();
        int oldMissed = 0;
        for (JNotification noti : this.oldNotifications) {
            if (noti.isDismissed()) continue;
            ++oldMissed;
        }
        n.setInPopup(true);
        if (this.oldNotifications.size() > 9) {
            this.oldNotifications.removeLast();
        }
        this.oldNotifications.add(0, n);
        n.addPropertyChangeListener(PAINTED_OLD_NOTIFICATION, evt -> {
            int oldMissed1 = 0;
            for (JNotification noti : this.oldNotifications) {
                if (noti.isDismissed()) continue;
                ++oldMissed1;
            }
            this.changeSupport.firePropertyChange(OLD_NOTIFICATIONS_SIZE, oldMissed1, oldMissed1 - 1);
        });
        if (!n.isDismissed()) {
            this.changeSupport.firePropertyChange(OLD_NOTIFICATIONS_SIZE, oldMissed, oldMissed + 1);
        }
        this.changeSupport.firePropertyChange(OLD_NOTIFICATIONS_LIST, oldList, this.oldNotifications);
    }

    void dismissNotifications() {
        this.oldNotifications.addAll(this.queue);
        this.queue.clear();
        JNotification active = this.getActiveNotification();
        if (active != null) {
            active.dismiss();
        }
    }

    private class ManagerThread
    extends Thread {
        public ManagerThread() {
            super("Notifiation manager");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long delay = 0L;
            while (true) {
                try {
                    while (true) {
                        Object object = this;
                        synchronized (object) {
                            this.wait(delay);
                        }
                        if (NotificationManager.this.active != null) {
                            if (NotificationManager.this.active.isShowing()) {
                                NotificationManager.this.active.rollUp();
                            }
                            JNotification tmp = NotificationManager.this.active;
                            NotificationManager.this.active = null;
                            SwingUtilities.invokeLater(() -> {
                                tmp.setVisible(false);
                                tmp.jumpDown();
                                tmp.removePropertyChangeListener("dismissed", NotificationManager.this);
                                NotificationManager.this.changeSupport.firePropertyChange(NotificationManager.NEW_ACTIVE_NOTIFICATION, null, null);
                                NotificationManager.this.addOldNotification(tmp);
                            });
                        }
                        if (NotificationManager.this.showCount >= 2) {
                            object = NotificationManager.this;
                            synchronized (object) {
                                Iterator it = NotificationManager.this.queue.iterator();
                                while (it.hasNext()) {
                                    JNotification n = (JNotification)it.next();
                                    if (n.getPriority() != JNotification.Priority.LOW) continue;
                                    NotificationManager.this.addOldNotification(n);
                                    it.remove();
                                }
                            }
                        }
                        if (!NotificationManager.this.queue.isEmpty()) {
                            NotificationManager.this.active = NotificationManager.this.queue.removeFirst();
                            NotificationManager.this.active.jumpDown();
                            NotificationManager.this.active.setVisible(true);
                            if (NotificationManager.this.active.getPriority() == JNotification.Priority.HIGH) {
                                Sounds.play("Sosumi.aiff");
                            }
                            NotificationManager.this.active.addPropertyChangeListener("dismissed", NotificationManager.this);
                            NotificationManager.this.changeSupport.firePropertyChange(NotificationManager.NEW_ACTIVE_NOTIFICATION, null, NotificationManager.this.active);
                            ++NotificationManager.this.showCount;
                            NotificationManager.this.active.rollDown();
                            delay = 1000 * NotificationManager.this.active.getExpiration();
                            continue;
                        }
                        delay = 0L;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

