/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Component;
import java.awt.Toolkit;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.MiniConfig;
import se.datadosen.util.AliasAction;
import se.datadosen.util.IO;
import se.datadosen.util.Multilingual;
import se.datadosen.util.SmartResourceBundle;
import se.datadosen.util.StringUtil;
import se.datadosen.util.annotations.ActionCommand;
import se.datadosen.util.annotations.Icon;
import se.datadosen.util.annotations.Shortcut;
import se.datadosen.util.annotations.TabTitle;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.Title;
import se.datadosen.util.annotations.ToolTipText;

public class Msg {
    static final String TEXTS_BUNDLE_NAME = "texts/texts";
    static final String SHORTCUTS_BUNDLE_NAME = "system/shortcuts/shortcuts";
    private static SmartResourceBundle textsBundle;
    private static SmartResourceBundle shortcutsBundle;
    private static final Map<Package, SmartResourceBundle> cache;
    private static final String[] charsetNames;
    protected static Set toTranslate;
    protected static boolean debugMode;
    private static String menuModifierString;
    private static String[] extensions;

    private static String getIconPath(String path) {
        if (((String)path).charAt(0) != '/') {
            path = "/icons/standard/" + (String)path;
        }
        return path;
    }

    private static String concatenate(String prefix, String postfix) {
        return (prefix != null ? prefix : "") + " [" + postfix + "]";
    }

    private Msg() {
    }

    public static SmartResourceBundle getResourceBundle() {
        return textsBundle;
    }

    public static void reloadBundle() {
        try {
            cache.clear();
            textsBundle = SmartResourceBundle.getBundle(Config.getConfig().progDir, TEXTS_BUNDLE_NAME);
            shortcutsBundle = SmartResourceBundle.getBundle(MiniConfig.getMiniConfig().configDir, SHORTCUTS_BUNDLE_NAME);
        }
        catch (MissingResourceException ex) {
            shortcutsBundle = SmartResourceBundle.getBundle(Config.getConfig().progDir, SHORTCUTS_BUNDLE_NAME);
        }
    }

    static String[] getCharsetNames() {
        return charsetNames;
    }

    @Deprecated
    public static String getString(String key) {
        return Msg.get(key);
    }

    public static boolean isTranslated(String key) {
        return textsBundle.isTranslated(key);
    }

    public static String get(String key) {
        try {
            return textsBundle.getString(key);
        }
        catch (MissingResourceException e) {
            if (debugMode) {
                throw e;
            }
            return "!" + key + "!";
        }
    }

    private static final String getMenuModifierString() {
        if (menuModifierString == null) {
            menuModifierString = Msg.getModifiersText(Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
        }
        return menuModifierString;
    }

    private static String parseShortcutString(String shortcut) {
        return shortcut != null ? shortcut.replaceAll("cmd ", Msg.getMenuModifierString()) : null;
    }

    public static String getShortcut(String key) {
        try {
            String shortcut = shortcutsBundle.getString(key);
            return Msg.parseShortcutString(shortcut);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static boolean isPresent(String key) {
        try {
            textsBundle.getString(key);
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public static Locale getLocale() {
        Locale locale = textsBundle.getLocale();
        return locale != null ? locale : Locale.US;
    }

    private static String normalize(String s) {
        return s.replace("''", "'").replace("'", "''");
    }

    public static String get(String key, Object ... params) {
        return MessageFormat.format(Msg.normalize(Msg.get(key)), params);
    }

    public static String get(Class caller, String key, Object ... params) {
        return MessageFormat.format(Msg.normalize(Msg.getString(caller, key)), params);
    }

    public static String get(Class caller, String key) {
        return Msg.getString(caller, key);
    }

    public static String getString(Object caller, String key, Object ... params) {
        return MessageFormat.format(Msg.normalize(Msg.getString(caller, key)), params);
    }

    public static String getString(Object caller, String key) {
        return Msg.getString(caller.getClass(), key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static String getString(Class<?> caller, String key) {
        Package callerPackage = caller.getPackage();
        if (!cache.containsKey(callerPackage)) {
            Class<Msg> clazz = Msg.class;
            // MONITORENTER : se.datadosen.jalbum.Msg.class
            if (!cache.containsKey(callerPackage)) {
                SmartResourceBundle bundle = SmartResourceBundle.getBundle(caller, TEXTS_BUNDLE_NAME);
                JAlbum.logger.fine("Loaded bundle " + String.valueOf(bundle));
                cache.put(callerPackage, bundle);
            }
            // MONITOREXIT : clazz
        }
        SmartResourceBundle bundle = cache.get(callerPackage);
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return "!" + key + "!";
        }
    }

    public static void maintainTranslated(Object o) {
        toTranslate.add(o);
        Msg.setTexts(o);
        Msg.setIcons(o);
    }

    public static void releaseFromTranslation(Object o) {
        toTranslate.remove(o);
    }

    public static void setTexts() {
        for (Object o : toTranslate) {
            Msg.setTexts(o);
        }
    }

    static void printShortcuts() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Object o : toTranslate) {
            for (Field f : o.getClass().getDeclaredFields()) {
                Text nk;
                if (!Action.class.isAssignableFrom(f.getType()) || (nk = f.getAnnotation(Text.class)) == null) continue;
                try {
                    f.setAccessible(true);
                    String key = Msg.makeKey(nk.value(), f);
                    Action a = (Action)f.get(o);
                    if (a instanceof AliasAction) continue;
                    KeyStroke ks = (KeyStroke)a.getValue("AcceleratorKey");
                    String stroke = ks != null ? ks.toString() : "";
                    stroke = stroke.replaceAll("meta", "cmd");
                    stroke = stroke.replaceAll("pressed ", "");
                    map.put(key, stroke);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    Logger.getLogger(Msg.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        map.entrySet().forEach(e -> {
            if (!((String)e.getValue()).isEmpty()) {
                System.out.println((String)e.getKey() + "=" + (String)e.getValue());
            }
        });
    }

    public static void setTexts(Object o) {
        boolean printTextKeys = JAlbum.logger.isLoggable(Level.FINEST);
        try {
            for (Field f : Msg.getAllDeclaredFields(o.getClass())) {
                TabTitle ttk;
                Title tk;
                ToolTipText tttk;
                Action a;
                String textKey = null;
                String toolTipText = null;
                Text nk = f.getAnnotation(Text.class);
                Shortcut sc = f.getAnnotation(Shortcut.class);
                ActionCommand ac = f.getAnnotation(ActionCommand.class);
                if (nk != null) {
                    f.setAccessible(true);
                    textKey = Msg.makeKey(nk.value(), f);
                    String result = Msg.get(textKey) + nk.postfix();
                    if (Action.class.isAssignableFrom(f.getType())) {
                        String shortcut;
                        String actionCommand = StringUtil.stripSuffix(textKey, "ToolTip");
                        a = (Action)f.get(o);
                        a.putValue("Name", result);
                        a.putValue("ActionCommandKey", actionCommand);
                        String string = shortcut = sc != null && sc.override() ? Msg.parseShortcutString(sc.value()) : Msg.getShortcut(actionCommand);
                        if (shortcut == null && sc != null) {
                            shortcut = Msg.parseShortcutString(sc.value());
                        }
                        if (shortcut != null) {
                            KeyStroke ks = KeyStroke.getKeyStroke(shortcut);
                            a.putValue("AcceleratorKey", ks);
                        }
                        if (ac != null && ac.value() != null) {
                            a.putValue("ActionCommandKey", ac.value());
                        }
                    } else if (JComponent.class.isAssignableFrom(f.getType())) {
                        Method method = f.get(o).getClass().getMethod("setText", String.class);
                        method.invoke(f.get(o), result);
                    } else {
                        throw new RuntimeException("Annotated element " + f.getName() + " is not an Action or JComponent");
                    }
                }
                if ((tttk = f.getAnnotation(ToolTipText.class)) != null) {
                    f.setAccessible(true);
                    String key = Msg.makeKey(tttk.value(), f, "ToolTip");
                    toolTipText = Msg.get(key) + tttk.postfix();
                    if (Action.class.isAssignableFrom(f.getType())) {
                        a = (Action)f.get(o);
                        a.putValue("ShortDescription", toolTipText);
                    } else if (JComponent.class.isAssignableFrom(f.getType())) {
                        JComponent comp = (JComponent)f.get(o);
                        comp.setToolTipText(toolTipText);
                    } else {
                        throw new RuntimeException("Annotated element " + f.getName() + " is not an Action or JComponent");
                    }
                }
                if (printTextKeys && textKey != null) {
                    f.setAccessible(true);
                    if (Action.class.isAssignableFrom(f.getType())) {
                        Action a2 = (Action)f.get(o);
                        a2.putValue("ShortDescription", Msg.concatenate(toolTipText, textKey));
                    } else if (JComponent.class.isAssignableFrom(f.getType())) {
                        JComponent comp = (JComponent)f.get(o);
                        comp.setToolTipText(Msg.concatenate(toolTipText, textKey));
                    }
                }
                if ((tk = f.getAnnotation(Title.class)) != null) {
                    f.setAccessible(true);
                    String key = Msg.makeKey(tk.value(), f);
                    String result = Msg.get(key);
                    Method method = f.get(o).getClass().getMethod("setTitle", String.class);
                    method.invoke(f.get(o), result);
                }
                if ((ttk = f.getAnnotation(TabTitle.class)) != null) {
                    JTabbedPane tabs;
                    int index;
                    f.setAccessible(true);
                    String key = Msg.makeKey(ttk.value(), f);
                    String result = Msg.get(key);
                    Component comp = (Component)f.get(o);
                    if (comp.getParent() instanceof JTabbedPane && (index = (tabs = (JTabbedPane)comp.getParent()).indexOfComponent(comp)) != -1) {
                        tabs.setTitleAt(index, result);
                    }
                }
                if (!Multilingual.class.isAssignableFrom(f.getType())) continue;
                f.setAccessible(true);
                Multilingual ml = (Multilingual)f.get(o);
                if (ml == null) continue;
                ml.languageUpdated();
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | RuntimeException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void setIcons(Object o) {
        try {
            for (Field f : Msg.getAllDeclaredFields(o.getClass())) {
                f.setAccessible(true);
                javax.swing.Icon icon = null;
                javax.swing.Icon rolloverIcon = null;
                javax.swing.Icon selectedIcon = null;
                Icon anno = f.getAnnotation(Icon.class);
                if (anno != null) {
                    String value = anno.value();
                    if (value.endsWith(".svg")) {
                        String base = IO.baseName(value.substring(value.lastIndexOf(47) + 1));
                        Object name = base;
                        int size = Integer.parseInt(value.split("x")[0]);
                        if (Icons.exists((String)name)) {
                            icon = Icons.get((String)name, size);
                        }
                        if (Icons.exists((String)(name = (String)name + "-1"))) {
                            rolloverIcon = Icons.get((String)name, size);
                        }
                        if (Icons.exists((String)(name = base + "-selected"))) {
                            selectedIcon = Icons.get((String)name, size);
                        }
                    } else {
                        URL iconURL = o.getClass().getResource(Msg.getIconPath(anno.value()));
                        if (iconURL != null) {
                            icon = new ImageIcon(iconURL);
                            rolloverIcon = null;
                            URL rolloverURL = o.getClass().getResource(Msg.getRolloverVersion(Msg.getIconPath(anno.value())));
                            if (rolloverURL != null) {
                                rolloverIcon = new ImageIcon(rolloverURL);
                            }
                        }
                    }
                }
                if (icon == null) continue;
                if (Action.class.isAssignableFrom(f.getType())) {
                    Action a = (Action)f.get(o);
                    a.putValue("SmallIcon", icon);
                    if (rolloverIcon != null) {
                        a.putValue("rolloverIcon", rolloverIcon);
                    }
                    if (selectedIcon == null) continue;
                    a.putValue("selectedIcon", selectedIcon);
                    continue;
                }
                if (JComponent.class.isAssignableFrom(f.getType())) {
                    Method method = f.get(o).getClass().getMethod("setIcon", javax.swing.Icon.class);
                    method.invoke(f.get(o), icon);
                    if (rolloverIcon != null && o instanceof AbstractButton && (method = f.get(o).getClass().getMethod("setRolloverIcon", javax.swing.Icon.class)) != null) {
                        method.invoke(f.get(o), rolloverIcon);
                    }
                    if (selectedIcon == null || (method = f.get(o).getClass().getMethod("setSelectedIcon", javax.swing.Icon.class)) == null) continue;
                    method.invoke(f.get(o), selectedIcon);
                    continue;
                }
                throw new RuntimeException("Annotated element " + f.getName() + " is not an Action or JComponent");
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | RuntimeException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String makeKey(String raw, Field f) {
        return Msg.makeKey(raw, f, "");
    }

    private static String makeKey(String raw, Field f, String defaultExtension) {
        if (raw.length() == 0) {
            return "ui." + Msg.baseNameOf(f) + defaultExtension;
        }
        String s = raw.replaceAll("~", Msg.baseNameOf(f));
        return s;
    }

    private static String baseNameOf(Field f) {
        String s = f.getName();
        for (String ext : extensions) {
            if (!s.endsWith(ext)) continue;
            return s.substring(0, s.length() - ext.length());
        }
        return s;
    }

    private static String getRolloverVersion(String s) {
        String base = IO.baseName(s);
        String ext = IO.extensionOf(s);
        return base + "-1." + ext;
    }

    private static String getSelectedVersion(String s) {
        String base = IO.baseName(s);
        String ext = IO.extensionOf(s);
        return base + "-selected." + ext;
    }

    private static final Field[] getAllDeclaredFields(Class clazz) {
        String pkg;
        Class parent = clazz.getSuperclass();
        if (parent == null || Object.class.equals(parent)) {
            return clazz.getDeclaredFields();
        }
        HashMap<String, Field> fields = new HashMap<String, Field>();
        while (!(clazz == null || Object.class.equals((Object)clazz) || (pkg = clazz.getPackage().getName()).startsWith("java.") || pkg.startsWith("javax."))) {
            Field[] f;
            for (Field f1 : f = clazz.getDeclaredFields()) {
                if (fields.containsKey(f1.getName())) continue;
                fields.put(f1.getName(), f1);
            }
            clazz = clazz.getSuperclass();
        }
        return fields.values().toArray(new Field[0]);
    }

    private static String getModifiersText(int modifiers) {
        StringBuilder buf = new StringBuilder();
        if ((modifiers & 0x40) != 0) {
            buf.append("shift ");
        }
        if ((modifiers & 0x80) != 0) {
            buf.append("ctrl ");
        }
        if ((modifiers & 0x100) != 0) {
            buf.append("meta ");
        }
        if ((modifiers & 0x200) != 0) {
            buf.append("alt ");
        }
        if ((modifiers & 0x2000) != 0) {
            buf.append("altGraph ");
        }
        if ((modifiers & 0x400) != 0) {
            buf.append("button1 ");
        }
        if ((modifiers & 0x800) != 0) {
            buf.append("button2 ");
        }
        if ((modifiers & 0x1000) != 0) {
            buf.append("button3 ");
        }
        return buf.toString();
    }

    static {
        cache = new HashMap<Package, SmartResourceBundle>();
        Msg.reloadBundle();
        charsetNames = new String[]{"ISO-8859-1", "MacRoman", "US-ASCII", "UTF-16", "UTF-16BE", "UTF-16LE", "UTF-8", "windows-1252", Msg.get("ui.internationalJavaInfo"), "Big5", "Big5-HKSCS", "EUC-CN", "EUC-JP", "euc-jp-linux", "EUC-KR", "EUC-TW", "GB18030", "GBK", "ISCII91", "ISO-2022-CN-CNS", "ISO-2022-CN-GB", "ISO-2022-KR", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-9", "ISO-8859-13", "ISO-8859-15", "JIS0201", "JIS0208", "JIS0212", "Johab", "KOI8-R", "Shift_JIS", "TIS-620", "windows-1250", "windows-1251", "windows-1253", "windows-1254", "windows-1255", "windows-1256", "windows-1257", "windows-1258", "windows-936", "windows-949", "windows-950"};
        toTranslate = new HashSet();
        debugMode = false;
        menuModifierString = null;
        extensions = new String[]{"Action", "Label"};
    }
}

