/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.media.Media;
import javafx.scene.media.MediaException;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.util.Duration;
import se.datadosen.jalbum.TimeCode;
import se.datadosen.util.IO;

public class MediaPlayerProcessor {
    private File lastFile;
    private Media media;
    private MediaPlayer mediaPlayer;
    private final MediaView mediaView = new MediaView();
    private CountDownLatch workerLatch = new CountDownLatch(0);
    private BufferedImage bi;
    private IOException ex;
    private TimeCode lastTimeFromStart;
    private static Set<String> supportedtypes = new HashSet<String>(){
        {
            this.add("aif");
            this.add("aiff");
            this.add("fxm");
            this.add("m3u8");
            this.add("mp4");
            this.add("m4a");
            this.add("m4v");
            this.add("mov");
        }
    };

    public void dispose() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.dispose();
        }
    }

    public void fxSetMedia(File inputVideo) throws IOException {
        if (!inputVideo.equals(this.lastFile)) {
            this.lastFile = inputVideo;
            this.media = null;
            this.ex = null;
            this.lastTimeFromStart = null;
            try {
                if (!supportedtypes.contains(IO.extensionOf(inputVideo).toLowerCase())) {
                    throw new IOException("Unsupported media");
                }
                this.media = new Media(inputVideo.toURI().toString());
                if (this.mediaPlayer != null) {
                    this.mediaPlayer.dispose();
                }
                this.mediaPlayer = new MediaPlayer(this.media);
                this.mediaPlayer.setMute(true);
            }
            catch (MediaException ex) {
                throw new IOException(ex);
            }
        }
    }

    public void setMedia(File inputVideo) throws IOException {
        block9: {
            if (!inputVideo.equals(this.lastFile)) {
                this.lastFile = inputVideo;
                this.media = null;
                this.ex = null;
                this.lastTimeFromStart = null;
                try {
                    if (!supportedtypes.contains(IO.extensionOf(inputVideo).toLowerCase())) {
                        throw new IOException("Unsupported media");
                    }
                    this.media = new Media(inputVideo.toURI().toString());
                    if (this.mediaPlayer != null) {
                        this.mediaPlayer.dispose();
                    }
                    this.mediaPlayer = new MediaPlayer(this.media);
                    this.mediaPlayer.setOnError(() -> {
                        this.ex = new IOException(this.mediaPlayer.getError());
                        this.workerLatch.countDown();
                    });
                    this.mediaPlayer.setMute(true);
                    this.mediaView.setMediaPlayer(this.mediaPlayer);
                    this.workerLatch = new CountDownLatch(1);
                    this.mediaPlayer.statusProperty().addListener((observable, oldValue, newValue) -> {
                        switch (newValue) {
                            case READY: {
                                this.workerLatch.countDown();
                                break;
                            }
                            case HALTED: {
                                this.ex = new IOException("Halted");
                                this.workerLatch.countDown();
                            }
                        }
                    });
                    try {
                        this.workerLatch.await();
                        break block9;
                    }
                    catch (InterruptedException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                catch (IOException ex) {
                    this.ex = ex;
                    throw ex;
                }
                catch (MediaException ex) {
                    this.ex = new IOException(ex);
                    throw ex;
                }
            }
            if (this.ex != null) {
                throw this.ex;
            }
        }
    }

    public boolean isSupported() {
        return this.ex == null;
    }

    private BufferedImage doCreateSnapshot(MediaPlayer mp) {
        this.mediaView.setMediaPlayer(mp);
        WritableImage image = this.mediaView.snapshot(null, null);
        this.bi = new BufferedImage(this.media.getWidth(), this.media.getHeight(), 5);
        BufferedImage read = SwingFXUtils.fromFXImage((Image)image, null);
        this.bi.getGraphics().drawImage(read, 0, 0, null);
        return this.bi;
    }

    public BufferedImage createSnapshot(MediaPlayer mp) throws IOException {
        if (Platform.isFxApplicationThread()) {
            return this.doCreateSnapshot(mp);
        }
        this.workerLatch = new CountDownLatch(1);
        Platform.runLater(() -> {
            try {
                this.doCreateSnapshot(mp);
            }
            catch (Throwable t) {
                this.ex = new IOException(t);
            }
            finally {
                this.workerLatch.countDown();
            }
        });
        try {
            this.workerLatch.await();
            if (this.ex != null) {
                throw this.ex;
            }
            return this.bi;
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public BufferedImage createSnapshot(TimeCode timeFromStart) throws IOException {
        if (timeFromStart.equals(this.lastTimeFromStart)) {
            return this.bi;
        }
        try {
            this.mediaPlayer.seek(Duration.millis((double)timeFromStart.asMillis()));
            BufferedImage bufferedImage = this.createSnapshot(this.mediaPlayer);
            return bufferedImage;
        }
        finally {
            this.lastTimeFromStart = timeFromStart;
        }
    }
}

