/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Component;
import java.io.IOException;
import java.util.Properties;
import java.util.function.Function;
import javax.script.ScriptException;
import net.jalbum.UsageCounters;
import net.jalbum.component.JProgressManager;
import se.datadosen.component.Hour;
import se.datadosen.component.JNotification;
import se.datadosen.component.JSpeechBubble;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.JHtmlBox;
import se.datadosen.jalbum.JSkinErrorDialog;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.Sounds;
import se.datadosen.jalbum.TaskManager;
import se.datadosen.jalbum.UploadAlbumTask;
import se.datadosen.tags.ElementException;
import se.datadosen.util.Debug;
import se.datadosen.util.StringUtil;

public class MakeAlbumTask
extends TaskManager.BackgroundTask
implements AlbumBeanListener {
    AlbumBean engine;
    Boolean forceRebuild;
    boolean forceVideoProcessing;
    private final Object pauseMonitor = new Object();
    JProgressManager.TaskStatus ts = new JProgressManager.TaskStatus();
    JAlbumFrame window;
    TaskManager.BackgroundTask chainedTask;
    private boolean handover;

    public MakeAlbumTask(AlbumProject ap, JAlbumContext context, JAlbumFrame window) throws IOException {
        super(ap);
        this.init(context, window);
        Properties props = JAlbumUtilities.importProject(ap.getProjectFile());
        this.engine.setProperties(props);
    }

    public MakeAlbumTask(JAlbumContext context, JAlbumFrame window) throws IOException {
        super(window.getCurrentProject());
        this.init(context, window);
        window.ui2Engine(this.engine);
        this.engine.setImageVariants(window.engine.getImageVariants());
        this.engine.setThumbVariants(window.engine.getThumbVariants());
    }

    public MakeAlbumTask(AlbumBean engine, JAlbumFrame window) {
        super(engine.getCurrentProject());
        this.handover = true;
        this.engine = engine;
        this.init(JAlbumContext.getInstance(), window);
    }

    public Boolean isForceRebuild() {
        return this.forceRebuild;
    }

    public void setForceRebuild(Boolean forceRebuild) {
        this.forceRebuild = forceRebuild;
    }

    public boolean isForceVideoProcessing() {
        return this.forceVideoProcessing;
    }

    public void setForceVideoProcessing(boolean forceVideoProcessing) {
        this.forceVideoProcessing = forceVideoProcessing;
    }

    private void init(JAlbumContext context, JAlbumFrame window) {
        this.window = window;
        this.setName(StringUtil.limit(this.ap.getName(), 30) + " (" + Msg.get("ui.makeTaskShortName") + ")");
        this.ts.setMessage(this.getName());
        this.ts.onAbort(() -> {
            Object object = this.pauseMonitor;
            synchronized (object) {
                this.ts.abort();
                this.cancel();
                if (this.ts.isStarted()) {
                    this.pauseMonitor.notifyAll();
                }
            }
            if (this.chainedTask instanceof UploadAlbumTask) {
                window.progressManager.removeTask(((UploadAlbumTask)this.chainedTask).ts);
            }
            window.progressManager.removeTask(this.ts);
        });
        this.ts.onPause(() -> {
            Object object = this.pauseMonitor;
            synchronized (object) {
                if (!this.ts.isPaused()) {
                    this.pauseMonitor.notifyAll();
                }
            }
        });
        if (this.engine == null) {
            this.engine = new AlbumBean(context);
            try {
                Properties props = JAlbumUtilities.importProject(this.ap.getProjectFile());
                this.engine.setProperties(props);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.engine.setCurrentProject(this.ap);
        }
        this.engine.addAlbumBeanListener(this);
        this.onError(ex -> {
            this.ap.lastExceptionProperty.set(ex);
            JNotification n = new JNotification(Msg.get("ui.errorMakingProject", this.ap.getName(), "<a href=\"about:blank\">" + ex.getMessage() + "</a>"), JNotification.Type.ERROR);
            n.onLinkClicked(he -> {
                n.setVisible(false);
                if (ex instanceof ElementException || ex instanceof ScriptException) {
                    JSkinErrorDialog d = new JSkinErrorDialog(JAlbumContext.getInstance(), (Throwable)ex);
                    d.setVisible(true);
                } else {
                    Debug.showErrorDialog(window, ex);
                }
            });
            window.showNotification(n);
        });
        if (this.handover) {
            window.progressManager.startTask(this.ts);
        }
    }

    public TaskManager.BackgroundTask getChainedTask() {
        return this.chainedTask;
    }

    public void setChainedTask(TaskManager.BackgroundTask chainedTask) {
        this.chainedTask = chainedTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doInBackground() throws Exception {
        this.ap.lastExceptionProperty.set(null);
        if (!this.handover) {
            this.window.progressManager.startTask(this.ts);
            this.engine.setScriptEnvironment(this.window.multiMaker.sharedScriptEnvironment);
            if (this.forceRebuild != null) {
                this.engine.setAppendImages(this.forceRebuild == false);
                this.engine.setForceVideoProcessing(this.forceVideoProcessing);
                this.engine.makeAlbum();
            } else {
                this.engine.smartMakeAlbum();
            }
            this.window.multiMaker.sharedScriptEnvironment = this.engine.getScriptEnvironment();
            if (UsageCounters.get("preview") == 0) {
                JSpeechBubble.show(this.window.mainSettingsPanel.previewButton, new Hour(3), Msg.get("tip.preview"), 2000);
            }
        } else {
            try {
                MakeAlbumTask makeAlbumTask = this;
                synchronized (makeAlbumTask) {
                    this.wait();
                }
            }
            catch (InterruptedException ex) {
                throw new OperationAbortedException();
            }
        }
        return null;
    }

    @Override
    public void albumMakingStarted(boolean changes) {
        this.window.statusBar.setText(Msg.get("ui.makingAlbumStarted", this.ap.getName(), changes ? Msg.get("ui.changes") : Msg.get("ui.all")));
    }

    @Override
    protected void done() {
        this.window.progressManager.removeTask(this.ts);
        this.engine.removeAlbumBeanListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProgress(AlbumBeanEvent e, float currentObjectProgress) {
        Object object = this.pauseMonitor;
        synchronized (object) {
            if (this.ts.isPaused()) {
                try {
                    this.pauseMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        Object msg = "";
        if (!e.dir.equals(this.engine.getOutputDir())) {
            msg = e.dir.getName() + "/";
        }
        msg = (String)msg + e.msg;
        this.ts.setSubMessage((String)msg);
        if (e.getTotalFiles() > 0) {
            this.ts.setProgress(Msg.get("progress.processingInfo2", e.getProcessingCount(), e.getTotalFiles()), e.getProcessedFiles() * 100 + (int)(currentObjectProgress * 100.0f), e.getTotalFiles() * 100);
        }
    }

    @Override
    public void status(String message) {
        this.ts.setSubMessage(message);
    }

    @Override
    public void warning(String message) {
        JNotification n = new JNotification(message, JNotification.Type.WARNING);
        n.setPriority(JNotification.Priority.HIGH);
        n.setExpiration(6);
        this.window.showNotification(n);
    }

    @Override
    public boolean requestConfirmation(String message, Function<Component, Boolean> showDialog) {
        return showDialog.apply(this.window);
    }

    @Override
    public void imageProcessingStarted(AlbumBeanEvent e) {
        if (this.ts.isAborted()) {
            e.abortProcessing();
        }
        this.updateProgress(e, 0.0f);
    }

    @Override
    public void imageProcessingFinished(AlbumBeanEvent e) {
        if (this.ts.isAborted()) {
            e.abortProcessing();
        }
        this.updateProgress(e, 0.0f);
    }

    @Override
    public void videoProcessingProgress(AlbumBeanEvent e, float currentObjectProgress) {
        if (this.ts.isAborted()) {
            e.abortProcessing();
        }
        this.updateProgress(e, currentObjectProgress);
    }

    @Override
    public void errorOccured(Throwable t, AlbumObject ao) {
        String msg = Msg.get("ui.objectSkippedError", ao.getPathFromRoot(), t.getMessage());
        JHtmlBox box = new JHtmlBox(msg);
        JNotification n = new JNotification(box, JNotification.Type.WARNING);
        box.onLinkClicked(he -> {
            this.window.albumExplorer.gotoPath(ao.getPathFromRoot());
            Sounds.play("Frog.aiff");
        });
        n.setPriority(JNotification.Priority.HIGH);
        n.setExpiration(12);
        this.window.showNotification(n);
    }

    public AlbumBean getEngine() {
        return this.engine;
    }
}

