/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.FullScreenAdapter;
import com.apple.eawt.FullScreenListener;
import com.apple.eawt.FullScreenUtilities;
import java.awt.Taskbar;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import se.datadosen.util.Platform;

public class MacUtilities {
    private static final Map<Window, Object> listeners = new HashMap<Window, Object>();
    private static final Map<Window, Boolean> stateMap = new HashMap<Window, Boolean>();

    public static void enableFullScreen(Window window, boolean enable) {
        if (!Platform.isMac()) {
            return;
        }
        FullScreenUtilities.setWindowCanFullScreen((Window)window, (boolean)enable);
        if (enable) {
            FullScreenAdapter listener = new FullScreenAdapter(){

                public void windowExitedFullScreen(AppEvent.FullScreenEvent fse) {
                    stateMap.put(fse.getWindow(), Boolean.FALSE);
                }

                public void windowEnteredFullScreen(AppEvent.FullScreenEvent fse) {
                    stateMap.put(fse.getWindow(), Boolean.TRUE);
                }
            };
            listeners.put(window, listener);
            FullScreenUtilities.addFullScreenListenerTo((Window)window, (FullScreenListener)listener);
        } else {
            FullScreenListener listener = (FullScreenListener)listeners.remove(window);
            if (listener != null) {
                FullScreenUtilities.removeFullScreenListenerFrom((Window)window, (FullScreenListener)listener);
            }
            stateMap.remove(window);
        }
    }

    private static void assertEnabled(Window window) {
        if (listeners.get(window) == null) {
            throw new IllegalStateException("Fullscreen support not enabled for window");
        }
    }

    public static boolean isFullScreen(Window window) {
        if (!Platform.isMac()) {
            return false;
        }
        MacUtilities.assertEnabled(window);
        return stateMap.getOrDefault(window, Boolean.FALSE);
    }

    public static void toggleFullScreen(Window window) {
        if (!Platform.isMac()) {
            return;
        }
        MacUtilities.assertEnabled(window);
        Application.getApplication().requestToggleFullScreen(window);
    }

    public static void requestUserAttention(boolean b) {
        if (Taskbar.isTaskbarSupported()) {
            Taskbar.getTaskbar().requestUserAttention(true, false);
        }
    }

    public static final boolean isMacOsDarkMode() {
        try {
            String line;
            boolean isDarkMode = false;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(new String[]{"defaults", "read", "-g", "AppleInterfaceStyle"});
            InputStreamReader isr = new InputStreamReader(process.getInputStream());
            BufferedReader rdr = new BufferedReader(isr);
            while ((line = rdr.readLine()) != null) {
                if (!line.equals("Dark")) continue;
                isDarkMode = true;
            }
            int rc = process.waitFor();
            return 0 == rc && isDarkMode;
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
    }
}

