/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.FileAlbumObject;
import se.datadosen.util.IO;
import se.datadosen.util.annotations.NoLinkForward;

public class LinkAlbumObject
extends FileAlbumObject {
    private transient Boolean internal;
    protected AlbumObject target;
    private boolean targetResolved;
    private static final Class<? extends LinkAlbumObject> PROXY_CLASS;
    private static final ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, Method>> methodCache;

    public LinkAlbumObject(File file, AlbumObject parent, AlbumObjectFactory factory) {
        super(file, parent, factory);
    }

    public LinkAlbumObject(File file, AlbumObject parent, AlbumObject target) {
        super(file, parent, parent.getFactory());
        this.target = target;
        this.targetResolved = true;
        this.internal = true;
    }

    @Override
    @NoLinkForward
    public boolean isLink() {
        return true;
    }

    @Override
    @NoLinkForward
    public boolean isInternalLink() {
        if (this.internal == null) {
            this.internal = LinkAlbumObject.isInternalLink(this.getFile(), this.getEngine());
        }
        return this.internal;
    }

    @NoLinkForward
    public AlbumObject getTarget() {
        AlbumObject it;
        if (!this.targetResolved && this.target == null && this.isInternalLink() && (it = LinkAlbumObject.getInternalTarget(this.file, this.getRoot())) != this) {
            this.target = it;
        }
        this.targetResolved = true;
        return this.target;
    }

    @Override
    protected AlbumObjectImpl getRepObject(AlbumObjectImpl.VisitorContext ctx) {
        AlbumObjectImpl rep;
        if (this.getEngine().isLinkInternally(this) && (rep = (AlbumObjectImpl)this.getTarget()) != null) {
            AlbumObjectImpl rep2 = rep.getRepObject(ctx);
            rep = rep2 != null ? rep2 : rep;
            this.setRep(rep);
            return rep;
        }
        return super.getRepObject(ctx);
    }

    static Method getTargetMethod(Object target, Method proxyMethod) {
        Class<?> targetClass = target.getClass();
        String key = proxyMethod.getName() + "#" + Arrays.toString(proxyMethod.getParameterTypes());
        methodCache.putIfAbsent(targetClass, new ConcurrentHashMap());
        ConcurrentHashMap<String, Method> classCache = methodCache.get(targetClass);
        return classCache.computeIfAbsent(key, k -> {
            try {
                Method m = targetClass.getMethod(proxyMethod.getName(), proxyMethod.getParameterTypes());
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        });
    }

    static LinkAlbumObject createInstance(File file, AlbumObject parent, AlbumObjectFactory factory) {
        try {
            return PROXY_CLASS.getConstructor(File.class, AlbumObject.class, AlbumObjectFactory.class).newInstance(file, parent, factory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static LinkAlbumObject createInstance(File file, AlbumObject parent, AlbumObject target) {
        try {
            return PROXY_CLASS.getConstructor(File.class, AlbumObject.class, AlbumObject.class).newInstance(file, parent, target);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isInternalLink(File f, AlbumBean engine) {
        return IO.isSubdirectoryOf(LinkFile.targetOf(f), engine.getRootImageDir());
    }

    protected static AlbumObject getInternalTarget(File f, AlbumObject root) {
        String childPath = root.getPath().relativize(LinkFile.linkOf(LinkFile.targetOf(f)).toPath()).toString().replace(File.separatorChar, '/');
        return root.getChild(childPath);
    }

    static {
        methodCache = new ConcurrentHashMap();
        PROXY_CLASS = new ByteBuddy().subclass(LinkAlbumObject.class).method((ElementMatcher)ElementMatchers.isPublic().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAnnotatedWith(NoLinkForward.class)))).intercept((Implementation)MethodDelegation.to(LinkInterceptor.class)).make().load(LinkAlbumObject.class.getClassLoader()).getLoaded();
    }

    public static class LinkInterceptor {
        @RuntimeType
        public static Object intercept(@This LinkAlbumObject proxy, @Origin Method method, @SuperCall Callable<?> zuper, @AllArguments Object[] args) throws Exception {
            AlbumObjectImpl target = (AlbumObjectImpl)proxy.getTarget();
            if (target != null) {
                Method targetMethod = LinkAlbumObject.getTargetMethod(target, method);
                return targetMethod.invoke((Object)target, args);
            }
            return zuper.call();
        }
    }
}

