/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javax.swing.JOptionPane;
import net.jalbum.resty.web.AbstractContent;
import net.jalbum.resty.web.RobustResty;
import se.datadosen.component.JBackgroundTextField;
import se.datadosen.component.WrappableJLabel;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AuthenticationException;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.LicenseManager;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.util.DigestUtil;
import se.datadosen.util.IO;
import se.datadosen.util.WindowUtilities;

public class LicenseManagerImpl
implements LicenseManager {
    protected final JAlbumContext context;
    public static final String JALBUM_SUPPORTER = "jAlbumSupporter";
    private PropertyChangeSupport changeSupport;
    protected Preferences preferences = Preferences.userNodeForPackage(LicenseManager.class);
    private JBackgroundTextField uacField;
    private ReadOnlyBooleanWrapper licenseValidProperty = new ReadOnlyBooleanWrapper(this.isLicenseValid());

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    LicenseManagerImpl(JAlbumContext context) {
        this.context = context;
        this.addPropertyChangeListener("licenseValid", pce -> this.licenseValidProperty.setValue((Boolean)pce.getNewValue()));
    }

    public void activateLicense() {
        if (this.uacField == null) {
            this.uacField = new JBackgroundTextField(26);
            this.uacField.setBackgroundText("nnnnnn-xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
            WindowUtilities.setDefaultFocus(this.uacField);
        }
        WrappableJLabel info = new WrappableJLabel(Msg.get("ui.activateLicenseInfo"));
        info.setPreferredWidth(360);
        Object[] options = new Object[]{Msg.get("ui.activateLicense"), Msg.get("ui.signIn"), Msg.get("cancel")};
        int answer = JOptionPane.showOptionDialog(this.getWindow(), new Object[]{info, this.uacField}, Msg.get("ui.activateLicense"), 0, 1, null, options, options[0]);
        if (answer == 0) {
            this.checkLicenseStatus(this.uacField.getText().trim());
        } else if (answer == 1) {
            SignInManager.getInstance().showDialog();
        }
    }

    public void backgroundCheckLicenseStatus() {
        Thread backgroundThread = new Thread("License authenticator"){

            @Override
            public void run() {
                try {
                    String uic = LicenseManagerImpl.this.preferences.get("uic", null);
                    if (uic == null) {
                        return;
                    }
                    AccountManager.AccountStatus status = AccountManager.getJalbumAccountStatus(uic);
                    LicenseManagerImpl.this.checkLicenseStatus(status);
                }
                catch (IOException uic) {
                }
                catch (AuthenticationException ex) {
                    LicenseManagerImpl.this.detachLicense();
                }
            }
        };
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void activateLicense(String uic) throws IOException, AuthenticationException {
        AccountManager.AccountStatus status = AccountManager.getJalbumAccountStatus(uic);
        this.checkLicenseStatus(status);
    }

    private void checkLicenseStatus(final String uic) {
        Thread backgroundThread = new Thread(this, "License authenticator"){
            final /* synthetic */ LicenseManagerImpl this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void run() {
                try {
                    this.this$0.getWindow().progressSpinner.workStarted();
                    AccountManager.AccountStatus status = AccountManager.getJalbumAccountStatus(uic);
                    this.this$0.checkLicenseStatus(status);
                    if (!this.this$0.isLicenseValid()) {
                        JOptionPane.showMessageDialog(this.this$0.getWindow(), Msg.get("activation.noLicenseError", this.this$0.getUserName()), Msg.get("ui.activateLicense"), 2);
                    }
                    return;
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this.this$0.getWindow(), Msg.get("activation.ioProblem", ex.getMessage()), Msg.get("ui.activateLicense"), 0);
                }
                catch (AuthenticationException ex) {
                    JOptionPane.showMessageDialog(this.this$0.getWindow(), Msg.get("ui." + ex.getMessage()), Msg.get("ui.activateLicense"), 0);
                }
                finally {
                    this.this$0.getWindow().progressSpinner.workDone();
                }
                this.this$0.activateLicense();
            }
        };
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    void detachLicense() {
        if (this.getUserId() != -1) {
            if (this.uacField != null) {
                this.uacField.setText("");
            }
            this.preferences.putBoolean("validLicense", false);
            this.preferences.remove("username");
            this.preferences.remove("uic");
            this.preferences.remove("license");
            this.preferences.remove("licenseVersion");
            this.preferences.remove("licenseExpires");
            try {
                this.preferences.flush();
                this.firePropertyChange("licenseValid", true, false);
                this.firePropertyChange("identified", true, false);
            }
            catch (BackingStoreException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    void checkLicenseStatus(AccountManager.AccountStatus status) {
        boolean wasIdentified = this.getUserId() != -1;
        String userName = (String)status.get("username");
        String uic = (String)status.get("uic");
        String validLicense = (String)status.get("validLicense");
        boolean isValid = "true".equals(validLicense);
        boolean wasValid = this.preferences.getBoolean("validLicense", false);
        if (!isValid && wasValid && !uic.equals(this.getUIC())) {
            return;
        }
        this.preferences.put("username", userName);
        this.preferences.put("uic", uic);
        this.ifExistsAddToPreferences("license", status);
        this.ifExistsAddToPreferences("licenseUsers", status);
        this.ifExistsAddToPreferences("licenseVersion", status);
        this.ifExistsAddToPreferences("licenseExpires", status);
        this.ifExistsAddToPreferences("supportExpires", status);
        this.preferences.putBoolean("validLicense", isValid);
        if (!wasIdentified) {
            this.firePropertyChange("identified", false, true);
        }
        if (isValid != wasValid) {
            this.firePropertyChange("licenseValid", wasValid, isValid);
        }
    }

    private void ifExistsAddToPreferences(String key, AccountManager.AccountStatus status) {
        if (status.containsKey(key)) {
            this.preferences.put(key, (String)status.get(key));
        } else {
            this.preferences.remove(key);
        }
    }

    @Override
    public String getUserName() {
        return this.preferences.get("username", "");
    }

    @Override
    public int getUserId() {
        String uic = this.preferences.get("uic", null);
        try {
            if (uic != null) {
                int dashIndex = uic.indexOf(45);
                return Integer.parseInt(uic.substring(0, dashIndex));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    public String getUIC() {
        return this.preferences.get("uic", null);
    }

    @Override
    public boolean isLicenseValid() {
        return this.preferences.getBoolean("validLicense", false);
    }

    @Override
    public ReadOnlyBooleanProperty licenseValidProperty() {
        return this.licenseValidProperty.getReadOnlyProperty();
    }

    public boolean isLicenseValidFor(String versionNumber) throws IOException {
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("uic", this.getUIC());
            data.put("internalVersion", versionNumber);
            data.put("guid", "" + JAlbum.getGUID());
            data.put("os.name", System.getProperty("os.name"));
            RobustResty r = new RobustResty();
            return "true".equals(r.xml(JAlbumSite.getInstance().getVerifyCidUrl(), (AbstractContent)RobustResty.form(data)).get("/reply/result/@validLicense", String.class));
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public String getLicenseCode() {
        return this.isLicenseValid() ? DigestUtil.md5(this.getUserName() + "partofit") : "";
    }

    @Override
    public boolean isOldDonor() {
        return this.preferences.getBoolean(JALBUM_SUPPORTER, false);
    }

    protected JAlbumFrame getWindow() {
        return this.context.getFrame();
    }

    @Override
    public String getLicenseType() {
        return this.preferences.get("license", null);
    }

    @Override
    public Integer getLicenseVersion() {
        try {
            return Integer.valueOf(this.preferences.get("licenseVersion", null));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Override
    public Integer getLicenseUsers() {
        try {
            return Integer.valueOf(this.preferences.get("licenseUsers", null));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Override
    public Date getLicenseExpires() {
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(this.preferences.get("licenseExpires", ""));
        }
        catch (ParseException ex) {
            return null;
        }
    }

    @Override
    public Date getSupportExpires() {
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(this.preferences.get("supportExpires", ""));
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public long getStartDate() {
        return JAlbum.getTSD();
    }

    @Override
    public int getTrialDaysLeft() {
        long trialStart = JAlbum.getTSD();
        File from = new File(Config.getConfig().progDir, "system/album.rss");
        String destName = "albumv25.rss";
        File to = Config.getConfigFile(destName, destName);
        if (!to.exists()) {
            try {
                String text = IO.readTextFile(from);
                IO.writeTextFile(text, to);
            }
            catch (IOException text) {
                // empty catch block
            }
        }
        if (trialStart > 0L && to.lastModified() > trialStart) {
            to.setLastModified(trialStart);
        }
        trialStart = Math.min(trialStart, to.lastModified());
        long now = Math.max(System.currentTimeMillis(), JAlbumSite.getInstance().getTimeStamp());
        long daysLeft = 30L - (now - trialStart) / 1000L / 3600L / 24L;
        daysLeft = Math.min(daysLeft, 30L);
        if ((daysLeft = Math.max(daysLeft, 0L)) == 0L && trialStart > 0L) {
            Preferences prefs = Preferences.userNodeForPackage(JAlbum.class);
            prefs.put("v25", "0");
        }
        return (int)daysLeft;
    }
}

