/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;

class KeyNavigator<T extends Component> {
    private final Container container;

    public KeyNavigator(Container container) {
        this.container = container;
    }

    T getNeigbour(T current, Direction dir) {
        int currentIndex = this.indexOf(current);
        if (currentIndex == -1) {
            return null;
        }
        switch (dir.ordinal()) {
            case 0: {
                return this.getAboveOrBelow(currentIndex, -1);
            }
            case 2: {
                return this.getAboveOrBelow(currentIndex, 1);
            }
            case 1: {
                return this.getBounded(currentIndex - 1);
            }
            case 3: {
                return this.getBounded(currentIndex + 1);
            }
        }
        return null;
    }

    private T getBounded(int i) {
        try {
            return (T)this.container.getComponent(i);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
    }

    private T getAboveOrBelow(int currentIndex, int delta) {
        Point p = this.container.getComponent(currentIndex).getLocation();
        Component[] comps = this.container.getComponents();
        for (int i = currentIndex; i >= 0 && i < comps.length; i += delta) {
            Point p2 = comps[i].getLocation();
            if (p2.x != p.x || p2.y == p.y) continue;
            return (T)comps[i];
        }
        return null;
    }

    int indexOf(T comp) {
        Component[] comps = this.container.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] != comp) continue;
            return i;
        }
        return -1;
    }

    T nextMatching(T start, String prefix) {
        int startIndex = this.indexOf(start);
        int foundIndex = this.indexOfNextMatching(startIndex + 1, this.container.getComponentCount(), prefix);
        if (foundIndex == -1) {
            foundIndex = this.indexOfNextMatching(0, startIndex - 1, prefix);
        }
        return this.getBounded(foundIndex);
    }

    private int indexOfNextMatching(int start, int stop, String prefix) {
        Component[] comps = this.container.getComponents();
        for (int i = start; i < stop; ++i) {
            Component comp = comps[i];
            String name = comp.getName();
            if (name == null || !name.toLowerCase().startsWith(prefix)) continue;
            return i;
        }
        return -1;
    }

    static enum Direction {
        NORTH,
        WEST,
        SOUTH,
        EAST;

    }
}

