/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import net.jalbum.resty.web.AbstractContent;
import net.jalbum.resty.web.RobustResty;
import net.jalbum.resty.web.XMLResource;
import org.w3c.dom.NodeList;
import se.datadosen.component.CenterLayout;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JNotification;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumBorders;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.JWarningPanel;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Notifier;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.jalbum.Widget;
import se.datadosen.jalbum.Widgets;
import se.datadosen.util.Debug;

public class JWidgetSettingsPanel
extends ControlPanel {
    JAlbumContext context;
    List<Widget> widgets;
    RefreshWorker refreshWorker = new RefreshWorker();
    private JProgressSpinner spinner = new JProgressSpinner(28);
    Action saveAsDefaultAction = new AbstractAction(Msg.get("ui.saveAsDefaultMenu")){

        @Override
        public void actionPerformed(ActionEvent e) {
            new UpdateStatusWorker(null, JWidgetSettingsPanel.this.widgets).execute();
        }
    };

    public JWidgetSettingsPanel(JAlbumContext context) {
        this.context = context;
        this.init();
    }

    private void init() {
        this.context.getFrame().addPropertyChangeListener("rootFolder", evt -> {
            if (this.isShowing()) {
                this.refresh();
            }
        });
        this.addHierarchyListener(e -> {
            if ((e.getChangeFlags() & 4L) != 0L && this.isShowing()) {
                this.refresh();
            }
        });
        SignInManager.getInstance().addPropertyChangeListener("signIn", evt -> {
            if (this.isShowing()) {
                this.refresh();
            }
        });
    }

    private void refresh() {
        if (this.refreshWorker.isDone()) {
            this.refreshWorker = new RefreshWorker();
        }
        if (this.refreshWorker.getState() == SwingWorker.StateValue.STARTED) {
            return;
        }
        if (this.getComponentCount() == 0) {
            JPanel spinnerPanel = new JPanel(new CenterLayout());
            spinnerPanel.add(this.spinner);
            this.add("hfill vfill", spinnerPanel);
            this.validate();
            this.spinner.workStarted();
        }
        this.refreshWorker.execute();
    }

    private void showLocalChangeHint() {
        JNotification tip = new JNotification(Msg.get("ui.widgetsUpdatedLocally"), JNotification.Type.TIP);
        tip.setPriority(JNotification.Priority.HIGH);
        tip.setExpiration(6);
        if (!tip.equals(this.context.getFrame().notificationManager.getActiveNotification())) {
            this.context.getFrame().showNotification(tip);
        }
    }

    private void showPublicChangeHint(String albumUrl) {
        JNotification tip = new JNotification(Msg.get("ui.widgetsUpdated", albumUrl), JNotification.Type.TIP);
        tip.setPriority(JNotification.Priority.HIGH);
        tip.setExpiration(10);
        if (!tip.equals(this.context.getFrame().notificationManager.getActiveNotification())) {
            this.context.getFrame().showNotification(tip);
        }
    }

    private class RefreshWorker
    extends SwingWorker<List<Widget>, Object> {
        Action enableWidgetSupportAction = new AbstractAction(Msg.get("ui.widgetSupport")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JWidgetSettingsPanel.this.context.getFrame().settingsWindow.widgetInjection.setSelected(true);
                JWidgetSettingsPanel.this.refresh();
            }
        };

        @Override
        protected List<Widget> doInBackground() throws Exception {
            JWidgetSettingsPanel.this.context.getFrame().progressSpinner.workStarted();
            JWidgetSettingsPanel.this.context.getFrame().statusBar.pushText(Msg.get("ui.fetchingWidgetStatus"));
            AlbumObject root = JWidgetSettingsPanel.this.context.getExplorer().getRootFolder();
            AlbumObjectProperties props = root.getProperties();
            if (props.containsKey("widgetsLocalChange") && props.containsKey("widgets")) {
                return (List)props.get("widgets");
            }
            RobustResty r = new RobustResty();
            HashMap<String, String> data = new HashMap<String, String>();
            SignInManager mgr = SignInManager.getInstance();
            if (mgr.isSignedIn() && JWidgetSettingsPanel.this.context.getFrame().settingsWindow.widgetInjection.isSelected()) {
                data.put("cid", AccountManager.getCid(mgr.getUserName(), mgr.getPassword()));
            }
            if (props.containsKey("albumURL")) {
                data.put("albumUrl", Notifier.urlEncode((String)props.get("albumURL")));
            }
            data.put("lang", Config.getConfig().getInterpretedLanguage());
            XMLResource xml = r.xml(JAlbumSite.getInstance().getWidgetsAPIUrl(), (AbstractContent)RobustResty.form(data));
            String scope = (String)xml.get("/reply/widgets/@scope", String.class);
            if (scope.length() > 0 && Config.getConfig().isDebugMode()) {
                System.out.println("Scope for Widget API reply: " + scope);
            }
            NodeList nodes = (NodeList)xml.get("/reply/widgets/widget", NodeList.class);
            List<Widget> widgets = Widgets.parseWidgetXML(nodes);
            props.put("widgets", widgets);
            if (root.getName().length() > 0 && widgets.size() > 0 && widgets.get(0).getActive() != null) {
                props.save(true);
            }
            return widgets;
        }

        @Override
        protected void done() {
            JWidgetSettingsPanel.this.context.getFrame().progressSpinner.workDone();
            JWidgetSettingsPanel.this.spinner.workDone();
            JWidgetSettingsPanel.this.context.getFrame().statusBar.popText(Msg.get("ui.fetchingWidgetStatus"));
            try {
                JLabel text;
                JPanel content;
                JWidgetSettingsPanel.this.removeAll();
                if (!SignInManager.getInstance().isSignedIn()) {
                    content = new JPanel();
                    text = new JLabel(Msg.get("ui.widgetsDisabledNotSignedIn"));
                    content.add(text);
                    content.add(new JButton(JWidgetSettingsPanel.this.context.getFrame().actions.signInAction));
                    JWarningPanel wp = new JWarningPanel(content);
                    JWidgetSettingsPanel.this.add("p hfill", wp);
                }
                if (!JWidgetSettingsPanel.this.context.getFrame().settingsWindow.widgetInjection.isSelected()) {
                    content = new JPanel();
                    text = new JLabel(Msg.get("ui.widgetSupportDisabled"));
                    content.add(text);
                    PropertyChangeListener enabledListener = pce -> this.enableWidgetSupportAction.setEnabled(JWidgetSettingsPanel.this.context.getFrame().settingsWindow.widgetInjection.isEnabled());
                    JWidgetSettingsPanel.this.context.getFrame().settingsWindow.widgetInjection.addPropertyChangeListener(enabledListener);
                    enabledListener.propertyChange(null);
                    content.add(new JButton(this.enableWidgetSupportAction));
                    JWarningPanel wp = new JWarningPanel(content);
                    JWidgetSettingsPanel.this.add("p hfill", wp);
                }
                try {
                    JWidgetSettingsPanel.this.widgets = (List)this.get();
                }
                catch (ExecutionException ex) {
                    Debug.logErr("Caught exception in reply from Widget API: " + ex.getCause().toString());
                    AlbumObject root = JWidgetSettingsPanel.this.context.getExplorer().getRootFolder();
                    AlbumObjectProperties props = root.getProperties();
                    List widgets = (List)props.get("widgets");
                    if (widgets == null || widgets.get(0) == null) {
                        throw ex;
                    }
                    JWidgetSettingsPanel.this.widgets = widgets;
                }
                Box widgetList = new Box(1);
                boolean first = true;
                for (Widget w : JWidgetSettingsPanel.this.widgets) {
                    if (!first) {
                        widgetList.add(JAlbumBorders.createSeparator());
                    }
                    widgetList.add(new JWidgetPanel(w));
                    first = false;
                }
                ControlPanel selectWidgetsPanel = new ControlPanel(Msg.get("ui.selectWidgets"));
                selectWidgetsPanel.setLayout(new BorderLayout());
                selectWidgetsPanel.add(widgetList);
                JWidgetSettingsPanel.this.add("br hfill", selectWidgetsPanel);
                SignInManager mgr = SignInManager.getInstance();
                JWidgetSettingsPanel.this.saveAsDefaultAction.setEnabled(mgr.isSignedIn() && JWidgetSettingsPanel.this.context.getFrame().settingsWindow.widgetInjection.isSelected());
                JWidgetSettingsPanel.this.add("p", new JLinkLabel(JAlbumSite.getInstance().getWidgetsUrl(), Msg.get("ui.moreAboutWidgets")));
                JWidgetSettingsPanel.this.add("hfill", Box.createHorizontalGlue());
                JWidgetSettingsPanel.this.add(new JButton(JWidgetSettingsPanel.this.saveAsDefaultAction));
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            catch (ExecutionException ex) {
                if (ex.getCause() instanceof IOException) {
                    JWidgetSettingsPanel.this.add("p hfill", new JWarningPanel(new JLabel(Msg.get("ui.fetchingWidgetStatusError") + ": " + ex.getCause().toString())));
                }
                Debug.showErrorDialog(JWidgetSettingsPanel.this.context.getFrame(), ex.getCause());
            }
            JWidgetSettingsPanel.this.validate();
            JWidgetSettingsPanel.this.repaint();
        }
    }

    private class JWidgetPanel
    extends JPanel {
        private Widget widget;
        JLabel name;
        JLabel description;
        JCheckBox active;

        public JWidgetPanel(Widget w) {
            super(new BorderLayout(12, 12));
            this.widget = w;
            this.setOpaque(false);
            try {
                this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                this.name = new JLabel(w.getName());
                this.name.setIcon(new ImageIcon(new URL(w.getIcon())));
                Font f = this.name.getFont();
                this.name.setFont(f.deriveFont(1, f.getSize() + 3));
                this.description = new JLabel(w.getDescription());
                this.add((Component)this.name, "Before");
                this.add((Component)this.description, "Last");
                if (w.getActive() != null) {
                    this.active = new JCheckBox();
                    this.active.setSelected(w.getActive());
                    this.active.addActionListener(e -> {
                        this.widget.setActive(this.active.isSelected());
                        AlbumObject root = this$0.context.getExplorer().getRootFolder();
                        AlbumObjectProperties props = root.getProperties();
                        props.put("widgets", this$0.widgets);
                        props.put("widgetsLocalChange", new Date());
                        if (root.getName().length() > 0) {
                            try {
                                props.store(true);
                            }
                            catch (IOException ex) {
                                Debug.showFriendlyErrorDialog(JWidgetSettingsPanel.this, ex);
                            }
                        }
                        if (props.containsKey("albumURL") && root.getName().length() > 0) {
                            new UpdateStatusWorker(root, this.widget).execute();
                        } else {
                            JWidgetSettingsPanel.this.showLocalChangeHint();
                        }
                    });
                    this.add((Component)this.active, "After");
                }
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    class UpdateStatusWorker
    extends SwingWorker<List<Widget>, Object> {
        private AlbumObjectProperties props;
        private List<Widget> widgets;

        public UpdateStatusWorker(AlbumObject albumRoot, List<Widget> widgets) {
            this.init(albumRoot, widgets);
        }

        public UpdateStatusWorker(AlbumObject albumRoot, Widget widget) {
            this.widgets = new ArrayList<Widget>();
            this.widgets.add(widget);
            this.init(albumRoot, this.widgets);
        }

        private void init(AlbumObject albumRoot, List<Widget> widgets) {
            if (albumRoot != null) {
                this.props = albumRoot.getProperties();
            }
            this.widgets = widgets;
        }

        @Override
        protected List<Widget> doInBackground() throws Exception {
            JWidgetSettingsPanel.this.context.getFrame().progressSpinner.workStarted();
            JWidgetSettingsPanel.this.context.getFrame().statusBar.pushText(Msg.get("ui.updating"));
            RobustResty r = new RobustResty();
            HashMap<Object, String> data = new HashMap<Object, String>();
            SignInManager mgr = SignInManager.getInstance();
            if (mgr.isSignedIn()) {
                data.put("cid", AccountManager.getCid(mgr.getUserName(), mgr.getPassword()));
            }
            if (this.props != null && this.props.containsKey("albumURL")) {
                data.put("albumUrl", Notifier.urlEncode((String)this.props.get("albumURL")));
            }
            for (Widget widget : this.widgets) {
                data.put("widget." + widget.getId(), Boolean.toString(widget.getActive()));
            }
            data.put("lang", Config.getConfig().getInterpretedLanguage());
            XMLResource xml = r.xml(JAlbumSite.getInstance().getWidgetsAPIUrl(), (AbstractContent)RobustResty.form(data));
            String errorCode = (String)xml.get("/reply/errorCode", String.class);
            if (errorCode.length() > 0) {
                Debug.logErr("Caught exception in reply from Widget API: " + errorCode);
                if (this.props != null) {
                    JWidgetSettingsPanel.this.showLocalChangeHint();
                }
            } else if (this.props != null) {
                this.props.remove("widgetsLocalChange");
                this.props.save(true);
                JWidgetSettingsPanel.this.showPublicChangeHint((String)this.props.get("albumURL"));
            }
            NodeList nodes = (NodeList)xml.get("/reply/widgets/widget", NodeList.class);
            return Widgets.parseWidgetXML(nodes);
        }

        @Override
        protected void done() {
            JWidgetSettingsPanel.this.context.getFrame().progressSpinner.workDone();
            JWidgetSettingsPanel.this.context.getFrame().statusBar.popText(Msg.get("ui.updating"));
            try {
                this.get();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            catch (ExecutionException ex) {
                Debug.showErrorDialog(JWidgetSettingsPanel.this.context.getFrame(), ex.getCause());
            }
        }
    }
}

