/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Container;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.JComponentHolder;

public class JWebServerSettingsDialog
extends JDialog
implements JComponentHolder {
    JLabel portLabel = new JLabel(Msg.get("share.port"));
    JTextField port = new JSmartTextField(5);
    JLabel hostNameLabel = new JLabel(Msg.get("share.hostName"));
    JTextField hostName = new JSmartTextField(15);
    JCheckBox autoStart = new JCheckBox(Msg.get("share.autoStart"));
    JCheckBox doPortMapping = new JCheckBox(Msg.get("share.doPortMapping"));
    ControlPanel logging = new ControlPanel(Msg.get("share.loggingBorder"));
    ButtonGroup logType = new ButtonGroup();
    JRadioButton noLogging = new JRadioButton(Msg.get("share.noLogging"));
    JRadioButton consoleLogging = new JRadioButton(Msg.get("share.consoleLogging"));
    JRadioButton fileLogging = new JRadioButton(Msg.get("share.fileLogging"));
    ActionListener logTypeListener;
    JLabel logFormatStringLabel = new JLabel(Msg.get("share.logDateFormat"));
    JTextField logFormatString = new JSmartTextField();
    JLabel logFileNameLabel = new JLabel(Msg.get("share.logFileName"));
    JTextField logFileName = new JSmartTextField();
    JButton okButton = new JButton(Msg.get("ok"));
    JButton cancelButton = new JButton(Msg.get("cancel"));
    private boolean okPressed;

    public JWebServerSettingsDialog(Frame p0, boolean p1) throws HeadlessException {
        super(p0, p1);
        try {
            this.jbInit();
            this.setLocationRelativeTo(p0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    private void jbInit() throws Exception {
        this.setTitle(Msg.get("share.settingsTitle"));
        this.noLogging.setActionCommand("no");
        this.consoleLogging.setActionCommand("console");
        this.fileLogging.setActionCommand("file");
        this.logType.add(this.noLogging);
        this.logType.add(this.consoleLogging);
        this.logType.add(this.fileLogging);
        this.logTypeListener = e -> {
            this.logFormatString.setEnabled(!this.noLogging.isSelected());
            this.logFormatStringLabel.setEnabled(!this.noLogging.isSelected());
            this.logFileName.setEnabled(this.fileLogging.isSelected());
            this.logFileNameLabel.setEnabled(this.fileLogging.isSelected());
        };
        this.noLogging.addActionListener(this.logTypeListener);
        this.consoleLogging.addActionListener(this.logTypeListener);
        this.fileLogging.addActionListener(this.logTypeListener);
        this.hostNameLabel.setToolTipText(Msg.get("share.hostNameToolTip"));
        this.hostName.setToolTipText(Msg.get("share.hostNameToolTip"));
        this.okButton.addActionListener(e -> {
            this.okPressed = true;
            this.setVisible(false);
        });
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(e -> this.setVisible(false));
        Container c = this.getContentPane();
        c.setLayout(new RiverLayout());
        c.add("br hfill", this.portLabel);
        c.add("tab", this.port);
        c.add("br hill", this.hostNameLabel);
        c.add("tab", this.hostName);
        c.add("br hfill", this.autoStart);
        c.add("br hfill", this.doPortMapping);
        this.logging.add("hfill", this.noLogging);
        this.logging.add("br hfill", this.consoleLogging);
        this.logging.add("br hfill", this.fileLogging);
        this.logging.add("p", this.logFormatStringLabel);
        this.logging.add("tab hfill", this.logFormatString);
        this.logging.add("br", this.logFileNameLabel);
        this.logging.add("tab hfill", this.logFileName);
        c.add("p hfill", this.logging);
        c.add("p center", this.okButton);
        c.add(this.cancelButton);
        this.pack();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.logTypeListener.actionPerformed(null);
            this.okPressed = false;
        }
        super.setVisible(visible);
    }
}

