/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JBackgroundPanel;
import se.datadosen.component.JFileSelector;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.JSmartTextField;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.JAlbumBorders;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.WebLocation;
import se.datadosen.util.Debug;

public class JWebLocationEditPanel
extends ControlPanel {
    SwingWorker updateTargetWorker;
    SwingWorker updateImageWorker;
    private BufferedImage image;
    private AlbumObject currentFolder;
    private int insertIndex;
    private PropertyChangeListener changeListener;
    private Action updateTargetURIAction = new AbstractAction(Msg.get("edit.update")){

        @Override
        public void actionPerformed(final ActionEvent e) {
            if (JWebLocationEditPanel.this.updateTargetWorker != null && !JWebLocationEditPanel.this.updateTargetWorker.isDone()) {
                JWebLocationEditPanel.this.updateTargetWorker.cancel(true);
            } else {
                JWebLocationEditPanel.this.updateTargetWorker = new SwingWorker<WebLocation, Void>(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    protected WebLocation doInBackground() throws Exception {
                        this.this$1.JWebLocationEditPanel.this.targetURISpinner.workStarted();
                        this.this$1.putValue("Name", Msg.get("cancel"));
                        String old = this.this$1.JWebLocationEditPanel.this.targetURI;
                        URI u = this.this$1.JWebLocationEditPanel.this.getURI(this.this$1.JWebLocationEditPanel.this.targetURIField);
                        WebLocation wl = new WebLocation(u);
                        String resolved = wl.assertResolved().toASCIIString();
                        this.this$1.JWebLocationEditPanel.this.setTargetURI(resolved);
                        if (this.this$1.JWebLocationEditPanel.this.changeListener != null && !old.equals(resolved)) {
                            this.this$1.JWebLocationEditPanel.this.changeListener.propertyChange(new PropertyChangeEvent(this.this$1.JWebLocationEditPanel.this, "targetURL", old, resolved));
                        }
                        if (u.isAbsolute()) {
                            this.this$1.JWebLocationEditPanel.this.image = wl.findRepresentingImage();
                        }
                        return wl;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.this$1.JWebLocationEditPanel.this.targetURISpinner.workDone();
                            this.this$1.putValue("Name", Msg.get("edit.update"));
                            WebLocation wl = (WebLocation)this.get();
                            this.this$1.JWebLocationEditPanel.this.title = wl.getTitle();
                            this.this$1.JWebLocationEditPanel.this.description = wl.getDescription();
                            if (wl.getImageUrl() != null && this.this$1.JWebLocationEditPanel.this.imageURLField.getText().length() == 0) {
                                this.this$1.JWebLocationEditPanel.this.imageURLField.setText(wl.getImageUrl().toExternalForm());
                                this.this$1.JWebLocationEditPanel.this.updateImageURLAction.actionPerformed(e);
                            }
                        }
                        catch (InterruptedException wl) {
                        }
                        catch (ExecutionException ex) {
                            if (this.this$1.JWebLocationEditPanel.this.changeListener != null) {
                                this.this$1.JWebLocationEditPanel.this.changeListener.propertyChange(new PropertyChangeEvent(this.this$1.JWebLocationEditPanel.this, "targetURL", null, null));
                            }
                            Debug.showErrorDialog(this.this$1.JWebLocationEditPanel.this, ex.getCause());
                        }
                    }
                };
                JWebLocationEditPanel.this.updateTargetWorker.execute();
            }
        }
    };
    private Action updateImageURLAction = new AbstractAction(Msg.get("edit.update")){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JWebLocationEditPanel.this.updateImageWorker != null && !JWebLocationEditPanel.this.updateImageWorker.isDone()) {
                JWebLocationEditPanel.this.updateImageWorker.cancel(true);
            } else {
                JWebLocationEditPanel.this.updateImageWorker = new SwingWorker<BufferedImage, Void>(){

                    @Override
                    protected BufferedImage doInBackground() throws Exception {
                        JWebLocationEditPanel.this.imageURLSpinner.workStarted();
                        this.putValue("Name", Msg.get("cancel"));
                        JWebLocationEditPanel.this.image = null;
                        JWebLocationEditPanel.this.image = WebLocation.readImage(JWebLocationEditPanel.this.toURL(JWebLocationEditPanel.this.imageURLField.getText()), JWebLocationEditPanel.this.getURL());
                        return JWebLocationEditPanel.this.image;
                    }

                    @Override
                    protected void done() {
                        JWebLocationEditPanel.this.imageURLSpinner.workDone();
                        this.putValue("Name", Msg.get("edit.update"));
                        JWebLocationEditPanel.this.imagePanel.setBackgroundImage(JWebLocationEditPanel.this.image);
                        if (JWebLocationEditPanel.this.changeListener != null) {
                            JWebLocationEditPanel.this.changeListener.propertyChange(new PropertyChangeEvent(JWebLocationEditPanel.this, "image", null, null));
                        }
                        String oldImageURI = JWebLocationEditPanel.this.imageURL;
                        JWebLocationEditPanel.this.imageURL = JWebLocationEditPanel.this.imageURLField.getText();
                        if (JWebLocationEditPanel.this.changeListener != null && !oldImageURI.equals(JWebLocationEditPanel.this.imageURL)) {
                            JWebLocationEditPanel.this.changeListener.propertyChange(new PropertyChangeEvent(JWebLocationEditPanel.this, "imageURI", oldImageURI, JWebLocationEditPanel.this.imageURL));
                        }
                    }
                };
                JWebLocationEditPanel.this.updateImageWorker.execute();
            }
        }
    };
    private String targetURI = "";
    private String imageURL = "";
    private String title = "";
    private String description = "";
    private JSmartTextField targetURIField = new JSmartTextField(20){
        {
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (this.getText().length() == 0) {
                        this.setText("http://");
                        this.selectAll();
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                }
            });
        }
    };
    private JSmartTextField imageURLField = new JSmartTextField(20);
    private JFileSelector imageFileSelector = new JFileSelector(this.imageURLField);
    private JButton updateTargetURIButton = new JButton(this.updateTargetURIAction);
    private JButton imageURLBUtton = new JButton(this.updateImageURLAction);
    private JProgressSpinner targetURISpinner = new JProgressSpinner();
    private JProgressSpinner imageURLSpinner = new JProgressSpinner();
    private JBackgroundPanel imagePanel = new JBackgroundPanel();

    private URL toURL(String uri) throws MalformedURLException {
        URI rel = this.currentFolder.getFile().toURI();
        return rel.resolve(uri).toURL();
    }

    public String getTargetURI() {
        return this.targetURI;
    }

    public void setTargetURI(String targetURI) {
        this.targetURI = targetURI;
        this.targetURIField.setText(targetURI);
    }

    public String getImageURL() {
        return this.imageURL;
    }

    public void setImageURL(String imageURL) {
        this.imageURL = imageURL;
        this.imageURLField.setText(imageURL);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.imagePanel.setBackgroundImage(image);
    }

    public void onChange(PropertyChangeListener listener) {
        this.changeListener = listener;
    }

    private URL getURL() {
        try {
            URI u = this.getURI(this.targetURIField);
            return u.isAbsolute() ? u.toURL() : null;
        }
        catch (MalformedURLException | URISyntaxException ex) {
            return null;
        }
    }

    private URI getURI(JTextField tf) throws URISyntaxException {
        String text = tf.getText();
        URI uri = new URI(text.replace(" ", "%20"));
        return uri;
    }

    private void init() {
        Authenticator.setDefault(new MyAuthenticator());
        this.add(new JLabel(Msg.get("ui.targetURL")));
        this.add("tab hfill", this.targetURIField);
        this.add(this.updateTargetURIButton);
        this.add(this.targetURISpinner);
        this.add("br", new JLabel(Msg.get("ui.imageURL")));
        this.add("tab hfill", this.imageURLField);
        this.add(this.imageFileSelector);
        this.add(this.imageURLBUtton);
        this.add(this.imageURLSpinner);
        this.add("p hfill vfill", this.imagePanel);
        this.imageFileSelector.setURLFormat(true);
        this.imageFileSelector.setCurrentDirectory(this.currentFolder.getFile());
        this.imageFileSelector.addActionListener(ae -> this.updateImageURLAction.actionPerformed(null));
        this.imagePanel.setBorder(JAlbumBorders.createImageBorder());
        this.imagePanel.setPreferredSize(new Dimension(500, 350));
        this.validate();
        this.targetURISpinner.setHidden(true);
        this.imageURLSpinner.setHidden(true);
        this.targetURIField.addActionListener(this.updateTargetURIAction);
        this.imageURLField.addActionListener(this.updateImageURLAction);
    }

    public JWebLocationEditPanel(AlbumObject currentFolder, int insertIndex) {
        this.currentFolder = currentFolder;
        this.insertIndex = insertIndex;
        this.init();
    }

    boolean isValidWebLocation() {
        return this.targetURIField.getText().trim().length() > 0 && this.image != null;
    }

    public static void openDialog(Window parent, final AlbumObject currentFolder, final int insertIndex) {
        final JSmartDialog dialog = new JSmartDialog(parent, Msg.get("edit.webLocation"), Dialog.ModalityType.DOCUMENT_MODAL);
        final JWebLocationEditPanel panel = new JWebLocationEditPanel(currentFolder, insertIndex);
        dialog.add(panel);
        dialog.pack();
        AbstractAction cancelAction = new AbstractAction(Msg.get("cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Authenticator.setDefault(null);
                dialog.setVisible(false);
            }
        };
        AbstractAction okAction = new AbstractAction(Msg.get("ok")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Authenticator.setDefault(null);
                dialog.setVisible(false);
                try {
                    WebLocation wl = new WebLocation(panel.targetURIField.getText());
                    File webLocFile = new File(currentFolder.getFile(), wl.getFileName());
                    wl.writeToFile(webLocFile);
                    AlbumObject ao = currentFolder.getFactory().createInstance(webLocFile, currentFolder);
                    currentFolder.add(insertIndex, ao);
                    ao.setTitle(panel.title);
                    ao.setComment(panel.description);
                    if (panel.getImage() != null) {
                        AlbumObjectProperties props = ao.getProperties();
                        props.put("imageURI", panel.imageURLField.getText());
                        props.save();
                        ao.setRepresentingIcon(panel.getImage(), true);
                    }
                    currentFolder.fireModelChanged();
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(JWebLocationEditPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(JWebLocationEditPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        okAction.setEnabled(false);
        panel.onChange(e -> okAction.setEnabled(panel.isValidWebLocation()));
        dialog.registerActions(okAction, cancelAction);
        dialog.getRootPane().setDefaultButton(null);
        dialog.setVisible(true);
        panel.targetURIField.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                panel.targetURIField.requestFocusInWindow();
            }
        });
    }

    private class MyAuthenticator
    extends Authenticator {
        private MyAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            ControlPanel panel = new ControlPanel();
            JTextField userName = new JTextField(20);
            JPasswordField password = new JPasswordField(20);
            panel.add(new JLabel(this.getRequestingPrompt()));
            panel.add("br", new JLabel("Username:"));
            panel.add("tab", userName);
            panel.add("br", new JLabel("Password:"));
            panel.add("tab", password);
            int anwswer = JOptionPane.showConfirmDialog(JWebLocationEditPanel.this, panel, "Authentication Required", 2, 3);
            if (anwswer != 0) {
                return null;
            }
            return new PasswordAuthentication(userName.getText(), password.getPassword());
        }
    }
}

