/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.table.TableColumnModel;
import se.datadosen.component.ComponentUtilities;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JCollapsiblePanel;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JParametersTable;
import se.datadosen.component.JSilentLabel;
import se.datadosen.component.StateMonitor;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JWarningPanel;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.VideoProcessor;
import se.datadosen.jalbum.VideoResolution;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

public class JVideoSettingsPanel
extends ControlPanel
implements PropertyChangeListener {
    JAlbumContext context;
    @Text(value="ui.videoSupportDisabledWarning")
    JLabel videoSupportDisabledWarningLabel = new JLabel();
    JWarningPanel warningPanel = new JWarningPanel(this.videoSupportDisabledWarningLabel);
    @Text(value="ui.quality")
    JLabel videoQualityLabel = new JLabel();
    JSlider videoQuality = new JSlider(0, 100, 75);
    @ToolTipText(value="ui.qualitySizeWarning")
    JLabel qualityPercentWarning = new JSilentLabel(Icons.small("warning-1"));
    @Text(value="ui.resolution")
    JLabel videoResolutionLabel = new JLabel();
    JComboBox videoResolution = new JComboBox<VideoResolution>(VideoResolution.values());
    @Text(value="ui.low")
    JLabel lowQuality = new JLabel();
    @Text(value="ui.high")
    JLabel highQuality = new JLabel();
    @Text(value="ui.customSettings")
    JCheckBox useCustomVideoSettings = new JCheckBox();
    @Text(value="ui.advancedPanel")
    JCollapsiblePanel videosAdvancedPanel = new JCollapsiblePanel(new BorderLayout());
    JParametersTable videoParametersTable = new JParametersTable();
    JLinkLabel ffmpegDocumentationLink = new JLinkLabel("http://ffmpeg.org/ffmpeg.html#Options", Msg.get("ui.ffmpegDocumentation"));
    JLinkLabel ffmpegHardwareAccelerationLink = new JLinkLabel("https://trac.ffmpeg.org/wiki/HWAccelIntro", Msg.get("ui.ffmpegHardwareAcceleratedProcessing"));

    public JVideoSettingsPanel(JAlbumContext context) {
        this.context = context;
        this.init();
    }

    private void init() {
        Msg.maintainTranslated(this);
        this.videoQuality.setMajorTickSpacing(25);
        this.videoQuality.setMinorTickSpacing(5);
        this.videoQuality.setPaintTicks(true);
        this.videoQuality.setSnapToTicks(true);
        Hashtable<Integer, JLabel> table = new Hashtable<Integer, JLabel>();
        ((Dictionary)table).put(0, this.lowQuality);
        ((Dictionary)table).put(100, this.highQuality);
        this.videoQuality.setLabelTable(table);
        this.videoQuality.setPaintLabels(true);
        this.videoParametersTable.setHeaderNames(Msg.get("ui.userVariablesNameColumn"), Msg.get("ui.userVariablesValueColumn"));
        TableColumnModel cm = this.videoParametersTable.getColumnModel();
        cm.getColumn(0).setMinWidth(60);
        cm.getColumn(0).setPreferredWidth(100);
        cm.getColumn(0).setMaxWidth(100);
        StateMonitor.monitoring(this.useCustomVideoSettings).onChange(e -> {
            if (this.useCustomVideoSettings.isSelected()) {
                this.videosAdvancedPanel.setExpanded(true);
            }
        });
        ComponentUtilities.whenSelectedEnable((AbstractButton)this.useCustomVideoSettings, (JComponent)this.videoParametersTable);
        new StateMonitor(){

            @Override
            public void onChange() {
                if (!BeanBinder.isSynchingUI()) {
                    VideoProcessor processor = JVideoSettingsPanel.this.context.getEngine().getVideoProcessor();
                    processor.setVideoResolution((VideoResolution)((Object)JVideoSettingsPanel.this.videoResolution.getSelectedItem()));
                    if (!JVideoSettingsPanel.this.useCustomVideoSettings.isSelected()) {
                        processor.setVideoParameters(null);
                    }
                    JVideoSettingsPanel.this.videoParametersTable.setData(processor.getVideoParameters());
                }
            }
        }.add(this.videoResolution).add(this.useCustomVideoSettings);
        new StateMonitor(){

            @Override
            public void onChange() {
                JVideoSettingsPanel.this.qualityPercentWarning.setVisible(JVideoSettingsPanel.this.videoQuality.getValue() > 75);
            }
        }.add(this.videoQuality).done();
        this.add("br hfill", this.warningPanel);
        this.add("br label", this.videoQualityLabel);
        this.add("tab", this.videoQuality);
        this.add(this.qualityPercentWarning);
        this.add("br label", this.videoResolutionLabel);
        this.add("tab", this.videoResolution);
        this.add("p", this.useCustomVideoSettings);
        this.videosAdvancedPanel.add(new JScrollPane(this.videoParametersTable));
        JPanel linkPanel = new JPanel();
        linkPanel.add(this.ffmpegDocumentationLink);
        linkPanel.add(new JLabel("|"));
        linkPanel.add(this.ffmpegHardwareAccelerationLink);
        this.videosAdvancedPanel.add((Component)linkPanel, "South");
        this.add("br hfill vfill", this.videosAdvancedPanel);
        Config.getConfig().addPropertyChangeListener(this);
        this.propertyChange(null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean videoSupportActive = Config.getConfig().isVideoSupported();
        this.warningPanel.setVisible(!videoSupportActive);
        this.videoQualityLabel.setVisible(videoSupportActive);
        this.videoQuality.setVisible(videoSupportActive);
        this.videoResolutionLabel.setVisible(videoSupportActive);
        this.videoResolution.setVisible(videoSupportActive);
        this.useCustomVideoSettings.setVisible(videoSupportActive);
        this.videosAdvancedPanel.setVisible(videoSupportActive);
        this.validate();
    }
}

