/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.DataRate;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.TaskbarProgress;
import se.datadosen.jalbum.event.ByteProgressEvent;
import se.datadosen.jalbum.event.FileProgressEvent;
import se.datadosen.jalbum.event.ProgressEvent;
import se.datadosen.jalbum.event.TransferListener;
import se.datadosen.util.DataSizeFormatter;
import se.datadosen.util.Stopwatch;

public class JTransferProgressDialog
extends JDialog
implements TransferListener {
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel mainPanel = new JPanel(){

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            ProgressEvent le = JTransferProgressDialog.this.lastEvent;
            JTransferProgressDialog.this.lastEvent = null;
            if (le != null) {
                JTransferProgressDialog.this.doUpdateProgressBar(le);
            }
        }
    };
    JPanel ButtonPanel = new JPanel();
    JButton abortButton = new JButton();
    FlowLayout flowLayout1 = new FlowLayout();
    JLabel directory = new JLabel();
    JProgressSpinner progressSpinner = new JProgressSpinner(18, true);
    JProgressBar progressBar = new JProgressBar();
    JLabel file = new JLabel();
    JLabel timeLeft = new JLabel();
    Stopwatch timer = new Stopwatch();
    boolean abort = false;
    String lastMsg = "";
    private Runnable onAbort;
    private Type type = Type.NORMAL;
    private DataRate rate = new DataRate();
    private DataRate timeLeftEstimator = new DataRate(10);
    private ProgressEvent lastEvent;
    long lastUpdateTime;

    public Type getDialogType() {
        return this.type;
    }

    public void setDialogType(Type type) {
        this.type = type;
    }

    public JTransferProgressDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JTransferProgressDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void onAbort(Runnable r) {
        this.onAbort = r;
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.abortButton.setText(Msg.get("abort"));
        this.abortButton.addActionListener(this::abortButton_actionPerformed);
        this.ButtonPanel.setLayout(this.flowLayout1);
        this.mainPanel.setLayout(new RiverLayout());
        this.directory.setText(Msg.get("upload.processingInfo"));
        this.file.setText(Msg.get("upload.fileLabel"));
        this.timeLeft.setText(Msg.get("upload.estimatedTimeLeftInfo"));
        this.progressBar.setString(Msg.get("upload.countLabel"));
        this.panel1.setPreferredSize(new Dimension(300, 151));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JTransferProgressDialog.this.abort = true;
                JTransferProgressDialog.this.setVisible(false);
                JTransferProgressDialog.this.dispose();
                if (JTransferProgressDialog.this.onAbort != null) {
                    JTransferProgressDialog.this.onAbort.run();
                }
            }
        });
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.mainPanel, "Center");
        this.mainPanel.add("br", this.directory);
        this.mainPanel.add("br", this.file);
        this.mainPanel.add("br hfill", this.progressBar);
        this.mainPanel.add("br", this.timeLeft);
        this.mainPanel.add(this.progressSpinner);
        this.panel1.add((Component)this.ButtonPanel, "South");
        this.ButtonPanel.add((Component)this.abortButton, null);
        this.progressSpinner.setDelay(100);
    }

    @Override
    public void fileProcessingProgress(ProgressEvent e) {
        if (this.type == Type.NORMAL) {
            this.updateProgressBar(e);
        }
    }

    public void updateProgressBar(ProgressEvent e) {
        if (!this.isVisible() && !this.abort) {
            new Thread(){
                {
                    this.setDaemon(true);
                }

                @Override
                public void run() {
                    JTransferProgressDialog.this.setVisible(true);
                }
            }.start();
        }
        if (this.abort) {
            e.abortProcessing();
        }
        this.lastEvent = e;
    }

    private void doUpdateProgressBar(ProgressEvent e) {
        this.directory.setText(Msg.get("upload.processingInfo") + " " + e.subMessage);
        this.file.setText(e.msg);
        this.lastMsg = e.msg;
        this.progressBar.setIndeterminate(e.isIndeterminate());
        if (!e.isIndeterminate()) {
            this.progressBar.setValue((int)(e.processed / 100L));
            this.progressBar.setMaximum((int)(e.total / 100L));
            if (e.total > 0L) {
                TaskbarProgress.setProgress(this, (int)(100L * e.processed / e.total));
            }
            if (e instanceof ByteProgressEvent) {
                this.rate.update(e.processed);
                this.timeLeftEstimator.update(e.processed);
                this.progressBar.setString(DataSizeFormatter.formatXofY("progress.processingInfo2", e.processed, e.total) + "  (" + String.valueOf(this.rate) + ")");
            } else if (e instanceof FileProgressEvent) {
                this.progressBar.setString(Msg.get("upload.processingInfo2", e.processed, e.total));
            }
            long elapsed = this.timer.getMillis();
            if (e.processed > 0L && e.processed <= e.total) {
                this.timeLeft.setText(Msg.get("upload.estimatedTimeLeftInfo") + " " + this.timeLeftEstimator.estTimeLeft(e.total - e.processed));
            }
        }
    }

    @Override
    public void progress(ProgressEvent e) {
        this.updateProgressBar(e);
    }

    @Override
    public void fileProcessingStarted(ProgressEvent e) {
        this.updateProgressBar(e);
    }

    @Override
    public void fileProcessingFinished(ProgressEvent e) {
        this.updateProgressBar(e);
    }

    @Override
    public void errorOccured(Throwable t, File f) {
    }

    public void bytesTransferred(long count) {
        if (this.type == Type.NORMAL) {
            this.file.setText(this.lastMsg + " " + count + " " + Msg.get("upload.bytesInfo"));
        }
    }

    public void byteRead(int bytes) {
    }

    void abortButton_actionPerformed(ActionEvent e) {
        this.abort = true;
        this.setVisible(false);
        this.dispose();
        if (this.onAbort != null) {
            this.onAbort.run();
        }
    }

    public void reset() {
        this.file.setText(" ");
        this.directory.setText(" ");
        this.progressBar.setString(" ");
        this.timeLeft.setText(" ");
        this.progressBar.setValue(0);
        TaskbarProgress.setProgress(this, 0);
        this.timer.reset();
        this.timer.start();
    }

    @Override
    public void setVisible(boolean show) {
        this.progressSpinner.setVisible(show);
        if (show) {
            this.reset();
            Dimension parentSize = this.getOwner().getSize();
            Dimension mySize = this.getSize();
            Point loc = this.getOwner().getLocation();
            this.setLocation(loc.x + (parentSize.width - mySize.width) / 2, loc.y + (parentSize.height - mySize.height) / 2);
            if (this.type == Type.NORMAL) {
                this.directory.setText(Msg.get("upload.comparingFilesInfo"));
            }
            this.progressBar.setStringPainted(true);
            this.abort = false;
        } else {
            TaskbarProgress.setProgress(this, 0);
        }
        super.setVisible(show);
    }

    void this_windowClosing(WindowEvent e) {
        this.abort = true;
    }

    static enum Type {
        NORMAL,
        HIRES;

    }
}

