/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.datadosen.component.JPlainButton;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.IgnoreOrdering;
import se.datadosen.jalbum.JAlbumColor;

public class JThumbnailChooser
extends JComponent {
    public static final int IMAGE_SIZE = 160;
    public static final int BORDER_SIZE = 10;
    private static final Dimension imageBounds = new Dimension(160, 160);
    private AlbumObject root;
    PropertyChangeListener representingAlbumObjectListener;
    JLabel imageLabel = new JLabel();
    Action previousAction = new AbstractAction("", Icons.tiny("arrow-left")){

        @Override
        public void actionPerformed(ActionEvent e) {
            JThumbnailChooser.this.root.getChildren();
            AlbumObject rep = JThumbnailChooser.this.findClosestAlbumObject(JThumbnailChooser.this.root.getRepresentingAlbumObject(true), true);
            if (rep != null) {
                JThumbnailChooser.this.root.setRepresentingAlbumObject(rep);
                JThumbnailChooser.this.nextAction.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    };
    Action nextAction = new AbstractAction("", Icons.tiny("arrow-right")){

        @Override
        public void actionPerformed(ActionEvent e) {
            JThumbnailChooser.this.root.getChildren();
            AlbumObject rep = JThumbnailChooser.this.findClosestAlbumObject(JThumbnailChooser.this.root.getRepresentingAlbumObject(true), false);
            if (rep != null) {
                JThumbnailChooser.this.root.setRepresentingAlbumObject(rep);
                JThumbnailChooser.this.previousAction.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    };

    public JThumbnailChooser() {
        this.init();
        this.setAlbumObject(null);
    }

    public JThumbnailChooser(AlbumObject root) {
        this.init();
        this.setAlbumObject(root);
        this.renderImage();
    }

    private AlbumObject findClosestAlbumObject(AlbumObject rep, boolean previous) {
        LinkedList<AlbumObject> list = new LinkedList<AlbumObject>();
        this.buildList(this.root, list);
        AlbumObject last = null;
        boolean returnThis = false;
        for (AlbumObject ao : list) {
            if (returnThis) {
                return ao;
            }
            if (ao == rep) {
                if (previous) {
                    return last;
                }
                returnThis = true;
            }
            last = ao;
        }
        return null;
    }

    private void buildList(AlbumObject folder, List<AlbumObject> list) {
        List<AlbumObject> children = folder.getChildren();
        for (AlbumObject ao : children) {
            if (ao.isFolder()) {
                this.buildList(ao, list);
                continue;
            }
            if (!ao.hasDisplayableImage()) continue;
            list.add(ao);
        }
    }

    public void setAlbumObject(AlbumObject ao) {
        this.root = ao;
        try (IgnoreOrdering _ignore = new IgnoreOrdering(ao);){
            boolean hasChildren = ao != null && ao.getChildren(false) != null;
            this.previousAction.setEnabled(hasChildren);
            this.nextAction.setEnabled(hasChildren);
            if (hasChildren) {
                this.renderImage();
                this.representingAlbumObjectListener = evt -> {
                    this.previousAction.setEnabled(true);
                    this.nextAction.setEnabled(true);
                    this.renderImage();
                };
                this.root.addPropertyChangeListener("representingAlbumObject", this.representingAlbumObjectListener);
                this.root.addPropertyChangeListener("children", this.representingAlbumObjectListener);
            } else {
                this.representingAlbumObjectListener = null;
                this.imageLabel.setIcon(null);
            }
        }
    }

    public AlbumObject getAlbumObject() {
        return this.root;
    }

    private void renderImage() {
        try {
            AlbumObject rep = this.root.getRepresentingAlbumObject(true);
            if (rep != null) {
                this.imageLabel.setIcon(rep.getRepresentingIcon(imageBounds, false));
            } else {
                this.imageLabel.setIcon(null);
            }
        }
        catch (IOException ex) {
            this.imageLabel.setText("Broken");
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.setBackground(JAlbumColor.text);
        this.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.imageLabel.setPreferredSize(new Dimension(160, 160));
        this.imageLabel.setOpaque(true);
        this.imageLabel.setBackground(JAlbumColor.text);
        this.imageLabel.setHorizontalAlignment(0);
        JPanel imagePanel = new JPanel(new BorderLayout());
        imagePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        imagePanel.setBackground(JAlbumColor.text);
        imagePanel.setOpaque(true);
        imagePanel.add((Component)this.imageLabel, "Center");
        this.add((Component)imagePanel, "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBackground(JAlbumColor.text);
        JPlainButton previousButton = new JPlainButton(this.previousAction);
        previousButton.setRealBorder(BorderFactory.createEmptyBorder(6, 6, 6, 20));
        JPlainButton nextButton = new JPlainButton(this.nextAction);
        nextButton.setRealBorder(BorderFactory.createEmptyBorder(6, 20, 6, 6));
        buttonPanel.add((Component)previousButton, "West");
        buttonPanel.add((Component)nextButton, "East");
        this.add((Component)buttonPanel, "South");
    }
}

