/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import se.datadosen.component.JCollapsiblePanel;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SkinManager;
import se.datadosen.jalbum.SkinProperties;
import se.datadosen.jalbum.TextEditor;
import se.datadosen.util.ContextualException;
import se.datadosen.util.Debug;
import se.datadosen.util.VersionNumber;

public class JSkinErrorDialog
extends JSmartDialog {
    private JAlbumContext context;
    JLabel sadFrog = new JLabel(Icons.getIcon("decorations.dorconfused"));
    Throwable theError;
    JPanel contentPanel = new JPanel(new BorderLayout());
    JPanel centerPanel = new JPanel(new RiverLayout());
    JLabel introLabel;
    JLabel whatDoDoLabel = new JLabel(Msg.get("skinError.whatToDo"));
    JCollapsiblePanel errorDetailsPanel = new JCollapsiblePanel(Msg.get("skinError.detailsPanel"), new BorderLayout());
    JTextArea codeArea = null;
    Action copyToClipboardAction = new AbstractAction(Msg.get("ui.copyToClipboard")){

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(JSkinErrorDialog.this.codeArea.getText()), null);
        }
    };
    Action closeAction = new AbstractAction(Msg.get("close")){

        @Override
        public void actionPerformed(ActionEvent e) {
            JSkinErrorDialog.this.setVisible(false);
        }
    };
    Action updateSkinAction = new AbstractAction(Msg.get("skinError.updateSkin1")){

        @Override
        public void actionPerformed(ActionEvent e) {
            JSkinErrorDialog.this.closeAction.actionPerformed(null);
            String skinName = JSkinErrorDialog.this.context.getEngine().getSkin();
            SkinManager sm = new SkinManager();
            try {
                sm.installSkin(skinName, new URL(JAlbumSite.getInstance().getSkinDownloadUrl(skinName)), null);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
    };
    String supportUrl = null;
    Action reportErrorAction = new AbstractAction(Msg.get("skinError.report1")){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JSkinErrorDialog.this.copyToClipboardAction.actionPerformed(null);
                JOptionPane.showMessageDialog(JSkinErrorDialog.this, Msg.get("skinError.reportInfo"), Msg.get("skinError.report1"), 1);
                BrowserLauncher.openURL(JSkinErrorDialog.this.supportUrl);
            }
            catch (IOException ex) {
                Debug.showFriendlyErrorDialog(JSkinErrorDialog.this, ex);
            }
        }
    };
    Action editSkinAction = new AbstractAction(Msg.get("ui.editToolTip")){

        @Override
        public void actionPerformed(ActionEvent e) {
            ContextualException ex;
            File f;
            if (JSkinErrorDialog.this.theError instanceof ContextualException && (f = (ex = (ContextualException)((Object)JSkinErrorDialog.this.theError)).getFile()) != null) {
                JSkinErrorDialog.this.closeAction.actionPerformed(e);
                SwingUtilities.invokeLater(() -> TextEditor.openDocument(f, ex.getLineNumber(), ex.getColumnNumber(), ex.getMessage()));
            }
        }
    };

    public JSkinErrorDialog(JDialog owner, JAlbumContext context, Throwable theError) {
        super(owner, Msg.get("ui.unexpectedErrorOccured"), false);
        this.context = context;
        this.theError = theError;
        this.init();
    }

    public JSkinErrorDialog(JAlbumContext context, Throwable theError) {
        super(context.getFrame(), Msg.get("ui.unexpectedErrorOccured"), false);
        this.context = context;
        this.theError = theError;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.introLabel = new JLabel(Msg.get("skinErrror.intro", this.context.getEngine().getSkin()));
        this.introLabel.setFont(this.introLabel.getFont().deriveFont(1));
        StringWriter sw = new StringWriter();
        PrintWriter err = new PrintWriter(sw);
        String skinName = this.context.getEngine().getSkin();
        err.print("Stack trace for jAlbum " + AlbumBean.getInternalVersion() + " using skin " + skinName);
        try {
            SkinProperties skinProps = this.context.getEngine().getSkinProperties();
            VersionNumber installedSkinVersion = null;
            String iv = skinProps.getProperty("version");
            if (iv != null) {
                installedSkinVersion = new VersionNumber(iv);
                err.print(" " + iv);
            }
            err.println(":\n");
            this.theError.printStackTrace(err);
            err.close();
            this.codeArea = new JSmartTextArea(sw.toString(), 20, 54);
            this.codeArea.setEditable(false);
            this.codeArea.setLineWrap(true);
            this.codeArea.setWrapStyleWord(true);
            this.codeArea.setFont(new Font("Courier new", 0, 12));
            JScrollPane sp = new JScrollPane(this.codeArea);
            this.errorDetailsPanel.add(sp);
            this.errorDetailsPanel.addPropertyChangeListener("expanded", evt -> this.pack());
            this.centerPanel.add("p", this.introLabel);
            this.centerPanel.add("p", this.whatDoDoLabel);
            int choiceCount = 0;
            if (installedSkinVersion != null) {
                try {
                    SkinProperties.RepositoryProperties repProps = skinProps.getRepositoryProperties();
                    if (repProps.getCurrentVersion().compareTo(installedSkinVersion) > 0) {
                        this.centerPanel.add("br", new JLabel("\u2022"));
                        this.centerPanel.add(new JButton(this.updateSkinAction));
                        this.centerPanel.add(new JLabel(Msg.get("skinError.updateSkin2", repProps.getCurrentVersion(), repProps.getFormattedLastUpdated())));
                        ++choiceCount;
                    }
                }
                catch (IOException ex) {
                    System.err.println(ex);
                }
            }
            if (choiceCount == 0) {
                this.supportUrl = skinProps.getProperty("supportForum", skinProps.getProperty("homePage", JAlbumSite.getInstance().getSkinBugReportUrl()));
                if (this.supportUrl != null) {
                    this.centerPanel.add("br", new JLabel("\u2022"));
                    this.centerPanel.add(new JButton(this.reportErrorAction));
                    this.centerPanel.add(new JLabel(Msg.get("skinError.report2")));
                    ++choiceCount;
                }
            }
            if (this.theError instanceof ContextualException) {
                this.centerPanel.add(new JButton(this.editSkinAction));
            }
            if (choiceCount > 0) {
                this.centerPanel.add("br", new JLabel(Msg.get("skinError.or")));
            }
            this.centerPanel.add("br", new JLabel("\u2022"));
            this.centerPanel.add(new JLabel(Msg.get("skinError.tryAnotherSkin")));
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        this.centerPanel.add("p hfill vfill", this.errorDetailsPanel);
        JPanel frogPanel = new JPanel();
        frogPanel.add(this.sadFrog);
        this.contentPanel.add((Component)frogPanel, "Before");
        this.contentPanel.add((Component)this.centerPanel, "Center");
        this.add((Component)this.contentPanel, "Center");
        this.registerActions(this.copyToClipboardAction, this.closeAction);
        this.pack();
    }
}

