/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.InvalidationListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.TableColumnModel;
import net.jalbum.OutputFormat;
import net.jalbum.Variant;
import net.jalbum.browser.Browsers;
import net.jalbum.browser.WebBrowser;
import net.jalbum.component.Group;
import net.jalbum.component.JActionComboBox;
import net.jalbum.component.RememberedName;
import se.datadosen.component.ComponentUtilities;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.DimensionFormatter;
import se.datadosen.component.Hour;
import se.datadosen.component.JBackgroundTextField;
import se.datadosen.component.JColorSelector;
import se.datadosen.component.JDatePatternComboBox;
import se.datadosen.component.JIconTextField;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JMapTable;
import se.datadosen.component.JSilentLabel;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout2;
import se.datadosen.component.StateMonitor;
import se.datadosen.component.buttonbar.JButtonBarPane;
import se.datadosen.component.search.SearchSupport;
import se.datadosen.component.search.UITarget;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.DirectoryChaining;
import se.datadosen.jalbum.FreeVersionDialogs;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JGeneralSettingsPanel;
import se.datadosen.jalbum.JImageEffectsPanel;
import se.datadosen.jalbum.JVariantsEditor;
import se.datadosen.jalbum.JVideoSettingsPanel;
import se.datadosen.jalbum.JWebBrowser;
import se.datadosen.jalbum.JWidgetSettingsPanel;
import se.datadosen.jalbum.LicenseManager;
import se.datadosen.jalbum.LicensedOnlyMask;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.TipOfTheDay;
import se.datadosen.jalbum.TitleSource;
import se.datadosen.jalbum.event.JAlbumEvent;
import se.datadosen.jalbum.scaling.CustomScaler;
import se.datadosen.jalbum.scaling.ImageScaler;
import se.datadosen.jalbum.structure.JStructurePanel;
import se.datadosen.util.ContextHelp;
import se.datadosen.util.Item;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.LambdaAction;
import se.datadosen.util.Platform;
import se.datadosen.util.PropertyBinder;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.Title;
import se.datadosen.util.annotations.ToolTipText;

@RememberedName(value="Settings window")
public class JSettingsWindow
extends JSmartDialog
implements JComponentHolder {
    public JAlbumFrame parent = JAlbumContext.getInstance().getFrame();
    private JWebBrowser skinSettingsBrowser = null;
    JMapTable userVariablesTable = new JMapTable();
    JButtonBarPane buttonBarPane = new JButtonBarPane();
    public JGeneralSettingsPanel generalPanel = new JGeneralSettingsPanel(this);
    public JTextField directory;
    private ControlPanel pagesPanel;
    JTabbedPane imagesPanel;
    private ControlPanel imagesGeneralPanel;
    @Text(value="ui.avifQuality")
    @ToolTipText(value="ui.qualityPercentToolTip")
    JLabel qualityPercentAVIFLabel;
    @ToolTipText(value="ui.qualityPercentToolTip")
    JSpinner qualityPercentAVIF;
    @Text(value="ui.avifSpeed")
    JLabel speedAVIFLabel;
    @ToolTipText(value="ui.avifSpeedToolTip")
    JSpinner speedAVIF;
    public JImageEffectsPanel imageEffectsPanel;
    JVideoSettingsPanel videosPanel;
    JSlider videoQuality;
    JComboBox videoResolution;
    JCheckBox useCustomVideoSettings;
    JTextArea notes;
    @Text(value="ui.notifyOnLoad")
    JCheckBox notifyNotes;
    JTabbedPane advancedPanel;
    private ControlPanel advGeneralPanel;
    private ControlPanel advMetadataPanel;
    private ControlPanel advNamingPanel;
    private ControlPanel widgetsPanel;
    private JStructurePanel structurePanel;
    private ControlPanel advUserVariablesPanel;
    ControlPanel notesPanel;
    JPanel skinSettingsPanel;
    private Icon bboxIcon;
    private Component currentPanel;
    final SkinUIIndirection skinUIHolder;
    JLabel creditTextLabel;
    JComboBox creditText;
    JCheckBox copyOriginals;
    @Text(value="ui.directoryChaining")
    @ToolTipText(value="ui.chainDirectoriesToolTip")
    JLabel directoryChainingLabel;
    @ToolTipText(value="ui.chainDirectoriesToolTip")
    JComboBox directoryChaining;
    JCheckBox slides;
    JCheckBox excludeBacklinks;
    JLabel homepageAddressLabel;
    JBackgroundTextField homepageAddress;
    JLabel homepageLinkTextLabel;
    JTextField homepageLinkText;
    ControlPanel imageBoundsPanel;
    JLabel thumbSizeLabel;
    JComboBox thumbSize;
    JLabel folderThumbSizeLabel;
    JComboBox folderThumbSize;
    JLabel imageSizeLabel;
    JComboBox imageSize;
    JCheckBox processFolderThumbs;
    JCheckBox hiDPIThumbs;
    JCheckBox hiDPIImages;
    @Text(value="ui.variants")
    @se.datadosen.util.annotations.Icon(value="16x16/add-variant-2.svg")
    JLabel variantsTabTitleLabel;
    ControlPanel variantsTab;
    ControlPanel variantsPanel;
    @Text(value="ui.noVariantSupport")
    @se.datadosen.util.annotations.Icon(value="24x24/information.svg")
    JLabel noVariantSupportLabel;
    JVariantsEditor imageVariants;
    JVariantsEditor thumbVariants;
    @Text(value="ui.presetsMenu")
    JLabel variantPresetsLabel;
    private final OutputFormat altFormat;
    JComboBox variantPresets;
    JLabel imageVariantsLabel;
    JLabel thumbVariantsLabel;
    @Text(value="ui.includeTypes")
    @ToolTipText(value="ui.includeTypesToolTip")
    ControlPanel includeTypesPanel;
    @Text(value="ui.scaling")
    ControlPanel scalingPanel;
    @Text(value="ui.output")
    ControlPanel outputPanel;
    @Text(value="ui.copyrightEmbeddingPanel")
    ControlPanel copyrightEmbeddingPanel;
    @Text(value="edit.creator")
    @ToolTipText(value="edit.creatorToolTip")
    private JLabel creatorLabel;
    @ToolTipText(value="edit.creatorToolTip")
    JTextField creator;
    @Text(value="edit.rights")
    @ToolTipText(value="edit.rightsToolTip")
    private JLabel rightsLabel;
    @ToolTipText(value="edit.rightsToolTip")
    JTextField rights;
    @Text(value="edit.rightsURL")
    private JLabel rightsURLLabel;
    JTextField rightsURL;
    @Text(value="ui.overrideExisting")
    JCheckBox overrideExistingCopyright;
    ControlPanel thumbnailLayoutPanel;
    ControlPanel imagesAdvancedPanel;
    JLabel imageBackgroundColorLabel;
    JColorSelector imageBackgroundColor;
    JCheckBox superimposeFilmIcon;
    JLabel colsLabel;
    JTextField cols;
    JLabel rowsLabel;
    JTextField rows;
    ControlPanel imageOrderingPanel;
    ControlPanel homepageLinkingPanel;
    ControlPanel creditLinksPanel;
    JComboBox imageOrdering;
    JCheckBox reverseOrder;
    JCheckBox directoriesFirst;
    @Text(value="ui.imageOrderingToolTip")
    @se.datadosen.util.annotations.Icon(value="16x16/lightbulb.svg")
    JLabel imageOrderingTip;
    @Text(value="ui.includeThumbnails")
    JCheckBox makeThumbs;
    @Text(value="ui.includeScaledImages")
    JCheckBox makeImages;
    @Text(value="ui.includeOriginals")
    JCheckBox includeOriginals;
    @Text(value="ui.jpegQuality")
    @ToolTipText(value="ui.qualityPercentToolTip")
    JLabel qualityPercentLabel;
    @Text(value="ui.webpQuality")
    @ToolTipText(value="ui.qualityPercentToolTip")
    JLabel qualityPercentWebPLabel;
    @ToolTipText(value="ui.qualityPercentToolTip")
    JSpinner qualityPercent;
    @ToolTipText(value="ui.qualityPercentToolTip")
    JSpinner qualityPercentWebP;
    private JLabel qualityPercentWarning;
    private JLabel webPQualityPercentWarning;
    JLabel sharpenPercentLabel;
    JSpinner sharpenPercent;
    JCheckBox forceProcessing;
    JCheckBox forceJPEGThumbs;
    JCheckBox forceJPEGImages;
    @Text(value="ui.imageFormat")
    JLabel outputFormatLabel;
    JComboBox<OutputFormat> outputFormat;
    @ToolTipText(value="ui.webpWarning")
    JLabel webpWarning;
    @Text(value="ui.webpWarning")
    JLabel webpWarningLabel;
    JCheckBox disableColorSubsampling;
    @Text(value="ui.type")
    JLabel scalingMethodLabel;
    JComboBox scalingMethod;
    @Text(value="opt.custom")
    JLabel smoothScalingTypeLabel;
    JComboBox smoothScalingType;
    JCheckBox acceleratedScaling;
    JCheckBox keepMetaData;
    JCheckBox keepXmpData;
    JCheckBox mediaRSS;
    @Text(value="ui.~")
    @ToolTipText(value="ui.~ToolTip")
    JCheckBox generateJSON;
    @Title(value="ui.sources")
    ControlPanel metadataSourcesPanel;
    ControlPanel commentSourcesPanel;
    @Text(value="ui.textFileComment")
    JCheckBox readJAlbumMetaData;
    JCheckBox readXmp;
    JCheckBox jpegComment;
    JCheckBox iptcCaption;
    JCheckBox exifUserComment;
    JCheckBox exifImageDescription;
    JDatePatternComboBox dateFormat;
    JLabel dateFormatLabel;
    @Text(value="ui.dateAndTimePatterns")
    JLinkLabel dateAndTimePatternsLink;
    JTextField indexPageName;
    JLabel indexPageNameLabel;
    JLabel titleSourceLabel;
    JComboBox titleSource;
    JCheckBox metaData;
    JCheckBox updatedDirsOnly;
    JCheckBox excludeByDefault;
    @Text(value="ui.~")
    @ToolTipText(value="ui.~ToolTip")
    JCheckBox useInternalLinking;
    @Text(value="ui.views")
    ControlPanel viewsPanel;
    @Text(value="view.includeHiddenObjects")
    JCheckBox includeHiddenObjectsInViews;
    JCheckBox useThumbForFolderIcon;
    JLabel dateExampleLabel;
    JTextField pageExtension;
    JLabel pageExtensionLabel;
    @Text(value="ui.~")
    @ToolTipText(value="ui.~ToolTip")
    JCheckBox removeDiacritics;
    @Text(value="ui.compatibility")
    ControlPanel advNamingCompatibilityPanel;
    JLabel encodingLabel;
    JComboBox textEncoding;
    JCheckBox writeUTF8;
    JScrollPane userVariablesScrollPane;
    JLabel ignorePatternLabel;
    JTextField ignorePattern;
    JCheckBox widgetInjection;
    private PropertyChangeListener changeListener;
    private final Object skinUIMonitor;

    @Override
    public Dimension getPreferredSize() {
        Rectangle win = new Rectangle(super.getPreferredSize());
        Rectangle screen = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        return win.intersection(screen).getSize();
    }

    JSettingsWindow(JAlbumFrame frame) {
        super((Window)frame);
        this.directory = this.generalPanel.directory;
        this.pagesPanel = new ControlPanel();
        this.imagesPanel = new JTabbedPane();
        this.imagesGeneralPanel = new ControlPanel();
        this.qualityPercentAVIFLabel = new JLabel();
        this.qualityPercentAVIF = new JSpinner(new SpinnerNumberModel(60, 0, 100, 5));
        this.speedAVIFLabel = new JLabel();
        this.speedAVIF = new JSpinner(new SpinnerNumberModel(4, 1, 10, 1));
        this.imageEffectsPanel = new JImageEffectsPanel(this);
        this.videosPanel = new JVideoSettingsPanel(JAlbumContext.getInstance());
        this.videoQuality = this.videosPanel.videoQuality;
        this.videoResolution = this.videosPanel.videoResolution;
        this.useCustomVideoSettings = this.videosPanel.useCustomVideoSettings;
        this.notes = (JTextArea)new JSmartTextArea(8, 20).spelling();
        this.notifyNotes = new JCheckBox();
        this.advancedPanel = new JTabbedPane();
        this.advGeneralPanel = new ControlPanel();
        this.advMetadataPanel = new ControlPanel();
        this.advNamingPanel = new ControlPanel();
        this.widgetsPanel = new JWidgetSettingsPanel(JAlbumContext.getInstance());
        this.structurePanel = new JStructurePanel(this);
        this.advUserVariablesPanel = new ControlPanel();
        this.notesPanel = new ControlPanel();
        this.skinSettingsPanel = new JPanel();
        this.bboxIcon = Icons.get("crop-demo");
        this.skinUIHolder = new SkinUIIndirection();
        this.creditTextLabel = new JLabel();
        this.creditText = new JComboBox<AlbumBean.CreditText>(AlbumBean.CreditText.values());
        this.copyOriginals = new JCheckBox();
        this.directoryChainingLabel = new JLabel();
        this.directoryChaining = new JComboBox<DirectoryChaining>(DirectoryChaining.values());
        this.slides = new JCheckBox();
        this.excludeBacklinks = new JCheckBox();
        this.homepageAddressLabel = new JLabel();
        this.homepageAddress = new JBackgroundTextField(27);
        this.homepageLinkTextLabel = new JLabel();
        this.homepageLinkText = (JTextField)new JSmartTextField(27).spelling();
        this.imageBoundsPanel = new ControlPanel();
        this.thumbSizeLabel = new JLabel();
        this.thumbSize = new JWiderComboBox(new String[]{"400x400", "240x240", "180x180", "160x160", "124x124", "..."});
        this.folderThumbSizeLabel = new JLabel();
        this.folderThumbSize = new JWiderComboBox(new String[]{"400x400", "240x240", "180x180", "160x160", "124x124", "..."});
        this.imageSizeLabel = new JLabel();
        this.imageSize = new JWiderComboBox(new String[]{"2000x2000", "1500x1500", "1200x1200", "1024x1024", "800x800", "720x720", "640x640", "..."});
        this.processFolderThumbs = new JCheckBox();
        this.hiDPIThumbs = new JCheckBox();
        this.hiDPIImages = new JCheckBox();
        this.variantsTabTitleLabel = new JLabel();
        this.variantsTab = new ControlPanel(new BorderLayout());
        this.variantsPanel = new ControlPanel();
        this.noVariantSupportLabel = new JLabel();
        this.imageVariants = new JVariantsEditor();
        this.thumbVariants = new JVariantsEditor();
        this.variantPresetsLabel = new JLabel();
        this.altFormat = OutputFormat.getAlternative();
        this.variantPresets = new JActionComboBox(new LambdaAction("<" + Msg.get("select") + ">", ae -> {}), new LambdaAction(Msg.get("variantPreset.clear"), ae -> {
            this.parent.engine.getThumbVariantList().clear();
            this.parent.engine.getImageVariantList().clear();
            this.thumbVariants.dataChanged();
            this.imageVariants.dataChanged();
        }), new VariantPreset(Msg.get("variantPreset.faster")).thumbs(new Variant(1.0f, this.altFormat)).images(new Variant(1.0f, this.altFormat), new Variant(0.5f, this.altFormat)), new VariantPreset(Msg.get("variantPreset.quality1")).thumbs(new Variant(1.5f, this.altFormat), new Variant(1.0f, this.altFormat)).images(new Variant(1.5f, this.altFormat), new Variant(1.0f, this.altFormat), new Variant(0.5f, this.altFormat)), new VariantPreset(Msg.get("variantPreset.quality2")).thumbs(new Variant(2.0f, this.altFormat), new Variant(1.0f, this.altFormat)).images(new Variant(2.0f, this.altFormat), new Variant(1.0f, this.altFormat), new Variant(0.5f, this.altFormat)), new VariantPreset(Msg.get("variantPreset.quality3")).thumbs(new Variant(2.0f, this.altFormat), new Variant(1.0f, this.altFormat)).images(new Variant(3.0f, this.altFormat), new Variant(2.0f, this.altFormat), new Variant(1.0f, this.altFormat), new Variant(0.5f, this.altFormat)));
        this.imageVariantsLabel = new JLabel();
        this.thumbVariantsLabel = new JLabel();
        this.includeTypesPanel = new ControlPanel();
        this.scalingPanel = new ControlPanel();
        this.outputPanel = new ControlPanel();
        this.copyrightEmbeddingPanel = new ControlPanel();
        this.creatorLabel = new JLabel();
        this.creator = (JTextField)new JSmartTextField(20).spelling();
        this.rightsLabel = new JLabel();
        this.rights = (JTextField)new JSmartTextField(20).spelling();
        this.rightsURLLabel = new JLabel();
        this.rightsURL = new JSmartTextField(20);
        this.overrideExistingCopyright = new JCheckBox();
        this.thumbnailLayoutPanel = new ControlPanel();
        this.imagesAdvancedPanel = new ControlPanel();
        this.imageBackgroundColorLabel = new JLabel();
        this.imageBackgroundColor = new JColorSelector(new JTextField(6));
        this.superimposeFilmIcon = new JCheckBox();
        this.colsLabel = new JLabel();
        this.cols = new JSmartTextField(4);
        this.rowsLabel = new JLabel();
        this.rows = new JSmartTextField(4);
        this.imageOrderingPanel = new ControlPanel();
        this.homepageLinkingPanel = new ControlPanel();
        this.creditLinksPanel = new ControlPanel();
        this.imageOrdering = new JComboBox();
        this.reverseOrder = new JCheckBox();
        this.directoriesFirst = new JCheckBox();
        this.imageOrderingTip = new JLabel();
        this.makeThumbs = new JCheckBox("", true);
        this.makeImages = new JCheckBox("", true);
        this.includeOriginals = new JCheckBox();
        this.qualityPercentLabel = new JLabel();
        this.qualityPercentWebPLabel = new JLabel();
        this.qualityPercent = new JSpinner(new SpinnerNumberModel(75, 0, 100, 5));
        this.qualityPercentWebP = new JSpinner(new SpinnerNumberModel(60, 0, 100, 5));
        this.qualityPercentWarning = new JSilentLabel(Icons.small("warning-1"));
        this.webPQualityPercentWarning = new JSilentLabel(Icons.small("warning-1"));
        this.sharpenPercentLabel = new JLabel();
        this.sharpenPercent = new JSpinner(new SpinnerNumberModel(50, 0, 100, 5));
        this.forceProcessing = new JCheckBox();
        this.forceJPEGThumbs = new JCheckBox();
        this.forceJPEGImages = new JCheckBox();
        this.outputFormatLabel = new JLabel();
        this.outputFormat = new JComboBox<OutputFormat>(OutputFormat.availableValues());
        this.webpWarning = new JSilentLabel(Icons.small("warning-1"));
        this.webpWarningLabel = new JLabel(Icons.small("warning-1"));
        this.disableColorSubsampling = new JCheckBox();
        this.scalingMethodLabel = new JLabel();
        this.scalingMethod = new JComboBox();
        this.smoothScalingTypeLabel = new JLabel();
        this.smoothScalingType = new JComboBox<CustomScaler.Type>(CustomScaler.Type.values());
        this.acceleratedScaling = new JCheckBox();
        this.keepMetaData = new JCheckBox();
        this.keepXmpData = new JCheckBox();
        this.mediaRSS = new JCheckBox();
        this.generateJSON = new JCheckBox();
        this.metadataSourcesPanel = new ControlPanel();
        this.commentSourcesPanel = new ControlPanel();
        this.readJAlbumMetaData = new JCheckBox();
        this.readXmp = new JCheckBox();
        this.jpegComment = new JCheckBox();
        this.iptcCaption = new JCheckBox();
        this.exifUserComment = new JCheckBox();
        this.exifImageDescription = new JCheckBox();
        this.dateFormat = new JDatePatternComboBox();
        this.dateFormatLabel = new JLabel();
        this.dateAndTimePatternsLink = new JLinkLabel("http://docs.oracle.com/javase/7/docs/api/java/text/SimpleDateFormat.html", "");
        this.indexPageName = new JTextField(20);
        this.indexPageNameLabel = new JLabel();
        this.titleSourceLabel = new JLabel();
        this.titleSource = new JComboBox<TitleSource>(TitleSource.values());
        this.metaData = new JCheckBox();
        this.updatedDirsOnly = new JCheckBox();
        this.excludeByDefault = new JCheckBox();
        this.useInternalLinking = new JCheckBox();
        this.viewsPanel = new ControlPanel();
        this.includeHiddenObjectsInViews = new JCheckBox();
        this.useThumbForFolderIcon = new JCheckBox();
        this.dateExampleLabel = new JLabel();
        this.pageExtension = new JTextField(20);
        this.pageExtensionLabel = new JLabel();
        this.removeDiacritics = new JCheckBox();
        this.advNamingCompatibilityPanel = new ControlPanel();
        this.encodingLabel = new JLabel();
        this.textEncoding = new JComboBox<String>(Msg.getCharsetNames());
        this.writeUTF8 = new JCheckBox();
        this.userVariablesScrollPane = new JScrollPane();
        this.ignorePatternLabel = new JLabel();
        this.ignorePattern = new JSmartTextField(16);
        this.widgetInjection = new JCheckBox();
        this.skinUIMonitor = new Object();
        this.parent = frame;
        this.init();
        ((JComponent)this.getContentPane()).registerKeyboardAction(this.parent.actions.reloadSkinAction, KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()), 2);
        new LicensedOnlyMask(this);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && !JAlbumContext.getInstance().getLicenseManager().isLicenseValid()) {
            SwingUtilities.invokeLater(() -> {
                FreeVersionDialogs fd = new FreeVersionDialogs(this.parent.context);
                fd.showOnSettings();
            });
        }
    }

    private void updateDateExample() {
        String dateString = "";
        try {
            SimpleDateFormat formatter = this.dateFormat.getEditorComponent().getText().length() > 0 ? new SimpleDateFormat(this.dateFormat.getEditorComponent().getText()) : new SimpleDateFormat();
            dateString = formatter.format(new Date());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.dateExampleLabel.setText(Msg.get("ui.example") + ": " + dateString);
    }

    private static void makeSmaller(JComponent comp) {
        float size = comp.getFont().getSize2D() - 2.0f;
        if (size < 10.0f) {
            size = 10.0f;
        }
        comp.setFont(comp.getFont().deriveFont(size));
    }

    boolean isUsingFormat(OutputFormat format) {
        return this.outputFormat.getSelectedItem() == format || this.thumbVariants.getModel().getVariants().stream().anyMatch(v -> v.getFormat() == format) || this.imageVariants.getModel().getVariants().stream().anyMatch(v -> v.getFormat() == format);
    }

    private void disableIrrelevantComponents() {
        boolean usingJPEG = this.isUsingFormat(OutputFormat.JPEG);
        boolean usingAVIF = this.isUsingFormat(OutputFormat.AVIF);
        boolean usingWEBP = this.isUsingFormat(OutputFormat.WEBP);
        this.qualityPercentLabel.setEnabled(usingJPEG);
        this.qualityPercent.setEnabled(usingJPEG);
        this.qualityPercentAVIFLabel.setEnabled(usingAVIF);
        this.qualityPercentAVIF.setEnabled(usingAVIF);
        this.speedAVIFLabel.setEnabled(usingAVIF);
        this.speedAVIF.setEnabled(usingAVIF);
        this.qualityPercentWebPLabel.setEnabled(usingWEBP);
        this.qualityPercentWebP.setEnabled(usingWEBP);
    }

    private void init() {
        Msg.maintainTranslated(this);
        this.colsLabel.setLabelFor(this.cols);
        this.thumbSizeLabel.setLabelFor(this.thumbSize);
        this.folderThumbSizeLabel.setLabelFor(this.folderThumbSize);
        this.imageSizeLabel.setLabelFor(this.imageSize);
        this.cols.setInputVerifier(new NumericVerifier());
        Config.getConfig().bind("language", pce -> {
            this.dateFormat.getEditorComponent().setBackgroundText(new SimpleDateFormat().toPattern());
            this.updateDateExample();
        });
        this.dateFormat.getEditorComponent().onChange(de -> this.updateDateExample());
        this.imageSize.setEditable(true);
        this.imageSize.setModel(new SmartComboBoxModel(this.imageSize));
        this.imageSize.setEditor(new DimensionComboBoxEditor());
        this.folderThumbSize.setEditable(true);
        this.folderThumbSize.setModel(new SmartComboBoxModel(this.folderThumbSize));
        this.folderThumbSize.setEditor(new DimensionComboBoxEditor());
        this.thumbSize.setEditable(true);
        this.thumbSize.setModel(new SmartComboBoxModel(this.thumbSize));
        this.thumbSize.setEditor(new DimensionComboBoxEditor());
        ListCellRenderer<OutputFormat> renderer = this.outputFormat.getRenderer();
        this.outputFormat.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
            JLabel label = (JLabel)renderer.getListCellRendererComponent(list, (OutputFormat)((Object)value), index, isSelected, cellHasFocus);
            if (value == OutputFormat.AVIF) {
                label.setText(label.getText() + " (" + Msg.get("ui.recommended") + ")");
            }
            label.setToolTipText(value.getToolTipText());
            return label;
        });
        StateMonitor.monitoring(this.outputFormat).onChange(c -> this.webpWarning.setVisible(OutputFormat.WEBP == this.outputFormat.getSelectedItem()));
        this.webpWarningLabel.setVisible(false);
        this.rowsLabel.setLabelFor(this.rows);
        this.includeOriginals.addActionListener(e -> {
            if (this.includeOriginals.isSelected()) {
                this.copyOriginals.setSelected(true);
            }
        });
        this.keepMetaData.addActionListener(e -> {
            if (this.keepMetaData.isSelected()) {
                JOptionPane.showMessageDialog(this, Msg.get("ui.keepMetaDataWarning"), Msg.get("ui.keepMetaDataInfo"), 2);
            }
        });
        this.excludeBacklinks.addActionListener(e -> {
            if (this.excludeBacklinks.isSelected()) {
                JOptionPane.showMessageDialog(this, Msg.get("ui.excludeBacklinksInfo"), Msg.get("ui.excludeBacklinks"), 1);
            }
        });
        if (Platform.isMac()) {
            this.pagesPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        }
        new StateMonitor(new JComponent[]{this.scalingMethod}){

            @Override
            public void onChange() {
                boolean custom = JSettingsWindow.this.scalingMethod.getSelectedIndex() == 2;
                JSettingsWindow.this.smoothScalingTypeLabel.setEnabled(custom);
                JSettingsWindow.this.smoothScalingType.setEnabled(custom);
            }
        }.done();
        ComponentUtilities.whenSelectedEnable((AbstractButton)this.makeImages, this.imageSizeLabel, this.imageSize, this.imageVariantsLabel, this.imageVariants);
        ComponentUtilities.whenSelectedDisable((AbstractButton)this.excludeBacklinks, (JComponent)this.creditText);
        ComponentUtilities.whenSelectedEnable((AbstractButton)this.processFolderThumbs, this.folderThumbSizeLabel, this.folderThumbSize);
        this.pagesPanel.add("br", this.slides);
        this.thumbnailLayoutPanel.add(this.colsLabel);
        this.thumbnailLayoutPanel.add(this.cols);
        this.thumbnailLayoutPanel.add(Box.createHorizontalStrut(8));
        this.thumbnailLayoutPanel.add(this.rowsLabel);
        this.thumbnailLayoutPanel.add(this.rows);
        this.imageOrderingPanel.add("", this.imageOrdering);
        this.imageOrderingPanel.add("", this.reverseOrder);
        this.imageOrderingPanel.add("", this.directoriesFirst);
        this.imageOrderingPanel.add("br", this.imageOrderingTip);
        JSettingsWindow.makeSmaller(this.imageOrderingTip);
        this.pagesPanel.add("br", this.thumbnailLayoutPanel);
        this.pagesPanel.add("p", this.imageOrderingPanel);
        this.homepageLinkingPanel.add("label", this.homepageAddressLabel);
        this.homepageLinkingPanel.add("tab", this.homepageAddress);
        this.homepageLinkingPanel.add("br label", this.homepageLinkTextLabel);
        this.homepageLinkingPanel.add("tab", this.homepageLinkText);
        this.pagesPanel.add("p", this.homepageLinkingPanel);
        this.creditLinksPanel.add(this.excludeBacklinks);
        this.creditLinksPanel.add("br label", this.creditTextLabel);
        this.creditLinksPanel.add("tab hfill", this.creditText);
        this.pagesPanel.add("p", this.creditLinksPanel);
        if (Platform.isMac()) {
            this.imagesGeneralPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        }
        StateMonitor.monitoring(this.qualityPercent).onChange(c -> this.qualityPercentWarning.setVisible((Integer)this.qualityPercent.getValue() > 90));
        StateMonitor.monitoring(this.qualityPercentWebP).onChange(c -> this.webPQualityPercentWarning.setVisible((Integer)this.qualityPercentWebP.getValue() > 80));
        this.includeTypesPanel.add(this.makeThumbs);
        this.includeTypesPanel.add(this.makeImages);
        this.includeTypesPanel.add(this.includeOriginals);
        JPanel imagesGeneralWrappingPanel = new JPanel(new RiverLayout2());
        imagesGeneralWrappingPanel.add("br hfill", this.includeTypesPanel);
        this.makeThumbs.setEnabled(false);
        StateMonitor.monitoring(this.makeImages).onChange(c -> {
            if (!this.makeImages.isSelected()) {
                this.includeOriginals.setSelected(true);
            }
        });
        StateMonitor.monitoring(this.includeOriginals).onChange(c -> {
            if (!this.includeOriginals.isSelected()) {
                this.makeImages.setSelected(true);
            }
        });
        this.imageBoundsPanel.add(Group.vertically(this.thumbSizeLabel, this.thumbSize));
        this.imageBoundsPanel.add(Group.vertically(this.folderThumbSizeLabel, this.folderThumbSize));
        this.imageBoundsPanel.add(Group.vertically(this.imageSizeLabel, this.imageSize));
        this.imageBoundsPanel.add("", new JLabel(this.bboxIcon));
        this.imageBoundsPanel.add("br", this.processFolderThumbs);
        imagesGeneralWrappingPanel.add("p hfill", this.imageBoundsPanel);
        this.scalingPanel.add(this.scalingMethodLabel);
        this.scalingPanel.add(this.scalingMethod);
        this.scalingPanel.add(new JLabel("-"));
        this.scalingPanel.add(this.smoothScalingType);
        this.scalingPanel.add(Box.createHorizontalStrut(10));
        this.scalingPanel.add(this.sharpenPercentLabel);
        this.scalingPanel.add(Group.horizontally(this.sharpenPercent, new JLabel("% ")));
        imagesGeneralWrappingPanel.add("p hfill", this.scalingPanel);
        this.outputPanel.add("vcenter", this.outputFormatLabel);
        this.outputPanel.add(this.outputFormat);
        this.outputPanel.add(this.webpWarning);
        this.outputPanel.add(Box.createHorizontalStrut(8));
        this.outputPanel.add("tab", this.qualityPercentLabel);
        this.outputPanel.add("tab", Group.horizontally(this.qualityPercent, new JLabel("% ")));
        this.outputPanel.add(this.qualityPercentWarning);
        this.outputPanel.add("br", Box.createHorizontalGlue());
        this.outputPanel.add("tab", this.qualityPercentAVIFLabel);
        this.outputPanel.add("tab", Group.horizontally(this.qualityPercentAVIF, new JLabel("% ")));
        this.outputPanel.add("br", Box.createHorizontalGlue());
        this.outputPanel.add("tab", this.speedAVIFLabel);
        this.outputPanel.add("tab", this.speedAVIF);
        this.outputPanel.add("br", Box.createHorizontalGlue());
        this.outputPanel.add("tab", this.qualityPercentWebPLabel);
        this.outputPanel.add("tab", Group.horizontally(this.qualityPercentWebP, new JLabel("% ")));
        this.outputPanel.add(this.webPQualityPercentWarning);
        imagesGeneralWrappingPanel.add("p hfill", this.outputPanel);
        this.imagesGeneralPanel.add(imagesGeneralWrappingPanel);
        this.noVariantSupportLabel.setEnabled(false);
        this.variantsPanel.add("p", this.variantPresetsLabel);
        this.variantsPanel.add(this.variantPresets);
        this.variantsPanel.add("p", Group.vertically(this.thumbVariantsLabel, this.thumbVariants));
        this.variantsPanel.add(Group.vertically(this.imageVariantsLabel, this.imageVariants));
        this.variantsPanel.add("br", this.webpWarningLabel);
        this.parent.binder.onRead(() -> {
            this.thumbVariants.setData(this.parent.engine.getThumbVariantList());
            this.imageVariants.setData(this.parent.engine.getImageVariantList());
        });
        this.variantsTab.add((Component)this.noVariantSupportLabel, "North");
        this.variantsTab.add(this.variantsPanel);
        this.imagesAdvancedPanel.add("br", this.forceProcessing);
        this.imagesAdvancedPanel.add("br", this.forceJPEGThumbs);
        this.imagesAdvancedPanel.add("br", this.forceJPEGImages);
        this.imagesAdvancedPanel.add("br", this.hiDPIThumbs);
        this.imagesAdvancedPanel.add("br", this.hiDPIImages);
        this.imagesAdvancedPanel.add("br", this.disableColorSubsampling);
        this.imagesAdvancedPanel.add("br", this.acceleratedScaling);
        this.imagesAdvancedPanel.add("br", this.superimposeFilmIcon);
        this.imagesAdvancedPanel.add("br", this.copyOriginals);
        this.imagesAdvancedPanel.add("br", this.imageBackgroundColorLabel);
        this.imagesAdvancedPanel.add(this.imageBackgroundColor);
        this.imagesAdvancedPanel.add(this.imageBackgroundColor.getTextComponent());
        this.copyrightEmbeddingPanel.add("label", this.creatorLabel);
        this.copyrightEmbeddingPanel.add("tab", this.creator);
        this.copyrightEmbeddingPanel.add("br label", this.rightsLabel);
        this.copyrightEmbeddingPanel.add("tab", this.rights);
        this.copyrightEmbeddingPanel.add("br label", this.rightsURLLabel);
        this.copyrightEmbeddingPanel.add("tab", this.rightsURL);
        this.copyrightEmbeddingPanel.add("br label", this.overrideExistingCopyright);
        this.imagesAdvancedPanel.add("p", this.copyrightEmbeddingPanel);
        StateMonitor.monitoring(this.outputFormat).onChange(src -> {
            this.forceJPEGThumbs.setText(Msg.get("ui.forceJPEGThumbs", this.outputFormat.getSelectedItem()));
            this.forceJPEGThumbs.setToolTipText(Msg.get("ui.forceJPEGWritingToolTip", this.outputFormat.getSelectedItem()));
            this.forceJPEGImages.setText(Msg.get("ui.forceJPEGImages", this.outputFormat.getSelectedItem()));
            this.forceJPEGImages.setToolTipText(Msg.get("ui.forceJPEGWritingToolTip", this.outputFormat.getSelectedItem()));
        });
        StateMonitor.monitoring(this.outputFormat).onChange(s -> this.disableIrrelevantComponents());
        this.thumbVariants.getModel().addTableModelListener(e -> this.disableIrrelevantComponents());
        this.imageVariants.getModel().addTableModelListener(e -> this.disableIrrelevantComponents());
        this.sharpenPercentLabel.setLabelFor(this.sharpenPercent);
        this.imagesPanel.setBorder(BorderFactory.createEmptyBorder(12, 9, 6, 9));
        this.imagesPanel.addTab(Msg.get("ui.mainPanel"), Icons.small("general"), this.imagesGeneralPanel);
        this.imagesPanel.addTab(Msg.get("ui.variants"), this.variantsTab);
        this.imagesPanel.setTabComponentAt(1, this.variantsTabTitleLabel);
        InvalidationListener activeListener = ce -> this.variantsTabTitleLabel.setForeground(this.thumbVariants.activeProperty.get() || this.imageVariants.activeProperty.get() ? Color.green.darker() : JAlbumColor.textText);
        InvalidationListener webpListener = ce -> this.webpWarningLabel.setVisible(this.thumbVariants.webpProperty.get() || this.imageVariants.webpProperty.get());
        this.thumbVariants.activeProperty.addListener(activeListener);
        this.imageVariants.activeProperty.addListener(activeListener);
        this.thumbVariants.webpProperty.addListener(webpListener);
        this.imageVariants.webpProperty.addListener(webpListener);
        this.imagesPanel.addTab(Msg.get("ui.advancedPanel"), Icons.small("wrench"), this.imagesAdvancedPanel);
        this.textEncoding.setEditable(true);
        this.dateFormatLabel.setLabelFor(this.dateFormat);
        this.indexPageNameLabel.setLabelFor(this.indexPageName);
        JSettingsWindow.makeSmaller(this.dateExampleLabel);
        JSettingsWindow.makeSmaller(this.dateAndTimePatternsLink);
        this.pageExtensionLabel.setLabelFor(this.pageExtension);
        LicenseManager mgr = JAlbumContext.getInstance().getLicenseManager();
        this.excludeBacklinks.setEnabled(mgr.isLicenseValid() || mgr.isOldDonor());
        this.widgetInjection.setEnabled(mgr.isLicenseValid());
        if (!mgr.isLicenseValid()) {
            this.widgetInjection.setSelected(true);
        }
        mgr.addPropertyChangeListener(evt -> {
            LicenseManager mgr1 = JAlbumContext.getInstance().getLicenseManager();
            this.excludeBacklinks.setEnabled(mgr1.isLicenseValid() || mgr1.isOldDonor());
            this.widgetInjection.setEnabled(mgr1.isLicenseValid());
            if (!mgr1.isLicenseValid()) {
                this.widgetInjection.setSelected(true);
            }
        });
        this.advancedPanel.setBorder(BorderFactory.createEmptyBorder(12, 9, 6, 9));
        this.advGeneralPanel.add("p label", this.encodingLabel);
        this.advGeneralPanel.add("tab", this.textEncoding);
        this.advGeneralPanel.add("hfill", this.writeUTF8);
        this.advGeneralPanel.add("br label", this.dateFormatLabel);
        this.advGeneralPanel.add("tab", this.dateFormat);
        this.advGeneralPanel.add(this.dateAndTimePatternsLink);
        this.advGeneralPanel.add("br tab", this.dateExampleLabel);
        this.advGeneralPanel.add("br label", this.ignorePatternLabel);
        this.advGeneralPanel.add("tab", this.ignorePattern);
        this.advGeneralPanel.add("br label", this.directoryChainingLabel);
        this.advGeneralPanel.add("tab", this.directoryChaining);
        this.advGeneralPanel.add("br hfill", this.updatedDirsOnly);
        this.advGeneralPanel.add("br hfill", this.useThumbForFolderIcon);
        this.advGeneralPanel.add("br hfill", this.excludeByDefault);
        this.advGeneralPanel.add("br hfill", this.useInternalLinking);
        this.viewsPanel.add(this.includeHiddenObjectsInViews);
        this.advGeneralPanel.add("br", this.viewsPanel);
        this.parent.addPropertyChangeListener("skinLoaded", pce -> {
            this.useInternalLinking.setEnabled(this.parent.engine.getSkinProperties().isSupportsInternalLinking());
            this.useInternalLinking.setToolTipText(this.useInternalLinking.isEnabled() ? Msg.get("ui.useInternalLinkingToolTip") : Msg.get("ui.notSupportedBySkin"));
        });
        this.advancedPanel.addTab(Msg.get("ui.mainPanel"), this.advGeneralPanel);
        this.readJAlbumMetaData.setEnabled(false);
        this.metadataSourcesPanel.add("hfill", this.readJAlbumMetaData);
        this.metadataSourcesPanel.add("br hfill", this.readXmp);
        this.advMetadataPanel.add("br", this.metadataSourcesPanel);
        this.advMetadataPanel.add("br", this.commentSourcesPanel);
        this.advMetadataPanel.add("p", this.titleSourceLabel);
        this.advMetadataPanel.add(this.titleSource);
        this.advMetadataPanel.add("p hfill", this.metaData);
        this.advMetadataPanel.add("br hfill", this.keepMetaData);
        this.advMetadataPanel.add("br hfill", this.keepXmpData);
        this.advMetadataPanel.add("br hfill", this.widgetInjection);
        this.advMetadataPanel.add("br hfill", this.mediaRSS);
        this.advMetadataPanel.add("br hfill", this.generateJSON);
        this.advancedPanel.addTab(Msg.get("ui.metadataPanel"), this.advMetadataPanel);
        this.advNamingPanel.add("p hfill label", this.indexPageNameLabel);
        this.advNamingPanel.add("tab", this.indexPageName);
        this.advNamingPanel.add("br hfill label", this.pageExtensionLabel);
        this.advNamingPanel.add("tab", this.pageExtension);
        this.advNamingCompatibilityPanel.add(this.removeDiacritics);
        this.advNamingPanel.add("p", this.advNamingCompatibilityPanel);
        this.advancedPanel.addTab(Msg.get("ui.namingPanel"), this.advNamingPanel);
        this.advancedPanel.addTab(Msg.get("ui.widgetPanel"), this.widgetsPanel);
        this.commentSourcesPanel.add("br hfill", this.jpegComment);
        this.commentSourcesPanel.add("br hfill", this.iptcCaption);
        this.commentSourcesPanel.add("br hfill", this.exifUserComment);
        this.commentSourcesPanel.add("br hfill", this.exifImageDescription);
        this.userVariablesScrollPane.getViewport().add(this.userVariablesTable);
        this.userVariablesScrollPane.setPreferredSize(new Dimension(50, 50));
        if (Platform.isMac()) {
            this.userVariablesScrollPane.setVerticalScrollBarPolicy(22);
        }
        this.advUserVariablesPanel.setLayout(new BorderLayout());
        this.advUserVariablesPanel.add((Component)this.userVariablesScrollPane, "Center");
        this.advUserVariablesPanel.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
        this.advancedPanel.addTab(Msg.get("ui.varsPanel"), this.advUserVariablesPanel);
        this.notesPanel.add(this.notifyNotes);
        this.notes.setWrapStyleWord(true);
        this.notes.setLineWrap(true);
        this.notesPanel.add("br hfill vfill", new JScrollPane(this.notes));
        this.advancedPanel.addTab(Msg.get("ui.notesPanel"), this.notesPanel);
        this.skinSettingsPanel.setLayout(new BorderLayout());
        this.buttonBarPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component previousPanel = JSettingsWindow.this.currentPanel;
                JSettingsWindow.this.currentPanel = JSettingsWindow.this.buttonBarPane.getSelectedComponent();
                if (previousPanel == JSettingsWindow.this.skinSettingsPanel) {
                    JSettingsWindow.this.parent.fireSkinUIHidden(new JAlbumEvent(this));
                } else if (JSettingsWindow.this.currentPanel == JSettingsWindow.this.skinSettingsPanel) {
                    JSettingsWindow.this.parent.fireSkinUIDisplayed(new JAlbumEvent(this));
                }
            }
        });
        Container c2 = this.getContentPane();
        c2.add((Component)this.buttonBarPane, "Center");
        AbstractAction closeAction = new AbstractAction(Msg.get("close")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JSettingsWindow.this.setVisible(false);
                if (!JSettingsWindow.this.generalPanel.directory.getText().equals(JSettingsWindow.this.parent.engine.getDirectory())) {
                    JSettingsWindow.this.parent.initView();
                }
                JSettingsWindow.this.parent.applySettings();
            }
        };
        AbstractAction applySettingsAction = new AbstractAction(Msg.get("filters.filterManager.apply")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!JSettingsWindow.this.generalPanel.directory.getText().equals(JSettingsWindow.this.parent.engine.getDirectory())) {
                    JSettingsWindow.this.parent.initView();
                }
                JSettingsWindow.this.parent.applySettings();
            }
        };
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                try {
                    JSettingsWindow.this.parent.setPreviousProjectSettings(JSettingsWindow.this.parent.getProjectSettings());
                }
                catch (Exception ex) {
                    Logger.getLogger(JSettingsWindow.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.registerActions(closeAction);
        final JIconTextField searchField = new JIconTextField(8);
        searchField.setToolTipText(Msg.get("ui.searchToolTip"));
        searchField.setIcon(Icons.small("btn-view"));
        searchField.setFont(searchField.getFont().deriveFont(searchField.getFont().getSize2D() + 2.0f));
        new SearchSupport(searchField, new UITarget.Provider(this.getContentPane()));
        JPanel slack = this.buttonBarPane.getSlackPanel();
        slack.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        Box searchAndHelp = Box.createHorizontalBox();
        searchAndHelp.add(searchField);
        ((JComponent)this.getContentPane()).registerKeyboardAction(new LambdaAction(ae -> searchField.requestFocusInWindow()), KeyStroke.getKeyStroke(32, 128), 2);
        searchAndHelp.add(Box.createHorizontalStrut(4));
        slack.add((Component)searchAndHelp, "North");
        this.buttonBarPane.addChangeListener(new ChangeListener(){
            int clickCount;
            long lastClick;
            final /* synthetic */ JSettingsWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                if (System.currentTimeMillis() - this.lastClick < 10000L) {
                    ++this.clickCount;
                    if (this.clickCount == 3) {
                        TipOfTheDay.showSpeechBubble(searchField, new Hour(7), Msg.get("ui.useSettingsSearchFieldPrompt"), 8);
                    }
                } else {
                    this.clickCount = 0;
                }
                this.lastClick = System.currentTimeMillis();
            }
        });
        ContextHelp help = ContextHelp.getInstance();
        searchAndHelp.add(help.getContext(this).getHelpButton());
        help.add(this.generalPanel, "Settings/General");
        help.add(this.structurePanel, "Settings/Structure");
        help.add(this.pagesPanel, "Settings/Pages");
        help.add(this.imagesPanel, "Settings/Images");
        help.add(this.imagesAdvancedPanel, "Settings/Images#Advanced");
        help.add(this.videosPanel, "Settings/Videos");
        help.add(this.imageEffectsPanel, "Settings/Effects");
        help.add(this.widgetsPanel, "Settings/Widgets");
        help.add(this.advancedPanel, "Settings/Advanced");
        help.add(this.advancedPanel, "Settings/Advanced#General");
        help.add(this.advMetadataPanel, "Settings/Advanced#Metadata");
        help.add(this.advNamingPanel, "Settings/Advanced#Naming");
        help.add(this.advancedPanel, "Settings/Advanced");
        help.add(this.advUserVariablesPanel, "Settings/Advanced#UserVariables");
        help.add(this.notesPanel, "Settings/Advanced#Notes");
    }

    public void setAlbumObject(AlbumObject root) {
        this.generalPanel.setAlbumObject(root);
        this.imageEffectsPanel.setAlbumObject(root);
    }

    boolean isSkinUISelected() {
        return this.buttonBarPane.getSelectedComponent() == this.skinSettingsPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSkinUI(ControlPanel ui) {
        Object object = this.skinUIMonitor;
        synchronized (object) {
            if (this.skinUIHolder.skinUI != null) {
                this.skinSettingsPanel.removeAll();
                this.skinUIHolder.skinUI = null;
            }
            if (ui != null) {
                HashMap vars = new HashMap(this.parent.engine.getUserVariables());
                vars.putAll(this.parent.engine.getSkinVariables());
                PropertyBinder.syncUI(vars, ui);
                JScrollPane scroller = new JScrollPane(ui, 20, 30);
                this.skinSettingsPanel.add(scroller);
                scroller.setBorder(null);
                ContextHelp.getInstance().addTree(ui);
                this.skinUIHolder.skinUI = ui;
            }
            this.buttonBarPane.remove(this.skinSettingsPanel);
            this.parent.actions.skinSettingsAction.setEnabled(false);
            if (ui != null) {
                URL u;
                String iconPath = this.parent.engine.getSkinProperties().getProperty("icon");
                Icon icon = null;
                if (iconPath != null && (u = ui.getClass().getResource(iconPath)) != null) {
                    icon = Icons.get(ui.getClass(), iconPath, 32);
                }
                if (icon == null) {
                    icon = Icons.get("skin-settings-1", 32);
                }
                this.buttonBarPane.addTab(this.parent.mainSettingsPanel.getSelectedSkin(), icon, this.skinSettingsPanel);
                this.pack();
                this.fitOnScreen();
                this.parent.actions.skinSettingsAction.setEnabled(true);
            }
        }
        if (ui != null) {
            this.parent.fireSkinLoaded();
        }
    }

    private void fitOnScreen() {
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        Rectangle sb = gc.getBounds();
        if (gc.getDevice() == GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice()) {
            sb = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        }
        Rectangle wb = this.getBounds();
        Rectangle originalBounds = new Rectangle(wb);
        wb.width = Math.min(wb.width, sb.width - sb.x);
        wb.height = Math.min(wb.height, sb.height - sb.y);
        if (wb.x + wb.width > sb.width) {
            wb.x = Math.max(sb.x, sb.width - wb.width - 16);
        }
        if (wb.y + wb.height > sb.height) {
            wb.y = Math.max(sb.y, sb.height - wb.height);
        }
        if (!wb.equals(originalBounds)) {
            this.setBounds(wb);
        }
    }

    void populateWithDefaultTabs() {
        this.buttonBarPane.addTab(Msg.get("ui.mainPanel"), Icons.get("general-settings-1", 32), this.generalPanel);
        this.buttonBarPane.addTab(Msg.get("ui.pagesPanel"), Icons.get("pages-settings-1", 32), this.pagesPanel);
        this.buttonBarPane.addTab(Msg.get("ui.imagesPanel"), Icons.get("images-settings-1", 32), this.imagesPanel);
        this.buttonBarPane.addTab(Msg.get("ui.effectsPanel"), Icons.get("filter-settings-1", 32), this.imageEffectsPanel);
        this.buttonBarPane.addTab(Msg.get("ui.videosPanel"), Icons.get("video-settings-1", 32), this.videosPanel);
        this.buttonBarPane.addTab(Msg.get("ui.advancedPanel"), Icons.get("advanced-settings-1", 32), this.advancedPanel);
    }

    void setTexts() {
        this.renameTab(this.generalPanel, Msg.get("ui.mainPanel"));
        this.renameTab(this.imagesPanel, Msg.get("ui.imagesPanel"));
        this.renameTab(this.pagesPanel, Msg.get("ui.pagesPanel"));
        this.renameTab(this.advancedPanel, Msg.get("ui.advancedPanel"));
        this.renameAdvancedTab(this.advGeneralPanel, Msg.get("ui.mainPanel"));
        this.renameAdvancedTab(this.advMetadataPanel, Msg.get("ui.metadataPanel"));
        this.renameAdvancedTab(this.advNamingPanel, Msg.get("ui.namingPanel"));
        this.renameAdvancedTab(this.advUserVariablesPanel, Msg.get("ui.varsPanel"));
        this.imageBoundsPanel.setTitle(Msg.get("ui.imageBoundsBorder"));
        this.imageBoundsPanel.setTitle(Msg.get("ui.imageBoundsBorder"));
        this.imageOrderingPanel.setTitle(Msg.get("ui.imageOrderingBorder"));
        this.thumbnailLayoutPanel.setTitle(Msg.get("ui.thumbnailLayoutBorder"));
        this.homepageLinkingPanel.setTitle(Msg.get("ui.homepageLinking"));
        this.creditLinksPanel.setTitle(Msg.get("ui.creditLinks"));
        this.imageSizeLabel.setText(Msg.get("ui.imagesLabel"));
        this.colsLabel.setText(Msg.get("ui.columnsLabel"));
        this.thumbSizeLabel.setText(Msg.get("ui.thumbnailsLabel"));
        this.folderThumbSizeLabel.setText(Msg.get("ui.foldersLabel"));
        this.processFolderThumbs.setText(Msg.get("ui.processFolderThumbs"));
        this.hiDPIThumbs.setText(Msg.get("ui.HiDPIThumbs"));
        this.hiDPIThumbs.setToolTipText(Msg.get("ui.HiDPIToolTip"));
        this.hiDPIImages.setText(Msg.get("ui.HiDPIImages"));
        this.hiDPIImages.setToolTipText(Msg.get("ui.HiDPIToolTip"));
        this.imageVariantsLabel.setText(Msg.get("ui.imagesLabel"));
        this.thumbVariantsLabel.setText(Msg.get("ui.thumbnailsLabel"));
        this.homepageAddressLabel.setText(Msg.get("ui.linkAddress"));
        this.homepageAddress.setBackgroundText(Msg.get("ui.linkAddressTemplate"));
        this.homepageLinkTextLabel.setText(Msg.get("ui.linkText"));
        this.imageBackgroundColorLabel.setText(Msg.get("ui.imageBackgroundColor"));
        this.imageBackgroundColor.setTitle(Msg.get("ui.imageBackgroundColor"));
        this.superimposeFilmIcon.setText(Msg.get("ui.superimposeFilmIcon"));
        this.imageSize.setToolTipText(Msg.get("ui.imageSizeToolTip"));
        this.thumbSize.setToolTipText(Msg.get("ui.thumbSizeToolTip"));
        this.folderThumbSize.setToolTipText(Msg.get("ui.folderThumbSizeToolTip"));
        this.slides.setText(Msg.get("ui.makeSlides"));
        this.slides.setToolTipText(Msg.get("ui.makeSlidesToolTip"));
        this.excludeBacklinks.setText(Msg.get("ui.excludeBacklinks"));
        this.excludeBacklinks.setToolTipText(Msg.get("ui.excludeBacklinksToolTip"));
        this.creditTextLabel.setText(Msg.get("ui.linkText"));
        this.rowsLabel.setText(Msg.get("ui.rows"));
        this.copyOriginals.setText(Msg.get("ui.copyOriginals"));
        this.copyOriginals.setToolTipText(Msg.get("ui.copyOriginalsToolTip"));
        this.scalingMethod.removeAllItems();
        HashMap<String, String> sm = new HashMap<String, String>();
        sm.put("ScaleFast", Msg.get("ui.scaleFast"));
        sm.put("ScaleMedium", Msg.get("ui.scaleMedium"));
        sm.put("ScaleSmooth", Msg.get("ui.scaleSmooth"));
        for (String methodName : ImageScaler.getScalerNames()) {
            String translated = (String)sm.get(methodName);
            if (translated == null) {
                translated = methodName;
            }
            this.scalingMethod.addItem(new Item(methodName, translated));
        }
        this.imageOrdering.removeAllItems();
        this.imageOrdering.addItem(new Item("OrderByDate", Msg.get("ui.dateOrdering")));
        this.imageOrdering.addItem(new Item("OrderByAddedDate", Msg.get("edit.addedDateOrdering")));
        this.imageOrdering.addItem(new Item("OrderByCameraDate", Msg.get("edit.cameraDateOrdering")));
        this.imageOrdering.addItem(new Item("OrderByName", Msg.get("ui.nameOrdering")));
        this.imageOrdering.addItem(new Item("OrderBySimpleName", Msg.get("ui.simpleNameOrdering")));
        this.rows.setToolTipText(Msg.get("ui.rowsToolTip") + Msg.get("ui.rowsToolTip2"));
        this.reverseOrder.setText(Msg.get("ui.reverseOrder"));
        this.directoriesFirst.setText(Msg.get("ui.directoriesFirst"));
        this.directoriesFirst.setToolTipText(Msg.get("ui.directoriesFirstToolTip"));
        this.dateFormatLabel.setText(Msg.get("ui.dateFormat"));
        this.indexPageNameLabel.setText(Msg.get("ui.indexPageName"));
        this.titleSourceLabel.setText(Msg.get("ui.titleSource"));
        this.metaData.setText(Msg.get("ui.metaData"));
        this.metaData.setToolTipText(Msg.get("ui.metaDataToolTip"));
        this.updatedDirsOnly.setText(Msg.get("ui.updatedDirsOnly"));
        this.updatedDirsOnly.setToolTipText(Msg.get("ui.updatedDirsOnlyToolTip"));
        this.excludeByDefault.setText(Msg.get("ui.excludeByDefault"));
        this.excludeByDefault.setToolTipText(Msg.get("ui.excludeByDefaultToolTip"));
        this.useThumbForFolderIcon.setText(Msg.get("ui.useThumbForFolderIcon"));
        this.useThumbForFolderIcon.setToolTipText(Msg.get("ui.useThumbForFolderIconToolTip"));
        this.dateFormat.setToolTipText(Msg.get("ui.dateFormatTemplateToolTip"));
        this.ignorePatternLabel.setText(Msg.get("ui.ignorePattern"));
        this.commentSourcesPanel.setTitle(Msg.get("ui.commentSourcesBorder"));
        this.commentSourcesPanel.setToolTipText(Msg.get("ui.commentSourcesToolTip"));
        this.readXmp.setText(Msg.get("ui.readXmp"));
        this.jpegComment.setText(Msg.get("ui.jpegComment"));
        this.iptcCaption.setText(Msg.get("ui.iptcCaption"));
        this.exifUserComment.setText(Msg.get("ui.exifUserComment"));
        this.exifImageDescription.setText(Msg.get("ui.exifImageDescription"));
        this.ignorePattern.setToolTipText(Msg.get("ui.ignorePatternToolTip"));
        this.qualityPercentWarning.setToolTipText(Msg.get("ui.qualitySizeWarning"));
        this.webPQualityPercentWarning.setToolTipText(Msg.get("ui.qualitySizeWarning"));
        this.sharpenPercentLabel.setText(Msg.get("ui.sharpenAmount"));
        this.forceProcessing.setText(Msg.get("ui.forceProcessing"));
        this.forceProcessing.setToolTipText(Msg.get("ui.forceProcessingToolTip"));
        this.forceJPEGThumbs.setText(Msg.get("ui.forceJPEGThumbs", this.outputFormat.getSelectedItem()));
        this.forceJPEGThumbs.setToolTipText(Msg.get("ui.forceJPEGWritingToolTip", this.outputFormat.getSelectedItem()));
        this.forceJPEGImages.setText(Msg.get("ui.forceJPEGImages", this.outputFormat.getSelectedItem()));
        this.forceJPEGImages.setToolTipText(Msg.get("ui.forceJPEGWritingToolTip", this.outputFormat.getSelectedItem()));
        this.disableColorSubsampling.setText(Msg.get("ui.disableColorSubsampling"));
        this.disableColorSubsampling.setToolTipText(Msg.get("ui.disableColorSubsamplingToolTip"));
        this.acceleratedScaling.setText(Msg.get("ui.hardwareScaling"));
        this.acceleratedScaling.setToolTipText(Msg.get("ui.hardwareScalingToolTip"));
        this.keepMetaData.setText(Msg.get("ui.keepMetaDataInfo"));
        this.keepMetaData.setToolTipText(Msg.get("ui.metaDataToolTip"));
        this.keepXmpData.setText(Msg.get("ui.keepXmpData"));
        this.keepXmpData.setToolTipText(Msg.get("ui.keepXmpDataToolTip"));
        this.widgetInjection.setText(Msg.get("ui.widgetSupport"));
        this.mediaRSS.setText(Msg.get("ui.mediaRSS"));
        this.mediaRSS.setToolTipText(Msg.get("ui.mediaRSSToolTip"));
        this.pageExtensionLabel.setText(Msg.get("ui.pageExtension"));
        this.userVariablesTable.setToolTipText(Msg.get("ui.userVariablesToolTip"));
        this.encodingLabel.setText(Msg.get("ui.encoding"));
        this.writeUTF8.setText(Msg.get("ui.writeUTF8"));
        this.writeUTF8.setToolTipText(Msg.get("ui.writeUTF8ToolTip"));
        this.textEncoding.setToolTipText(Msg.get("ui.textEncodingToolTip"));
        this.userVariablesTable.setHeaderNames(Msg.get("ui.userVariablesNameColumn"), Msg.get("ui.userVariablesValueColumn"));
        TableColumnModel cm = this.userVariablesTable.getColumnModel();
        cm.getColumn(0).setMinWidth(60);
        cm.getColumn(0).setPreferredWidth(100);
        cm.getColumn(0).setMaxWidth(300);
    }

    private void renameTab(JComponent comp, String newName) {
        int index = this.buttonBarPane.indexOfTab(comp);
        if (index != -1) {
            this.buttonBarPane.setTitleAt(index, newName);
        }
    }

    private void renameAdvancedTab(Component comp, String newName) {
        for (int i = 0; i < this.advancedPanel.getTabCount(); ++i) {
            Component c = this.advancedPanel.getComponentAt(i);
            if (c != comp) continue;
            this.advancedPanel.setTitleAt(i, newName);
            break;
        }
    }

    String getImageSize() {
        return this.imageSize.getSelectedItem().toString();
    }

    void setImageSize(String size) {
        this.imageSize.setSelectedItem(size);
    }

    String getThumbsSize() {
        return this.thumbSize.getSelectedItem().toString();
    }

    void setThumbsSize(String size) {
        this.thumbSize.setSelectedItem(size);
    }

    boolean isCopyOriginals() {
        return this.copyOriginals.isSelected();
    }

    String getDirectory() {
        return this.generalPanel.directory.getText();
    }

    String getOutputDirectory() {
        return this.generalPanel.outputDirectory.getText();
    }

    public JWebBrowser getSkinSettingsBrowser() {
        if (this.skinSettingsBrowser == null) {
            WebBrowser browser = Browsers.create();
            this.skinSettingsBrowser = new JWebBrowser(browser);
        }
        return this.skinSettingsBrowser;
    }

    class SkinUIIndirection {
        JComponent skinUI;

        SkinUIIndirection() {
        }
    }

    private static class JWiderComboBox
    extends JComboBox {
        public JWiderComboBox(Object[] items) {
            super(items);
            Dimension dim = this.getPreferredSize();
            dim.width += 6;
            this.setPreferredSize(dim);
        }
    }

    private class VariantPreset
    extends AbstractAction {
        Variant[] thVariants;
        Variant[] imVariants;

        public VariantPreset(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Variant> variants = JSettingsWindow.this.parent.engine.getThumbVariantList();
            variants.clear();
            OutputFormat altFormat = OutputFormat.getAlternative();
            for (Variant v : this.thVariants) {
                if (v.getScale() == 1.0f && altFormat == v.getFormat() && JSettingsWindow.this.outputFormat.getSelectedItem() == altFormat) continue;
                variants.add(v);
            }
            JSettingsWindow.this.thumbVariants.dataChanged();
            variants = JSettingsWindow.this.parent.engine.getImageVariantList();
            variants.clear();
            for (Variant v : this.imVariants) {
                if (v.getScale() == 1.0f && altFormat == v.getFormat() && JSettingsWindow.this.outputFormat.getSelectedItem() == altFormat) continue;
                variants.add(v);
            }
            JSettingsWindow.this.imageVariants.dataChanged();
        }

        public VariantPreset thumbs(Variant ... thVariants) {
            this.thVariants = thVariants;
            return this;
        }

        public VariantPreset images(Variant ... imVariants) {
            this.imVariants = imVariants;
            return this;
        }
    }

    static class NumericVerifier
    extends InputVerifier {
        NumericVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            JTextField tf = (JTextField)input;
            try {
                Integer.parseInt(tf.getText());
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
    }

    private static class SmartComboBoxModel
    implements ComboBoxModel {
        private ComboBoxModel theModel;

        public SmartComboBoxModel(JComboBox comp) {
            this.theModel = comp.getModel();
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if ("...".equals(anItem.toString())) {
                anItem = "";
            }
            this.theModel.setSelectedItem(anItem);
        }

        @Override
        public Object getSelectedItem() {
            Object item = this.theModel.getSelectedItem();
            return item;
        }

        @Override
        public int getSize() {
            return this.theModel.getSize();
        }

        @Override
        public Object getElementAt(int index) {
            return this.theModel.getElementAt(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.theModel.addListDataListener(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.theModel.removeListDataListener(l);
        }
    }

    private static class DimensionComboBoxEditor
    extends BasicComboBoxEditor {
        private DimensionComboBoxEditor() {
        }

        @Override
        protected JTextField createEditorComponent() {
            JFormattedTextField editor = new JFormattedTextField(new DimensionFormatter());
            editor.setColumns(6);
            return editor;
        }

        @Override
        public Object getItem() {
            try {
                JFormattedTextField f = (JFormattedTextField)this.editor;
                return f.getFormatter().valueToString(f.getFormatter().stringToValue(this.editor.getText()));
            }
            catch (ClassCastException | ParseException ex) {
                return super.getItem();
            }
        }
    }
}

