/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.adobe.internal.xmp.XMPException;
import com.github.cliftonlabs.json_simple.JsonArray;
import com.github.cliftonlabs.json_simple.JsonException;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsoner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.script.ScriptException;
import net.jalbum.Rendition;
import net.jalbum.util.Profiler;
import net.jalbum.views.View;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.CategoryCounters;
import se.datadosen.jalbum.CircularFolderReferenceException;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Flag;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.WebLocation;
import se.datadosen.jalbum.XmpManager;
import se.datadosen.util.DigestUtil;
import se.datadosen.util.IO;
import se.datadosen.util.MyJSONObject;
import se.datadosen.util.Scope;
import se.datadosen.util.TargetPage;

public class JSONMaker {
    public static Predicate<AlbumObject> ALL_FILTER = ao -> true;
    public static Predicate<AlbumObject> NO_VIEWS_FILTER = ao -> !ao.isView();
    private AlbumBean engine;
    private int paging = 0;
    private String[] includes = new String[0];
    private boolean makeTree = true;
    private BiConsumer<AlbumObject, MyJSONObject> consumer;
    private List<Future> futures = new ArrayList<Future>();
    private boolean includeLocation = true;
    private Predicate<AlbumObject> filter = ALL_FILTER;
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'");
    private boolean prettyPrint;

    public int getPaging() {
        return this.paging;
    }

    public void setPaging(int paging) {
        this.paging = paging;
    }

    public boolean isMakeTree() {
        return this.makeTree;
    }

    public void setMakeTree(boolean makeTree) {
        this.makeTree = makeTree;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public Predicate<AlbumObject> getFilter() {
        return this.filter;
    }

    public void setFilter(Predicate<AlbumObject> filter) {
        this.filter = filter != null ? filter : ALL_FILTER;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public JSONMaker(AlbumBean engine) {
        this.engine = engine;
        this.init();
    }

    public boolean isIncludeLocation() {
        return this.includeLocation;
    }

    public void setIncludeLocation(boolean includeLocation) {
        this.includeLocation = includeLocation;
    }

    public void forEach(BiConsumer<AlbumObject, MyJSONObject> consumer) {
        this.consumer = consumer;
    }

    public JSONMaker(AlbumBean engine, File configFile) throws FileNotFoundException, IOException {
        this.engine = engine;
        this.init();
        try (FileReader reader = new FileReader(configFile);){
            try {
                JsonObject config = (JsonObject)Jsoner.deserialize((Reader)reader);
                if (config.containsKey((Object)"paging")) {
                    this.setPaging(((BigDecimal)config.get((Object)"paging")).intValue());
                }
                if (config.containsKey((Object)"include")) {
                    JsonArray includes = (JsonArray)config.get((Object)"include");
                    this.setIncludes((String[])includes.toArray((Object[])new String[includes.size()]));
                }
                if (config.containsKey((Object)"makeTree")) {
                    this.setMakeTree((Boolean)config.get((Object)"makeTree"));
                }
                if (config.containsKey((Object)"prettyPrint")) {
                    this.setPrettyPrint((Boolean)config.get((Object)"prettyPrint"));
                }
            }
            catch (JsonException ex) {
                JAlbum.logger.warning(ex.toString());
            }
        }
        JAlbum.logger.finer("Using paging: " + this.getPaging());
    }

    public String getTreeAsString(AlbumObject rootFolder) throws IOException {
        return this.toJson(this.getTree(rootFolder));
    }

    public MyJSONObject getTree(AlbumObject rootFolder) throws IOException {
        if (rootFolder.getVars() == null) {
            try {
                this.engine.registerVariables(rootFolder, this.engine.rootOutputDir, false);
            }
            catch (ScriptException ex) {
                throw new RuntimeException(ex);
            }
        }
        MyJSONObject rootNode = this.createJsonObject(rootFolder, true);
        this.getTree(rootFolder, rootNode);
        return rootNode;
    }

    void makeDataPages(AlbumObject folder, File outputDir, AlbumObject[] allObjects) throws IOException {
        try (Profiler.Sample _s = Profiler.profile();){
            MyJSONObject current = this.createJsonObject(folder);
            current.remove("category");
            MyJSONObject album = new MyJSONObject();
            album.putNotEmpty("title", this.engine.root.getTitle());
            album.putNotEmpty("description", this.engine.root.getComment());
            current.putNotEmpty("album", (Object)album);
            if (this.paging == 0) {
                this.makeDataPage(current, outputDir, allObjects, 0);
            } else {
                for (int page = 0; page <= (allObjects.length - 1) / this.paging; ++page) {
                    this.makeDataPage(current, outputDir, allObjects, page);
                }
            }
        }
    }

    private void makeDataPage(MyJSONObject current, File outputDir, AlbumObject[] allObjects, int page) throws IOException {
        TargetPage dataPage = new TargetPage(new File(outputDir, this.getPageName(page)));
        JsonArray objects = new JsonArray();
        int last = allObjects.length;
        if (this.paging != 0) {
            last = (page + 1) * this.paging;
        }
        for (int i = this.paging * page; i < last && i < allObjects.length; ++i) {
            AlbumObject ao = allObjects[i];
            if (!ao.isIncluded()) continue;
            objects.add((Object)this.createJsonObject(ao));
        }
        current.put("objects", objects);
        if (this.paging != 0) {
            JsonObject pg = new JsonObject();
            if (page > 0) {
                pg.put((Object)"previous", (Object)this.getPageName(page - 1));
            }
            if (page < (allObjects.length - 1) / this.paging) {
                pg.put((Object)"next", (Object)this.getPageName(page + 1));
            }
            current.putNotEmpty("paging", pg);
        }
        this.futures.add(dataPage.writeChangesBg(this.toJson(current), "UTF-8"));
    }

    private void waitUntilDoneWritingPages() throws IOException {
        for (Future f : this.futures) {
            try {
                f.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                if (ex.getCause() instanceof IOException) {
                    throw (IOException)ex.getCause();
                }
                throw new IOException(ex.getCause());
            }
        }
        this.futures.clear();
    }

    private String getPageName(int page) {
        return "data" + (page + 1) + ".json";
    }

    private MyJSONObject createJsonObject(AlbumObject ao) throws CircularFolderReferenceException {
        return this.createJsonObject(ao, false);
    }

    private String getTargetName(AlbumObject ao) {
        if (ao.isFolder()) {
            return ao.getName();
        }
        return this.engine.getTargetName(ao.getFile());
    }

    private MyJSONObject createJsonObject(AlbumObject ao, boolean treeStyle) throws CircularFolderReferenceException {
        MyJSONObject obj = new MyJSONObject();
        String targetName = ao.getWebName();
        obj.put("name", targetName);
        if (ao.isFolder()) {
            obj.put("path", IO.parentOf((String)ao.getVars().get("closeupPath")));
            if (this.engine.isLinkInternally(ao)) {
                obj.put("internalLink", true);
            }
        } else {
            obj.put("path", IO.urlEncode(targetName));
        }
        if (ao.getCategory() == Category.webLocation) {
            try {
                WebLocation wl = new WebLocation(ao.getFile());
                obj.put("path", wl.getURI().toASCIIString());
            }
            catch (IOException wl) {
                // empty catch block
            }
        }
        if (ao.isHidden()) {
            obj.put("hidden", "true");
        }
        if (!treeStyle) {
            obj.put("category", ao.getCategory().name());
        }
        obj.putNotEmpty("title", ao.getTitle());
        obj.putNotEmpty("comment", ao.getComment());
        obj.put("fileDate", this.dateFormatter.format(new Date(ao.getFile().lastModified())));
        obj.putNotEmpty("rating", ao.getRating());
        if (ao.getFlag() != Flag.NoFlag) {
            obj.put("flag", ao.getFlag().name());
        }
        obj.put("keywords", ao.getKeywords().split(",\\s?"));
        XmpManager xmp = ao.getXmpManager();
        if (xmp != null) {
            try {
                obj.putNotEmpty("creator", xmp.getCreator());
                obj.putNotEmpty("rights", xmp.getRights());
                obj.putNotEmpty("rightsURL", xmp.getRightsURL());
                obj.putNotEmpty("projectionType", xmp.getXMPMeta().getPropertyString("http://ns.google.com/photos/1.0/panorama/", "ProjectionType"));
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        Scope vars = ao.getVars();
        Map<String, Object> locals = ao.getParent() == null ? vars : vars.getMap();
        for (String var : this.includes) {
            Object value = locals.get(var);
            if (value instanceof Enum) {
                value = ((Enum)value).name();
            }
            obj.putNotEmpty(var, value);
        }
        if (ao.getCategory() != Category.webPage) {
            if (!ao.isFolder()) {
                MyJSONObject image = new MyJSONObject();
                image.putNotEmpty("path", vars.get("imagePath"));
                image.putNotEmpty("width", vars.get("imageWidth"));
                image.putNotEmpty("height", vars.get("imageHeight"));
                JSONMaker.addRenditions(image, (List)vars.get("imageRenditions"));
                obj.putNotEmpty("image", (Object)image);
            }
            if (ao.getCategory() != Category.webLocation) {
                MyJSONObject original = new MyJSONObject();
                original.putNotEmpty("path", vars.get("originalPath"));
                if (!original.isEmpty()) {
                    original.putNotEmpty("width", vars.get("originalWidth"));
                    original.putNotEmpty("height", vars.get("originalHeight"));
                }
                obj.putNotEmpty("original", (Object)original);
            }
        }
        MyJSONObject thumb = new MyJSONObject();
        thumb.putNotEmpty("path", vars.get("thumbPath"));
        thumb.putNotEmpty("width", vars.get("thumbWidth"));
        thumb.putNotEmpty("height", vars.get("thumbHeight"));
        JSONMaker.addRenditions(thumb, (List)vars.get("thumbRenditions"));
        obj.putNotEmpty("thumb", (Object)thumb);
        if (ao.isFolder()) {
            MyJSONObject theme = new MyJSONObject();
            if (ao.getVars().containsKey("themePath")) {
                theme.putNotEmpty("path", vars.get("themePath"));
                theme.putNotEmpty("width", vars.get("themeWidth"));
                theme.putNotEmpty("height", vars.get("themeHeight"));
            }
            obj.putNotEmpty("theme", (Object)theme);
            if (!treeStyle) {
                obj.put("deepCounters", this.createCounters(ao, true));
            }
            obj.put("counters", this.createCounters(ao, false));
            View viewObject = (View)vars.get("view");
            if (viewObject != null) {
                MyJSONObject view = new MyJSONObject();
                view.put("type", viewObject.getClass().getSimpleName());
                obj.put("view", (Object)view);
            }
        } else {
            obj.put("fileSize", ao.getFile().length());
        }
        switch (ao.getCategory()) {
            case image: {
                obj.putNotEmpty("camera", (Object)this.createCamera(ao));
                break;
            }
            case video: {
                obj.putNotEmpty("video", (Object)this.createVideo(ao));
            }
        }
        if (!treeStyle && this.consumer != null) {
            this.consumer.accept(ao, obj);
        }
        return obj;
    }

    private JsonObject createCounters(AlbumObject folder, boolean deep) throws CircularFolderReferenceException {
        CategoryCounters cnt = JAlbumUtilities.countCategories(folder, deep);
        MyJSONObject counters = new MyJSONObject();
        counters.putNotEmpty("total", cnt.getTotalCount());
        counters.putNotEmpty("files", cnt.getFileCount());
        counters.putNotEmpty("folders", cnt.getCount(Category.folder));
        counters.putNotEmpty("images", cnt.getCount(Category.image));
        counters.putNotEmpty("videos", cnt.getCount(Category.video));
        counters.putNotEmpty("audios", cnt.getCount(Category.audio));
        counters.putNotEmpty("webPages", cnt.getCount(Category.webPage));
        counters.putNotEmpty("others", cnt.getCount(Category.other));
        return counters;
    }

    private MyJSONObject createCamera(AlbumObject ao) {
        MyJSONObject camera = new MyJSONObject();
        Scope vars = ao.getVars();
        if (ao.getMetadata().cameraDate > 0L) {
            camera.putNotEmpty("originalDate", this.dateFormatter.format(new Date(ao.getMetadata().cameraDate)));
        }
        this.putVar("resolution", vars, camera);
        this.putVar("flash", vars, camera);
        this.putVar("focalLength", vars, camera);
        this.putVar("focalLength35mm", vars, camera);
        this.putVar("exposureTime", vars, camera);
        this.putVar("aperture", vars, camera);
        this.putVar("focusDistance", vars, camera);
        this.putVar("cameraMake", vars, camera);
        this.putVar("cameraModel", vars, camera);
        this.putVar("isoEquivalent", vars, camera);
        if (this.includeLocation) {
            camera.putNotEmpty("location", (Object)this.createLocation(ao));
        }
        return camera;
    }

    private void putVar(String name, Scope vars, MyJSONObject json) {
        json.putNotEmpty(name, vars.get(name));
    }

    private MyJSONObject createVideo(AlbumObject ao) {
        MyJSONObject video = new MyJSONObject();
        Scope vars = ao.getVars();
        video.putNotEmpty("fps", vars.get("videoFPS"));
        if (vars.containsKey("videoDuration")) {
            video.putNotEmpty("duration", vars.get("videoDuration").toString());
        }
        video.putNotEmpty("path", ao.getVars().get("originalPath"));
        video.putNotEmpty("height", vars.get("videoHeight"));
        video.putNotEmpty("width", vars.get("videoWidth"));
        return video;
    }

    private MyJSONObject createLocation(AlbumObject ao) {
        MyJSONObject gps = new MyJSONObject();
        Scope vars = ao.getVars();
        String loc = (String)vars.get("gpsLocation");
        if (loc != null) {
            String[] tokens = loc.split(",");
            gps.put("lat", Float.valueOf(Float.parseFloat(tokens[0])));
            gps.put("long", Float.valueOf(Float.parseFloat(tokens[1])));
        }
        gps.putNotEmpty("longitude", vars.get("gpsLongitude"));
        gps.putNotEmpty("latitude", vars.get("gpsLatitude"));
        gps.putNotEmpty("altitude", vars.get("gpsAltitude"));
        return gps;
    }

    void makeTree(AlbumObject rootFolder, File outputDir) throws IOException {
        try (Profiler.Sample _s = Profiler.profile();){
            TargetPage treePage = new TargetPage(new File(outputDir, "tree.json"));
            MyJSONObject rootNode = this.createJsonObject(rootFolder, true);
            this.makeTree(rootFolder, rootNode);
            treePage.writeChangesBg(this.toJson(rootNode), "UTF-8");
        }
    }

    void makeTree(AlbumObject folder, MyJSONObject node) throws IOException {
        JsonArray children = new JsonArray();
        for (AlbumObject ao : folder.getChildren()) {
            if (!ao.isIncluded() || !ao.isFolder()) continue;
            MyJSONObject child = this.createJsonObject(ao, true);
            this.makeTree(ao, child);
            children.add((Object)child);
        }
        node.putNotEmpty("folders", children);
    }

    private void getTree(AlbumObject folder, MyJSONObject node) throws CircularFolderReferenceException {
        JsonArray children = new JsonArray();
        for (AlbumObject ao : folder.getChildren()) {
            if (!ao.isIncluded() || !this.filter.test(ao)) continue;
            MyJSONObject child = this.createJsonObject(ao);
            if (ao.isFolder() && this.makeTree) {
                this.getTree(ao, child);
            }
            children.add((Object)child);
        }
        node.putNotEmpty("objects", children);
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void makeDeepJSONData(File outputDir) throws IOException {
        try (Profiler.Sample _s = Profiler.profile("Making deep-data.json");){
            this.waitUntilDoneWritingPages();
            JsonObject json = this.getDeepJSON(outputDir);
            json.remove((Object)"path");
            json.remove((Object)"fileDate");
            File dest = new File(outputDir, "deep-data.json");
            long lastModified = dest.lastModified();
            String oldMD5 = "";
            if (lastModified > 0L) {
                oldMD5 = DigestUtil.md5(dest);
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new DigestOutputStream(new FileOutputStream(dest), md), Charset.forName("UTF-8"));){
                json.toJson((Writer)writer);
            }
            String newMD5 = DigestUtil.md5(md);
            if (newMD5.equals(oldMD5)) {
                dest.setLastModified(lastModified);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    JsonObject getDeepJSON(File outputDir) throws IOException {
        JsonObject json;
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(new File(outputDir, this.getPageName(0))), "UTF-8");){
            json = (JsonObject)Jsoner.deserialize((Reader)reader);
        }
        catch (JsonException ex) {
            throw new IOException("Error parsing " + String.valueOf(new File(outputDir, this.getPageName(0))), ex);
        }
        json.remove((Object)"album");
        ((List)json.get((Object)"objects")).parallelStream().filter(item -> item.containsKey((Object)"counters")).forEach((? super T item) -> {
            String name = (String)item.get((Object)"name");
            try {
                JsonObject content = this.getDeepJSON(new File(outputDir, name));
                item.putAll((Map)content);
            }
            catch (IOException ex) {
                System.out.println(ex);
            }
        });
        return json;
    }

    private Object stripFirstFolder(String path) {
        int slashIndex = path.indexOf(47);
        if (slashIndex != -1) {
            return path.substring(slashIndex + 1);
        }
        return path;
    }

    private String toJson(JsonObject o) {
        String s = o.toJson();
        return this.prettyPrint ? Jsoner.prettyPrint((String)s) : s;
    }

    private static void addRenditions(MyJSONObject obj, List<Rendition> renditions) {
        if (renditions != null) {
            JsonArray arr = new JsonArray();
            for (Rendition r : renditions) {
                JsonObject o = new JsonObject();
                o.put((Object)"name", (Object)r.getEncodedName());
                o.put((Object)"width", (Object)r.getWidth());
                o.put((Object)"height", (Object)r.getHeight());
                arr.add((Object)o);
            }
            obj.put("renditions", arr);
        }
    }

    private void init() {
        this.prettyPrint = Config.getConfig().isPrettyPrintJSON();
    }
}

