/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.github.cliftonlabs.json_simple.Jsoner;
import java.awt.Color;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.Colors;

class JSONEncoder {
    JSONEncoder() {
    }

    public String serialize(Object o) throws IOException {
        StringBuilder buf = new StringBuilder();
        this.serialize(o, buf, "");
        return buf.toString();
    }

    private void serialize(Object o, StringBuilder buf, String indent) throws IOException {
        Object s = null;
        if (o == null) {
            s = "\"null\"";
        } else if (o instanceof Number || o instanceof Boolean) {
            s = o.toString();
        } else if (o instanceof String || o instanceof Date) {
            s = "\"" + Jsoner.escape((String)o.toString()) + "\"";
        } else if (o instanceof Enum) {
            s = "\"" + ((Enum)o).name() + "\"";
        } else if (o instanceof Color) {
            s = "\"" + Colors.toRGBAHexColor((Color)o) + "\"";
        }
        if (s != null) {
            buf.append((String)s);
        } else if (o instanceof Map) {
            buf.append("{\n");
            for (Map.Entry e : ((Map)o).entrySet()) {
                buf.append(indent + "  ");
                buf.append('\"').append(e.getKey().toString()).append('\"').append(": ");
                this.serialize(e.getValue(), buf, indent + "  ");
                buf.append(",\n");
            }
            buf.delete(buf.length() - 2, buf.length());
            buf.append('\n').append(indent).append('}');
        } else if (o instanceof List) {
            buf.append("[\n");
            for (Object item : (List)o) {
                buf.append(indent + "  ");
                this.serialize(item, buf, indent + "  ");
                buf.append(",\n");
            }
            buf.delete(buf.length() - 2, buf.length());
            buf.append('\n').append(indent).append(']');
        } else {
            try {
                Map<String, Object> def = BeanBinder.getMap(o.getClass().getConstructor(new Class[0]).newInstance(new Object[0]));
                def.remove("class");
                Map<String, Object> props = BeanBinder.getMap(o);
                props.put("class", o.getClass().getName());
                buf.append("{\n");
                for (Map.Entry<String, Object> e : props.entrySet()) {
                    if (e.getValue().equals(def.get(e.getKey()))) continue;
                    buf.append(indent + "  ");
                    buf.append('\"').append(e.getKey().toString()).append('\"').append(": ");
                    this.serialize(e.getValue(), buf, indent + "  ");
                    buf.append(",\n");
                }
                buf.delete(buf.length() - 2, buf.length());
                buf.append('\n').append(indent).append('}');
            }
            catch (ReflectiveOperationException ex) {
                buf.append('\"').append(o.toString()).append('\"');
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
    }
}

