/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import se.datadosen.explorer.JCopyWarningDialog;
import se.datadosen.io.CachedFile;
import se.datadosen.io.RenamedFile;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.BackupRestoreBase;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.FileCopier;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.util.ContextHelp;
import se.datadosen.util.LambdaAction;
import se.datadosen.util.annotations.Text;

public final class JRestoreFrame
extends BackupRestoreBase {
    @Text(value="ui.restoreSelected")
    Action restoreSelectedAction = new LambdaAction(ae -> this.restoreProjects(this.getSelectedProjects()));
    @Text(value="ui.restoreAll")
    Action restoreAllAction = new LambdaAction(ae -> this.restoreProjects(this.model.projects));
    JButton restoreSelectedButton = new JButton(this.restoreSelectedAction);
    JButton restoreAllButton = new JButton(this.restoreAllAction);
    Thread gatheringThread = new Thread(() -> this.gatherAllProjects());

    private List<AlbumProject> filterCollissionFiles(List<AlbumProject> projects, AlbumObject target) throws OperationAbortedException {
        CopyDecision copyDecision = CopyDecision.UNDECIDED;
        ArrayList<AlbumProject> filtered = new ArrayList<AlbumProject>();
        for (AlbumProject ap : projects) {
            CopyDecision decision = copyDecision;
            File f = ap.getRootFolder().getFile();
            if (target.containsName(f.getName()) && !f.getParentFile().equals(target.getFile()) && copyDecision == CopyDecision.UNDECIDED) {
                JCopyWarningDialog confirmDialog = new JCopyWarningDialog(this, Msg.get("ui.restoreProjects"), f);
                confirmDialog.setVisible(true);
                if (confirmDialog.buttonPressed == confirmDialog.replaceButton) {
                    decision = CopyDecision.COPY;
                } else if (confirmDialog.buttonPressed == confirmDialog.dontReplaceButton) {
                    decision = CopyDecision.SKIP;
                } else if (confirmDialog.buttonPressed == confirmDialog.keepBothButton) {
                    decision = CopyDecision.KEEPBOTH;
                } else {
                    throw new OperationAbortedException();
                }
                if (confirmDialog.applyToAll.isSelected()) {
                    copyDecision = decision;
                }
            }
            if (decision == CopyDecision.KEEPBOTH) {
                AlbumProject renamedAP = new AlbumProject(ap.getProjectFile(), this.context.getAlbumObjectfactory().createInstance(new RenamedFile(target.getUniqueName(f.getName()), f)));
                filtered.add(renamedAP);
                continue;
            }
            if (decision == CopyDecision.SKIP) continue;
            filtered.add(ap);
        }
        return filtered;
    }

    private void restoreProjects(List<AlbumProject> projects) {
        File myAlbumsDir = new File(Config.getConfig().getMyAlbumsLocation());
        myAlbumsDir.mkdirs();
        AlbumObject destFolder = this.context.getAlbumObjectfactory().createInstance(myAlbumsDir);
        try {
            projects = this.filterCollissionFiles(projects, destFolder);
            FileCopier copier = new FileCopier(this);
            copier.setMillisToPopup(0);
            copier.setFileFilter(null);
            copier.setAllowDuplicates(true);
            for (AlbumProject ap : projects) {
                copier.setTitle(Msg.get("ui.restoringX", ap.getName()));
                List<File> copied = copier.copyFiles(List.of(ap.getRootFolder().getFile()), destFolder);
                if (copier.isAborted()) {
                    return;
                }
                for (File f : copied) {
                    File projFile = new File(f, ap.getProjectFile().getName());
                    SwingUtilities.invokeLater(() -> this.context.getFrame().loadProject(projFile));
                }
            }
        }
        catch (OperationAbortedException operationAbortedException) {
            // empty catch block
        }
    }

    public JRestoreFrame(JAlbumContext context) {
        super(Msg.get("ui.restoreProjects"), context);
        this.init();
    }

    protected void gatherAllProjects() {
        File backupDir = new File(this.backupDirectory.getText());
        if (backupDir.exists()) {
            for (File projDir : backupDir.listFiles(f -> f.isDirectory())) {
                Optional<CachedFile> firstFound;
                File projFile = new File(projDir, "jalbum-settings.jap");
                if (!projFile.exists() && (firstFound = Stream.of(CachedFile.listFiles(projDir)).filter(f -> f.getName().endsWith(".jap")).findFirst()).isPresent()) {
                    projFile = firstFound.get();
                }
                if (!projFile.exists()) continue;
                try {
                    AlbumProject ap = new AlbumProject(projFile, this.context.getAlbumObjectfactory());
                    this.model.addProject(ap);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            SwingUtilities.invokeLater(() -> this.model.fireTableDataChanged());
        }
    }

    @Override
    protected void init() {
        Msg.maintainTranslated(this);
        super.init();
        ContextHelp help = ContextHelp.getInstance();
        help.installHelpButton(this, ContextHelp.Corner.TOP_RIGHT);
        help.add((JComponent)this.getContentPane(), "https://jalbum.net/help/JAlbum/Menus#Restore_projects...");
        this.buttonPanel.add(this.restoreSelectedButton);
        this.buttonPanel.add(this.restoreAllButton);
        this.buttonPanel.add(this.closeButton);
        this.getRootPane().setDefaultButton(this.restoreSelectedButton);
        this.table.getSelectionModel().addListSelectionListener(e -> {
            int[] selRows = this.table.getSelectedRows();
            this.restoreSelectedAction.setEnabled(selRows.length > 0);
        });
        this.backupDirectory.setEditable(false);
        this.backupDirectorySelector.addActionListener(ae -> {
            this.gatheringThread.interrupt();
            try {
                this.gatheringThread.join();
                this.model.clear();
                this.model.fireTableDataChanged();
                this.gatheringThread = new Thread(() -> this.gatherAllProjects());
                this.gatheringThread.start();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        this.gatheringThread.start();
        this.pack();
    }

    private static enum CopyDecision {
        UNDECIDED,
        COPY,
        SKIP,
        KEEPBOTH;

    }
}

