/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import net.jalbum.undo.UndoHandler;
import net.jalbum.undo.UndoableGroupEdit;
import se.datadosen.component.ComponentUtilities;
import se.datadosen.component.RiverLayout;
import se.datadosen.component.StateMonitor;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.Platform;
import se.datadosen.util.annotations.Text;

public class JRenameDialog
extends JDialog {
    private static JRenameDialog theInstance;
    AlbumObject sampleObject;
    DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH.mm.ss");
    private List<AlbumObject> selectedObjects;
    ComboBoxModel<Mode> mode = new DefaultComboBoxModel<Mode>(Mode.values());
    ComboBoxModel<Position> addPosition = new DefaultComboBoxModel<Position>(Position.values());
    JPanel centerPanel = new JPanel(new BorderLayout());
    Panel replacePanel = new Panel();
    Panel addTextPanel = new Panel();
    Panel addKeywordsPanel = new Panel();
    Panel formatPanel = new Panel();
    @Text(value="rename.example", postfix=": ")
    JLabel examplePromptLabel = new JLabel();
    JLabel exampleLabel = new JLabel("              ");
    @Text(value="rename.find")
    JLabel findLabel = new JLabel();
    JTextField findText = new JTextField(12);
    @Text(value="rename.replaceWith")
    JLabel replaceLabel = new JLabel();
    JTextField replaceText = new JTextField(12);
    JTextField addText = new JTextField(12);
    @Text(value="rename.nameFormat")
    JLabel nameFormatLabel = new JLabel();
    JComboBox<NameFormat> nameFormat = new JComboBox<NameFormat>(NameFormat.values());
    @Text(value="rename.where")
    JLabel whereLabel = new JLabel();
    JComboBox<Position> where = new JComboBox<Position>(Position.values());
    @Text(value="rename.customFormat")
    JLabel customFormatLabel = new JLabel();
    JTextField customFormat = new JTextField(12);
    @Text(value="rename.startNumbersAt")
    JLabel startNumbersAtLabel = new JLabel();
    JSpinner startNumbersAt = new JSpinner(new SpinnerNumberModel(1, 0, 99999, 1));
    @Text(value="cancel")
    Action cancelAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JRenameDialog.this.cleanup();
            JRenameDialog.this.setVisible(false);
        }
    };
    @Text(value="edit.renameFile")
    Action renameAction = new AbstractAction(){
        SwingWorker<Void, Void> worker;
        ProgressMonitor monitor;
        int nItems;
        int index;
        UndoableGroupEdit groupEdit;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            JRenameDialog.this.cancelAction.setEnabled(false);
            this.nItems = JRenameDialog.this.selectedObjects.size();
            this.groupEdit = new UndoableGroupEdit(Msg.get("rename.renameNItems", this.nItems));
            this.monitor = new ProgressMonitor(JRenameDialog.this, Msg.get("rename.renamingNItems", this.nItems), "", 1, this.nItems);
            this.index = 0;
            this.worker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    UndoHandler.getInstance().undoableEditHappened(this, groupEdit);
                    int start = (Integer)JRenameDialog.this.startNumbersAt.getValue();
                    for (AlbumObject ao : JRenameDialog.this.selectedObjects) {
                        monitor.setProgress(index);
                        monitor.setNote(ao.getName());
                        String suggestedName = JRenameDialog.this.createName(ao, start + index);
                        while (!ao.setName(suggestedName)) {
                            if (monitor.isCanceled()) {
                                return null;
                            }
                            if (JRenameDialog.this.getMode() == Mode.FORMAT && JRenameDialog.this.nameFormat.getSelectedItem() == NameFormat.NAME_AND_DATE) {
                                ao.setName(ao.getParent().getUniqueName(suggestedName));
                                break;
                            }
                            ++index;
                        }
                        ++index;
                    }
                    monitor.setProgress(index);
                    return null;
                }

                @Override
                protected void done() {
                    monitor.close();
                    groupEdit.end();
                    UndoHandler.getInstance().update();
                    this.setEnabled(true);
                    JRenameDialog.this.cancelAction.setEnabled(true);
                    try {
                        this.get();
                        JRenameDialog.this.cleanup();
                        JRenameDialog.this.setVisible(false);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException ex) {
                        Debug.showStackTraceDialog(JRenameDialog.this, ex.getCause());
                    }
                }
            };
            this.worker.execute();
        }
    };

    public static void show(JAlbumFrame window, List<AlbumObject> selectedObjects) {
        if (theInstance == null) {
            theInstance = new JRenameDialog(window, selectedObjects);
        } else {
            theInstance.init(selectedObjects);
        }
    }

    Mode getMode() {
        return (Mode)((Object)this.mode.getSelectedItem());
    }

    private void cleanup() {
        this.sampleObject = null;
        this.selectedObjects = null;
    }

    private JRenameDialog(JAlbumFrame window, List<AlbumObject> selectedObjects) {
        super(window, Msg.get("edit.renameFile"), true);
        Msg.maintainTranslated(this);
        this.sampleObject = selectedObjects.get(0);
        this.selectedObjects = selectedObjects;
        Box outer = Box.createVerticalBox();
        this.setContentPane(outer);
        outer.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        this.replacePanel.add(new JComboBox<Mode>(this.mode));
        this.replacePanel.add("br", this.findLabel);
        this.replacePanel.add(this.findText);
        this.replacePanel.add(Box.createHorizontalStrut(10));
        this.replacePanel.add(this.replaceLabel);
        this.replacePanel.add(this.replaceText);
        this.addTextPanel.add(new JComboBox<Mode>(this.mode));
        this.addTextPanel.add(this.addText);
        this.addTextPanel.add(new JComboBox<Position>(this.addPosition));
        this.addKeywordsPanel.add(new JComboBox<Mode>(this.mode));
        this.addKeywordsPanel.add(new JComboBox<Position>(this.addPosition));
        this.formatPanel.add(new JComboBox<Mode>(this.mode));
        this.formatPanel.add("br label", this.nameFormatLabel);
        this.formatPanel.add("tab", this.nameFormat);
        this.formatPanel.add(Box.createHorizontalStrut(20));
        this.formatPanel.add("tab label", this.whereLabel);
        this.formatPanel.add("tab label", this.where);
        this.formatPanel.add("br label", this.customFormatLabel);
        this.formatPanel.add("tab", this.customFormat);
        this.formatPanel.add("tab label", this.startNumbersAtLabel);
        this.formatPanel.add("tab", this.startNumbersAt);
        this.centerPanel.add(this.replacePanel);
        new StateMonitor(this.mode){

            @Override
            public void onChange() {
                JRenameDialog.this.centerPanel.removeAll();
                switch (JRenameDialog.this.getMode().ordinal()) {
                    case 0: {
                        JRenameDialog.this.centerPanel.add(JRenameDialog.this.replacePanel);
                        JRenameDialog.this.findText.requestFocusInWindow();
                        break;
                    }
                    case 1: {
                        JRenameDialog.this.centerPanel.add(JRenameDialog.this.addTextPanel);
                        JRenameDialog.this.addText.requestFocusInWindow();
                        break;
                    }
                    case 2: {
                        JRenameDialog.this.centerPanel.add(JRenameDialog.this.addKeywordsPanel);
                        JRenameDialog.this.addText.requestFocusInWindow();
                        break;
                    }
                    case 3: {
                        JRenameDialog.this.centerPanel.add(JRenameDialog.this.formatPanel);
                        JRenameDialog.this.customFormat.requestFocusInWindow();
                    }
                }
                JRenameDialog.this.pack();
            }
        };
        ComponentUtilities.whenEqualsDisable(this.nameFormat, (Object)NameFormat.NAME_AND_DATE, (JComponent)this.startNumbersAt);
        outer.add(this.centerPanel);
        outer.add(new JSeparator());
        Panel buttonPanel = new Panel();
        buttonPanel.add(this.examplePromptLabel);
        buttonPanel.add(this.exampleLabel);
        buttonPanel.add("hfill", Box.createHorizontalGlue());
        buttonPanel.add("right", new JButton(this.cancelAction));
        JButton renameButton = new JButton(this.renameAction);
        buttonPanel.add(renameButton);
        this.getRootPane().setDefaultButton(renameButton);
        outer.add(buttonPanel);
        new StateMonitor(){

            @Override
            public void onChange() {
                JRenameDialog.this.updateUI();
            }
        }.add(this.findText, this.replaceText, this.addText, this.nameFormat, this.where, this.customFormat, this.startNumbersAt).add(this.mode).add(this.addPosition);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JRenameDialog.this.cancelAction.actionPerformed(null);
            }
        });
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JLayeredPane pane = this.getLayeredPane();
        pane.registerKeyboardAction(this.cancelAction, "close", ks, 2);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.init(selectedObjects);
    }

    private void updateUI() {
        try {
            String sampleName = this.createName(this.sampleObject, (Integer)this.startNumbersAt.getValue());
            this.exampleLabel.setText(sampleName);
            if (!this.isValidFileName(sampleName)) {
                this.renameAction.setEnabled(false);
                return;
            }
            switch (this.getMode().ordinal()) {
                case 0: {
                    this.renameAction.setEnabled(!this.findText.getText().isEmpty());
                    break;
                }
                case 1: {
                    this.renameAction.setEnabled(!this.addText.getText().isEmpty());
                    break;
                }
                case 2: {
                    this.renameAction.setEnabled(true);
                    break;
                }
                case 3: {
                    this.renameAction.setEnabled(true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String createName(AlbumObject ao, int number) {
        Object base = IO.baseName(ao.getFile());
        String ext = IO.extensionOf(ao.getFile());
        Object newBase = "";
        switch (this.getMode().ordinal()) {
            case 0: {
                newBase = ((String)base).replaceAll(this.findText.getText(), this.replaceText.getText());
                break;
            }
            case 1: {
                newBase = this.addPosition.getSelectedItem() == Position.AFTER_NAME ? (String)base + this.addText.getText() : this.addText.getText() + (String)base;
                break;
            }
            case 2: {
                String keywords = ao.getKeywords();
                if (keywords.length() == 0) {
                    newBase = base;
                    break;
                }
                newBase = this.addPosition.getSelectedItem() == Position.AFTER_NAME ? (String)base + " " + ao.getKeywords() : ao.getKeywords() + " " + (String)base;
                break;
            }
            case 3: {
                String part = "";
                switch (((NameFormat)((Object)this.nameFormat.getSelectedItem())).ordinal()) {
                    case 0: {
                        part = Integer.toString(number);
                        break;
                    }
                    case 1: {
                        part = String.format("%05d", number);
                        break;
                    }
                    case 2: {
                        part = this.dateFormat.format(new Date(ao.getLastModified()));
                    }
                }
                base = !this.customFormat.getText().isEmpty() ? this.customFormat.getText() : " " + (String)base + " ";
                newBase = (this.where.getSelectedItem() == Position.AFTER_NAME ? (String)base + part : part + (String)base).trim();
            }
        }
        if (ao.getName().indexOf(46) != -1) {
            return (String)newBase + "." + ext;
        }
        return newBase;
    }

    private void init(List<AlbumObject> selectedObjects) {
        this.setTitle(Msg.get("rename.renameNItems", selectedObjects.size()));
        this.sampleObject = selectedObjects.get(0);
        this.selectedObjects = selectedObjects;
        this.updateUI();
        this.pack();
        this.setVisible(true);
    }

    private boolean isValidFileName(String sampleName) {
        if (sampleName.contains(File.pathSeparator) || sampleName.contains(File.separator)) {
            return false;
        }
        try {
            new File(sampleName).getCanonicalPath();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    static enum Mode {
        REPLACE("rename.replaceText"),
        ADD_TEXT("rename.addText"),
        ADD_KEYWORDS("rename.addKeywords"),
        FORMAT("rename.format");

        private String nameKey;

        private Mode(String nameKey) {
            this.nameKey = nameKey;
        }

        public String toString() {
            return Msg.get(this.nameKey);
        }
    }

    static enum Position {
        AFTER_NAME("rename.afterName"),
        BEFORE_NAME("rename.beforeName");

        private String nameKey;

        private Position(String nameKey) {
            this.nameKey = nameKey;
        }

        public String toString() {
            return Msg.get(this.nameKey);
        }
    }

    class Panel
    extends JPanel {
        public Panel() {
            this.setLayout(Platform.isMac() ? new RiverLayout(6, 4) : new RiverLayout());
            this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        }
    }

    static enum NameFormat {
        NAME_AND_INDEX("rename.nameAndIndex"),
        NAME_AND_COUNTER("rename.nameAndCounter"),
        NAME_AND_DATE("rename.nameAndDate");

        private String nameKey;

        private NameFormat(String nameKey) {
            this.nameKey = nameKey;
        }

        public String toString() {
            return Msg.get(this.nameKey);
        }
    }
}

