/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.jalbum.remotefs.RemoteFSDelegate;
import net.jalbum.remotefs.RemoteFSException;
import net.jalbum.remotefs.RemoteFile;
import net.jalbum.resty.web.AbstractContent;
import net.jalbum.resty.web.RobustResty;
import net.miginfocom.swing.MigLayout;
import se.datadosen.component.AutoSelectingTreeCellEditor;
import se.datadosen.component.ChooserFactory;
import se.datadosen.component.CompoundAction;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.DirectoryChooser;
import se.datadosen.component.HBox;
import se.datadosen.component.JBackgroundTextField;
import se.datadosen.component.JCleanToolBar;
import se.datadosen.component.JIconButton;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JNotification;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.component.JSkinLikesPanel;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.JToolBarButton;
import se.datadosen.component.JWizard;
import se.datadosen.component.JWizardStep;
import se.datadosen.component.NonCollapsableJTree;
import se.datadosen.component.RiverLayout;
import se.datadosen.component.StateMonitor;
import se.datadosen.component.Verifier;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumManifest;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAddAccountDialog;
import se.datadosen.jalbum.JAdvancedAccountSettingsDialog;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.JPrivacyDialog;
import se.datadosen.jalbum.JProgressDialog;
import se.datadosen.jalbum.JTransferProgressDialog;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.MyDesktop;
import se.datadosen.jalbum.Notifier;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.OverwriteBlockedException;
import se.datadosen.jalbum.ParameterException;
import se.datadosen.jalbum.RecoveryTool;
import se.datadosen.jalbum.RemoteFSContext;
import se.datadosen.jalbum.RemoteFSNode;
import se.datadosen.jalbum.RemoteFSTreeCellRenderer;
import se.datadosen.jalbum.RemoteFSTreeTransferHandler;
import se.datadosen.jalbum.RemoteFileImpl;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.jalbum.SlowOperation;
import se.datadosen.jalbum.TipOfTheDay;
import se.datadosen.jalbum.Tracer;
import se.datadosen.jalbum.TransferProtocol;
import se.datadosen.jalbum.UploadBean;
import se.datadosen.jalbum.io.FileTreeCollection;
import se.datadosen.jalbum.io.FileTreeProcessor;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Elements;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.Callback;
import se.datadosen.util.ContextHelp;
import se.datadosen.util.DataSizeFormatter;
import se.datadosen.util.Debug;
import se.datadosen.util.DigestUtil;
import se.datadosen.util.IO;
import se.datadosen.util.NamedThreadFactory;
import se.datadosen.util.Platform;
import se.datadosen.util.URLChecker;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

public class JPublishWizard
extends JWizard {
    private static Callback onCreate;
    AccountManager accountManager = AccountManager.getInstance();
    AccountProfile currentAccount;
    AlbumBean engine;
    JAlbumContext context;
    UploadBean uploadBean = new UploadBean();
    RemoteFSNode rootNode;
    Set<String> protectedPaths;
    AccountsStep accountsStep;
    PublishStep publishStep;

    public JPublishWizard(JAlbumContext context) {
        super(context.getFrame(), Msg.get("ui.publishPanel"), true, Icons.get("publish-graphics"));
        this.init(context);
        Msg.maintainTranslated(this);
        context.getFrame().prepareWindow(this);
    }

    protected JPublishWizard(JAlbumContext context, String title) {
        super(context.getFrame(), title, true, Icons.get("publish-graphics"));
        this.init(context);
        Msg.maintainTranslated(this);
    }

    private void init(JAlbumContext context) {
        this.context = context;
        this.engine = context.getEngine();
        this.allowFinish(false);
        this.backAction.putValue("Name", Msg.get("wiz.back"));
        this.cancelAction.putValue("Name", Msg.get("close"));
        this.addSteps();
        if (onCreate != null) {
            onCreate.call(this);
        }
        ContextHelp.getInstance().installHelpButton(this, ContextHelp.Corner.TOP_RIGHT, 6);
        this.getLayeredPane().registerKeyboardAction(context.getFrame().actions.showConsoleWindowAction, "showConsole", KeyStroke.getKeyStroke(118, 0), 2);
    }

    protected void addSteps() {
        this.accountsStep = new AccountsStep();
        this.publishStep = new PublishStep();
        this.addStep(this.accountsStep);
        this.addStep(this.publishStep);
    }

    @Override
    public void setVisible(boolean show) {
        if (show) {
            Tracer.getInstance().trace("open publish window");
        }
        super.setVisible(show);
    }

    public static void setOnCreate(Callback callback) {
        onCreate = callback;
    }

    @Override
    protected void updateTitle() {
        if (this.steps.size() > 1) {
            this.setTitle(this.title + " - " + Msg.get("wiz.stepInfo", this.stepIndex + 1, this.steps.size()));
        } else {
            this.setTitle(this.title);
        }
    }

    @Override
    public void onHide() {
        try {
            this.uploadBean.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.onHide();
    }

    static String showPasswordInputDialog(Component parent, String message, String title, String initialValue) {
        final JPasswordField jpf = new JPasswordField();
        if (initialValue != null) {
            jpf.setText(initialValue);
        }
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new RiverLayout());
        messagePanel.add(new JLabel(message));
        messagePanel.add("br hfill", jpf);
        JOptionPane pane = new JOptionPane(messagePanel, 1, 2, null, null, null);
        JDialog dialog = pane.createDialog(parent, title);
        dialog.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                jpf.requestFocusInWindow();
            }
        });
        dialog.setVisible(true);
        Object val = pane.getValue();
        if (val instanceof Integer && (Integer)val == 0) {
            return new String(jpf.getPassword());
        }
        return null;
    }

    String getFtpWebRootDirectory() {
        if (this.currentAccount.getFtpWebRootDirectory().equals("VALUE_UNSET")) {
            return "VALUE_UNSET";
        }
        return this.currentAccount.isShowServerRootDirectory() ? this.toAbsolute(this.currentAccount.getFtpWebRootDirectory()) : this.toRelative(this.currentAccount.getFtpWebRootDirectory());
    }

    void setFtpWebRootDirectory(String path) {
        this.currentAccount.setFtpWebRootDirectory(this.currentAccount.isShowServerRootDirectory() ? this.toAbsolute(path) : this.toRelative(path));
    }

    String getRemoteDirectory() {
        return this.currentAccount.isShowServerRootDirectory() ? this.toAbsolute(this.uploadBean.getRemoteDirectory()) : this.toRelative(this.uploadBean.getRemoteDirectory());
    }

    void setRemoteDirectory(String path) {
        this.uploadBean.setRemoteDirectory(this.currentAccount.isShowServerRootDirectory() ? path : this.toRelative(path));
    }

    private String toAbsolute(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        return IO.combinePaths(this.uploadBean.getBaseDirectory(), path);
    }

    private String toRelative(String path) {
        if (!path.startsWith("/")) {
            return path;
        }
        String rel = IO.relativePath(path, this.uploadBean.getBaseDirectory());
        if (rel.startsWith("..")) {
            return path;
        }
        if (".".equals(rel)) {
            return "";
        }
        return rel;
    }

    private Window getParentWindow() {
        return this.isVisible() ? this : this.getOwner();
    }

    class AccountsStep
    extends JWizardStep {
        Icon plugIcon;
        Icon serverIcon;
        Icon serverConnectionIcon;
        @se.datadosen.util.annotations.Icon(value="16x16/user_add.svg")
        @Text(value="add")
        Action addAccountAction;
        @se.datadosen.util.annotations.Icon(value="16x16/user_delete.svg")
        @Text(value="remove")
        Action removeAccountAction;
        @se.datadosen.util.annotations.Icon(value="16x16/rename.svg")
        @Text(value="edit.renameFile")
        Action renameAccountAction;
        JList accountList;
        JScrollPane accountsScrollPane;
        ControlPanel currentAccountPanel;
        JLabel webRootURLLabel;
        JBackgroundTextField webRootURL;
        JLabel protocolLabel;
        JComboBox protocol;
        JLabel ftpServerLabel;
        JBackgroundTextField ftpServer;
        JLabel ftpUserNameLabel;
        JTextField ftpUser;
        JLabel ftpPasswordLabel;
        JPasswordField ftpPassword;
        JButton advancedAccountSettingsButton;
        JAdvancedAccountSettingsDialog advancedSettingsDialog;
        Action connectAction;

        private JButton unfocusable(JButton b) {
            b.setFocusable(false);
            return b;
        }

        private String urlToServerName(String url) {
            String name = url.substring(url.indexOf("//") + 2);
            if (name.toLowerCase().startsWith("www.")) {
                name = name.substring(4);
            }
            return name;
        }

        AccountsStep() {
            super(Msg.get("acc.profilesLabel"));
            this.plugIcon = Icons.small("plug");
            this.serverIcon = Icons.get("server_large", 32);
            this.serverConnectionIcon = Icons.get("server_connection_large", 32);
            this.addAccountAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        String activationUrl;
                        JAlbumSite theSite = JAlbumSite.getTrueInstance();
                        String string = activationUrl = (e.getModifiers() & 8) != 0 ? theSite.getMyJAlbumAltActivationUrl() : theSite.getMyJAlbumActivationUrl();
                        if (activationUrl != null && activationUrl.length() > 0) {
                            JAddAccountDialog dialog = new JAddAccountDialog(JPublishWizard.this, true, (e.getModifiers() & 8) != 0);
                            dialog.setVisible(true);
                            return;
                        }
                    }
                    catch (IOException | ElementException ex) {
                        JOptionPane.showMessageDialog(JPublishWizard.this, Msg.get("ui.softwareFirewallInfo"), Msg.get("publish.connectionError"), 0);
                        return;
                    }
                    AccountsStep.this.addAccount(new AccountProfile(Msg.get("publish.NewAccount")));
                }
            };
            this.removeAccountAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AccountProfile account = (AccountProfile)AccountsStep.this.accountList.getSelectedValue();
                    if (account == null) {
                        return;
                    }
                    int answer = JOptionPane.showConfirmDialog(JPublishWizard.this, Msg.get("acc.removeAccountInfo", account.getName()), Msg.get("acc.removeAccountTitle"), 0);
                    if (answer == 0) {
                        AccountsStep.this.removeAccount(account);
                    }
                }
            };
            this.renameAccountAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String newName = (String)JOptionPane.showInputDialog(JPublishWizard.this, null, Msg.get("edit.renameFile"), 1, null, null, JPublishWizard.this.currentAccount.getName());
                    if (newName != null && newName.length() > 0) {
                        JPublishWizard.this.currentAccount.setName(newName);
                        AccountsStep.this.accountList.updateUI();
                    }
                }
            };
            this.accountList = new JList(JPublishWizard.this.accountManager.getAccounts());
            this.accountsScrollPane = new JScrollPane(this.accountList);
            this.currentAccountPanel = new ControlPanel(Msg.get("publish.currentAccountBorder"));
            this.webRootURLLabel = new JLabel(Msg.get("ui.webAddress"));
            this.webRootURL = new JBackgroundTextField(20);
            this.protocolLabel = new JLabel(Msg.get("ui.type"));
            this.protocol = new JComboBox<TransferProtocol>(TransferProtocol.values());
            this.ftpServerLabel = new JLabel(Msg.get("ui.ftpServer"));
            this.ftpServer = new JBackgroundTextField(20);
            this.ftpUserNameLabel = new JLabel(Msg.get("ui.userName"));
            this.ftpUser = new JSmartTextField(20);
            this.ftpPasswordLabel = new JLabel(Msg.get("ui.password"));
            this.ftpPassword = new JPasswordField(20);
            this.advancedAccountSettingsButton = new JIconButton(Msg.get("ui.advancedPanel"), Icons.small("wrench"));
            this.advancedSettingsDialog = new JAdvancedAccountSettingsDialog(JPublishWizard.this, false);
            this.connectAction = new AbstractAction(Msg.get("publish.connect"), this.plugIcon){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    BeanBinder.setProperties((Object)JPublishWizard.this.currentAccount, AccountsStep.this);
                    BeanBinder.setProperties((Object)JPublishWizard.this.currentAccount, AccountsStep.this.advancedSettingsDialog);
                    JPublishWizard.this.uploadBean.setAccountProperties(JPublishWizard.this.currentAccount);
                    if (AccountsStep.this.ftpPassword.getPassword().length == 0 && JPublishWizard.this.uploadBean.getProtocol() != TransferProtocol.sftp) {
                        String password = JPublishWizard.showPasswordInputDialog(JPublishWizard.this.getParentWindow(), Msg.get("publish.enterPasswordInfo"), Msg.get("publish.connect"), null);
                        if (password == null) return;
                        JPublishWizard.this.uploadBean.setFtpPassword(password);
                    }
                    SlowOperation connectOp = new SlowOperation(){

                        @Override
                        public void operation() throws Throwable {
                            UploadBean ub = JPublishWizard.this.uploadBean;
                            ub.connect();
                            if (JPublishWizard.this.currentAccount.isShowServerRootDirectory()) {
                                ub.getRemoteFS().setDirectory("/");
                            }
                            JPublishWizard.this.engine.setAccountProfileName(JPublishWizard.this.currentAccount.getName());
                            JPublishWizard.this.accountManager.fireAccountListUpdated();
                            JPublishWizard.this.rootNode = new RemoteFSNode(AccountsStep.this.ftpServer.getText(), false, false, JPublishWizard.this.publishStep);
                            JPublishWizard.this.protectedPaths = null;
                            this.getMessageLabel().setText(Msg.get("edit.preparingPreviewInfo"));
                            SwingUtilities.invokeAndWait(() -> JPublishWizard.this.nextAction.actionPerformed(null));
                        }

                        @Override
                        public void abort() {
                            try {
                                UploadBean oldUploadBean = JPublishWizard.this.uploadBean;
                                JPublishWizard.this.uploadBean = new UploadBean();
                                this.dialog.setVisible(false);
                                oldUploadBean.getRemoteFS().abortConnect();
                                if (JPublishWizard.this.stepIndex > 0) {
                                    JPublishWizard.this.backAction.actionPerformed(null);
                                }
                            }
                            catch (IOException | RemoteFSException exception) {
                                // empty catch block
                            }
                        }
                    };
                    try {
                        boolean done = connectOp.launch(JPublishWizard.this.getParentWindow(), new JLabel(Msg.get("ui.connectingToServer") + " " + AccountsStep.this.ftpServer.getText() + "...", AccountsStep.this.serverIcon, 10), AccountsStep.this.serverConnectionIcon, Msg.get("publish.connect"));
                        if (!done) return;
                    }
                    catch (AccountExpiredException ex) {
                        JOptionPane.showMessageDialog(JPublishWizard.this.getParentWindow(), new Object[]{ex.getMessage(), new JLinkLabel(JAlbumSite.getInstance().getMyJAlbumUpgradeUrl() + "/?utm_source=client&utm_medium=extendLink&utm_campaign=accountExpiredDialog&referrer=jalbumConnectFailedDialog&cid=" + AccountManager.getCid(JPublishWizard.this.currentAccount), Msg.get("publish.extendAccount"))}, Msg.get("publish.accountExpiredTitle"), 0);
                        return;
                    }
                    catch (FailedLoginException ex) {
                        JOptionPane.showMessageDialog(JPublishWizard.this.getParentWindow(), ex.getMessage(), Msg.get("publish.connectionError"), 0);
                        return;
                    }
                    catch (RemoteFSException ex) {
                        UploadBean.showErrorDialog(JPublishWizard.this.getParentWindow(), ex, Msg.get("publish.connectionError") + ". " + Msg.get("publish.serverReportedInfo"), Msg.get("publish.connect"));
                        return;
                    }
                    catch (IOException ex) {
                        Debug.showExpandableErrorDialog(null, "<html>" + Msg.get("ui.cannotConnectError") + "</html>", ex.toString(), Msg.get("publish.connect"));
                        return;
                    }
                    catch (Throwable ex) {
                        JPublishWizard.this.uploadBean.disconnect();
                        Debug.showErrorDialog(JPublishWizard.this.getParentWindow(), ex);
                    }
                }
            };
            Msg.maintainTranslated(this);
            ContextHelp.getInstance().add(this, "Upload#Accounts");
            this.advancedAccountSettingsButton.addActionListener(e -> this.advancedSettingsDialog.setVisible(true));
            this.webRootURL.setBackgroundText("http://www.yoursite.com");
            Verifier webRootVerifier = new Verifier(this.webRootURL);
            Verifier serverVerifier = new Verifier(this.ftpServer);
            webRootVerifier.onVerify(text -> {
                JPublishWizard.this.currentAccount.setWebRootURL((String)text);
                this.webRootURL.setText(JPublishWizard.this.currentAccount.getWebRootURL());
                try {
                    int rc = URLChecker.getResponseCode(this.webRootURL.getText());
                    webRootVerifier.setVerified(rc == 200 || rc == 401 || rc == 403);
                }
                catch (Exception ex) {
                    webRootVerifier.setVerified(false);
                }
                if (this.ftpServer.getText().length() != 0) return;
                ExecutorService pool = Executors.newCachedThreadPool();
                ArrayList<PortTester> tasks = new ArrayList<PortTester>();
                String sn = this.urlToServerName(this.webRootURL.getText());
                class PortTester
                implements Callable<InetSocketAddress> {
                    private String hostName;
                    private int port;

                    public PortTester(String name, int port) {
                        this.hostName = name;
                        this.port = port;
                    }

                    @Override
                    public InetSocketAddress call() throws Exception {
                        InetSocketAddress addr = new InetSocketAddress(this.hostName, this.port);
                        Socket sock = new Socket();
                        sock.connect(addr, 500);
                        sock.close();
                        return addr;
                    }
                }
                tasks.add(new PortTester("ssh." + sn, 22));
                tasks.add(new PortTester("www." + sn, 22));
                tasks.add(new PortTester(sn, 21));
                tasks.add(new PortTester(sn, 22));
                tasks.add(new PortTester("ftp." + sn, 21));
                tasks.add(new PortTester("www." + sn, 21));
                tasks.add(new PortTester("ftp." + sn, 990));
                tasks.add(new PortTester(sn, 990));
                try {
                    InetSocketAddress okAddr = (InetSocketAddress)pool.invokeAny(tasks);
                    this.ftpServer.setText(okAddr.getHostString());
                    serverVerifier.setVerified(true);
                    switch (okAddr.getPort()) {
                        case 21: {
                            this.protocol.setSelectedItem((Object)TransferProtocol.ftp);
                            return;
                        }
                        case 22: {
                            this.protocol.setSelectedItem((Object)TransferProtocol.sftp);
                            return;
                        }
                        case 990: {
                            this.protocol.setSelectedItem((Object)TransferProtocol.ftps);
                            return;
                        }
                    }
                    return;
                }
                catch (InterruptedException okAddr) {
                    return;
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(JPublishWizard.class.getName()).log(Level.FINER, null, ex);
                    return;
                }
                finally {
                    pool.shutdownNow();
                }
            });
            this.ftpServer.setToolTipText(Msg.get("ui.ftpServerToolTip"));
            this.ftpServer.setBackgroundText("ftp.yoursite.com");
            serverVerifier.onVerify(hostName -> {
                try {
                    InetSocketAddress addr = new InetSocketAddress((String)hostName, Integer.parseInt(this.advancedSettingsDialog.ftpPort.getText()));
                    Socket sock = new Socket();
                    sock.connect(addr, 500);
                    sock.close();
                    serverVerifier.setVerified(true);
                }
                catch (Exception ex) {
                    serverVerifier.setVerified(false);
                }
            });
            this.ftpUser.setToolTipText(Msg.get("ui.userNameToolTip"));
            this.ftpPassword.setToolTipText(Msg.get("ui.passwordToolTip"));
            this.webRootURL.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    AccountsStep.this.modifyAccountName();
                }
            });
            this.ftpServer.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    char c = e.getKeyChar();
                    if (c == ':' || c == ' ' || c == ',') {
                        e.consume();
                    }
                }
            });
            this.protocol.addActionListener(e -> {
                this.advancedSettingsDialog.ftpPort.setText("" + ((TransferProtocol)((Object)((Object)this.protocol.getSelectedItem()))).getDefaultPort());
                serverVerifier.setUnverified();
            });
            new StateMonitor(){

                @Override
                public void onChange() {
                    AccountsStep.this.advancedSettingsDialog.passiveMode.setEnabled((TransferProtocol)((Object)AccountsStep.this.protocol.getSelectedItem()) != TransferProtocol.sftp);
                }
            }.add(this.protocol).done();
            JCleanToolBar toolbar = new JCleanToolBar();
            toolbar.add(this.unfocusable(new JToolBarButton(this.addAccountAction, true)));
            toolbar.add(this.unfocusable(new JToolBarButton(this.removeAccountAction, true)));
            toolbar.add(this.unfocusable(new JToolBarButton(this.renameAccountAction, true)));
            this.add(toolbar);
            this.add("br hfill vfill", this.accountsScrollPane);
            this.currentAccountPanel.add("br", this.webRootURLLabel);
            this.currentAccountPanel.add("tab", this.webRootURL);
            this.currentAccountPanel.add("p", this.protocolLabel);
            this.currentAccountPanel.add("tab", this.protocol);
            this.currentAccountPanel.add("br", this.ftpServerLabel);
            this.currentAccountPanel.add("tab", this.ftpServer);
            this.currentAccountPanel.add("br", this.ftpUserNameLabel);
            this.currentAccountPanel.add("tab", this.ftpUser);
            this.currentAccountPanel.add("br", this.ftpPasswordLabel);
            this.currentAccountPanel.add("tab", this.ftpPassword);
            this.currentAccountPanel.add("tab", this.advancedAccountSettingsButton);
            this.add("br hfill", this.currentAccountPanel);
            this.accountList.setSelectionMode(0);
            this.accountList.addListSelectionListener(e -> {
                AccountProfile newProfile = (AccountProfile)this.accountList.getSelectedValue();
                if (JPublishWizard.this.stepIndex > 0) {
                    return;
                }
                if (JPublishWizard.this.currentAccount != null) {
                    BeanBinder.setProperties((Object)JPublishWizard.this.currentAccount, this);
                    BeanBinder.setProperties((Object)JPublishWizard.this.currentAccount, this.advancedSettingsDialog);
                    if (JPublishWizard.this.engine != null) {
                        JPublishWizard.this.engine.setAccountProfileName(JPublishWizard.this.currentAccount.getName());
                    }
                }
                if (newProfile != null) {
                    JPublishWizard.this.currentAccount = newProfile;
                }
                this.updateView();
            });
            this.accountList.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.check(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.check(e);
                }

                public void check(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        AccountsStep.this.accountList.setSelectedIndex(AccountsStep.this.accountList.locationToIndex(e.getPoint()));
                        JPopupMenu popup = new JPopupMenu();
                        popup.add(AccountsStep.this.renameAccountAction);
                        popup.show(AccountsStep.this.accountList, e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        AccountsStep.this.connectAction.actionPerformed(null);
                    }
                }
            });
            try {
                this.accountList.setSelectedValue(new AccountProfile(JPublishWizard.this.engine.getAccountProfileName()), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.accountList.getSelectedIndex() == -1 && this.accountList.getModel().getSize() > 0) {
                this.accountList.setSelectedIndex(0);
            }
            this.updateView();
        }

        private void modifyAccountName() {
            String finalName = this.webRootURL.getText();
            if (finalName.length() > 0) {
                JPublishWizard.this.currentAccount.setName(finalName);
            } else {
                JPublishWizard.this.currentAccount.setName(Msg.get("publish.NewAccount"));
            }
            this.accountList.updateUI();
        }

        @Override
        public Action[] getActions() {
            if (Platform.isMac()) {
                return new Action[]{JPublishWizard.this.cancelAction, this.connectAction};
            }
            return new Action[]{this.connectAction, JPublishWizard.this.cancelAction};
        }

        @Override
        public Action getDefaultAction() {
            return this.connectAction;
        }

        private void updateView() {
            this.removeAccountAction.setEnabled(this.accountList.getSelectedIndex() >= 0);
            this.renameAccountAction.setEnabled(this.accountList.getSelectedIndex() >= 0);
            if (JPublishWizard.this.accountManager.getAccounts().getSize() > 0) {
                AccountProfile a = (AccountProfile)this.accountList.getSelectedValue();
                if (a == null) {
                    this.accountList.setSelectedIndex(JPublishWizard.this.accountManager.getAccounts().getSize() - 1);
                    a = (AccountProfile)this.accountList.getSelectedValue();
                }
                BeanBinder.getProperties((Object)a, this);
                BeanBinder.getProperties((Object)a, this.advancedSettingsDialog);
                this.accountList.setEnabled(true);
                this.currentAccountPanel.setEnabled(true);
                this.connectAction.setEnabled(true);
                this.currentAccountPanel.setEnabled(!a.isProtected());
                this.advancedAccountSettingsButton.setEnabled(!a.isProtected());
                this.ftpPasswordLabel.setEnabled(true);
                this.ftpPassword.setEnabled(true);
            } else {
                this.accountList.setEnabled(false);
                this.currentAccountPanel.setEnabled(false);
                this.connectAction.setEnabled(false);
            }
        }

        public void addAccount(AccountProfile newAccount) {
            JPublishWizard.this.accountManager.addAccount(newAccount);
            this.accountList.setSelectedIndex(JPublishWizard.this.accountManager.getAccounts().getSize() - 1);
            this.updateView();
            this.webRootURL.requestFocusInWindow();
        }

        void saveAccounts() {
            try {
                JPublishWizard.this.accountManager.saveAccounts();
            }
            catch (Exception ex) {
                Debug.showErrorDialog(this, ex);
            }
        }

        public void removeAccount(AccountProfile oldAccount) {
            int oldIndex = this.accountList.getSelectedIndex();
            JPublishWizard.this.accountManager.removeAccount(oldAccount);
            if (oldIndex < JPublishWizard.this.accountManager.getAccounts().size()) {
                this.accountList.setSelectedIndex(oldIndex);
            }
        }

        @Override
        public void onShow() {
            if (JPublishWizard.this.currentAccount != null && JPublishWizard.this.currentAccount.getName().equals(Msg.get("publish.NewAccount"))) {
                this.webRootURL.requestFocusInWindow();
            }
        }

        @Override
        public void onHide() {
            if (JPublishWizard.this.currentAccount != null) {
                BeanBinder.setProperties((Object)JPublishWizard.this.currentAccount, this);
                BeanBinder.setProperties((Object)JPublishWizard.this.currentAccount, this.advancedSettingsDialog);
                if (JPublishWizard.this.currentAccount.getFtpServer().length() == 0 || JPublishWizard.this.currentAccount.getFtpUser().length() == 0) {
                    JPublishWizard.this.accountManager.removeAccount(JPublishWizard.this.currentAccount);
                }
                this.saveAccounts();
            }
        }
    }

    class PublishStep
    extends JWizardStep
    implements RemoteFSContext {
        Icon uploadIcon;
        @se.datadosen.util.annotations.Icon(value="16x16/folder_new.svg")
        @Text(value="publish.newDirectory")
        Action newDirectoryAction;
        @se.datadosen.util.annotations.Icon(value="16x16/delete.svg")
        @Text(value="edit.delete")
        Action deleteAction;
        @se.datadosen.util.annotations.Icon(value="16x16/rename.svg")
        @Text(value="edit.renameFile")
        Action renameAction;
        @se.datadosen.util.annotations.Icon(value="16x16/folder_refresh.svg")
        @Text(value="publish.refreshDirectory")
        Action refreshDirectoryAction;
        @se.datadosen.util.annotations.Icon(value="16x16/folder_earth.svg")
        @Text(value="publish.markAsWebRoot")
        Action markAsWebRootAction;
        @se.datadosen.util.annotations.Icon(value="16x16/download.svg")
        @Text(value="ui.download")
        Action downloadAction;
        @se.datadosen.util.annotations.Icon(value="16x16/folder_lock.svg")
        @Text(value="publish.passwordProtect")
        Action passwordProtectAction;
        @se.datadosen.util.annotations.Icon(value="16x16/gauge.svg")
        @Text(value="publish.getQuota")
        Action getQuotaAction;
        JToggleButton advancedModeButton;
        @se.datadosen.util.annotations.Icon(value="16x16/wrench.svg")
        @ToolTipText(value="ui.advancedPanel")
        Action advancedModeAction;
        @se.datadosen.util.annotations.Icon(value="16x16/copy.svg")
        Action copyURLAction;
        @se.datadosen.util.annotations.Icon(value="16x16/upload.svg")
        Action smartUploadAction;
        Action uploadAllAction;
        Action uploadAction;
        JCleanToolBar remoteToolBar;
        JTree tree;
        DefaultTreeModel treeModel;
        RemoteFSTreeCellRenderer customRenderer;
        JPopupMenu treeMenu;
        JScrollPane remoteTreeScrollPane;
        JLabel previewLinkLabel;
        JLinkLabel previewLink;
        JButton copyURLButton;
        Notifier notifier;
        private Thread uploadThread;
        private final TreeSelectionListener selectionListener;

        PublishStep() {
            super(Msg.get("publish.selectDirectory"));
            this.uploadIcon = Icons.small("btn-upload");
            this.newDirectoryAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RemoteFSNode selNode = (RemoteFSNode)PublishStep.this.tree.getLastSelectedPathComponent();
                    if (selNode != null) {
                        if (selNode.getRemoteName() != null) {
                            String defaultAlbumName = Msg.get("publish.newDirectory");
                            JPublishWizard.this.context.getFrame().ui2Engine();
                            String projectName = PublishStep.this.getProjectName();
                            if (projectName.length() > 0) {
                                defaultAlbumName = projectName;
                            }
                            RemoteFSNode newNode = new RemoteFSNode(PublishStep.this.uniqueName(selNode, defaultAlbumName), null, (RemoteFSContext)JPublishWizard.this.publishStep);
                            PublishStep.this.treeModel.insertNodeInto(newNode, selNode, 0);
                            Object[] nodes = PublishStep.this.treeModel.getPathToRoot(newNode);
                            TreePath path = new TreePath(nodes);
                            PublishStep.this.tree.expandPath(path);
                            PublishStep.this.tree.setSelectionPath(path);
                            if (PublishStep.this.isShowing()) {
                                PublishStep.this.tree.startEditingAtPath(path);
                            }
                        } else {
                            TreePath path = new TreePath(PublishStep.this.treeModel.getPathToRoot(selNode));
                            SwingUtilities.invokeLater(() -> {
                                if (!PublishStep.this.tree.isEditing()) {
                                    PublishStep.this.tree.startEditingAtPath(path);
                                }
                            });
                        }
                    }
                }
            };
            this.deleteAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int answer;
                    final TreePath[] paths = PublishStep.this.tree.getSelectionPaths();
                    if (paths == null) {
                        return;
                    }
                    StringBuilder folderNames = new StringBuilder();
                    for (TreePath tp : paths) {
                        RemoteFSNode node = (RemoteFSNode)tp.getLastPathComponent();
                        if (node.isLink() || node.isLeaf()) continue;
                        if (folderNames.length() > 0) {
                            folderNames.append(", ");
                            if (folderNames.length() > 50) {
                                folderNames.append("...");
                                break;
                            }
                        }
                        folderNames.append(node.toString());
                    }
                    if (folderNames.length() > 0 && (answer = JOptionPane.showConfirmDialog(JPublishWizard.this, Msg.get("publish.DeleteDirectoryWarning", folderNames.toString()), Msg.get("publish.deleteDirectory"), 0, 2)) != 0) {
                        return;
                    }
                    final JProgressDialog progressDialog = new JProgressDialog((Dialog)JPublishWizard.this, Msg.get("publish.deletingDirectoryInfo", folderNames.toString()), true, true);
                    progressDialog.setSize(new Dimension(350, 180));
                    progressDialog.setIndeterminate(true);
                    JPublishWizard.this.uploadBean.addAlbumBeanListener(progressDialog);
                    new Thread(this, "DirectoryDeletingThread"){
                        final /* synthetic */ 2 this$2;
                        {
                            this.this$2 = this$2;
                            super(arg0);
                            this.setDaemon(true);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                SwingUtilities.invokeLater(() -> progressDialog.updateStateAndSetVisible(true));
                                TreePath lastFolderPath = null;
                                for (TreePath tp : paths) {
                                    if (lastFolderPath != null && lastFolderPath.isDescendant(tp)) continue;
                                    RemoteFSNode node = (RemoteFSNode)tp.getLastPathComponent();
                                    if (node.isLink() || node.isLeaf()) {
                                        this.this$2.JPublishWizard.this.uploadBean.getRemoteFS().removeFile(node.remotePath());
                                    } else {
                                        AlbumObject root = this.this$2.JPublishWizard.this.context.getFrame().albumExplorer.getRootFolder();
                                        this.this$2.JPublishWizard.this.uploadBean.deleteAlbum(root, node.remotePath());
                                        this.this$2.JPublishWizard.this.protectedPaths = null;
                                        if (this.this$2.PublishStep.this.notifier != null) {
                                            this.this$2.PublishStep.this.notifier.albumDeletedBg(this.this$2.JPublishWizard.this.currentAccount, this.this$2.PublishStep.this.getUrl(node.remotePath()));
                                        }
                                    }
                                    this.this$2.PublishStep.this.tree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)node.getParent()).getPath()));
                                    this.this$2.PublishStep.this.treeModel.removeNodeFromParent(node);
                                    lastFolderPath = tp;
                                }
                            }
                            catch (OperationAbortedException ex) {
                                this.this$2.PublishStep.this.refreshFrom((RemoteFSNode)this.this$2.PublishStep.this.tree.getLastSelectedPathComponent());
                            }
                            catch (IOException | RemoteFSException | ParameterException ex) {
                                ex.printStackTrace();
                                RemoteFSNode node = (RemoteFSNode)this.this$2.PublishStep.this.tree.getLastSelectedPathComponent();
                                Debug.showErrorDialog(this.this$2.JPublishWizard.this, ex);
                                this.this$2.PublishStep.this.tree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)node.getParent()).getPath()));
                                this.this$2.PublishStep.this.refreshFrom((RemoteFSNode)node.getParent());
                            }
                            finally {
                                this.this$2.JPublishWizard.this.uploadBean.removeAlbumBeanListener(progressDialog);
                                SwingUtilities.invokeLater(() -> progressDialog.updateStateAndSetVisible(false));
                            }
                        }
                    }.start();
                }
            };
            this.renameAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PublishStep.this.tree.startEditingAtPath(PublishStep.this.tree.getSelectionPath());
                }
            };
            this.refreshDirectoryAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RemoteFSNode node = (RemoteFSNode)PublishStep.this.tree.getLastSelectedPathComponent();
                    if (node != null && node.isLeaf()) {
                        node = (RemoteFSNode)node.getParent();
                    }
                    if (node == null) {
                        node = (RemoteFSNode)PublishStep.this.tree.getModel().getRoot();
                    }
                    PublishStep.this.refreshFrom(node);
                }
            };
            this.markAsWebRootAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object answer = (String)JOptionPane.showInputDialog(JPublishWizard.this, Msg.get("publish.markAsWebRootInfo"), Msg.get("publish.markAsWebRoot"), 1, null, null, JPublishWizard.this.currentAccount.getWebRootURL());
                    if (answer != null) {
                        if (((String)answer).indexOf(58) == -1) {
                            answer = "http://" + ((String)answer).trim();
                        }
                        JPublishWizard.this.currentAccount.setWebRootURL(((String)answer).trim());
                        JPublishWizard.this.currentAccount.setVerified(false);
                        JPublishWizard.this.setFtpWebRootDirectory(JPublishWizard.this.toRelative(((RemoteFSNode)PublishStep.this.tree.getLastSelectedPathComponent()).remotePath()));
                        JPublishWizard.this.accountsStep.saveAccounts();
                        TreePath webRootPath = RemoteFSNode.treePath(JPublishWizard.this.getFtpWebRootDirectory(), PublishStep.this.treeModel);
                        PublishStep.this.customRenderer.setWebRoot((TreeNode)webRootPath.getLastPathComponent());
                        PublishStep.this.tree.repaint();
                        PublishStep.this.updateView();
                        PublishStep.this.verifyWebAccess();
                    }
                }
            };
            this.downloadAction = new AbstractAction(){
                File destination = new File(System.getProperty("desktop.path", System.getProperty("user.home")));
                DirectoryChooser chooser;
                {
                    this.chooser = ChooserFactory.createDirectoryChooser(JPublishWizard.this);
                    this.chooser.setCurrentDirectory(this.destination);
                    this.chooser.setDialogTitle(Msg.get("ui.selectDestinationFolder"));
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    RemoteFSNode node = (RemoteFSNode)PublishStep.this.tree.getLastSelectedPathComponent();
                    String camelotPath = IO.combinePaths(node.remotePath(), ".jalbum/camelot-album.xml");
                    try {
                        int answer;
                        if (PublishStep.this.getRemoteFS().exists(camelotPath)) {
                            int answer2 = JOptionPane.showConfirmDialog(JPublishWizard.this, Msg.get("ui.installAlbum"), Msg.get("ui.download"), 1, 1);
                            if (answer2 == 0) {
                                String projectFilePath = IO.combinePaths(node.remotePath(), "jalbum-settings.jap");
                                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                                PublishStep.this.getRemoteFS().get(projectFilePath, bos);
                                bos.close();
                                Properties p = new Properties();
                                ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                                p.load(bis);
                                String skin = p.getProperty("skin");
                                File skinDir = Config.getConfig().chainedSkinsDir.getFile(skin);
                                if (!skinDir.exists()) {
                                    int doInstallSkin = JOptionPane.showConfirmDialog(JPublishWizard.this, Msg.get("ui.missingSkin", skin), Msg.get("ui.missingSkinTitle"), 0, 0);
                                    if (doInstallSkin == 0) {
                                        try {
                                            BrowserLauncher.openURL(JAlbumSite.getTrueInstance().getSkinUrl(skin));
                                        }
                                        catch (IOException | ElementException exception) {
                                            // empty catch block
                                        }
                                    }
                                    return;
                                }
                                JPublishWizard.this.context.getFrame().mainSettingsPanel.scanSkins();
                                File target = IO.ensureUnique(new File(Config.getConfig().getMyAlbumsLocation()), node.getRemoteName());
                                PublishStep.this.doDownloadFiles(target, () -> {
                                    try {
                                        JPublishWizard.this.cancelAction.actionPerformed(null);
                                        File projectFile = new File(target, "jalbum-settings.jap");
                                        Properties props = IO.readPropertyFile(projectFile);
                                        props.put("directory", new File(target, "originals").getAbsolutePath());
                                        props.put("outputDirectory", "..");
                                        props.put("copyOriginals", "false");
                                        props.put("includeHiResImages", "false");
                                        try (FileOutputStream fos = new FileOutputStream(projectFile);){
                                            props.store(fos, "jAlbum Project");
                                        }
                                        JPublishWizard.this.context.getFrame().loadProject(projectFile);
                                    }
                                    catch (IOException ex) {
                                        Debug.showErrorDialog(JPublishWizard.this, ex);
                                    }
                                });
                                return;
                            }
                            if (answer2 == 2) {
                                return;
                            }
                        }
                        String thumbsPath = IO.combinePaths(node.remotePath(), "thumbs");
                        String lifeboatPath = IO.combinePaths(node.remotePath(), "lifeboat.zip");
                        if (node.isAlbum() || PublishStep.this.getRemoteFS().exists(thumbsPath) || PublishStep.this.getRemoteFS().exists(lifeboatPath)) {
                            answer = JOptionPane.showConfirmDialog(JPublishWizard.this, Msg.get("ui.installAlbum2"), Msg.get("ui.download"), 1, 1);
                            if (answer == 0) {
                                File projectDir = IO.ensureUnique(new File(Config.getConfig().getMyAlbumsLocation()), node.getRemoteName());
                                File albumDir = new File(projectDir, "album");
                                albumDir.mkdirs();
                                PublishStep.this.doDownloadFiles(albumDir, () -> {
                                    try {
                                        JPublishWizard.this.cancelAction.actionPerformed(null);
                                        RecoveryTool.recreateProjectFromAlbum(albumDir, projectDir);
                                    }
                                    catch (IOException ex) {
                                        Debug.showErrorDialog(JPublishWizard.this, ex);
                                    }
                                });
                                return;
                            }
                            if (answer == 2) {
                                return;
                            }
                        }
                        if ((answer = this.chooser.showOpenDialog(JPublishWizard.this)) != 0) {
                            return;
                        }
                        this.destination = this.chooser.getSelectedFile();
                        File target = IO.ensureUnique(this.destination, node.getRemoteName());
                        PublishStep.this.doDownloadFiles(target, () -> MyDesktop.getDesktop().browseFileDirectory(target));
                    }
                    catch (IOException | RemoteFSException ex) {
                        Debug.showErrorDialog(JPublishWizard.this, ex);
                    }
                }
            };
            this.passwordProtectAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        String s = JAlbumSite.getTrueInstance().getMyJAlbumPasswordProtectUrl(JPublishWizard.this.currentAccount.getFtpServer());
                        if (s == null) {
                            return;
                        }
                        ControlPanel messagePanel = new ControlPanel();
                        final JPasswordField jpf = new JPasswordField();
                        ((Container)messagePanel).add("br", new JLabel(Msg.get("ui.password")));
                        ((Container)messagePanel).add("tab hfill", jpf);
                        ((Container)messagePanel).add("br", new JLabel(Msg.get("publish.leaveBlankHint")));
                        JOptionPane pane = new JOptionPane(messagePanel, 1, 2, null, null, null);
                        JDialog dialog = pane.createDialog(JPublishWizard.this, Msg.get("publish.passwordProtect"));
                        dialog.addWindowListener(new WindowAdapter(this){
                            final /* synthetic */ 7 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            @Override
                            public void windowOpened(WindowEvent e) {
                                jpf.requestFocusInWindow();
                            }
                        });
                        dialog.setVisible(true);
                        Object val = pane.getValue();
                        if (val instanceof Integer && (Integer)val != 0) {
                            return;
                        }
                        if (!(val instanceof Integer)) {
                            return;
                        }
                        Properties data = new Properties();
                        data.setProperty("ownerUserName", JPublishWizard.this.currentAccount.getFtpUser());
                        data.setProperty("ownerPassword", DigestUtil.md5(JPublishWizard.this.currentAccount.getFtpPassword()));
                        data.setProperty("password", new String(jpf.getPassword()));
                        data.setProperty("path", ((RemoteFSNode)PublishStep.this.tree.getLastSelectedPathComponent()).remotePath());
                        RobustResty r = new RobustResty();
                        String content = r.text(s, (AbstractContent)RobustResty.form(data)).toString();
                        if (!content.trim().equals("OK")) {
                            throw new Exception(content);
                        }
                        JPublishWizard.this.protectedPaths = null;
                        RemoteFSNode node = (RemoteFSNode)PublishStep.this.tree.getLastSelectedPathComponent();
                        node.invalidateNodeOnly();
                        PublishStep.this.treeModel.nodeChanged(node);
                    }
                    catch (Exception ex) {
                        Debug.showErrorDialog(JPublishWizard.this, ex);
                    }
                }
            };
            this.getQuotaAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        RobustResty r = new RobustResty();
                        Properties p = new Properties();
                        p.setProperty("userName", JPublishWizard.this.currentAccount.getFtpUser());
                        String content = r.text(JAlbumSite.getTrueInstance().getMyJAlbumQuotaUrl(), (AbstractContent)RobustResty.form(p)).toString();
                        Element result = Elements.getElementByName("result", content, false);
                        if (result != null) {
                            float usage = (float)Long.parseLong(result.getAttribute("usage")) / 1024.0f;
                            float quota = (float)Long.parseLong(result.getAttribute("quota")) / 1024.0f;
                            JProgressBar meter = new JProgressBar(0, (int)quota);
                            meter.setValue((int)usage);
                            meter.setStringPainted(true);
                            DecimalFormat twoDec = new DecimalFormat("0.##");
                            meter.setString(Msg.get("publish.quotaInfo", twoDec.format(usage), twoDec.format(quota)));
                            JOptionPane.showMessageDialog(JPublishWizard.this, new Object[]{meter, PublishStep.this.getPromoteMyJAlbumLabel()}, Msg.get("publish.getQuota"), 1);
                        }
                    }
                    catch (HeadlessException | IOException | NumberFormatException | ElementException ex) {
                        Debug.showErrorDialog(JPublishWizard.this, ex);
                    }
                }
            };
            this.advancedModeButton = null;
            this.advancedModeAction = new AbstractAction(null){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PublishStep.this.refreshFrom((RemoteFSNode)PublishStep.this.treeModel.getRoot());
                    TreePath tp = RemoteFSNode.treePath(JPublishWizard.this.getRemoteDirectory(), PublishStep.this.treeModel);
                    if (tp.getLastPathComponent() == PublishStep.this.treeModel.getRoot()) {
                        tp = RemoteFSNode.treePath(JPublishWizard.this.getFtpWebRootDirectory(), PublishStep.this.treeModel);
                    }
                    PublishStep.this.tree.setSelectionPath(tp);
                    PublishStep.this.tree.scrollPathToVisible(tp);
                    PublishStep.this.updateView();
                }
            };
            this.copyURLAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StringSelection stringSelection = new StringSelection(PublishStep.this.previewLink.getURL());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, null);
                }
            };
            this.smartUploadAction = new AbstractAction(Msg.get("ui.smartUpload")){
                {
                    this.putValue("ShortDescription", Msg.get("ui.smartUploadToolTip"));
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    PublishStep.this.doUploadAlbum(false);
                }
            };
            this.uploadAllAction = new AbstractAction(Msg.get("ui.uploadAll"), this.uploadIcon){
                {
                    this.putValue("ShortDescription", Msg.get("ui.uploadAllToolTip"));
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    PublishStep.this.doUploadAlbum(true);
                }
            };
            this.uploadAction = new CompoundAction(Msg.get("ui.upload"), this.uploadIcon){
                {
                    this.setSubActions(new Action[]{PublishStep.this.smartUploadAction, PublishStep.this.uploadAllAction});
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    PublishStep.this.doUploadAlbum(false);
                }
            };
            this.remoteToolBar = new JCleanToolBar();
            this.tree = new NonCollapsableJTree((TreeModel)null);
            this.remoteTreeScrollPane = new JScrollPane(this.tree);
            this.previewLinkLabel = new JLabel(Msg.get("share.url"));
            this.previewLink = new JLinkLabel();
            this.copyURLButton = new JButton(this.copyURLAction);
            this.selectionListener = e -> {
                String remotePath = RemoteFSNode.remotePath(e.getPath(), this);
                JPublishWizard.this.setRemoteDirectory(JPublishWizard.this.toRelative(remotePath));
                this.updateView();
            };
            ContextHelp.getInstance().add(this, "Upload#Connected");
            try {
                this.notifier = new Notifier(JPublishWizard.this.context);
            }
            catch (IOException | ElementException exception) {
                // empty catch block
            }
            this.advancedModeButton = new JToggleButton(this.advancedModeAction);
            this.copyURLAction.putValue("ShortDescription", Msg.get("share.urlToolTip"));
            this.treeMenu = new JPopupMenu();
            this.treeMenu.add(this.newDirectoryAction);
            this.treeMenu.add(this.renameAction);
            this.treeMenu.add(this.downloadAction);
            this.treeMenu.add(this.deleteAction);
            this.treeMenu.add(this.refreshDirectoryAction);
            this.treeMenu.add(this.markAsWebRootAction);
            this.treeMenu.add(this.passwordProtectAction);
            this.tree.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    PublishStep.this.tree.getCellEditor().cancelCellEditing();
                    TreePath selPath = PublishStep.this.tree.getPathForLocation(e.getX(), e.getY());
                    if (e.getButton() != 1) {
                        PublishStep.this.tree.getSelectionModel().setSelectionPath(selPath);
                    }
                    if (e.isPopupTrigger() && selPath != null) {
                        PublishStep.this.treeMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    TreePath path = PublishStep.this.tree.getPathForLocation(e.getX(), e.getY());
                    if (e.isPopupTrigger() && path != null) {
                        PublishStep.this.treeMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
            this.tree.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 127 || Platform.isMac() && e.getKeyCode() == 8 && e.getModifiersEx() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()) {
                        PublishStep.this.deleteAction.actionPerformed(null);
                    } else if (e.getKeyCode() == 116) {
                        PublishStep.this.refreshDirectoryAction.actionPerformed(null);
                    }
                }
            });
            this.remoteTreeScrollPane.setPreferredSize(new Dimension(150, 150));
            this.remoteToolBar.add(new JToolBarButton(this.newDirectoryAction, false));
            this.remoteToolBar.add(this.renameAction);
            this.remoteToolBar.add(this.downloadAction);
            this.remoteToolBar.add(this.deleteAction);
            this.remoteToolBar.add(this.refreshDirectoryAction);
            this.remoteToolBar.add(this.markAsWebRootAction);
            this.remoteToolBar.add(this.passwordProtectAction);
            this.remoteToolBar.add(this.getQuotaAction);
            this.remoteToolBar.addSeparator();
            this.remoteToolBar.add(this.advancedModeButton);
            this.add(this.remoteToolBar);
            this.add("br hfill vfill", this.remoteTreeScrollPane);
            this.add("p", this.previewLinkLabel);
            this.add("tab", this.previewLink);
            this.add(this.copyURLButton);
            Msg.maintainTranslated(this);
        }

        private String uniqueName(RemoteFSNode node, String name) {
            node.getChildCount();
            Enumeration<TreeNode> en = node.children();
            HashSet<String> names = new HashSet<String>();
            while (en.hasMoreElements()) {
                RemoteFSNode child = (RemoteFSNode)en.nextElement();
                names.add(child.getRemoteName());
            }
            int index = 1;
            Object newName = name;
            while (names.contains(newName)) {
                newName = name + index;
                ++index;
            }
            return newName;
        }

        private String getProjectName() {
            return JPublishWizard.this.context.getFrame().getProjectName();
        }

        private void refreshFrom(RemoteFSNode node) {
            node.invalidate();
            this.treeModel.nodeStructureChanged(node);
            TreePath webRootPath = RemoteFSNode.treePath(JPublishWizard.this.getFtpWebRootDirectory(), this.treeModel);
            this.customRenderer.setWebRoot((TreeNode)webRootPath.getLastPathComponent());
        }

        private String discoverWebRoot(TreeModel model) {
            TreePath tp = new TreePath(model.getRoot());
            TreeNode tn = (TreeNode)tp.getLastPathComponent();
            tn.getChildCount();
            Enumeration<? extends TreeNode> children = tn.children();
            HashSet<String> webRootNames = new HashSet<String>();
            webRootNames.add("public_html");
            webRootNames.add("htdocs");
            webRootNames.add("wwwroot");
            webRootNames.add("httpdocs");
            webRootNames.add("www");
            webRootNames.add("html");
            while (children.hasMoreElements()) {
                TreeNode child = children.nextElement();
                if (!webRootNames.contains(child.toString().toLowerCase())) continue;
                return child.toString();
            }
            return null;
        }

        @Override
        public Action[] getActions() {
            if (Platform.isMac()) {
                return new Action[]{JPublishWizard.this.cancelAction, JPublishWizard.this.backAction, this.uploadAction};
            }
            return new Action[]{JPublishWizard.this.backAction, this.uploadAction, JPublishWizard.this.cancelAction};
        }

        @Override
        public Action getDefaultAction() {
            return this.uploadAction;
        }

        @Override
        public void onShow() {
            JPublishWizard.this.uploadBean.setEngine(JPublishWizard.this.context.getEngine());
            this.markAsWebRootAction.setEnabled(!JPublishWizard.this.currentAccount.isMyjalbum());
            this.passwordProtectAction.setEnabled(JPublishWizard.this.currentAccount.isMyjalbum());
            this.getQuotaAction.setEnabled(JPublishWizard.this.currentAccount.isMyjalbum());
            this.treeModel = new DefaultTreeModel(JPublishWizard.this.rootNode);
            this.tree.setModel(this.treeModel);
            this.tree.setEditable(true);
            this.tree.getSelectionModel().setSelectionMode(4);
            new RemoteFSTreeTransferHandler(this.tree, JPublishWizard.this, JPublishWizard.this.uploadBean, 3);
            this.treeModel.addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                    RemoteFSNode node = (RemoteFSNode)PublishStep.this.tree.getLastSelectedPathComponent();
                    if (node != null) {
                        node.setUserObject(((String)node.getUserObject()).trim());
                        try {
                            if (!node.isRealDirectory()) {
                                JPublishWizard.this.uploadBean.getRemoteFS().createDirectory(node.remotePath());
                            } else if (!node.oldRemotePath().equals(node.remotePath())) {
                                JPublishWizard.this.uploadBean.getRemoteFS().rename(node.oldRemotePath(), node.remotePath());
                                if (PublishStep.this.notifier != null) {
                                    PublishStep.this.notifier.albumMovedBg(JPublishWizard.this.currentAccount, PublishStep.this.getUrl(node.oldRemotePath()), PublishStep.this.getUrl(node.remotePath()));
                                }
                            }
                            node.setRemoteName(node.toString());
                            JPublishWizard.this.setRemoteDirectory(node.remotePath());
                            PublishStep.this.updateView();
                        }
                        catch (RemoteFSException ex) {
                            UploadBean.showErrorDialog(JPublishWizard.this, ex, Msg.get("publish.serverReportedInfo"), Msg.get("publish.renameDirectory"));
                            ((AutoSelectingTreeCellEditor)PublishStep.this.tree.getCellEditor()).ignoreFocusLost = true;
                            PublishStep.this.tree.startEditingAtPath(PublishStep.this.tree.getSelectionPath());
                        }
                        catch (IOException ex) {
                            Debug.showErrorDialog(JPublishWizard.this, ex);
                            ((AutoSelectingTreeCellEditor)PublishStep.this.tree.getCellEditor()).ignoreFocusLost = true;
                            PublishStep.this.tree.startEditingAtPath(PublishStep.this.tree.getSelectionPath());
                        }
                    }
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                }
            });
            this.tree.removeTreeSelectionListener(this.selectionListener);
            this.tree.addTreeSelectionListener(this.selectionListener);
            this.customRenderer = new RemoteFSTreeCellRenderer();
            String webRoot = JPublishWizard.this.getFtpWebRootDirectory();
            if (webRoot.equals("VALUE_UNSET")) {
                webRoot = this.discoverWebRoot(this.treeModel);
                if (webRoot == null) {
                    webRoot = JPublishWizard.this.currentAccount.isShowServerRootDirectory() ? JPublishWizard.this.uploadBean.getBaseDirectory() : "";
                }
                JPublishWizard.this.setFtpWebRootDirectory(webRoot);
            }
            TreePath webRootPath = RemoteFSNode.treePath(JPublishWizard.this.getFtpWebRootDirectory(), this.treeModel);
            this.customRenderer.setWebRoot((TreeNode)webRootPath.getLastPathComponent());
            this.tree.setCellRenderer(this.customRenderer);
            ToolTipManager.sharedInstance().registerComponent(this.tree);
            AutoSelectingTreeCellEditor editor = new AutoSelectingTreeCellEditor(this.tree, this.customRenderer);
            this.tree.setCellEditor(editor);
            this.tree.getCellEditor().addCellEditorListener(new CellEditorListener(){

                @Override
                public void editingCanceled(ChangeEvent e) {
                    RemoteFSNode lastNode = (RemoteFSNode)PublishStep.this.tree.getLastSelectedPathComponent();
                    if (lastNode != null && !lastNode.isRealDirectory()) {
                        PublishStep.this.tree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)lastNode.getParent()).getPath()));
                        PublishStep.this.treeModel.removeNodeFromParent(lastNode);
                    }
                }

                @Override
                public void editingStopped(ChangeEvent e) {
                }
            });
            boolean notFound = false;
            TreePath tp = RemoteFSNode.treePath(JPublishWizard.this.getRemoteDirectory(), this.treeModel);
            if (!JPublishWizard.this.currentAccount.isMyjalbum() && JPublishWizard.this.uploadBean.getRemoteDirectory().length() == 0) {
                this.tree.setSelectionPath(tp);
                return;
            }
            if (!IO.lastPathComponentOf(JPublishWizard.this.getRemoteDirectory()).equals(((RemoteFSNode)tp.getLastPathComponent()).toString()) && !((RemoteFSNode)(tp = RemoteFSNode.treePath(IO.combinePaths(JPublishWizard.this.getFtpWebRootDirectory(), this.getProjectName()), this.treeModel)).getLastPathComponent()).getRemoteName().equals(this.getProjectName())) {
                notFound = true;
            }
            this.tree.setSelectionPath(tp);
            this.tree.scrollPathToVisible(tp);
            this.updateView();
            if (notFound && this.getProjectName().length() > 0) {
                this.newDirectoryAction.actionPerformed(null);
            } else if (((RemoteFSNode)tp.getLastPathComponent()).getRemoteName() == null) {
                this.tree.startEditingAtPath(tp);
            }
        }

        @Override
        public void onHide() {
            this.tree.removeTreeSelectionListener(this.selectionListener);
            this.tree.setModel(null);
            try {
                ToolTipManager.sharedInstance().unregisterComponent(this.tree);
                JPublishWizard.this.uploadBean.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private String getAlbumURL() {
            RemoteFSNode node;
            Object uri;
            String webRoot = JPublishWizard.this.getFtpWebRootDirectory();
            if (webRoot == null) {
                webRoot = "";
            }
            if (((String)(uri = IO.relativePath(JPublishWizard.this.toAbsolute(JPublishWizard.this.uploadBean.getRemoteDirectory()), JPublishWizard.this.toAbsolute(webRoot)))).startsWith("..")) {
                return null;
            }
            if (((String)uri).equals(".")) {
                uri = "";
            }
            if ((node = (RemoteFSNode)this.tree.getLastSelectedPathComponent()) != null && !node.isLeaf()) {
                uri = !"index".equals(JPublishWizard.this.engine.getIndexPageName()) ? IO.combinePaths((String)uri, JPublishWizard.this.engine.getIndexPageName() + JPublishWizard.this.engine.getPageExtension()) : (String)uri + "/";
            }
            String url = IO.combinePaths(JPublishWizard.this.currentAccount.getWebRootURL(), (String)uri);
            return url;
        }

        private void updateView() {
            String url = this.getAlbumURL();
            if (url == null || !JPublishWizard.this.currentAccount.isVerified()) {
                this.previewLink.setVisible(false);
                this.copyURLButton.setVisible(false);
                this.copyURLAction.setEnabled(false);
            } else {
                this.previewLink.setVisible(true);
                this.copyURLButton.setVisible(true);
                this.previewLink.setText(url);
                this.previewLink.setURL(IO.urlEncode(url));
                this.copyURLAction.setEnabled(true);
            }
            RemoteFSNode node = (RemoteFSNode)this.tree.getLastSelectedPathComponent();
            boolean isRootSelected = node == null || node.isRoot();
            boolean isFolderSelected = node != null && !node.isLeaf();
            boolean singleSelected = this.tree.getSelectionCount() == 1;
            this.passwordProtectAction.setEnabled(JPublishWizard.this.currentAccount.isMyjalbum() && node != null && !node.isLeaf() && singleSelected);
            this.markAsWebRootAction.setEnabled(singleSelected);
            this.newDirectoryAction.setEnabled(singleSelected);
            this.renameAction.setEnabled(!isRootSelected && singleSelected);
            this.deleteAction.setEnabled(!isRootSelected && this.tree.getSelectionCount() > 0);
            this.downloadAction.setEnabled(singleSelected);
            boolean enableUpload = isFolderSelected && (this.isAdvancedMode() || !JPublishWizard.this.currentAccount.isMyjalbum() || !isRootSelected) && singleSelected;
            this.uploadAction.setEnabled(enableUpload);
        }

        public String getUrl(String path) {
            String uri;
            String webRoot = JPublishWizard.this.getFtpWebRootDirectory();
            if (webRoot == null) {
                webRoot = "";
            }
            if ((uri = IO.relativePath(path, webRoot)).startsWith("..")) {
                return null;
            }
            if (uri.equals(".")) {
                uri = "";
            }
            if (!"index".equals(JPublishWizard.this.engine.getIndexPageName())) {
                uri = IO.combinePaths(uri, JPublishWizard.this.engine.getIndexPageName() + JPublishWizard.this.engine.getPageExtension());
            }
            Object url = IO.combinePaths(JPublishWizard.this.currentAccount.getWebRootURL(), uri);
            if ("index".equals(JPublishWizard.this.engine.getIndexPageName())) {
                url = (String)url + "/";
            }
            return url;
        }

        private boolean assertValidUpload(boolean fullUpdate) {
            int answer;
            File dir = JPublishWizard.this.engine.getOutputDir();
            if (!dir.isDirectory()) {
                JOptionPane.showMessageDialog(this, Msg.get("publish.invalidOutputDirectoryError"), Msg.get("publish.publishAlbumTitle"), 0);
                return false;
            }
            if (this.treeModel == null) {
                return false;
            }
            AlbumObject root = JPublishWizard.this.context.getFrame().albumExplorer.getRootFolder();
            AlbumObjectProperties props = root.getProperties();
            return this.tree.getLastSelectedPathComponent() != RemoteFSNode.treePath(JPublishWizard.this.getFtpWebRootDirectory(), this.treeModel).getLastPathComponent() || props.containsKey("lastPublishedDate") && JPublishWizard.this.uploadBean.getRemoteDirectory().equals(props.get("remotePath", "")) || !Config.getConfig().isShowWarnings() && !fullUpdate || (answer = JOptionPane.showConfirmDialog(this, Msg.get("publish.publishToRootWarning"), Msg.get("publish.publishAlbumTitle"), 0, 2)) == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resolveAlbumURL() throws IOException, RemoteFSException {
            if (!JPublishWizard.this.currentAccount.isVerified()) {
                String remoteDir = JPublishWizard.this.uploadBean.getRemoteDirectory();
                String absRemoteDir = JPublishWizard.this.toAbsolute(remoteDir);
                try {
                    JPublishWizard.this.uploadBean.getRemoteFS().setDirectory(absRemoteDir);
                }
                catch (RemoteFSException ex) {
                    JPublishWizard.this.uploadBean.getRemoteFS().createDirectory(absRemoteDir);
                    JPublishWizard.this.uploadBean.getRemoteFS().setDirectory(absRemoteDir);
                }
                final String[] parts = remoteDir.split("/");
                final String fileName = "webAccessTest.txt";
                String path = IO.combinePaths(JPublishWizard.this.toAbsolute(remoteDir), fileName);
                String msg = "Test. Remove me";
                try (ByteArrayInputStream is2 = new ByteArrayInputStream(msg.getBytes("UTF-8"));){
                    JPublishWizard.this.uploadBean.getRemoteFS().put(is2, path);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException is2) {
                    // empty catch block
                }
                ExecutorService pool = Executors.newCachedThreadPool();
                class PathChecker
                implements Callable<String> {
                    int split;
                    final /* synthetic */ PublishStep this$1;

                    public PathChecker(int split) {
                        this.this$1 = this$1;
                        this.split = split;
                    }

                    @Override
                    public String call() throws Exception {
                        String testURL = this.this$1.JPublishWizard.this.currentAccount.getWebRootURL();
                        for (int i = this.split; i < parts.length; ++i) {
                            testURL = IO.combinePaths(testURL, parts[i]);
                        }
                        int response = URLChecker.getResponseCode(testURL = IO.combinePaths(testURL, fileName));
                        if (response == 200 || response == 401) {
                            String webRootDir = "";
                            for (int i = 0; i < this.split; ++i) {
                                webRootDir = IO.combinePaths(webRootDir, parts[i]);
                            }
                            return webRootDir;
                        }
                        throw new IOException("Not found");
                    }
                }
                ArrayList<PathChecker> tasks = new ArrayList<PathChecker>();
                if (remoteDir.length() == 0) {
                    tasks.add(new PathChecker(0));
                } else {
                    for (int split = 0; split <= parts.length; ++split) {
                        tasks.add(new PathChecker(split));
                    }
                }
                try {
                    String dir = (String)pool.invokeAny(tasks);
                    JPublishWizard.this.setFtpWebRootDirectory(dir);
                    JPublishWizard.this.currentAccount.setVerified(true);
                    JPublishWizard.this.accountsStep.saveAccounts();
                    TreePath webRootPath = RemoteFSNode.treePath(JPublishWizard.this.getFtpWebRootDirectory(), this.treeModel);
                    this.customRenderer.setWebRoot((TreeNode)webRootPath.getLastPathComponent());
                    this.tree.repaint();
                    this.updateView();
                }
                catch (InterruptedException dir) {
                }
                catch (ExecutionException ex) {
                    System.err.println("No web root directory found");
                }
                finally {
                    pool.shutdown();
                    JPublishWizard.this.uploadBean.getRemoteFS().removeFile(path);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doUploadAlbum(final boolean fullUpdate) {
            this.uploadThread = null;
            try {
                Object[] message;
                JPublishWizard.this.context.getFrame().ui2Engine();
                if (!this.assertValidUpload(fullUpdate)) {
                    return;
                }
                try {
                    this.resolveAlbumURL();
                }
                catch (RemoteFSException ex) {
                    ex.printStackTrace(System.err);
                }
                final String albumURL = this.getAlbumURL();
                String printableAlbumURL = JPublishWizard.this.uploadBean.getPrintableAlbumURL();
                final JLabel publishConfirmationLabel = new JLabel(Msg.get("publish.uploadConfirmation", printableAlbumURL));
                final JLabel albumSizeLabel = new JLabel(Msg.get("publish.albumSize") + ": ");
                final JProgressSpinner sizeSpinner = new JProgressSpinner(18);
                final JLabel quotaLabel = new JLabel(Msg.get("publish.accountSpace") + ": ");
                final JProgressSpinner quotaSpinner = new JProgressSpinner(18);
                if (JPublishWizard.this.currentAccount.isMyjalbum()) {
                    JPanel combined = new JPanel();
                    combined.add(new HBox(quotaLabel, Box.createHorizontalStrut(4), quotaSpinner));
                    combined.add(this.getPromoteMyJAlbumLabel());
                    message = new Object[]{publishConfirmationLabel, new HBox(albumSizeLabel, Box.createHorizontalStrut(4), sizeSpinner), combined};
                } else {
                    message = new Object[]{publishConfirmationLabel, new HBox(albumSizeLabel, Box.createHorizontalStrut(4), sizeSpinner)};
                }
                final ConfirmDialog cd = new ConfirmDialog(JPublishWizard.this.getParentWindow(), message, Msg.get("ui.uploadConfirmationTitle"));
                cd.okButton.setEnabled(false);
                sizeSpinner.workStarted();
                quotaSpinner.workStarted();
                final DiskSpaceReporter reporter = new DiskSpaceReporter(this, JPublishWizard.this.engine.getOutputDir(), JPublishWizard.this.currentAccount.isMyjalbum() ? JPublishWizard.this.currentAccount.getFtpUser() : null){
                    final /* synthetic */ PublishStep this$1;
                    {
                        this.this$1 = this$1;
                        super(albumRoot, userName);
                    }

                    @Override
                    public void localAlbumSizeCalculated(long albumSize) {
                        this.sizeCalculated();
                    }

                    private void updateAlbumSize(long albumSize) {
                        albumSizeLabel.setText(Msg.get("publish.albumSize") + ": " + String.valueOf(DataSizeFormatter.formatBytes(albumSize)));
                    }

                    @Override
                    public void remoteAlbumSizeCalculating(long albumSize) {
                        SwingUtilities.invokeLater(() -> this.updateAlbumSize(albumSize));
                    }

                    @Override
                    public void remoteAlbumSizeCalculated(long albumSize) {
                        try {
                            this.this$1.assertNoAccidentalOverwrite(this.existingFiles);
                            this.sizeCalculated();
                        }
                        catch (OverwriteBlockedException ex) {
                            cd.setVisible(false);
                            this.service.shutdownNow();
                        }
                    }

                    private void sizeCalculated() {
                        if (this.localAlbumSize != null && this.remoteAlbumSize != null) {
                            sizeSpinner.workDone();
                            this.updateAlbumSize(this.localAlbumSize);
                            this.updateOkButtonState();
                        }
                    }

                    @Override
                    public void quotaCalculated(long spaceUsed, long quota) {
                        this.spaceUsed = spaceUsed;
                        this.quota = quota;
                        this.updateOkButtonState();
                        quotaSpinner.workDone();
                        quotaLabel.setText(Msg.get("publish.accountSpace") + ": " + Msg.get("publish.quotaInfo2", DataSizeFormatter.formatBytes(quota - spaceUsed), DataSizeFormatter.formatBytes(quota)));
                    }

                    void updateOkButtonState() {
                        if (this.localAlbumSize != null && this.spaceUsed != null && this.quota != null && this.remoteAlbumSize != null) {
                            long spaceLeft = this.quota - this.spaceUsed - (this.localAlbumSize - this.remoteAlbumSize);
                            if (spaceLeft > 102400L) {
                                cd.okButton.setEnabled(true);
                            } else {
                                publishConfirmationLabel.setText(Msg.get("publish.albumTooLarge"));
                                quotaLabel.setForeground(Color.red);
                            }
                        }
                        if (!this.this$1.JPublishWizard.this.currentAccount.isMyjalbum() && this.localAlbumSize != null && this.remoteAlbumSize != null) {
                            cd.okButton.setEnabled(true);
                        }
                    }

                    @Override
                    public void errorOccured(Exception ex) {
                        cd.errorOccured();
                    }
                };
                int res = cd.showConfirmDialog();
                sizeSpinner.workDone();
                quotaSpinner.workDone();
                reporter.shutdown();
                reporter.assertNoError();
                if (reporter.existingFiles != null) {
                    this.assertNoAccidentalOverwrite(reporter.existingFiles);
                }
                if (res != 0) {
                    if (cd.isChangeLocation()) {
                        Tracer.getInstance().trace("publish change location");
                        JPublishWizard.this.backAction.actionPerformed(null);
                        JPublishWizard.this.setVisible(true);
                    } else {
                        Tracer.getInstance().trace("publish cancelled");
                    }
                    return;
                }
                Tracer.getInstance().trace("publish started");
                final JTransferProgressDialog uploadProgress = JPublishWizard.this.isVisible() ? new JTransferProgressDialog(JPublishWizard.this, Msg.get("ui.uploadingAlbumTitle"), false) : new JTransferProgressDialog(JPublishWizard.this.context.getFrame(), Msg.get("ui.uploadingAlbumTitle"), false);
                this.uploadThread = new Thread(this, "Upload thread"){
                    final /* synthetic */ PublishStep this$1;
                    {
                        this.this$1 = this$1;
                        super(arg0);
                    }

                    @Override
                    public void run() {
                        AlbumManifest manifest = null;
                        try {
                            this.this$1.JPublishWizard.this.uploadBean.addTransferListener(uploadProgress);
                            AlbumObject root = this.this$1.JPublishWizard.this.context.getFrame().albumExplorer.getRootFolder();
                            manifest = this.this$1.JPublishWizard.this.uploadBean.uploadAlbum(this.this$1.JPublishWizard.this.context.getEngine(), fullUpdate, reporter.localAlbumFiles, reporter.existingFiles);
                            uploadProgress.directory.setText(Msg.get("edit.preparingPreviewInfo"));
                            uploadProgress.file.setText(" ");
                            this.this$1.refreshDirectoryAction.actionPerformed(null);
                            this.this$1.doAfterUploadAlbum(this.this$1.JPublishWizard.this.engine.getCurrentProject(), albumURL);
                        }
                        catch (OperationAbortedException ex) {
                            Tracer.getInstance().trace("publish aborted");
                        }
                        catch (RemoteFSException ex) {
                            if (ex.getMessage().toLowerCase().contains("quota")) {
                                Tracer.getInstance().trace("quota exceeded during publish");
                                JOptionPane.showMessageDialog(this.this$1.JPublishWizard.this, new Object[]{Msg.get("publish.quotaExceeded"), this.this$1.getPromoteMyJAlbumLabel()}, uploadProgress.getTitle(), 0);
                            } else {
                                Tracer.getInstance().trace("error during publish", ex, albumURL);
                                Debug.showErrorDialog(this.this$1.JPublishWizard.this, ex);
                            }
                        }
                        catch (IOException | ElementException t2) {
                            Tracer.getInstance().trace("crash", t2, albumURL);
                            Debug.showErrorDialog(this.this$1.JPublishWizard.this, t2);
                        }
                        finally {
                            uploadProgress.setVisible(false);
                            uploadProgress.dispose();
                            this.this$1.JPublishWizard.this.uploadBean.removeTransferListener(uploadProgress);
                            if (!this.this$1.JPublishWizard.this.isVisible()) {
                                this.this$1.JPublishWizard.this.uploadBean.disconnect();
                            }
                        }
                    }
                };
                this.uploadThread.setDaemon(true);
                uploadProgress.onAbort(() -> {
                    if (JPublishWizard.this.uploadBean.workers != null) {
                        JPublishWizard.this.uploadBean.workers.abortWorkers();
                    }
                });
                this.uploadThread.start();
                this.enableActions(false);
                uploadProgress.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        PublishStep.this.enableActions(true);
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                        PublishStep.this.enableActions(true);
                    }
                });
                uploadProgress.setVisible(true);
            }
            catch (OverwriteBlockedException ex) {
                Tracer.getInstance().trace("overwrite protection");
                JOptionPane.showMessageDialog(JPublishWizard.this, ex.getMessage(), Msg.get("publish.overwriteBlockedTitle"), 0);
            }
            catch (Throwable ex) {
                Debug.showErrorDialog(this, ex);
            }
            finally {
                if (!(this.uploadThread != null && this.uploadThread.isAlive() || JPublishWizard.this.isVisible())) {
                    JPublishWizard.this.uploadBean.disconnect();
                    this.uploadThread = null;
                }
            }
        }

        private void assertNoAccidentalOverwrite(Set<RemoteFile> existingFiles) throws OverwriteBlockedException {
            if (!(existingFiles instanceof AlbumManifest.ManifestBasedSet)) {
                RemoteFileImpl indexFile = new RemoteFileImpl(JPublishWizard.this.engine.getIndexPageName() + JPublishWizard.this.engine.getPageExtension());
                RemoteFileImpl rssFile = new RemoteFileImpl("album.rss");
                RemoteFileImpl resFile = new RemoteFileImpl("res");
                RemoteFileImpl lifeboatFile = new RemoteFileImpl("lifeboat.zip");
                RemoteFileImpl jsonFile = new RemoteFileImpl("data1.json");
                if (!(!existingFiles.contains(indexFile) || existingFiles.contains(rssFile) || existingFiles.contains(resFile) || existingFiles.contains(lifeboatFile) || existingFiles.contains(jsonFile))) {
                    throw new OverwriteBlockedException(Msg.get("publish.overwriteBlockedError"));
                }
            }
        }

        private void doAfterUploadAlbum(AlbumProject project, String albumURL) throws IOException, ElementException {
            Config.AfterPublishAction afterPublishAction = Config.getConfig().getAfterPublishAction();
            String cid = AccountManager.resolveCid(JPublishWizard.this.currentAccount);
            this.notifyAboutLikes(JPublishWizard.this.engine.getSkin());
            if (afterPublishAction != Config.AfterPublishAction.doNothing && albumURL != null) {
                JPublishWizard.this.context.getFrame().openInBrowser(albumURL, (Boolean)false);
            }
            TipOfTheDay.showInBackground(Msg.get("tip.shareAfterUpload"), 10);
        }

        private void notifyAboutLikes(final String skin) {
            if (SignInManager.getInstance().isSignedIn()) {
                new Thread(this, "skin likes checker"){
                    final /* synthetic */ PublishStep this$1;
                    {
                        this.this$1 = this$1;
                        super(arg0);
                    }

                    @Override
                    public void run() {
                        JSkinLikesPanel lp = new JSkinLikesPanel(skin);
                        lp.waitForUpdate();
                        if (lp.getLikesCount() != null && !lp.isLikes()) {
                            final JNotification n = new JNotification(lp, JNotification.Type.SKIN);
                            n.setExpiration(60);
                            n.setRememberDismissed(true);
                            if (!n.isDismissedBefore()) {
                                lp.addPropertyChangeListener("likes", evt -> new Thread(this, "closer"){
                                    final /* synthetic */ 21 this$2;
                                    {
                                        this.this$2 = this$2;
                                        super(arg0);
                                    }

                                    @Override
                                    public void run() {
                                        try {
                                            1.sleep(1500L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                        n.setVisible(false);
                                    }
                                }.start());
                                JAlbumContext.getInstance().getFrame().showNotification(n);
                            }
                        }
                    }
                }.start();
            }
        }

        private JLabel getPromoteMyJAlbumLabel() {
            try {
                if (JPublishWizard.this.currentAccount.isMyjalbum()) {
                    return new JLinkLabel(JAlbumSite.getTrueInstance().getMyJAlbumUpgradeUrl() + "/?utm_source=client&utm_medium=upgradeStorageLink&utm_campaign=uploadConfirmationDialog&referrer=jalbumPromoteUpgrade&cid=" + AccountManager.getCid(JPublishWizard.this.currentAccount), Msg.get("publish.upgradeAccount"));
                }
                return new JLinkLabel(JAlbumSite.getTrueInstance().getMyJAlbumInfoUrl() + "/?utm_source=client&utm_medium=getStorageLink&utm_campaign=uploadConfirmationDialog", Msg.get("publish.getAMyJAlbumAccount"));
            }
            catch (IOException | ElementException ex) {
                ex.printStackTrace(System.err);
                return new JLabel();
            }
        }

        void doUploadFiles(final List<File> filesDirs) {
            final JTransferProgressDialog uploadProgress = JPublishWizard.this.isVisible() ? new JTransferProgressDialog(JPublishWizard.this, Msg.get("ui.uploadingFilesTitle"), false) : new JTransferProgressDialog(JPublishWizard.this.context.getFrame(), Msg.get("ui.uploadingFilesTitle"), false);
            Thread uploadThread = new Thread(this, "Upload thread"){
                final /* synthetic */ PublishStep this$1;
                {
                    this.this$1 = this$1;
                    super(arg0);
                }

                @Override
                public void run() {
                    try {
                        this.this$1.JPublishWizard.this.uploadBean.addTransferListener(uploadProgress);
                        this.this$1.JPublishWizard.this.uploadBean.uploadFiles(filesDirs.toArray(new File[filesDirs.size()]), this.this$1.JPublishWizard.this.uploadBean.getRemoteDirectory());
                        uploadProgress.setVisible(false);
                        uploadProgress.dispose();
                        this.this$1.refreshDirectoryAction.actionPerformed(null);
                    }
                    catch (OperationAbortedException operationAbortedException) {
                    }
                    catch (IOException | RemoteFSException t2) {
                        if ("2: No such file".equals(t2.getMessage())) {
                            JOptionPane.showMessageDialog(this.this$1.JPublishWizard.this, new Object[]{Msg.get("publish.quotaExceeded"), this.this$1.getPromoteMyJAlbumLabel()}, Msg.get("ui.uploadingAlbumTitle"), 0);
                            return;
                        }
                        Debug.showErrorDialog(this.this$1.JPublishWizard.this, t2);
                    }
                    finally {
                        this.this$1.JPublishWizard.this.uploadBean.removeTransferListener(uploadProgress);
                    }
                }
            };
            uploadThread.start();
            this.enableActions(false);
            uploadProgress.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PublishStep.this.enableActions(true);
                }

                @Override
                public void windowClosed(WindowEvent e) {
                    PublishStep.this.enableActions(true);
                }
            });
            uploadProgress.setVisible(true);
        }

        void doDownloadFiles(final File target, final Runnable afterDownload) {
            final JTransferProgressDialog downloadProgress = JPublishWizard.this.isVisible() ? new JTransferProgressDialog(JPublishWizard.this, Msg.get("ui.downloading"), false) : new JTransferProgressDialog(JPublishWizard.this.context.getFrame(), Msg.get("ui.downloading"), false);
            Thread uploadThread = new Thread(this, "Download thread"){
                final /* synthetic */ PublishStep this$1;
                {
                    this.this$1 = this$1;
                    super(arg0);
                }

                @Override
                public void run() {
                    try {
                        this.this$1.JPublishWizard.this.uploadBean.addTransferListener(downloadProgress);
                        RemoteFSNode node = (RemoteFSNode)this.this$1.tree.getLastSelectedPathComponent();
                        Tracer.getInstance().trace("download started");
                        if (!node.isLeaf()) {
                            this.this$1.JPublishWizard.this.uploadBean.downloadFiles(node.remotePath(), target);
                        } else {
                            this.this$1.JPublishWizard.this.uploadBean.downloadFile(node, target);
                        }
                        Tracer.getInstance().trace("download done");
                        downloadProgress.setVisible(false);
                        downloadProgress.dispose();
                        afterDownload.run();
                    }
                    catch (OperationAbortedException node) {
                    }
                    catch (IOException | RemoteFSException t2) {
                        Debug.showErrorDialog(this.this$1.JPublishWizard.this, t2);
                    }
                    finally {
                        this.this$1.JPublishWizard.this.uploadBean.removeTransferListener(downloadProgress);
                    }
                }
            };
            uploadThread.start();
            this.enableActions(false);
            downloadProgress.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PublishStep.this.enableActions(true);
                }

                @Override
                public void windowClosed(WindowEvent e) {
                    PublishStep.this.enableActions(true);
                }
            });
            downloadProgress.reset();
            downloadProgress.setVisible(true);
        }

        private void enableActions(boolean enable) {
            if (!enable) {
                JPublishWizard.this.setDefaultCloseOperation(0);
            } else {
                JPublishWizard.this.setDefaultCloseOperation(1);
            }
            JPublishWizard.this.backAction.setEnabled(enable);
            JPublishWizard.this.finishAction.setEnabled(enable);
            JPublishWizard.this.cancelAction.setEnabled(enable);
            this.newDirectoryAction.setEnabled(enable);
            this.renameAction.setEnabled(enable);
            this.downloadAction.setEnabled(enable);
            this.deleteAction.setEnabled(enable);
            this.refreshDirectoryAction.setEnabled(enable);
            this.markAsWebRootAction.setEnabled(enable && !JPublishWizard.this.currentAccount.isMyjalbum());
            this.advancedModeAction.setEnabled(enable);
            this.tree.setEnabled(enable);
            this.uploadAction.setEnabled(enable);
        }

        @Override
        public boolean isAdvancedMode() {
            return this.advancedModeButton.isSelected();
        }

        @Override
        public Window getOwningWindow() {
            return JPublishWizard.this;
        }

        @Override
        public RemoteFSDelegate getRemoteFS() {
            return JPublishWizard.this.uploadBean.getRemoteFS();
        }

        @Override
        public String getBasePath() {
            return JPublishWizard.this.currentAccount.isShowServerRootDirectory() ? "" : JPublishWizard.this.uploadBean.getBaseDirectory();
        }

        @Override
        public Set<String> getProtectedPaths() {
            if (JPublishWizard.this.protectedPaths == null) {
                try {
                    JPublishWizard.this.protectedPaths = AccountManager.getProtectedPaths(JPublishWizard.this.currentAccount);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                    JPublishWizard.this.protectedPaths = new TreeSet<String>();
                }
            }
            return JPublishWizard.this.protectedPaths;
        }

        private void verifyWebAccess() {
            if (!JPublishWizard.this.currentAccount.isVerified() && !JPublishWizard.this.currentAccount.isMyjalbum()) {
                new SwingWorker<Integer, Boolean>(){

                    @Override
                    protected Integer doInBackground() throws Exception {
                        JPublishWizard.this.context.getFrame().progressSpinner.workStarted();
                        JPublishWizard.this.context.getFrame().statusBar.pushText(Msg.get("ui.verifyingWebAccess"));
                        UploadBean.PathFinder pf = JPublishWizard.this.uploadBean.getPathFinder(JPublishWizard.this.currentAccount, JPublishWizard.this.engine);
                        return pf.verifyWebAccess();
                    }

                    @Override
                    protected void done() {
                        JPublishWizard.this.context.getFrame().progressSpinner.workDone();
                        JPublishWizard.this.context.getFrame().statusBar.popText(Msg.get("ui.verifyingWebAccess"));
                        try {
                            int response = (Integer)this.get();
                            if (response == 200 || response == 401) {
                                JPublishWizard.this.currentAccount.setVerified(true);
                                JPublishWizard.this.accountsStep.saveAccounts();
                                return;
                            }
                        }
                        catch (InterruptedException | ExecutionException ex) {
                            Logger.getLogger(JPublishWizard.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        JOptionPane.showMessageDialog(JPublishWizard.this, new JLabel("<html>" + Msg.get("ui.noWebAccessMessage", JPublishWizard.this.currentAccount.getWebRootURL()) + "</html>"), Msg.get("ui.noWebAccessTitle"), 2);
                    }
                }.execute();
            }
        }
    }

    abstract class DiskSpaceReporter {
        protected ExecutorService service = Executors.newCachedThreadPool(new NamedThreadFactory("Space calculator"));
        private final File albumRoot;
        protected NavigableSet<RemoteFile> existingFiles;
        protected Long remoteAlbumSize;
        private long currentRemoteAlbumSize;
        private String parentPath = "";
        private int clusterSize = 1;
        Set<File> localAlbumFiles;
        Long localAlbumSize;
        Long quota;
        Long spaceUsed;
        Throwable error;

        public DiskSpaceReporter(File albumRoot, String userName) throws OverwriteBlockedException {
            this.albumRoot = albumRoot;
            this.clusterSize = JAlbumSite.getInstance().getMyJAlbumFileClusterSize();
            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
            if (userName != null) {
                futures.add(this.service.submit(() -> {
                    try {
                        RobustResty r = new RobustResty();
                        Properties p = new Properties();
                        p.setProperty("userName", userName);
                        String content1 = r.text(JAlbumSite.getTrueInstance().getMyJAlbumQuotaUrl(), (AbstractContent)RobustResty.form(p)).toString();
                        Element result = Elements.getElementByName("result", content1, false);
                        if (result != null) {
                            this.quotaCalculated(Long.parseLong(result.getAttribute("usage")) * 1024L, Long.parseLong(result.getAttribute("quota")) * 1024L);
                        }
                        return null;
                    }
                    catch (InterruptedIOException ex) {
                        throw ex;
                    }
                    catch (IOException | NumberFormatException | ElementException ex) {
                        this.error = ex;
                        this.errorOccured(ex);
                        throw ex;
                    }
                }));
            }
            futures.add(this.service.submit(() -> {
                try {
                    this.existingFiles = JPublishWizard.this.uploadBean.getExistingAlbumFiles(JPublishWizard.this.engine, JPublishWizard.this.uploadBean.getRemoteDirectory(), rf -> {
                        this.currentRemoteAlbumSize += this.toClusterSize(rf.size());
                        if (!rf.getParentPath().equals(this.parentPath)) {
                            this.remoteAlbumSizeCalculating(this.currentRemoteAlbumSize);
                        }
                        this.parentPath = rf.getParentPath();
                    });
                    this.remoteAlbumSize = UploadBean.getTotalSize(this.existingFiles, JAlbumSite.getInstance().getMyJAlbumFileClusterSize());
                    this.remoteAlbumSizeCalculated(this.remoteAlbumSize);
                    return null;
                }
                catch (InterruptedIOException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    this.error = ex;
                    this.errorOccured(ex);
                    throw ex;
                }
            }));
            futures.add(this.service.submit(() -> {
                try (FileTreeProcessor p = new FileTreeProcessor(new FileTreeCollection(albumRoot, (FileFilter)new UploadBean.UploadFileFilter()));){
                    this.localAlbumFiles = p.process(str -> str.peek(f -> {
                        if (Thread.interrupted()) {
                            throw new OperationAbortedException();
                        }
                    }).filter(f -> !f.isDirectory()).collect(Collectors.toSet()));
                    this.localAlbumSize = this.localAlbumFiles.stream().mapToLong(rf -> this.toClusterSize(rf.length())).sum();
                    this.localAlbumSizeCalculated(this.localAlbumSize);
                }
                catch (IOException ex) {
                    this.error = ex;
                    this.errorOccured(ex);
                    throw ex;
                }
                return null;
            }));
        }

        public void assertNoError() throws Throwable {
            if (this.error != null) {
                throw this.error;
            }
        }

        public void shutdown() throws InterruptedException {
            this.service.shutdownNow();
            this.service.awaitTermination(10L, TimeUnit.SECONDS);
        }

        public abstract void remoteAlbumSizeCalculating(long var1);

        public abstract void remoteAlbumSizeCalculated(long var1);

        public abstract void localAlbumSizeCalculated(long var1);

        public abstract void quotaCalculated(long var1, long var3);

        public abstract void errorOccured(Exception var1);

        private long toClusterSize(long size) {
            return (size + (long)this.clusterSize - 1L) / (long)this.clusterSize * (long)this.clusterSize;
        }
    }

    class ConfirmDialog
    extends JDialog
    implements ActionListener {
        Action privacyAction;
        private Object source;
        JButton okButton;
        JButton cancelButton;
        JButton changeLocationButton;
        JButton privacyButton;
        private boolean errorOccured;

        public ConfirmDialog(Window parent, Object[] message, String title) {
            super(parent, title, Dialog.ModalityType.APPLICATION_MODAL);
            this.privacyAction = new AbstractAction(Msg.get("ui.privacy")){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JPrivacyDialog d = new JPrivacyDialog((Dialog)ConfirmDialog.this, JPublishWizard.this.engine, JPublishWizard.this.currentAccount);
                    d.setVisible(true);
                }
            };
            this.okButton = new JButton(Msg.get("ok"));
            this.cancelButton = new JButton(Msg.get("cancel"));
            this.changeLocationButton = new JButton(Msg.get("ui.changeLocation"));
            this.privacyButton = new JButton(this.privacyAction);
            this.privacyButton.setToolTipText(Msg.get("ui.privacyToolTip"));
            this.getRootPane().setDefaultButton(this.okButton);
            Container c = this.getContentPane();
            c.setLayout((LayoutManager)new MigLayout("fill, insets dialog"));
            for (Object o : message) {
                if (o == null) continue;
                c.add((Component)o, "wrap");
            }
            c.add((Component)this.changeLocationButton, "split 4,");
            c.add(this.privacyButton);
            c.add((Component)this.okButton, "tag ok");
            c.add((Component)this.cancelButton, "tag cancel");
            this.okButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
            this.changeLocationButton.addActionListener(this);
            if (JPublishWizard.this.isVisible()) {
                this.changeLocationButton.setVisible(false);
            }
            this.pack();
            this.setLocationRelativeTo(parent);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    if (ConfirmDialog.this.errorOccured) {
                        ConfirmDialog.this.setVisible(false);
                    }
                }
            });
        }

        public void errorOccured() {
            this.errorOccured = true;
            this.setVisible(false);
        }

        public int showConfirmDialog() {
            if (this.errorOccured) {
                return 2;
            }
            this.setVisible(true);
            return this.source == this.okButton ? 0 : 2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.source = e.getSource();
            this.setVisible(false);
        }

        public boolean isChangeLocation() {
            return this.source == this.changeLocationButton;
        }
    }
}

