/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import javax.swing.text.JTextComponent;
import net.jalbum.component.JRememberedFrame;
import net.jalbum.component.RememberedName;
import net.jalbum.projectgroups.JProjectGroupsComboBox;
import net.jalbum.projectgroups.ProjectGroup;
import net.jalbum.projectgroups.ProjectGroups;
import net.jalbum.util.AbortableBackgroundTask;
import net.jalbum.util.Func;
import se.datadosen.component.ChooserFactory;
import se.datadosen.component.FileChooser;
import se.datadosen.component.JNotification;
import se.datadosen.component.RiverLayout2;
import se.datadosen.dnd.FileDropListener;
import se.datadosen.dnd.JFileDropPanel;
import se.datadosen.io.ConsoleStream;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumFrameIcons;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.MakeAlbumTask;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.ProjectSettings;
import se.datadosen.jalbum.ScriptEnvironment;
import se.datadosen.jalbum.TaskManager;
import se.datadosen.jalbum.TypeNavigator;
import se.datadosen.jalbum.UploadAlbumTask;
import se.datadosen.util.ContextHelp;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.LambdaAction;
import se.datadosen.util.NamedThreadFactory;
import se.datadosen.util.TableColumnAdjuster2;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

@RememberedName(value="Multimaker window")
public class JMultiMaker
extends JRememberedFrame {
    private final String CTRL_KEY = InputEvent.getModifiersExText(Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
    Preferences prefs = Preferences.userNodeForPackage(JMultiMaker.class);
    JAlbumFrame window;
    PrintStream log;
    JAlbumContext context = JAlbumContext.getInstance();
    TaskManager<MakeAlbumTask> maker = new TaskManager("Background maker");
    TaskManager<UploadAlbumTask> uploader = new TaskManager("Background uploader");
    private ScheduledExecutorService changeChecker = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Background change checker"));
    ForkJoinPool changeCheckingPool = new ForkJoinPool(4);
    ScriptEnvironment sharedScriptEnvironment;
    JTextArea logArea = new JTextArea(8, 50);
    private AlbumProjectModel model;
    private JTable table;
    private JPopupMenu popup = new JPopupMenu();
    private Date dialogOpenDate;
    private AlbumProject projectAtPoint;
    private TypeNavigator typeNavigator;
    private TableRowSorter<AlbumProjectModel> sorter;
    @Text(value="ui.fileMenu")
    JMenu fileMenu = new JMenu();
    @Text(value="ui.view")
    JMenu viewMenu = new JMenu();
    MenuItem multiMakerItem;
    @Text(value="ui.location")
    JLabel locationLabel = new JLabel();
    JProjectGroupsComboBox projectGroupSelector = new JProjectGroupsComboBox();
    ActionListener locationListener = ae -> this.setProjectGroup(this.projectGroupSelector.getSelectedGroup());
    @se.datadosen.util.annotations.Icon(value="16x16/lightbulb.svg")
    JLabel prompt;
    @se.datadosen.util.annotations.Icon(value="16x16/lightbulb.svg")
    JLabel prompt2;
    @Text(value="close")
    Action closeAction;
    JButton closeButton;
    @Text(value="ui.makeSelected")
    @ToolTipText(value="ui.makeSelectedToolTip")
    Action makeSelectedAction;
    @Text(value="ui.uploadSelected")
    Action uploadSelectedAction;
    @Text(value="ui.makeAndUploadSelected")
    Action makeAndUploadAction;
    @Text(value="ui.openProject")
    Action openProjectAction;
    @Text(value="ui.viewAlbumToolTip")
    Action viewLocalAlbumAction;
    @Text(value="ui.viewPublishedAlbum")
    Action viewPublishedAlbumAction;
    @Text(value="ui.makeInBackground")
    public Action makeInBackgroundAction;
    @Text(value="ui.makeAndUploadInBackground")
    public Action makeAndUploadInBackgroundAction;
    @Text(value="ui.uploadInBackground")
    public Action uploadInBackgroundAction;
    @Text(value="ui.clearList")
    public Action clearListAction;
    @Text(value="ui.restoreList")
    public Action restoreListAction;
    @Text(value="ui.openProjectListFile")
    public Action openProjectListFileAction;
    @Text(value="ui.applyCurrentSettings", postfix="...")
    public Action applyCurrentSettingsAction;
    JButton makeButton;
    JButton makeAndUploadButton;
    JButton uploadButton;
    protected final DefaultTableCellRenderer albnumProjectRenderer;
    private final DefaultTableCellRenderer dateCellRenderer;
    boolean firstOpen;

    private static Boolean shiftDown(ActionEvent ae) {
        return (ae.getModifiers() & 1) != 0 ? Boolean.valueOf(true) : null;
    }

    private static boolean altDown(ActionEvent ae) {
        return (ae.getModifiers() & 8) != 0;
    }

    private void updateTable(AlbumProject ap) {
        int row = this.model.getProjectIndex(ap);
        if (row != -1) {
            this.model.fireTableRowsUpdated(row, row);
        }
    }

    private void openProjectListFile(File projectsFile) throws IOException {
        ArrayList<AlbumProject> listData = new ArrayList<AlbumProject>();
        try (BufferedReader in = new BufferedReader(new StringReader(IO.readTextFile(projectsFile)));){
            String path;
            while ((path = in.readLine()) != null) {
                if ((path = path.trim()).length() <= 0) continue;
                File f = new File(path);
                if (f.exists()) {
                    listData.add(new AlbumProject(f, this.window.context.getAlbumObjectfactory()));
                    continue;
                }
                System.out.println("File not found: " + f.getAbsolutePath());
            }
        }
        this.model.setData(listData);
        this.table.selectAll();
    }

    private void setProjectGroup(ProjectGroup group) {
        this.model.clear();
        if (group instanceof JProjectGroupsComboBox.SelectFolderProjectGroup && !((JProjectGroupsComboBox.SelectFolderProjectGroup)group).chooseLocation()) {
            return;
        }
        File location = group.getLocation();
        if (location != null) {
            for (AlbumProject ap : group.getProjects()) {
                this.model.addProject(ap);
            }
        }
    }

    private void makeProjects(String title, List<AlbumProject> projects, Boolean forceRebuild, boolean forceVideoProcessing, boolean uploadToo) {
        this.window.dismissNotifications();
        for (AlbumProject ap : projects) {
            try {
                this.makeProjectInBackground(ap, forceRebuild, forceVideoProcessing, uploadToo);
            }
            catch (IOException ex) {
                Logger.getLogger(JMultiMaker.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.getRootPane().setDefaultButton(this.closeButton);
        this.window.progressManager.showTasksPanel();
    }

    String getAlbumURL(AlbumProject ap) {
        AlbumObjectProperties props = ap.getRootFolder().getProperties();
        return (String)props.get("albumURL");
    }

    void showNotification(JNotification n) {
        switch (Config.getConfig().getBgNotifications()) {
            case NORMAL: {
                this.window.showNotification(n);
                break;
            }
            case DISCRETE: {
                this.window.notificationManager.addOldNotification(n);
                break;
            }
        }
    }

    public void makeCurrentProjectInBackground(boolean uploadToo) {
        this.makeCurrentProjectInBackground(null, false, uploadToo);
    }

    public void makeCurrentProjectInBackground(Boolean forceRebuild, boolean forceVideoProcessing, boolean uploadToo) {
        this.window.dismissNotifications();
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component fo = kfm.getFocusOwner();
        if (fo instanceof JTextComponent) {
            fo.transferFocus();
            fo.requestFocusInWindow();
            SwingUtilities.invokeLater(() -> this.makeCurrentProjectInBackground(uploadToo));
            return;
        }
        try {
            MakeAlbumTask makeTask = new MakeAlbumTask(this.context, this.window);
            makeTask.setForceRebuild(forceRebuild);
            makeTask.setForceVideoProcessing(forceVideoProcessing);
            this.makeInBackground(makeTask, uploadToo);
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, ex);
        }
    }

    public void makeProjectInBackground(AlbumProject ap, Boolean forceRebuild, boolean forceVideoProcessing, boolean uploadToo) throws IOException {
        MakeAlbumTask makeTask = new MakeAlbumTask(ap, this.context, this.window);
        makeTask.setForceRebuild(forceRebuild);
        makeTask.setForceVideoProcessing(forceVideoProcessing);
        this.makeInBackground(makeTask, uploadToo);
    }

    public void makeInBackground(MakeAlbumTask makeTask, boolean uploadToo) {
        if (this.maker.getQueuedTasks(makeTask.ap).count() > 0L) {
            this.window.statusBar.setText(Msg.get("ui.projectAlreadyQueued", makeTask.ap.getName()));
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.window.progressManager.addTask(makeTask.ts);
        UploadAlbumTask uploadTask = new UploadAlbumTask(makeTask.getEngine(), this.window, this.log);
        if (uploadToo) {
            uploadTask.ts.setSubMessage(Msg.get("ui.waitingForMake") + "...");
            this.window.progressManager.addTask(uploadTask.ts);
            makeTask.setChainedTask(uploadTask);
            uploadTask.onDone(() -> {
                if (uploadTask.completedNormally()) {
                    this.updateTable(uploadTask.ap);
                }
            });
            makeTask.onDone(() -> {
                if (makeTask.completedNormally()) {
                    this.updateTable(makeTask.ap);
                    uploadTask.ts.setSubMessage(" ");
                    String msg = Msg.get("ui.makingAlbumDone", makeTask.ap.getName(), makeTask.getEngine().getStopwatch());
                    this.window.statusBar.setText(msg);
                    if (makeTask.ap == this.window.getCurrentProject()) {
                        this.window.changeStatus.refresh();
                    }
                    if (!uploadTask.isCancelled()) {
                        this.uploader.submit(uploadTask);
                    }
                } else {
                    uploadTask.abort();
                    this.window.progressManager.removeTask(uploadTask.ts);
                }
            });
        } else {
            makeTask.onDone(() -> {
                this.updateTable(makeTask.ap);
                if (makeTask.completedNormally()) {
                    this.window.fixUIdisabling();
                    String msg = Msg.get("ui.makingAlbumDone", makeTask.ap.getName(), makeTask.getEngine().getStopwatch());
                    this.window.statusBar.setText(msg);
                    if (makeTask.ap == this.window.getCurrentProject()) {
                        this.window.changeStatus.refresh();
                    }
                    JNotification n = new JNotification(msg + ". <a href=\"about:blank\">" + Msg.get("ui.preview") + "</a>", JNotification.Type.INFO);
                    n.onLinkClicked(he -> {
                        try {
                            n.setDismissed(true);
                            File outputDir = makeTask.getEngine().getOutputDir();
                            File indexFile = new File(outputDir, makeTask.engine.getIndexPageName() + makeTask.getEngine().getPageExtension());
                            this.window.openInBrowser(makeTask.ap, indexFile.toURI().toURL(), null);
                        }
                        catch (MalformedURLException ex) {
                            Debug.showErrorDialog(this.window, ex);
                        }
                    });
                    n.setExpiration(8);
                    n.setDismissed(true);
                    this.showNotification(n);
                }
            });
        }
        this.maker.submit(makeTask);
    }

    public void uploadProjectInBackground(AlbumProject ap) {
        try {
            UploadAlbumTask uploadTask = new UploadAlbumTask(ap, this.context, this.window, this.log);
            uploadTask.onDone(() -> {
                if (uploadTask.completedNormally()) {
                    this.updateTable(uploadTask.ap);
                }
            });
            this.window.progressManager.addTask(uploadTask.ts);
            this.uploader.submit(uploadTask);
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, ex);
        }
    }

    public void uploadInBackground(AlbumBean engine) {
        if (this.uploader.getQueuedTasks(engine.getCurrentProject()).count() > 0L) {
            this.window.statusBar.setText(Msg.get("ui.projectAlreadyQueued", engine.getCurrentProject().getName()));
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        UploadAlbumTask uploadTask = new UploadAlbumTask(engine, this.window, this.log);
        uploadTask.onDone(() -> {
            if (uploadTask.completedNormally()) {
                this.updateTable(uploadTask.ap);
            }
        });
        this.window.progressManager.addTask(uploadTask.ts);
        this.uploader.submit(uploadTask);
    }

    public JMultiMaker(JAlbumContext context) {
        super(Msg.get("ui.multiMaker"));
        this.projectGroupSelector.addActionListener(this.locationListener);
        this.prompt = new JLabel(Msg.get("ui.multiMakerPrompt", this.CTRL_KEY));
        this.prompt2 = new JLabel("(" + Msg.get("ui.multiMakerProjectListToolTip") + ")");
        this.closeAction = new LambdaAction(ae -> {
            this.setVisible(false);
            this.handleClose();
        });
        this.closeButton = new JButton(this.closeAction);
        this.makeSelectedAction = new LambdaAction(ae -> {
            this.logArea.setText("");
            this.table.repaint();
            this.makeProjects(Msg.get("ui.makeSelected"), this.getSelectedProjects(), JMultiMaker.shiftDown(ae), JMultiMaker.altDown(ae), false);
        });
        this.uploadSelectedAction = new LambdaAction(() -> {
            this.logArea.setText("");
            this.table.repaint();
            this.window.dismissNotifications();
            for (AlbumProject ap : this.getSelectedProjects()) {
                this.uploadProjectInBackground(ap);
            }
            this.getRootPane().setDefaultButton(this.closeButton);
            this.window.progressManager.showTasksPanel();
        });
        this.makeAndUploadAction = new LambdaAction(ae -> {
            this.logArea.setText("");
            this.table.repaint();
            this.makeProjects(Msg.get("ui.makeAndUploadSelected"), this.getSelectedProjects(), JMultiMaker.shiftDown(ae), JMultiMaker.altDown(ae), true);
        });
        this.openProjectAction = new LambdaAction(ae -> {
            AlbumProject ap = this.projectAtPoint;
            this.window.loadProject(ap.getProjectFile());
            this.window.toFront();
        });
        this.viewLocalAlbumAction = new LambdaAction(ae -> {
            try {
                AlbumProject ap = this.projectAtPoint;
                AlbumBean tempEngine = new AlbumBean();
                tempEngine.setProperties(ap.getProperties());
                File outputDir = tempEngine.getOutputDir();
                this.window.openInBrowser(ap, outputDir.toURI().toURL(), null);
            }
            catch (IOException ex) {
                Logger.getLogger(JMultiMaker.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.viewPublishedAlbumAction = new LambdaAction(ae -> {
            AlbumProject ap = this.projectAtPoint;
            String url = this.getAlbumURL(ap);
            if (url != null) {
                this.window.openInBrowser(url);
            }
        });
        this.makeInBackgroundAction = new LambdaAction(ae -> {
            try {
                this.makeProjectInBackground(this.projectAtPoint, JMultiMaker.shiftDown(ae), JMultiMaker.altDown(ae), false);
                this.window.progressManager.showTasksPanel();
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        });
        this.makeAndUploadInBackgroundAction = new LambdaAction(ae -> {
            try {
                this.makeProjectInBackground(this.projectAtPoint, JMultiMaker.shiftDown(ae), JMultiMaker.altDown(ae), true);
                this.window.progressManager.showTasksPanel();
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        });
        this.uploadInBackgroundAction = new LambdaAction(() -> {
            this.uploadProjectInBackground(this.projectAtPoint);
            this.window.progressManager.showTasksPanel();
        });
        this.clearListAction = new LambdaAction(() -> this.model.setData(new ArrayList<AlbumProject>()));
        this.restoreListAction = new LambdaAction(() -> this.model.setData(this.window.albumExplorer.albumManager.getProjects()));
        this.openProjectListFileAction = new LambdaAction(() -> {
            File projectsFile;
            FileChooser chooser = ChooserFactory.createFileChooser(this);
            if (chooser.showOpenDialog(this) == 0 && (projectsFile = chooser.getSelectedFile()) != null) {
                try {
                    this.openProjectListFile(projectsFile);
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(this, ex);
                }
            }
        });
        this.applyCurrentSettingsAction = new LambdaAction(() -> {
            int answer = JOptionPane.showConfirmDialog(this, Msg.get("ui.applyCurrentSettingsWarning"), Msg.get("ui.applyCurrentSettings"), 0, 2);
            if (answer != 0) {
                return;
            }
            for (AlbumProject ap : this.getSelectedProjects()) {
                try {
                    Properties props = ap.getProperties();
                    ProjectSettings currentSettings = new ProjectSettings(this.window.engine);
                    for (String key : ProjectSettings.SPECIFIC_KEYS) {
                        String val = props.getProperty(key);
                        if (val != null) {
                            currentSettings.main.put(key, val);
                            continue;
                        }
                        currentSettings.main.remove(key);
                    }
                    currentSettings.save(ap.getProjectFile());
                    this.updateTable(ap);
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(this, ex);
                }
            }
        });
        this.makeButton = new JButton(this.makeSelectedAction);
        this.makeAndUploadButton = new JButton(this.makeAndUploadAction);
        this.uploadButton = new JButton(this.uploadSelectedAction);
        this.albnumProjectRenderer = new DefaultTableCellRenderer(){
            private final ImageIcon newAlbumProjectIcon = Icons.getIcon("big.newAlbumProject");

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                AlbumProject ap = (AlbumProject)value;
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, ap.getName(), isSelected, hasFocus, row, column);
                label.setIcon(ap.icon != null ? ap.icon : this.newAlbumProjectIcon);
                if (table.isShowing()) {
                    ap.forIcon((icon, cached) -> {
                        label.setIcon((Icon)icon);
                        if (!cached.booleanValue()) {
                            JMultiMaker.this.model.fireTableCellUpdated(row, column);
                        }
                    });
                }
                label.setToolTipText(ap.getLongName());
                return label;
            }
        };
        this.dateCellRenderer = new DefaultTableCellRenderer(){
            private final JLabel label = new JLabel();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel template = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                try {
                    Date date = (Date)value;
                    this.label.setText(date.getTime() != 0L ? JMultiMaker.formatDate(date) : "");
                    this.label.setOpaque(template.isOpaque());
                    this.label.setForeground(template.getForeground());
                    this.label.setBackground(template.getBackground());
                    this.label.setBorder(null);
                    if (date.after(JMultiMaker.this.dialogOpenDate)) {
                        this.label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createLineBorder(Color.green.darker())));
                        this.label.setForeground(Color.green.darker());
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                return this.label;
            }
        };
        this.firstOpen = true;
        this.window = context.getFrame();
        this.init(context);
    }

    List<AlbumProject> getSelectedProjects() {
        ArrayList<AlbumProject> selectedProjects = new ArrayList<AlbumProject>();
        for (int index : this.table.getSelectedRows()) {
            selectedProjects.add(this.model.getProject(this.table.convertRowIndexToModel(index)));
        }
        return selectedProjects;
    }

    private void loadSelection() {
        try {
            HashSet<String> selected = new HashSet<String>(Arrays.asList(this.prefs.node("selectedProjects").keys()));
            ListSelectionModel selModel = this.table.getSelectionModel();
            selModel.clearSelection();
            for (int i = 0; i < this.model.projects.size(); ++i) {
                AlbumProject ap = this.model.getProject(i);
                if (!selected.contains(ap.getName())) continue;
                int viewIndex = this.table.convertRowIndexToView(i);
                this.table.getSelectionModel().addSelectionInterval(viewIndex, viewIndex);
            }
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(JMultiMaker.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.getRootPane().setDefaultButton(this.makeButton);
            this.dialogOpenDate = new Date();
        }
        this.setProjectGroup(this.projectGroupSelector.getSelectedGroup());
        super.setVisible(visible);
    }

    private void init(JAlbumContext context) {
        Msg.maintainTranslated(this);
        this.model = new AlbumProjectModel(new ArrayList<AlbumProject>(ProjectGroups.getInstance().getCurrentGroup().getProjects()));
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.fileMenu);
        menuBar.add(this.viewMenu);
        this.fileMenu.add(this.openProjectListFileAction);
        this.viewMenu.add(this.clearListAction);
        this.viewMenu.add(this.restoreListAction);
        this.setJMenuBar(menuBar);
        this.dialogOpenDate = new Date();
        this.setIconImages(JAlbumFrameIcons.getInstance().getWindowIcons());
        this.projectGroupSelector.setSelectedItem(ProjectGroups.getInstance().getCurrentGroup());
        this.table = new JTable(this.model){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(super.getPreferredSize().width, super.getPreferredScrollableViewportSize().height);
            }
        };
        this.sorter = new TableRowSorter<AlbumProjectModel>(this.model);
        this.sorter.setComparator(0, (p1, p2) -> p1.getName().compareToIgnoreCase(p2.getName()));
        this.table.setRowSorter(this.sorter);
        this.table.setRowHeight(AlbumProject.iconSize.height + 2);
        this.table.setSelectionMode(2);
        this.table.setAutoResizeMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int rowAtPoint = JMultiMaker.this.table.rowAtPoint(e.getPoint());
                    JMultiMaker.this.projectAtPoint = JMultiMaker.this.model.getProject(JMultiMaker.this.table.convertRowIndexToModel(rowAtPoint));
                    JMultiMaker.this.openProjectAction.actionPerformed(null);
                }
            }
        });
        this.typeNavigator = new TypeNavigator(this.table){

            @Override
            public String getFocusedName() {
                int selectedRow = JMultiMaker.this.table.getSelectedRow();
                return selectedRow != -1 ? JMultiMaker.this.model.getProject(JMultiMaker.this.table.convertRowIndexToModel(selectedRow)).getName() : null;
            }

            @Override
            public void focusNextMatching(String prefix) {
                int i;
                int selectedRow = JMultiMaker.this.table.getSelectedRow();
                if (selectedRow == -1) {
                    selectedRow = 0;
                }
                for (i = selectedRow + 1; i < JMultiMaker.this.model.getRowCount(); ++i) {
                    if (!this.isMatch(JMultiMaker.this.model.getProject(JMultiMaker.this.table.convertRowIndexToModel(i)).getName())) continue;
                    JMultiMaker.this.table.getSelectionModel().setSelectionInterval(i, i);
                    JMultiMaker.this.table.scrollRectToVisible(JMultiMaker.this.table.getCellRect(i, 0, true));
                    return;
                }
                for (i = 0; i < selectedRow - 1; ++i) {
                    if (!this.isMatch(JMultiMaker.this.model.getProject(JMultiMaker.this.table.convertRowIndexToModel(i)).getName())) continue;
                    JMultiMaker.this.table.getSelectionModel().setSelectionInterval(i, i);
                    JMultiMaker.this.table.scrollRectToVisible(JMultiMaker.this.table.getCellRect(i, 0, true));
                    return;
                }
                Toolkit.getDefaultToolkit().beep();
            }
        };
        this.popup.add(this.applyCurrentSettingsAction);
        this.popup.addSeparator();
        this.popup.add(this.makeInBackgroundAction);
        this.popup.add(this.makeAndUploadInBackgroundAction);
        this.popup.add(this.uploadInBackgroundAction);
        this.popup.addSeparator();
        this.popup.add(this.openProjectAction);
        this.popup.add(this.viewLocalAlbumAction);
        this.popup.add(this.viewPublishedAlbumAction);
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SwingUtilities.invokeLater(() -> {
                    int rowAtPoint = JMultiMaker.this.table.rowAtPoint(SwingUtilities.convertPoint(JMultiMaker.this.popup, new Point(0, 0), JMultiMaker.this.table));
                    if (rowAtPoint > -1) {
                        JMultiMaker.this.projectAtPoint = JMultiMaker.this.model.getProject(JMultiMaker.this.table.convertRowIndexToModel(rowAtPoint));
                        String url = JMultiMaker.this.getAlbumURL(JMultiMaker.this.projectAtPoint);
                        JMultiMaker.this.viewPublishedAlbumAction.setEnabled(url != null);
                    }
                });
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.table.setComponentPopupMenu(this.popup);
        for (int colIndex = 0; colIndex < this.model.cols.length; ++colIndex) {
            if (this.model.cols[colIndex].renderer == null) continue;
            TableColumn column = this.table.getColumnModel().getColumn(colIndex);
            column.setCellRenderer(this.model.cols[colIndex].renderer);
            if (this.model.cols[colIndex].minWidth <= 0) continue;
            column.setMinWidth(this.model.cols[colIndex].minWidth);
        }
        SwingUtilities.invokeLater(() -> {
            TableColumnAdjuster2.adjustColumnWidths(this.table);
            this.pack();
        });
        JComponent content = (JComponent)this.getContentPane();
        content.setBorder(BorderFactory.createEmptyBorder(12, 12, 8, 12));
        JFileDropPanel topSection = new JFileDropPanel(new BorderLayout());
        JPanel bottomPanel = new JPanel(new BorderLayout());
        this.prompt.setBorder(BorderFactory.createEmptyBorder(0, 0, 12, 0));
        JPanel controls = new JPanel(new RiverLayout2());
        controls.add(this.locationLabel);
        controls.add(this.projectGroupSelector);
        controls.add("br", this.prompt);
        controls.add("br", this.prompt2);
        controls.add("br", Box.createVerticalStrut(12));
        content.add((Component)controls, "North");
        FileDropListener fileDropListener = e -> {
            try {
                File droppedFile = e.getFirstFile();
                if (!droppedFile.isDirectory()) {
                    this.openProjectListFile(droppedFile);
                } else {
                    this.model.clear();
                    ProjectGroup droppedGroup = ProjectGroup.createInstance(() -> droppedFile);
                    for (AlbumProject ap : droppedGroup.getProjects()) {
                        this.model.addProject(ap);
                    }
                }
            }
            catch (Exception ex) {
                Debug.showFriendlyErrorDialog(this, ex);
            }
        };
        topSection.addFileDropListener(fileDropListener);
        topSection.add(new JScrollPane(this.table));
        this.logArea.setEditable(false);
        this.log = new PrintStream(new ConsoleStream(this.logArea), true);
        JPanel buttonPanel = new JPanel(new FlowLayout(4));
        this.getRootPane().setDefaultButton(this.makeButton);
        buttonPanel.add(this.makeButton);
        buttonPanel.add(this.makeAndUploadButton);
        buttonPanel.add(this.uploadButton);
        buttonPanel.add(this.closeButton);
        bottomPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add((Component)bottomPanel, "South");
        this.add(topSection);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JMultiMaker.this.setVisible(false);
                JMultiMaker.this.handleClose();
            }
        });
        ContextHelp help = ContextHelp.getInstance();
        help.installHelpButton(this, ContextHelp.Corner.TOP_RIGHT);
        help.add((JComponent)this.getContentPane(), "MultiMaker");
        this.makeSelectedAction.setEnabled(false);
        this.makeAndUploadAction.setEnabled(false);
        this.uploadSelectedAction.setEnabled(false);
        this.table.getSelectionModel().addListSelectionListener(e -> {
            int[] selRows = this.table.getSelectedRows();
            this.makeSelectedAction.setEnabled(selRows.length > 0);
            this.makeAndUploadAction.setEnabled(selRows.length > 0);
            this.uploadSelectedAction.setEnabled(selRows.length > 0);
        });
        this.loadSelection();
        AbortableBackgroundTask abt = new AbortableBackgroundTask(this.window.progressManager, Msg.get("ui.monitorChanges"));
        abt.setMillisToPopup(3000);
        abt.onAbort(() -> {
            abt.removeTaskStatus();
            this.changeCheckingPool.shutdownNow();
            this.changeCheckingPool = new ForkJoinPool(4);
        });
        this.changeChecker.scheduleWithFixedDelay(() -> {
            try {
                ProjectGroups.getInstance().groups().forEach(pg -> {
                    try {
                        for (AlbumProject ap : pg.getProjects()) {
                            Long lastMade;
                            if (this.maker.getTasks(ap).count() > 0L || ap.equals(this.window.albumExplorer.albumManager.getCurrentProject()) || (lastMade = ap.getRootFolder().getProperties().get("lastMadeDate", 0L)) == null || !ap.getRootFolder().getProperties().get("makeOnChange", false).booleanValue()) continue;
                            abt.call(() -> {
                                try {
                                    abt.setSubMessage(ap.getName());
                                    long lastModified = JAlbumUtilities.deepLastModified(ap.getRootFolder(), this.changeCheckingPool);
                                    if (lastModified > lastMade) {
                                        long newLastModified = lastModified;
                                        do {
                                            lastModified = newLastModified;
                                            Thread.sleep(3000L);
                                        } while ((newLastModified = JAlbumUtilities.deepLastModified(ap.getRootFolder(), this.changeCheckingPool)) > lastModified);
                                        boolean uploadToo = ap.getRootFolder().getProperties().get("uploadOnChange", false);
                                        String msg = uploadToo ? Msg.get("ui.changesDetectedMakingAndUploadingMessage", ap.getName()) : Msg.get("ui.changesDetectedMakingMessage", ap.getName());
                                        JNotification n = new JNotification(msg, JNotification.Type.INFO);
                                        n.setExpiration(4);
                                        this.showNotification(n);
                                        this.makeProjectInBackground(ap, false, false, uploadToo);
                                    }
                                }
                                catch (OperationAbortedException ex) {
                                    this.window.statusBar.setText(Msg.get("ui.taskAborted", Msg.get("ui.monitorChanges")));
                                }
                                catch (IOException ex) {
                                    JAlbum.logger.fine(ex.getMessage());
                                }
                                return null;
                            });
                        }
                    }
                    catch (ConcurrentModificationException i$) {
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(System.err);
                    }
                });
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }, 5L, 10L, TimeUnit.SECONDS);
        context.getFrame().addPropertyChangeListener("skinLoaded", pce -> {
            this.sharedScriptEnvironment = null;
        });
        context.getFrame().addPropertyChangeListener("projectLoaded", pce -> {
            this.sharedScriptEnvironment = null;
        });
        this.getLayeredPane().registerKeyboardAction(context.getFrame().actions.showConsoleWindowAction, "showConsole", KeyStroke.getKeyStroke(118, 0), 2);
    }

    private void handleClose() {
        try {
            Preferences node = this.prefs.node("selectedProjects");
            node.clear();
            for (AlbumProject ap : this.getSelectedProjects()) {
                node.putBoolean(ap.getName(), true);
            }
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(JMultiMaker.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static String formatDate(Date date) {
        return date != null ? Config.getConfig().getDateFormatter().format(date) : "";
    }

    public class AlbumProjectModel
    extends AbstractTableModel {
        private List<AlbumProject> projects;
        private final Column[] cols;

        public AlbumProjectModel(List<AlbumProject> projects) {
            this.cols = new Column[]{new Column<AlbumProject>(Msg.get("edit.name"), AlbumProject.class, ap -> ap).renderer(JMultiMaker.this.albnumProjectRenderer), new Column<String>(Msg.get("ui.skin"), String.class, ap -> ap.getProperties(false).getProperty("skin")), new Column<String>(Msg.get("ui.style"), String.class, ap -> IO.baseName(ap.getProperties(false).getProperty("style", ""))), new Column<Date>(Msg.get("ui.lastMade"), Date.class, ap -> new Date(ap.getRootFolder().getProperties().get("lastMadeDate", 0L))).renderer(JMultiMaker.this.dateCellRenderer), new Column<Date>(Msg.get("ui.lastPublished"), Date.class, ap -> new Date(ap.getRootFolder().getProperties().get("lastPublishedDate", 0L))).renderer(JMultiMaker.this.dateCellRenderer)};
            this.projects = projects;
        }

        int getProjectIndex(AlbumProject project) {
            int i = 0;
            for (AlbumProject ap : this.projects) {
                if (ap.equals(project)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public int getRowCount() {
            return this.projects.size();
        }

        @Override
        public int getColumnCount() {
            return this.cols.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.cols[column].name;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.cols[columnIndex].type;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                AlbumProject ap = this.projects.get(rowIndex);
                Object val = this.cols[columnIndex].getter.apply(ap);
                if (val == null) {
                    val = "";
                }
                return val;
            }
            catch (Exception ex) {
                return "-";
            }
        }

        public AlbumProject getProject(int rowIndex) {
            return this.projects.get(rowIndex);
        }

        public void addProject(AlbumProject row) {
            int index = this.projects.size();
            this.projects.add(row);
            this.fireTableRowsInserted(index, index);
        }

        private void removeProject(AlbumProject row) {
            int rowIndex;
            if (row != null && (rowIndex = this.getProjectIndex(row)) >= 0) {
                this.projects.remove(rowIndex);
                this.fireTableRowsDeleted(rowIndex, rowIndex);
            }
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            AlbumProject ap = this.projects.get(rowIndex);
            this.cols[columnIndex].setter.accept(ap, (AlbumProject)aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        public void setData(List<AlbumProject> data) {
            this.projects = data;
            this.fireTableDataChanged();
            JMultiMaker.this.sorter.allRowsChanged();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.cols[columnIndex].isEditable();
        }

        private void clear() {
            int size = this.projects.size();
            this.projects.clear();
            this.fireTableDataChanged();
        }
    }

    private static class Column<T> {
        String name;
        String toolTip;
        Class<T> type;
        Func<AlbumProject, T> getter;
        BiConsumer<AlbumProject, T> setter;
        TableCellRenderer renderer;
        int minWidth = 0;

        public Column(String name, Class<T> type, Func<AlbumProject, T> getter) {
            this.name = name;
            this.type = type;
            this.getter = getter;
        }

        public Column renderer(TableCellRenderer renderer) {
            this.renderer = renderer;
            return this;
        }

        public boolean isEditable() {
            return this.setter != null;
        }

        public Column setter(BiConsumer<AlbumProject, T> setter) {
            this.setter = setter;
            return this;
        }

        public Column toolRip(String toolTip) {
            this.toolTip = toolTip;
            return this;
        }

        public Column minWidth(int minWidth) {
            this.minWidth = minWidth;
            return this;
        }
    }
}

