/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Cursor;
import java.awt.SystemColor;
import java.io.IOException;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import se.datadosen.jalbum.Msg;

public class JHtmlBox
extends JTextPane
implements HyperlinkListener {
    private String text = "";
    private Consumer<HyperlinkEvent> onLinkClicked;

    public JHtmlBox() {
        this.init();
    }

    public JHtmlBox(String htmlText) {
        this.init();
        this.setHtmlText(htmlText);
    }

    public JHtmlBox(String htmlText, int relFontSize) {
        this.init();
        this.setHtmlText(htmlText, relFontSize);
    }

    public void setHtmlText(String htmlText) {
        this.setHtmlText(htmlText, 0);
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        this.text = t;
    }

    public void setHtmlText(String htmlText, int relFontSize) {
        String in = "<html><body><font face=\"sansserif\" size=" + (3 + relFontSize) + ">" + htmlText + "</font></body></html>";
        this.setText(in);
    }

    public void onLinkClicked(Consumer<HyperlinkEvent> consumer) {
        this.onLinkClicked = consumer;
    }

    public void styleMe() {
        HTMLEditorKit customKit = new HTMLEditorKit(){
            private final StyleSheet customStyleSheet = new StyleSheet();
            {
                this.customStyleSheet.addRule("a { color: blue; }");
            }

            @Override
            public StyleSheet getStyleSheet() {
                return this.customStyleSheet;
            }
        };
        this.setEditorKit(customKit);
        this.setForeground(SystemColor.black);
        this.setText(this.text);
    }

    private void init() {
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.setFocusable(false);
        this.setContentType("text/html");
        this.setEditable(false);
        this.addHyperlinkListener(this);
        this.setOpaque(false);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
            this.linkActivated(e);
        } else if (e.getEventType().equals(HyperlinkEvent.EventType.ENTERED)) {
            this.linkEntered(e);
        } else if (e.getEventType().equals(HyperlinkEvent.EventType.EXITED)) {
            this.linkExited(e);
        }
    }

    protected void linkActivated(HyperlinkEvent e) {
        if (this.onLinkClicked != null) {
            this.onLinkClicked.accept(e);
        } else {
            try {
                BrowserLauncher.openURL(e.getURL().toExternalForm());
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), ex.getMessage(), Msg.get("wiz.openFailed"), 0);
            }
        }
    }

    protected void linkEntered(HyperlinkEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    protected void linkExited(HyperlinkEvent e) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public int hashCode() {
        return this.text != null ? this.text.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JHtmlBox other = (JHtmlBox)obj;
        return this.text.equals(other.text);
    }

    @Override
    public String toString() {
        return this.text;
    }
}

